/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magic.elements.handlers;

import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.S2CPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.util.ArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ElementHandler {
    public static void drawElementEffects(LivingEntity livingEntity, Element element) {
        if (element.equals((Object)Element.PYRO)) {
            ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
        } else if (element.equals((Object)Element.CRYO)) {
            ParticleUtils.createAABB(livingEntity.m_9236_(), (ParticleOptions)ParticleTypes.f_175821_, livingEntity.m_20191_(), 1, 5.0E-4f);
            ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
        } else if (element.equals((Object)Element.AERO) && livingEntity.f_19797_ % 3 == 0) {
            ParticleUtils.createAABB(livingEntity.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(element), RandomUtils.random().nextFloat(0.1f, 0.4f), 30, 0.025f), livingEntity.m_20191_(), 3, 0.002f);
        }
    }

    public static boolean addElement(LivingEntity owner, LivingEntity entity, Element element, float damage, int duration, boolean trigger, boolean isCrit) {
        return entity.getCapability(CapabilityRegistry.ENTITY).map(data -> {
            if (data.hasElementDuration(element, duration)) {
                return false;
            }
            data.addElement(element, duration);
            if (trigger) {
                ElementHandler.handleHit(owner, entity, damage, element, isCrit, true);
            }
            SyncCapabilityManager.syncEntity(entity, data.serializeNBT());
            return true;
        }).orElse(false);
    }

    public static boolean addElement(LivingEntity entity, Element element, float damage, int duration) {
        return ElementHandler.addElement(entity, element, damage, duration, false);
    }

    public static boolean addElement(LivingEntity entity, Element element, float damage, int duration, boolean isCrit) {
        return ElementHandler.addElement(null, entity, element, damage, duration, true, isCrit);
    }

    public static float handleHit(LivingEntity owner, LivingEntity target, float baseDmg, Element type, boolean isCrit, boolean canTrigger) {
        return target.getCapability(CapabilityRegistry.ENTITY).map(data -> {
            ArrayList<Element> activeElements;
            float finalDmg = baseDmg;
            boolean consumeAura = false;
            if (canTrigger && !(activeElements = new ArrayList<Element>(data.getElements().keySet())).isEmpty()) {
                for (Element aura : activeElements) {
                    if (aura == type) continue;
                    if (type == Element.AERO || aura == Element.AERO) {
                        Element e;
                        Element element = e = type == Element.AERO ? aura : type;
                        if (e == Element.PYRO || e == Element.CRYO) {
                            ElementHandler.triggerSwirl(owner, target, e, baseDmg, isCrit);
                            break;
                        }
                    }
                    if ((type != Element.PYRO || aura != Element.CRYO) && (type != Element.CRYO || aura != Element.PYRO)) continue;
                    float multi = type == Element.PYRO ? 2.0f : 1.5f;
                    finalDmg *= multi;
                    consumeAura = true;
                    ElementHandler.spawnReactionParticles(target, type, aura);
                    target.m_7311_(0);
                    break;
                }
            }
            DamageSource source = target.m_9236_().m_269111_().m_269425_();
            boolean applied = target.m_6469_(source, finalDmg);
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("entityId", target.m_19879_());
            tag.m_128350_("damage", finalDmg);
            tag.m_128379_("isCrit", isCrit);
            tag.m_128359_("element", type.name().toLowerCase());
            Networking.sendTrackingEntity((Entity)target, new S2CPacket(tag, 1927));
            if (applied) {
                if (consumeAura) {
                    data.getElements().clear();
                } else {
                    data.addElement(type, 200);
                }
                SyncCapabilityManager.syncEntity(target, data.serializeNBT());
                return Float.valueOf(finalDmg);
            }
            return Float.valueOf(-1.0f);
        }).orElse(Float.valueOf(-1.0f)).floatValue();
    }

    private static void triggerSwirl(LivingEntity owner, LivingEntity target, Element element, float dmg, boolean isCrit) {
        float swirlDmg = dmg * 0.6f;
        target.m_6469_(target.m_9236_().m_269111_().m_269425_(), swirlDmg);
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("entityId", target.m_19879_());
        tag.m_128350_("damage", swirlDmg);
        tag.m_128379_("isCrit", isCrit);
        tag.m_128359_("element", element.name().toLowerCase());
        Networking.sendTrackingEntity((Entity)target, new S2CPacket(tag, 1927));
        ParticleUtils.createSwirlParticleEffect(target.m_9236_(), new GlowingParticleData(ElementsUtils.getColorByElement(element).getRGB(), 0.5f, 80, 0.025f, 1.0f, 0.93f, true, false, false), target.m_20182_().m_82520_(0.0, 1.0, 0.0), 4.0, 0.05f, 50, 0.5f, 0.05f);
        target.m_9236_().m_6443_(LivingEntity.class, target.m_20191_().m_82400_(4.0), e -> !e.m_20148_().equals(target.m_20148_()) && owner != null && !e.m_20148_().equals(owner.m_20148_())).forEach(e -> ElementHandler.handleHit(owner, e, dmg * 0.8f, element, isCrit, false));
    }

    private static void spawnReactionParticles(LivingEntity target, Element e1, Element e2) {
        int color = ElementsUtils.getColorByElement(e1).getRGB();
        ParticleUtils.createAABB(target.m_9236_(), new GlowingParticleData(color, 0.5f, 60, 0.25f), target.m_20191_().m_82400_(0.5), 40, 0.05f);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="etheria")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onWorldTick(TickEvent.LevelTickEvent event) {
            Object object;
            if (event.phase == TickEvent.Phase.END && (object = event.level) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)object;
                for (Entity entity : level.m_142646_().m_142273_()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    entity.getCapability(CapabilityRegistry.ENTITY).ifPresent(data -> {
                        data.tick();
                        if (level.m_46467_() % 20L == 0L) {
                            data.tickElements();
                            SyncCapabilityManager.syncEntity(livingEntity, data.serializeNBT());
                        }
                        if (data.getTimerTick() <= 0 && data.isFrozen()) {
                            data.setFrozen(false);
                            SyncCapabilityManager.syncEntity(livingEntity, data.serializeNBT());
                        }
                        if (entity.m_20094_() > 0) {
                            ElementHandler.addElement(livingEntity, Element.PYRO, 1.0f, entity.m_20094_());
                        }
                        if (entity.m_146888_() > 0) {
                            ElementHandler.addElement(livingEntity, Element.CRYO, 1.0f, entity.m_146888_());
                        }
                        if (livingEntity.m_21023_(MobEffects.f_19591_) && livingEntity.m_21124_(MobEffects.f_19591_) != null) {
                            ElementHandler.addElement(livingEntity, Element.AERO, 0.1f, livingEntity.m_21124_(MobEffects.f_19591_).m_19557_());
                        }
                        if (livingEntity.m_21023_(MobEffects.f_19620_) && livingEntity.m_21124_(MobEffects.f_19620_) != null) {
                            ElementHandler.addElement(livingEntity, Element.AERO, 0.25f, livingEntity.m_21124_(MobEffects.f_19620_).m_19557_());
                        }
                    });
                }
            }
        }
    }
}

