/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.magemicon.utils;

import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.client.gui.widgets.StarType;
import it.mralxart.etheria.leveling.data.ConditionInfo;
import it.mralxart.etheria.magemicon.MageMiconStorage;
import it.mralxart.etheria.magemicon.data.ConstellationInfo;
import it.mralxart.etheria.magemicon.data.StarData;
import it.mralxart.etheria.magemicon.data.StarInfo;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.AddToastPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class StarUtils {
    public static List<StarData> getStars(Player player) {
        return CapabilityRegistry.getCap(player).getStars();
    }

    public static void addCondition(Player player, String skillId, String id) {
        StarInfo info;
        List<StarData> skills = StarUtils.getStars(player);
        Optional<StarData> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.getConditions().add(id);
            SyncCapabilityManager.sync(player);
        });
        if (StarUtils.isConditionsCompleted(player, skillId) && (info = StarUtils.getInfoSkillById(skillId)) != null) {
            MutableComponent titleComponent;
            boolean isCustomName = new ResourceLocation(info.getId()).m_135827_().equals("etheria");
            ItemStack stack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(info.getInfo().getId()))));
            if (info.getType().equals((Object)StarType.RITUAL)) {
                if (isCustomName) {
                    String displayName = stack.m_41611_().getString().replace("[", "").replace("]", "");
                    titleComponent = Component.m_237113_((String)displayName);
                } else {
                    titleComponent = Component.m_237115_((String)("mage_micon.rituals." + skillId));
                }
            } else {
                titleComponent = info.getType().equals((Object)StarType.SPELL) ? Component.m_237115_((String)("mage_micon.spell." + skillId)) : Component.m_237115_((String)("mage_micon.chapter." + skillId));
            }
            Networking.sendToClient((ServerPlayer)player, new AddToastPacket(stack, Component.m_237115_((String)"mage_micon.new_chapter").getString() + "\n\u00a7l" + titleComponent.getString()));
        }
    }

    public static void checkConditions(Player player) {
        StarUtils.getStars(player).forEach(starData -> {
            if (!starData.isActive() && StarUtils.isParentStarUnlocked(player, starData.getId())) {
                StarInfo starInfo = StarUtils.getInfoSkillById(starData.getId());
                if (starInfo == null) {
                    return;
                }
                List<String> conditions = starData.getConditions();
                starInfo.getConditions().stream().filter(requiredCondition -> !conditions.contains(requiredCondition.getId())).filter(requiredCondition -> StarUtils.isConditionMet(player, requiredCondition)).forEach(metCondition -> StarUtils.addCondition(player, starData.getId(), metCondition.getId()));
            }
        });
    }

    public static boolean isConditionsCompleted(Player player, String skillId) {
        StarInfo starInfo = StarUtils.getInfoSkillById(skillId);
        if (starInfo == null || starInfo.getConditions().isEmpty()) {
            return true;
        }
        Optional<StarData> starDataOptional = StarUtils.getStars(player).stream().filter(sd -> sd.getId().equals(skillId)).findFirst();
        if (starDataOptional.isEmpty()) {
            return false;
        }
        StarData starData = starDataOptional.get();
        Set conditions = starInfo.getConditions().stream().map(ConditionInfo::getId).collect(Collectors.toSet());
        return new HashSet<String>(starData.getConditions()).containsAll(conditions);
    }

    private static boolean isConditionMet(Player player, ConditionInfo condition) {
        if (condition == null || condition.getType() == null) {
            return false;
        }
        switch (condition.getType()) {
            case ITEM: {
                Item requiredItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(condition.getId()));
                if (requiredItem == null || requiredItem == Items.f_41852_) {
                    return false;
                }
                int count = player.m_150109_().m_18947_(requiredItem);
                return count >= condition.getAmount();
            }
            case STAR_UNLOCKED: {
                return StarUtils.isStarUnlocked(player, condition.getId());
            }
        }
        return false;
    }

    public static void unlockStarById(Player player, String skillId, boolean active) {
        List<StarData> skills = StarUtils.getStars(player);
        Optional<StarData> skillOptional = skills.stream().filter(skill -> skill.getId().equals(skillId)).findFirst();
        skillOptional.ifPresent(skill -> {
            skill.setActive(active);
            SyncCapabilityManager.sync(player);
        });
    }

    public static boolean isStarUnlocked(Player player, String skillId) {
        Optional<EtheriaCapability> capability = Optional.of(CapabilityRegistry.getCap(player));
        ArrayList<StarData> skillData = new ArrayList<StarData>(StarUtils.getStars(player));
        return capability.map(skills -> skillData.stream().filter(skill -> skill != null && skill.getId().equals(skillId)).findFirst().map(StarData::isActive).orElse(false)).orElse(false);
    }

    public static boolean isParentStarUnlocked(Player player, String skillId) {
        StarInfo starInfo = StarUtils.getInfoSkillById(skillId);
        if (starInfo == null) {
            return false;
        }
        for (String parentId : starInfo.getParents()) {
            if (StarUtils.isStarUnlocked(player, parentId)) continue;
            return false;
        }
        return true;
    }

    public static Optional<StarData> getStarById(Player player, String id) {
        List<StarData> skills = StarUtils.getStars(player);
        for (StarData data : new ArrayList<StarData>(skills)) {
            if (data == null || !data.getId().equals(id)) continue;
            return Optional.of(data);
        }
        return Optional.empty();
    }

    @Nullable
    public static StarInfo getInfoSkillById(String skillId) {
        List<StarInfo> stars = StarUtils.getInfoStars();
        if (stars.isEmpty()) {
            return null;
        }
        return stars.stream().filter(skill -> skill.getId().equals(skillId)).findFirst().orElse(null);
    }

    public static List<StarInfo> getInfoStars() {
        ArrayList<StarInfo> dataList = new ArrayList<StarInfo>();
        for (ConstellationInfo categoryInfo : MageMiconStorage.DATA.getConstellations().values()) {
            dataList.addAll(categoryInfo.getStars().values());
        }
        return dataList;
    }
}

