/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.leveling.data;

import com.google.common.collect.Lists;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.data.ConditionInfo;
import it.mralxart.etheria.leveling.data.ConditionType;
import it.mralxart.etheria.leveling.data.ImageInfo;
import it.mralxart.etheria.leveling.data.ImageType;
import java.util.ArrayList;
import java.util.List;

public class SkillInfo {
    private Boolean active;
    private Boolean blocked;
    private String id;
    private List<String> parents;
    private int reqLvl;
    private int maxLvl;
    private int reqPoints;
    private int reqUpPoints;
    private float initialValue;
    private Branches category;
    private List<String> description;
    private List<ConditionInfo> conditions;
    private int x;
    private int y;
    private ImageInfo info;

    private static Boolean $default$active() {
        return true;
    }

    private static Boolean $default$blocked() {
        return false;
    }

    private static String $default$id() {
        return "";
    }

    private static int $default$reqLvl() {
        return 0;
    }

    private static int $default$maxLvl() {
        return 0;
    }

    private static int $default$reqPoints() {
        return 1;
    }

    private static int $default$reqUpPoints() {
        return 1;
    }

    private static float $default$initialValue() {
        return 1.0f;
    }

    private static Branches $default$category() {
        return Branches.MINING;
    }

    private static int $default$x() {
        return 0;
    }

    private static int $default$y() {
        return 0;
    }

    SkillInfo(Boolean active, Boolean blocked, String id, List<String> parents, int reqLvl, int maxLvl, int reqPoints, int reqUpPoints, float initialValue, Branches category, List<String> description, List<ConditionInfo> conditions, int x, int y, ImageInfo info) {
        this.active = active;
        this.blocked = blocked;
        this.id = id;
        this.parents = parents;
        this.reqLvl = reqLvl;
        this.maxLvl = maxLvl;
        this.reqPoints = reqPoints;
        this.reqUpPoints = reqUpPoints;
        this.initialValue = initialValue;
        this.category = category;
        this.description = description;
        this.conditions = conditions;
        this.x = x;
        this.y = y;
        this.info = info;
    }

    public static SkillInfoBuilder builder() {
        return new SkillInfoBuilder();
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getBlocked() {
        return this.blocked;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public int getReqLvl() {
        return this.reqLvl;
    }

    public int getMaxLvl() {
        return this.maxLvl;
    }

    public int getReqPoints() {
        return this.reqPoints;
    }

    public int getReqUpPoints() {
        return this.reqUpPoints;
    }

    public float getInitialValue() {
        return this.initialValue;
    }

    public Branches getCategory() {
        return this.category;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public List<ConditionInfo> getConditions() {
        return this.conditions;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public ImageInfo getInfo() {
        return this.info;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public void setReqLvl(int reqLvl) {
        this.reqLvl = reqLvl;
    }

    public void setMaxLvl(int maxLvl) {
        this.maxLvl = maxLvl;
    }

    public void setReqPoints(int reqPoints) {
        this.reqPoints = reqPoints;
    }

    public void setReqUpPoints(int reqUpPoints) {
        this.reqUpPoints = reqUpPoints;
    }

    public void setInitialValue(float initialValue) {
        this.initialValue = initialValue;
    }

    public void setCategory(Branches category) {
        this.category = category;
    }

    public void setDescription(List<String> description) {
        this.description = description;
    }

    public void setConditions(List<ConditionInfo> conditions) {
        this.conditions = conditions;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setInfo(ImageInfo info) {
        this.info = info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkillInfo)) {
            return false;
        }
        SkillInfo other = (SkillInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReqLvl() != other.getReqLvl()) {
            return false;
        }
        if (this.getMaxLvl() != other.getMaxLvl()) {
            return false;
        }
        if (this.getReqPoints() != other.getReqPoints()) {
            return false;
        }
        if (this.getReqUpPoints() != other.getReqUpPoints()) {
            return false;
        }
        if (Float.compare(this.getInitialValue(), other.getInitialValue()) != 0) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$blocked = this.getBlocked();
        Boolean other$blocked = other.getBlocked();
        if (this$blocked == null ? other$blocked != null : !((Object)this$blocked).equals(other$blocked)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<String> this$parents = this.getParents();
        List<String> other$parents = other.getParents();
        if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
            return false;
        }
        Branches this$category = this.getCategory();
        Branches other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        List<String> this$description = this.getDescription();
        List<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        List<ConditionInfo> this$conditions = this.getConditions();
        List<ConditionInfo> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        ImageInfo this$info = this.getInfo();
        ImageInfo other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SkillInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReqLvl();
        result = result * 59 + this.getMaxLvl();
        result = result * 59 + this.getReqPoints();
        result = result * 59 + this.getReqUpPoints();
        result = result * 59 + Float.floatToIntBits(this.getInitialValue());
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $blocked = this.getBlocked();
        result = result * 59 + ($blocked == null ? 43 : ((Object)$blocked).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<String> $parents = this.getParents();
        result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
        Branches $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        List<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        List<ConditionInfo> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        ImageInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        return result;
    }

    public String toString() {
        return "SkillInfo(active=" + this.getActive() + ", blocked=" + this.getBlocked() + ", id=" + this.getId() + ", parents=" + String.valueOf(this.getParents()) + ", reqLvl=" + this.getReqLvl() + ", maxLvl=" + this.getMaxLvl() + ", reqPoints=" + this.getReqPoints() + ", reqUpPoints=" + this.getReqUpPoints() + ", initialValue=" + this.getInitialValue() + ", category=" + String.valueOf((Object)this.getCategory()) + ", description=" + String.valueOf(this.getDescription()) + ", conditions=" + String.valueOf(this.getConditions()) + ", x=" + this.getX() + ", y=" + this.getY() + ", info=" + String.valueOf(this.getInfo()) + ")";
    }

    public static class SkillInfoBuilder {
        private boolean active$set;
        private Boolean active$value;
        private boolean blocked$set;
        private Boolean blocked$value;
        private boolean id$set;
        private String id$value;
        private boolean reqLvl$set;
        private int reqLvl$value;
        private boolean maxLvl$set;
        private int maxLvl$value;
        private boolean reqPoints$set;
        private int reqPoints$value;
        private boolean reqUpPoints$set;
        private int reqUpPoints$value;
        private boolean initialValue$set;
        private float initialValue$value;
        private boolean category$set;
        private Branches category$value;
        private boolean x$set;
        private int x$value;
        private boolean y$set;
        private int y$value;
        private List<String> parents = new ArrayList<String>();
        private List<ConditionInfo> conditions = new ArrayList<ConditionInfo>();
        private ImageInfo info = new ImageInfo("minecraft:air", ImageType.ITEM);
        private List<String> description = new ArrayList<String>();

        public SkillInfoBuilder parents(String ... parents) {
            this.parents.addAll(Lists.newArrayList((Object[])parents));
            return this;
        }

        public SkillInfoBuilder condition(ConditionType condition, String data) {
            this.conditions.add(new ConditionInfo(data, 0, condition));
            return this;
        }

        public SkillInfoBuilder condition(ConditionType condition, String data, int amount) {
            this.conditions.add(new ConditionInfo(data, amount, condition));
            return this;
        }

        public SkillInfoBuilder image(ImageType type, String data) {
            this.info = new ImageInfo(data, type);
            return this;
        }

        public SkillInfoBuilder description(String ... description) {
            return this;
        }

        SkillInfoBuilder() {
        }

        public SkillInfoBuilder active(Boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public SkillInfoBuilder blocked(Boolean blocked) {
            this.blocked$value = blocked;
            this.blocked$set = true;
            return this;
        }

        public SkillInfoBuilder id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        public SkillInfoBuilder reqLvl(int reqLvl) {
            this.reqLvl$value = reqLvl;
            this.reqLvl$set = true;
            return this;
        }

        public SkillInfoBuilder maxLvl(int maxLvl) {
            this.maxLvl$value = maxLvl;
            this.maxLvl$set = true;
            return this;
        }

        public SkillInfoBuilder reqPoints(int reqPoints) {
            this.reqPoints$value = reqPoints;
            this.reqPoints$set = true;
            return this;
        }

        public SkillInfoBuilder reqUpPoints(int reqUpPoints) {
            this.reqUpPoints$value = reqUpPoints;
            this.reqUpPoints$set = true;
            return this;
        }

        public SkillInfoBuilder initialValue(float initialValue) {
            this.initialValue$value = initialValue;
            this.initialValue$set = true;
            return this;
        }

        public SkillInfoBuilder category(Branches category) {
            this.category$value = category;
            this.category$set = true;
            return this;
        }

        public SkillInfoBuilder conditions(List<ConditionInfo> conditions) {
            this.conditions = conditions;
            return this;
        }

        public SkillInfoBuilder x(int x) {
            this.x$value = x;
            this.x$set = true;
            return this;
        }

        public SkillInfoBuilder y(int y) {
            this.y$value = y;
            this.y$set = true;
            return this;
        }

        public SkillInfoBuilder info(ImageInfo info) {
            this.info = info;
            return this;
        }

        public SkillInfo build() {
            Boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = SkillInfo.$default$active();
            }
            Boolean blocked$value = this.blocked$value;
            if (!this.blocked$set) {
                blocked$value = SkillInfo.$default$blocked();
            }
            String id$value = this.id$value;
            if (!this.id$set) {
                id$value = SkillInfo.$default$id();
            }
            int reqLvl$value = this.reqLvl$value;
            if (!this.reqLvl$set) {
                reqLvl$value = SkillInfo.$default$reqLvl();
            }
            int maxLvl$value = this.maxLvl$value;
            if (!this.maxLvl$set) {
                maxLvl$value = SkillInfo.$default$maxLvl();
            }
            int reqPoints$value = this.reqPoints$value;
            if (!this.reqPoints$set) {
                reqPoints$value = SkillInfo.$default$reqPoints();
            }
            int reqUpPoints$value = this.reqUpPoints$value;
            if (!this.reqUpPoints$set) {
                reqUpPoints$value = SkillInfo.$default$reqUpPoints();
            }
            float initialValue$value = this.initialValue$value;
            if (!this.initialValue$set) {
                initialValue$value = SkillInfo.$default$initialValue();
            }
            Branches category$value = this.category$value;
            if (!this.category$set) {
                category$value = SkillInfo.$default$category();
            }
            int x$value = this.x$value;
            if (!this.x$set) {
                x$value = SkillInfo.$default$x();
            }
            int y$value = this.y$value;
            if (!this.y$set) {
                y$value = SkillInfo.$default$y();
            }
            return new SkillInfo(active$value, blocked$value, id$value, this.parents, reqLvl$value, maxLvl$value, reqPoints$value, reqUpPoints$value, initialValue$value, category$value, this.description, this.conditions, x$value, y$value, this.info);
        }

        public String toString() {
            return "SkillInfo.SkillInfoBuilder(active$value=" + this.active$value + ", blocked$value=" + this.blocked$value + ", id$value=" + this.id$value + ", parents=" + String.valueOf(this.parents) + ", reqLvl$value=" + this.reqLvl$value + ", maxLvl$value=" + this.maxLvl$value + ", reqPoints$value=" + this.reqPoints$value + ", reqUpPoints$value=" + this.reqUpPoints$value + ", initialValue$value=" + this.initialValue$value + ", category$value=" + String.valueOf((Object)this.category$value) + ", description=" + String.valueOf(this.description) + ", conditions=" + String.valueOf(this.conditions) + ", x$value=" + this.x$value + ", y$value=" + this.y$value + ", info=" + String.valueOf(this.info) + ")";
        }
    }
}

