/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.leveling;

import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.utils.RandomUtils;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="etheria")
public class SkillsHandler {
    @SubscribeEvent
    public static void fishing(ItemFishedEvent event) {
        Player player = event.getEntity();
        long time = player.m_9236_().m_46468_() % 24000L;
        int xp = SkillsHandler.calculateExperience(time, player);
        SkillsUtils.addXp(player, Branches.FISHING, xp);
    }

    private static int calculateExperience(long time, Player player) {
        int baseExperience = new Random().nextInt(1, 20);
        double timeMultiplier = time >= 0L && time < 6000L ? 1.1 : (time >= 6000L && time < 12000L ? 1.3 : (time >= 12000L && time < 18000L ? 1.7 : 2.4));
        return (int)((double)baseExperience * timeMultiplier);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        CropBlock crop;
        CropBlock crop2;
        Player player = event.getPlayer();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        Block block = state.m_60734_();
        Level level = player.m_9236_();
        Random random = RandomUtils.random();
        int baseXp = SkillsHandler.getBlockXp(block, state);
        if (baseXp != 0 && (double)random.nextFloat() < 0.1) {
            baseXp += 2;
        }
        int miningLevel = SkillsUtils.getLvl(player, Branches.MINING);
        int woodcuttingLevel = SkillsUtils.getLvl(player, Branches.WOODCUTTING);
        int farmingLevel = SkillsUtils.getLvl(player, Branches.FARMING);
        if (baseXp != 0) {
            baseXp += miningLevel / 10;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13106_)) {
            int woodXp = 1 + woodcuttingLevel / 15;
            SkillsUtils.addXp(player, Branches.WOODCUTTING, woodXp);
        }
        if (block instanceof CropBlock && (crop2 = (CropBlock)block).m_52305_(state) == crop2.m_7419_()) {
            int farmXp = 1 + farmingLevel / 15;
            SkillsUtils.addXp(player, Branches.FARMING, farmXp);
        }
        if (baseXp > 0) {
            SkillsUtils.addXp(player, Branches.MINING, baseXp);
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13106_)) {
            SkillsUtils.addXp(player, Branches.WOODCUTTING, 1);
        }
        if (block instanceof CropBlock && (crop = (CropBlock)block).m_52305_(state) == crop.m_7419_()) {
            SkillsUtils.addXp(player, Branches.FARMING, 1);
        }
        if (SkillsUtils.isSkillActive(player, "mining:5") && (block == Blocks.f_49995_ || block == Blocks.f_152467_) && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:5") / 100.0f) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42587_)));
        }
        if (SkillsUtils.isSkillActive(player, "mining:6") && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:6") / 100.0f) {
            player.m_6756_(1);
        }
        if (SkillsUtils.isSkillActive(player, "mining:7") && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:7") / 100.0f) {
            player.m_5634_(1.0f);
        }
        if (SkillsUtils.isSkillActive(player, "mining:9") && (block == Blocks.f_50089_ || block == Blocks.f_152474_) && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:9") / 100.0f) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42415_)));
        }
        if (SkillsUtils.isSkillActive(player, "mining:10") && block == Blocks.f_50722_ && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:10") / 100.0f) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42419_)));
        }
        if (SkillsUtils.isSkillActive(player, "mining:8") && !player.m_6144_() && player.m_21205_().m_41720_() instanceof PickaxeItem) {
            SkillsUtils.mineInRadius(player, pos, level, 3, 1);
        }
        if (SkillsUtils.isSkillActive(player, "mining:11") && !player.m_6144_() && player.m_21205_().m_41720_() instanceof PickaxeItem) {
            SkillsUtils.mineInRadius(player, pos, level, 3, 3);
        }
        if (SkillsUtils.isSkillActive(player, "mining:15") && player.m_21205_().m_41720_() instanceof ShovelItem && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:15") / 100.0f) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 100, 0));
        }
        if (SkillsUtils.isSkillActive(player, "mining:16") && player.m_21205_().m_41720_() instanceof ShovelItem && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:16") / 100.0f) {
            ItemStack treasure = SkillsUtils.getRandomTreasureItem(level);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), treasure));
        }
        if (SkillsUtils.isSkillActive(player, "mining:20") && player.m_21205_().m_41720_() instanceof AxeItem && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:20") / 100.0f) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 100, 0));
        }
        if (SkillsUtils.isSkillActive(player, "mining:21") && block.m_49966_().m_204336_(BlockTags.f_13106_) && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:21") / 100.0f) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)block.m_5456_())));
        }
        if (SkillsUtils.isSkillActive(player, "mining:22") && block.m_49966_().m_204336_(BlockTags.f_13106_) && random.nextFloat() < SkillsUtils.getAnInt(player, "mining:22") / 100.0f) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)Items.f_42414_)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack mainHandItem = player.m_21205_();
        BlockState blockState = event.getState();
        float newSpeed = event.getNewSpeed();
        if (SkillsHandler.isItemBlocked(player, mainHandItem)) {
            event.setNewSpeed(0.0f);
            return;
        }
        if (SkillsUtils.isSkillActive(player, "mining:1")) {
            newSpeed *= 1.05f;
        }
        if (!(mainHandItem.m_41720_() instanceof PickaxeItem) || !ForgeHooks.isCorrectToolForDrops((BlockState)blockState, (Player)player)) {
            return;
        }
        if (SkillsUtils.isSkillActive(player, "mining:2") && player.m_21206_().m_41720_() instanceof PickaxeItem && player.m_9236_().f_46441_.m_188501_() < 0.1f) {
            newSpeed *= 1.1f;
        }
        event.setNewSpeed(newSpeed);
    }

    @SubscribeEvent
    public static void onEntityKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.m_7500_() && event.getEntity().getPersistentData().m_128471_("notKill")) {
            event.setCanceled(true);
            return;
        }
        LivingEntity entity2 = event.getEntity();
        int xp = 0;
        if (entity2.m_21233_() >= 50.0f) {
            xp = 8;
        } else if (entity2.m_21233_() >= 25.0f) {
            xp = 5;
        } else if (entity2.m_21233_() >= 2.0f) {
            xp = 1;
        }
        SkillsUtils.addXp(player, Branches.COMBAT, xp);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.m_7500_()) {
            return;
        }
        if (SkillsHandler.isItemBlocked(player, player.m_21205_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.m_7500_()) {
            return;
        }
        if (event.getLevel().m_8055_(event.getPos()).m_60795_()) {
            return;
        }
        if (SkillsHandler.isItemBlocked(player, player.m_21205_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAttackEntity(LivingAttackEvent event) {
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && SkillsHandler.isItemBlocked(player = (Player)entity, player.m_21205_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            final Player player = (Player)entity;
            mainHandItem = player.m_21205_();
            float newAmount = event.getAmount();
            if (SkillsUtils.isSkillActive(player, "combat:1")) {
                newAmount += newAmount * (SkillsUtils.getAnInt(player, "combat:1") / 100.0f);
            }
            if (SkillsUtils.isSkillActive(player, "combat:6")) {
                Random random = new Random();
                if (random.nextFloat() < 0.3f) {
                    player.m_5634_(SkillsUtils.getAnInt(player, "combat:6"));
                }
            }
            if (SkillsUtils.isSkillActive(player, "combat:7")) {
                Random random = new Random();
                if (random.nextFloat() < SkillsUtils.getAnInt(player, "combat:7") / 100.0f) {
                    SkillsHandler.applyAttribute((LivingEntity)player, "etheria_movement_speed_combat", Attributes.f_22279_, 0.2f, AttributeModifier.Operation.ADDITION);
                    final Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            SkillsHandler.removeAttribute((LivingEntity)player, "etheria_movement_speed_combat", Attributes.f_22279_, AttributeModifier.Operation.ADDITION);
                            timer.cancel();
                        }
                    }, 5000L);
                }
            }
            newAmount += 0.03f + newAmount * ((float)SkillsUtils.getStatAmount("damage", player) / 100.0f);
            event.setAmount(newAmount);
        } else {
            mainHandItem = event.getEntity();
            if (mainHandItem instanceof Player) {
                Player player = (Player)mainHandItem;
                mainHandItem = player.m_21205_();
                float newAmount = event.getAmount();
                if (SkillsHandler.isItemBlocked(player, (ItemStack)mainHandItem)) {
                    event.setCanceled(true);
                    return;
                }
                if (SkillsUtils.isSkillActive(player, "combat:8")) {
                    Random random = new Random();
                    if (random.nextFloat() < SkillsUtils.getAnInt(player, "combat:8") / 100.0f) {
                        event.setCanceled(true);
                        return;
                    }
                }
                if (SkillsUtils.isSkillActive(player, "combat:3")) {
                    newAmount -= newAmount * (SkillsUtils.getAnInt(player, "combat:3") / 100.0f);
                }
                event.setAmount(Math.max(0.0f, newAmount));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onArmorEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_7500_()) {
            return;
        }
        ItemStack newArmor = event.getTo();
        if (SkillsHandler.isItemBlocked(player, newArmor)) {
            player.m_150109_().m_36040_(player.m_150109_().m_6643_() - 1, newArmor);
            player.m_8061_(event.getSlot(), ItemStack.f_41583_);
            if (!player.m_150109_().m_36063_(newArmor)) {
                player.m_36176_(newArmor, true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER) {
            return;
        }
        float hearts = (SkillsUtils.isSkillActive(event.player, "combat:2") ? SkillsUtils.getAnInt(event.player, "combat:2") : 0.0f) + (float)SkillsUtils.getStatAmount("heart", event.player);
        SkillsHandler.removeAttribute((LivingEntity)event.player, "etheria_heart_modif", Attributes.f_22276_, AttributeModifier.Operation.ADDITION);
        if (hearts > 0.0f) {
            SkillsHandler.applyAttribute((LivingEntity)event.player, "etheria_heart_modif", Attributes.f_22276_, hearts, AttributeModifier.Operation.ADDITION);
        }
        if (SkillsUtils.isSkillActive(event.player, "combat:4") && event.player.m_21205_().m_41720_() instanceof SwordItem) {
            float percent = SkillsUtils.getAnInt(event.player, "combat:4");
            AttributeInstance attr = event.player.m_21051_(Attributes.f_22283_);
            if (attr != null) {
                float base = (float)attr.m_22135_();
                float bonus = base * (percent / 100.0f);
                SkillsHandler.removeAttribute((LivingEntity)event.player, "etheria_attack_speed_combat", Attributes.f_22283_, AttributeModifier.Operation.ADDITION);
                SkillsHandler.applyAttribute((LivingEntity)event.player, "etheria_attack_speed_combat", Attributes.f_22283_, bonus, AttributeModifier.Operation.ADDITION);
            }
        } else if (SkillsUtils.isSkillActive(event.player, "combat:5") && event.player.m_21205_().m_41720_() instanceof AxeItem) {
            float percent = SkillsUtils.getAnInt(event.player, "combat:5");
            AttributeInstance attr = event.player.m_21051_(Attributes.f_22283_);
            if (attr != null) {
                float base = (float)attr.m_22135_();
                float bonus = base * (percent / 100.0f);
                SkillsHandler.removeAttribute((LivingEntity)event.player, "etheria_attack_speed_combat", Attributes.f_22283_, AttributeModifier.Operation.ADDITION);
                SkillsHandler.applyAttribute((LivingEntity)event.player, "etheria_attack_speed_combat", Attributes.f_22283_, bonus, AttributeModifier.Operation.ADDITION);
            }
        } else {
            SkillsHandler.removeAttribute((LivingEntity)event.player, "etheria_attack_speed_combat", Attributes.f_22283_, AttributeModifier.Operation.ADDITION);
        }
    }

    public static boolean isItemBlocked(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return !SkillsUtils.getSkillItemUnlock(player, String.valueOf(id));
    }

    public static void applyAttribute(LivingEntity entity, String name, Attribute attribute, float value, AttributeModifier.Operation operation) {
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        AttributeModifier modifier = new AttributeModifier(uuid, name, (double)value, operation);
        if (instance == null || instance.m_22109_(modifier)) {
            return;
        }
        instance.m_22118_(modifier);
    }

    public static void removeAttribute(LivingEntity entity, String name, Attribute attribute, AttributeModifier.Operation operation) {
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes(StandardCharsets.UTF_8));
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        AttributeModifier modifier = new AttributeModifier(uuid, name, instance.m_22135_(), operation);
        if (!instance.m_22109_(modifier)) {
            return;
        }
        instance.m_22130_(modifier);
    }

    private static int getBlockXp(Block block, BlockState state) {
        if (block == Blocks.f_50089_ || block == Blocks.f_152474_) {
            return 6;
        }
        if (block == Blocks.f_50264_ || block == Blocks.f_152479_) {
            return 7;
        }
        if (block == Blocks.f_49996_ || block == Blocks.f_152468_) {
            return 3;
        }
        if (block == Blocks.f_49995_ || block == Blocks.f_152467_) {
            return 4;
        }
        if (block == Blocks.f_50173_ || block == Blocks.f_152473_) {
            return 3;
        }
        if (block == Blocks.f_50059_ || block == Blocks.f_152472_) {
            return 4;
        }
        if (block == Blocks.f_49997_ || block == Blocks.f_152469_) {
            return 2;
        }
        if (block == Blocks.f_50331_) {
            return 5;
        }
        if (block == Blocks.f_50722_) {
            return 6;
        }
        if (state.m_204336_(Tags.Blocks.ORES)) {
            return 3;
        }
        return 0;
    }
}

