/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.items;

import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.artifacts.StatType;
import it.mralxart.etheria.handlers.AchievementHandler;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.magemicon.utils.StarUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.data.SpellModifier;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.AddToastPacket;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellScrollItem
extends Item
implements IMageMiconEntryItem,
IElementItem {
    public SpellScrollItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        if (stack.m_41784_().m_128461_("spell_id").isEmpty()) {
            return Component.m_237115_((String)"item.etheria.spell_scroll");
        }
        return Component.m_237115_((String)("mage_micon.spell." + stack.m_41784_().m_128461_("spell_id")));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand p_41434_) {
        ItemStack stack = player.m_21120_(p_41434_);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            String spellId;
            Spell spell;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("spell_id") && !(spell = SpellsUtils.getSpell(player, spellId = stack.m_41783_().m_128461_("spell_id"))).isUnlock()) {
                stack.m_41774_(1);
                SpellsUtils.unlockSpell(player, spellId);
                SkillsUtils.addXp(player, Branches.MAGIC, 10);
                StarUtils.unlockStarById(player, spell.getId(), true);
                AchievementHandler.grantAdvancement(serverPlayer, "spell_scroll");
                Networking.sendToClient(serverPlayer, new AddToastPacket("textures/item/spells/" + spellId + ".png", Component.m_237115_((String)"mage_micon.new_spell").getString() + ": \n\u00a7l" + Component.m_237115_((String)("mage_micon.spell." + spellId)).getString()));
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        if (p_41422_ == null || !p_41422_.f_46443_) {
            return;
        }
        this.appendHoverTextClient(stack, p_41422_, tooltip, p_41424_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverTextClient(ItemStack stack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        String spellId = stack.m_41784_().m_128461_("spell_id");
        if (spellId.isEmpty()) {
            return;
        }
        Map<StatType, Float> mainStats = ArtifactStatsManager.getMainStats(stack);
        Map<StatType, Float> secondaryStats = ArtifactStatsManager.getSecondaryStats(stack);
        boolean isUpgrade = stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$spell_upgrade");
        List<SpellModifier> modifiers = SpellsUtils.getModifiers(spellId);
        Element element = Element.ETHER;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$element")) {
            element = Element.valueOf(stack.m_41783_().m_128461_("etheria$element").toUpperCase());
        }
        if (!modifiers.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"etheria.curve").getString() + ":")).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(element).getRGB())));
            for (SpellModifier modifier : modifiers) {
                String modifierId = modifier.getId();
                String name = Component.m_237115_((String)("mage_micon.modifier." + modifierId)).getString();
                float baseValue = isUpgrade && !SpellsUtils.isMaxLevel((Player)Minecraft.m_91087_().f_91074_, spellId) ? SpellsUtils.getUpgradeValue(spellId, modifierId, SpellsUtils.getSpellLevel((Player)Minecraft.m_91087_().f_91074_, spellId) + 1) : SpellsUtils.getUpgradeValue((Player)Minecraft.m_91087_().f_91074_, spellId, modifierId);
                MutableComponent modifierText = Component.m_237113_((String)("\u00b7 \u00a7r" + name + ": " + String.format("%.1f", Float.valueOf(baseValue))));
                try {
                    StatType statType = StatType.valueOf(modifierId.toUpperCase());
                    if (mainStats.containsKey((Object)statType)) {
                        statValue = mainStats.get((Object)statType).floatValue();
                        formattedValue = String.format("(%+,.1f%%)", Float.valueOf(statValue));
                        modifierText = modifierText.m_130946_(" \u00a7r" + formattedValue);
                    } else if (secondaryStats.containsKey((Object)statType)) {
                        statValue = secondaryStats.get((Object)statType).floatValue();
                        formattedValue = String.format("(%+,.1f%%)", Float.valueOf(statValue));
                        modifierText = modifierText.m_130946_(" \u00a7r" + formattedValue);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                tooltip.add((Component)modifierText);
            }
        }
        if (SpellsUtils.isMaxLevel((Player)Minecraft.m_91087_().f_91074_, spellId)) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)"etheria.max_level").getString()).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getColorByElement(element).getRGB())));
        }
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("basics", "spells_fundamentals");
    }

    @Override
    public Element getElement(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("etheria$element")) {
            return Element.valueOf(stack.m_41783_().m_128461_("etheria$element").toUpperCase());
        }
        return Element.ETHER;
    }

    @Override
    public Element getElement() {
        return this.getElement(this.m_7968_());
    }
}

