/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.items;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.items.base.IEtherTabEntry;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.utils.EtherUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EtherEntryItem
extends Item
implements IEtherEntryItem,
IEtherTabEntry,
IElementItem,
IMageMiconEntryItem {
    private final int maxEther;

    public EtherEntryItem(Item.Properties properties, int maxEther) {
        super(properties);
        this.maxEther = maxEther;
    }

    @Override
    public List<ItemStack> etherTab() {
        ItemStack itemStack = this.m_7968_();
        EtherUtils.setEther(itemStack, this.maxEther);
        return Lists.newArrayList((Object[])new ItemStack[]{itemStack});
    }

    @Override
    public int getMaxEther() {
        return this.maxEther;
    }

    @Override
    public Element getElement() {
        return Element.ETHER;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            tooltip.add((Component)Component.m_237115_((String)"etheria.shift").m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(this.getElement()).getRGB())));
        } else {
            tooltip.add((Component)Component.m_237113_((String)Component.m_237115_((String)(this.m_5524_() + ".tooltip")).getString()).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(Element.ETHER).getRGB())));
        }
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"etheria.ether").getString() + ": " + EtherUtils.getEther(stack) + " / " + EtherUtils.getMaxEther(stack))));
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("items", "ether_vessels");
    }
}

