/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.items;

import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.magic.spells.entities.SpellEntity;
import it.mralxart.etheria.magic.weapon.WeaponItem;
import it.mralxart.etheria.magic.weapon.base.AttributeEffectBuilder;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.magic.weapon.base.WeaponRarity;
import it.mralxart.etheria.magic.weapon.base.WeaponType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CatalystItem
extends WeaponItem
implements IElementItem,
IMageMiconEntryItem {
    private final Element element;

    public CatalystItem(Element element, float baseDamage, float baseAttackSpeed, WeaponType type, WeaponRarity rarity, Item.Properties properties, AttributeEffectBuilder builder) {
        super(baseDamage, baseAttackSpeed, type, rarity, properties, builder);
        this.element = element;
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return true;
    }

    @Override
    protected void normalAttack(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        float damage = this.calculateDamage(stack) * 0.2f;
        Vec3 look = player.m_20154_();
        DamageContext context = ArtifactStatCalculator.createContext((LivingEntity)player, damage, this.element);
        SpellEntity spell = new SpellEntity(level, damage, this.element.name().toUpperCase());
        spell.m_5602_((Entity)player);
        spell.setScale(0.7f);
        spell.setContext(context);
        spell.m_6034_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
        spell.m_20256_(look.m_82490_(1.5));
        spell.m_20242_(true);
        level.m_7967_((Entity)spell);
    }

    @Override
    protected void chargedAttack(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        float damage = this.calculateDamage(stack) * 0.8f;
        Vec3 look = player.m_20154_();
        DamageContext context = ArtifactStatCalculator.createContext((LivingEntity)player, damage, this.element);
        SpellEntity spell = new SpellEntity(level, damage, this.element.name().toUpperCase());
        spell.m_5602_((Entity)player);
        spell.setContext(context);
        spell.m_6034_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
        spell.m_20256_(look.m_82490_(1.5));
        spell.m_20242_(true);
        level.m_7967_((Entity)spell);
    }

    @Override
    @NotNull
    public Component m_7626_(@NotNull ItemStack p_41458_) {
        MutableComponent component = Component.m_237115_((String)this.m_5671_(p_41458_));
        int stars = p_41458_.m_41784_().m_128441_("etheria$stars") ? (p_41458_.m_41783_() != null ? p_41458_.m_41783_().m_128451_("etheria$stars") : 0) : 1;
        String starsText = "[" + "\u2605".repeat(Math.max(0, stars)) + "\u2606".repeat(Math.max(0, 5 - stars)) + "]";
        MutableComponent starsComponent = Component.m_237113_((String)starsText).m_130948_(component.m_7383_());
        return Component.m_237113_((String)(component.getString() + " " + starsComponent.getString())).m_130948_(component.m_7383_().m_178520_(ElementsUtils.getColorByElement(this.getElement()).getRGB()));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        return super.m_7203_(p_41432_, p_41433_, p_41434_);
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("items", "basic_runes");
    }
}

