/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.integration.jei;

import it.mralxart.etheria.client.gui.SkillScreen;
import it.mralxart.etheria.integration.jei.RitualRecipe;
import it.mralxart.etheria.items.RuneItem;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.magic.magemicon.Page;
import it.mralxart.etheria.magic.rituals.data.RitualData;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.EtherUtils;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipe> {
    public static final RecipeType<RitualRecipe> TYPE = RecipeType.create((String)"etheria", (String)"rituals", RitualRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public void draw(RitualRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RitualData ritual = recipe.data();
        SkillScreen.renderTooltipBorder(guiGraphics, new ResourceLocation("etheria", "textures/gui/border_paper.png"), 144, 115, -5, -5);
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/next_page.png"), 119, 58, 19.0f, 0.0f, 19, 11, 38, 11);
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (recipe.data().isEnigma() && Minecraft.m_91087_().f_91073_ != null) {
            Page.renderEntityInInventoryFollowsAngle(guiGraphics, 75, 5, 20, (float)mouseX, (float)mouseY, ((EntityType)EntityRegistry.SHADOW_NIHILIS.get()).m_20615_((Level)Minecraft.m_91087_().f_91073_));
        }
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), 67, 56, 0.0f, 0.0f, 16, 16, 16, 16);
        ItemStack orb = this.findBestOrbForRitual(ritual);
        if (!orb.m_41619_()) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), 10, 56, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        int runeIndex = 0;
        for (RuneItem ignored : ritual.getRunes().values()) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), runeIndex * 15, 105, 0.0f, 0.0f, 16, 16, 16, 16);
            ++runeIndex;
        }
        int baseX = 33;
        int baseY = 26;
        for (int i = 0; i < 8; ++i) {
            int row = i / 4;
            int col = i % 4;
            int offX = baseX + col * 23;
            int offY = baseY + row * 30;
            if (i == 1 || i == 2) {
                offY -= 16;
            }
            if (i == 5 || i == 6) {
                offY += 16;
            }
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), offX, offY + 14, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget.png"), 135, 55, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(150, 120);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.ETHER_ALTAR.get()));
    }

    public RecipeType<RitualRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"Rituals");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualRecipe recipe, IFocusGroup focusGroup) {
        RitualData ritual = recipe.data();
        builder.addSlot(RecipeIngredientRole.INPUT, 67, 40).addIngredients(ritual.getMainIngredient());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 67, 54).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.ETHER_ALTAR.get()}));
        ItemStack orb = this.findBestOrbForRitual(ritual);
        if (!orb.m_41619_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 10, 40).addItemStack(orb);
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 10, 54).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.ETHER_DISTRIBUTOR.get()}));
        }
        int runeIndex = 0;
        for (RuneItem rune : ritual.getRunes().values()) {
            builder.addSlot(RecipeIngredientRole.INPUT, runeIndex * 15, 91).addItemStack(new ItemStack((ItemLike)rune));
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, runeIndex * 15, 104).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.RUNIC_PEDESTAL.get()}));
            ++runeIndex;
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(ritual.getIngredients().values());
        int totalItems = ingredients.size();
        int baseX = 33;
        int baseY = 26;
        for (int i = 0; i < 8; ++i) {
            int row = i / 4;
            int col = i % 4;
            int offX = baseX + col * 23;
            int offY = baseY + row * 30;
            if (i == 1 || i == 2) {
                offY -= 16;
            }
            if (i == 5 || i == 6) {
                offY += 16;
            }
            if (totalItems >= i + 1) {
                builder.addSlot(RecipeIngredientRole.INPUT, offX, offY + 2).addIngredients((Ingredient)ingredients.get(i));
            }
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, offX, offY + 14).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.ETHER_PEDESTAL.get()}));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 135, 42).addItemStack(recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 135, 54).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.ETHER_ALTAR.get()}));
    }

    private ItemStack findBestOrbForRitual(RitualData ritual) {
        int minEther = Integer.MAX_VALUE;
        ItemStack bestOrb = ItemStack.f_41583_;
        for (RegistryObject entry : ItemRegistry.ITEMS.getEntries()) {
            IEtherEntryItem etherItem;
            int maxEther;
            Item item;
            if (!entry.isPresent() || !((item = (Item)entry.get()) instanceof IEtherEntryItem) || (maxEther = (etherItem = (IEtherEntryItem)item).getMaxEther()) < ritual.getRequiredEther() || maxEther >= minEther) continue;
            minEther = maxEther;
            bestOrb = new ItemStack((ItemLike)item);
        }
        if (!bestOrb.m_41619_()) {
            EtherUtils.setEther(bestOrb, ritual.getRequiredEther());
        }
        return bestOrb;
    }
}

