/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageManager;

public class TranslationHandler {
    private final Map<String, Map<String, String>> translations = new ConcurrentHashMap<String, Map<String, String>>();

    public TranslationHandler addTranslation(String language, String key, String text) {
        this.translations.computeIfAbsent(language, k -> new HashMap()).put(key, text);
        return this;
    }

    public String getTranslation(String language, String key) {
        Map<String, String> langTranslations = this.translations.get(language);
        if (langTranslations != null && langTranslations.containsKey(key)) {
            return langTranslations.get(key);
        }
        Map<String, String> defaultTranslations = this.translations.get("en_us");
        return defaultTranslations != null ? defaultTranslations.getOrDefault(key, key) : key;
    }

    public boolean contains(String language, String key) {
        Map<String, String> langTranslations = this.translations.get(language);
        if (langTranslations != null && langTranslations.containsKey(key)) {
            return true;
        }
        Map<String, String> defaultTranslations = this.translations.get("en_us");
        return defaultTranslations != null && defaultTranslations.containsKey(key);
    }

    public boolean contains(String key) {
        Map<String, String> langTranslations = this.translations.get(TranslationHandler.getClientLanguage());
        if (langTranslations != null && langTranslations.containsKey(key)) {
            return true;
        }
        Map<String, String> defaultTranslations = this.translations.get("en_us");
        return defaultTranslations != null && defaultTranslations.containsKey(key);
    }

    public static String getClientLanguage() {
        LanguageManager languageManager = Minecraft.m_91087_().m_91102_();
        return languageManager.m_264236_();
    }

    public static String translate(String key) {
        String clientLanguage = TranslationHandler.getClientLanguage();
        return TranslationHandler.build().getTranslation(clientLanguage, key);
    }

    public static TranslationHandler build() {
        return new TranslationHandler().addTranslation("ru_ru", "mage_micon.page.ether_mirror", "\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u043e\u0435 \u0417\u0435\u0440\u043a\u0430\u043b\u043e\u00a7r - \u0434\u0440\u0435\u0432\u043d\u044f\u044f \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0430\u044f \u0447\u0438\u0441\u0442\u044b\u0439 \u044d\u0444\u0438\u0440 \u0438\u0437 \u044d\u0444\u0438\u0440\u043d\u044b\u0445 \u0441\u043e\u0441\u0443\u0434\u043e\u0432 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u044d\u043d\u0435\u0440\u0433\u0438\u0438. \u042d\u0442\u043e\u0442 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0441\u0432\u043e\u0435\u043c\u0443 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0443 \u0437\u0430\u043f\u0435\u0447\u0430\u0442\u043b\u0435\u0442\u044c \u043c\u0435\u0441\u0442\u043e, \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0432 \u043d\u0430 \u043d\u0435\u0433\u043e \u043e\u0442\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0437\u0435\u0440\u043a\u0430\u043b\u0430 [SHIFT] + [\u041f\u041a\u041c], \u0430 \u0437\u0430\u0442\u0435\u043c \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438\u0441\u044c \u0442\u0443\u0434\u0430. {CRAFT1}").addTranslation("ru_ru", "mage_micon.page.elemental_compass", "\u00a7l\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u0440\u043d\u0430\u044f \u044d\u043c\u0431\u043b\u0435\u043c\u0430\u00a7r - \u0434\u0440\u0435\u0432\u043d\u0438\u0439 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u043f\u0440\u0438\u0437\u0432\u0430\u043d\u043d\u044b\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0438\u0441\u043a\u0430\u0442\u0435\u043b\u044f \u043a \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430\u043c \u0441\u0442\u0438\u0445\u0438\u0438. \u041e\u0434\u043d\u0430\u043a\u043e \u0432 \u0441\u0432\u043e\u0435\u043c \u043d\u044b\u043d\u0435\u0448\u043d\u0435\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u043e\u043d\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0441\u043f\u044f\u0449\u0435\u043c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438. \u0427\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0431\u0443\u0434\u0438\u0442\u044c \u0435\u0451, \u00a7l\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043d\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0439 \u0441\u0442\u0438\u0445\u0438\u0435\u0439 \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u043c\u00a7r.\n {CRAFT1}\n {RITUAL1}\n {RITUAL2}\n {RITUAL3}").addTranslation("ru_ru", "mage_micon.page.ether_collector", "\u00a7l\u0421\u0431\u043e\u0440\u0449\u0438\u043a \u042d\u0444\u0438\u0440\u0430\u00a7r - \u044d\u0442\u043e \u0434\u0440\u0435\u0432\u043d\u0438\u0439 \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c, \u043e\u0441\u0442\u0430\u0432\u0448\u0438\u0439\u0441\u044f \u043e\u0442 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044b\u0439 \u0434\u043b\u044f \u0441\u0431\u043e\u0440\u0430 \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u044b\u0445 \u044d\u0444\u0438\u0440\u043e\u0432\u044b\u0445 \u043f\u043e\u0442\u043e\u043a\u043e\u0432, \u0447\u0442\u043e \u043f\u0440\u043e\u0445\u043e\u0434\u044f\u0442 \u0447\u0435\u0440\u0435\u0437 \u043c\u0438\u0440. \u041e\u043d \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u043e\u0447\u044c\u044e, \u043a\u043e\u0433\u0434\u0430 \u043d\u0435\u0431\u0435\u0441\u0430 \u043d\u0430\u043f\u043e\u043b\u043d\u044f\u044e\u0442\u0441\u044f \u0441\u043a\u0440\u044b\u0442\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439 \u044d\u0444\u0438\u0440\u0430. \u041e\u0434\u043d\u0430\u043a\u043e \u0435\u0433\u043e \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u044c \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0430: \u0432 \u0440\u0430\u0434\u0438\u0443\u0441\u0435 20 \u0431\u043b\u043e\u043a\u043e\u0432 \u043e\u0442 \u0421\u0431\u043e\u0440\u0449\u0438\u043a\u0430 \u042d\u0444\u0438\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0434\u0440\u0443\u0433\u0438\u0445 \u0442\u0430\u043a\u0438\u0445 \u0436\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432. \u0415\u0441\u043b\u0438 \u0436\u0435 \u0432 \u044d\u0442\u043e\u043c \u0440\u0430\u0434\u0438\u0443\u0441\u0435 \u043e\u043a\u0430\u0436\u0435\u0442\u0441\u044f \u0435\u0449\u0435 \u043e\u0434\u0438\u043d \u0421\u0431\u043e\u0440\u0449\u0438\u043a, \u043e\u0431\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u043f\u0435\u0440\u0435\u0441\u0442\u0430\u043d\u0443\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c, \u043f\u043e\u0441\u043a\u043e\u043b\u044c\u043a\u0443 \u044d\u0444\u0438\u0440\u043d\u044b\u0435 \u043f\u043e\u0442\u043e\u043a\u0438 \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u0442\u044c\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u043d\u0438\u043c.\n\n\n\u0414\u043b\u044f \u00a7l\u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f\u00a7r \u042d\u0444\u0438\u0440\u0430 \u0438\u0437 \u0421\u0431\u043e\u0440\u0449\u0438\u043a\u0430 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u044d\u0444\u0438\u0440\u043e\u0432\u044b\u0439 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b \u0438 \u0441\u043e\u0441\u0443\u0434, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0439 \u0445\u0440\u0430\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0441\u043e\u043a\u0440\u043e\u0432\u0435\u043d\u043d\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u043c\u0430\u0433\u0438\u0438.\n{CRAFT1}\n").addTranslation("ru_ru", "mage_micon.page.ether_source", "\u00a7l\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 \u044d\u0444\u0438\u0440\u0430\u00a7r - \u044d\u0442\u043e \u0434\u0440\u0435\u0432\u043d\u0438\u0435 \u0443\u0437\u043b\u044b \u0441\u0438\u043b\u044b, \u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c\u0438. \u041e\u043d\u0438 \u043d\u0430\u043f\u043e\u043b\u043d\u044f\u044e\u0442 \u043c\u0438\u0440 \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439 \u0438 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u044b \u0434\u043b\u044f \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f \u0447\u0438\u0441\u0442\u043e\u0433\u043e \u044d\u0444\u0438\u0440\u0430.\n\n\u0427\u0442\u043e\u0431\u044b \u0437\u0430\u0431\u0440\u0430\u0442\u044c \u044d\u0444\u0438\u0440 \u0438\u0437 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430, \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u044d\u0444\u0438\u0440\u043e\u0432\u044b\u0439 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b \u0438 \u0441\u043e\u0441\u0443\u0434, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0439 \u0445\u0440\u0430\u043d\u0438\u0442\u044c \u044d\u043d\u0435\u0440\u0433\u0438\u044e, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440,\u00a7l \u044d\u0444\u0438\u0440\u043d\u044b\u0439 \u00a7l\u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u00a7r.\n\n\u041f\u043e\u043b\u043e\u0436\u0438\u0432 \u0441\u043e\u0441\u0443\u0434 \u043d\u0430 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b, \u043c\u043e\u0436\u043d\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0442\u043e\u043a \u044d\u0444\u0438\u0440\u0430 \u0432\u043d\u0443\u0442\u0440\u044c, \u0430\u043a\u043a\u0443\u043c\u0443\u043b\u0438\u0440\u0443\u044f \u0435\u0433\u043e \u0434\u043b\u044f \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f.\n\n\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 \u043d\u0435 \u0432\u0435\u0447\u043d\u044b - \u0441\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u0438\u0445 \u0437\u0430\u043f\u0430\u0441 \u0438\u0441\u0442\u043e\u0449\u0430\u0435\u0442\u0441\u044f. \u041e\u0434\u043d\u0430\u043a\u043e \u0438\u0445 \u043c\u043e\u0436\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u044d\u0444\u0438\u0440\u043e\u0432\u044b\u0445 \u043e\u0441\u043a\u043e\u043b\u043a\u043e\u0432, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043f\u0440\u043e\u0431\u0443\u0436\u0434\u0430\u044e\u0442 \u0443\u0437\u043b\u044b, \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044f \u0438\u043c \u0432\u043d\u043e\u0432\u044c \u0438\u0437\u043b\u0443\u0447\u0430\u0442\u044c \u044d\u0444\u0438\u0440\u043d\u0443\u044e \u0441\u0438\u043b\u0443.\n\n\u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043d\u0430\u0437\u044b\u0432\u0430\u043b\u0438 \u044d\u0442\u043e\u0442 \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u042d\u0444\u0438\u0440\u043d\u044b\u043c \u043f\u043e\u0442\u043e\u043a\u043e\u043c - \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u044b\u043c, \u043d\u043e \u043e\u0449\u0443\u0442\u0438\u043c\u044b\u043c \u0434\u043b\u044f \u0442\u0435\u0445, \u043a\u0442\u043e \u0441\u043f\u043e\u0441\u043e\u0431\u0435\u043d \u0447\u0443\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0434\u044b\u0445\u0430\u043d\u0438\u0435 \u043c\u0430\u0433\u0438\u0438.\n\n\n{CRAFT1}\n\u041f\u0440\u0438 \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d\u0438\u0438 \u042d\u0444\u0438\u0440\u043e\u0432\u043e\u0433\u043e \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0441 \u043d\u0435\u0433\u043e \u0432\u044b\u043f\u0430\u0434\u0435\u0442 \u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u043e\u0435 \u042f\u0434\u0440\u043e\u00a7r.\n{ITEMS1}\n").addTranslation("ru_ru", "mage_micon.page.ether_anvil", "\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f\u00a7r - \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0441\u0432\u044f\u0437\u0443\u044e\u0449\u0438\u0439 \u0438\u0445 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u043e \u0441 \u0441\u0438\u043b\u043e\u0439 \u044d\u0444\u0438\u0440\u0430. \u041e\u043d\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b, \u0430 \u0442\u0430\u043a\u0436\u0435 \u043d\u0430\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u0442\u044c \u0438\u0445 \u0441\u0438\u043b\u0443 \u043d\u0430 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438 \u043e\u0440\u0443\u0436\u0438\u0435. {CRAFT1}").addTranslation("ru_ru", "mage_micon.page.ether_anvil2", "\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f\u00a7r - \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0441\u0432\u044f\u0437\u0443\u044e\u0449\u0438\u0439 \u0438\u0445 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u043e \u0441 \u0441\u0438\u043b\u043e\u0439 \u044d\u0444\u0438\u0440\u0430. \u041e\u043d\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b, \u0430 \u0442\u0430\u043a\u0436\u0435 \u043d\u0430\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u0442\u044c \u0438\u0445 \u0441\u0438\u043b\u0443 \u043d\u0430 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438 \u043e\u0440\u0443\u0436\u0438\u0435.").addTranslation("ru_ru", "mage_micon.page.ether_anvil3", "\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044f\u00a7r - \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0441\u0432\u044f\u0437\u0443\u044e\u0449\u0438\u0439 \u0438\u0445 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u043e \u0441 \u0441\u0438\u043b\u043e\u0439 \u044d\u0444\u0438\u0440\u0430. \u041e\u043d\u0430 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b, \u0430 \u0442\u0430\u043a\u0436\u0435 \u043d\u0430\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u0442\u044c \u0438\u0445 \u0441\u0438\u043b\u0443 \u043d\u0430 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438 \u043e\u0440\u0443\u0436\u0438\u0435.\n\u041f\u043e\u043c\u0435\u0441\u0442\u0438\u0442\u0435 \u041a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u0432 \u043b\u0435\u0432\u044b\u0439 \u0441\u043b\u043e\u0442. \u0412\u043e \u0432\u0442\u043e\u0440\u043e\u0439 \u0441\u043b\u043e\u0442 \u043f\u043e\u043c\u0435\u0441\u0442\u0438\u0442\u0435 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b.").addTranslation("ru_ru", "mage_micon.page.seal_pedestal", "\u00a7l\u041f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b \u043f\u0435\u0447\u0430\u0442\u0438\u00a7r - \u043a\u043b\u044e\u0447\u0438 \u043a \u0440\u0430\u0437\u0433\u0430\u0434\u043a\u0435 \u0434\u0440\u0435\u0432\u043d\u0438\u0445 \u0430\u043b\u0442\u0430\u0440\u0435\u0439. \u042d\u0442\u0438 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b \u043c\u043e\u0436\u043d\u043e \u0432\u0441\u0442\u0440\u0435\u0442\u0438\u0442\u044c \u0432 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0440\u0443\u0438\u043d\u0430\u0445 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0432 \u043a\u043e\u043c\u043d\u0430\u0442\u0430\u0445 \u0441 \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u043c\u0438 \u043a\u0440\u0443\u0433\u0430\u043c\u0438, \u0441\u043f\u0440\u044f\u0442\u0430\u043d\u043d\u044b\u043c\u0438 \u043f\u043e\u0434 \u043c\u043e\u0449\u043d\u044b\u043c\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0435\u0447\u0430\u0442\u044c\u044e.\n{ITEMS1}\n\u041a\u0440\u0438\u043e \u043f\u0435\u0447\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0441\u043e\u0431\u043e\u0439 \u043c\u0430\u0441\u0441\u0438\u0432\u043d\u0443\u044e \u0433\u043b\u044b\u0431\u0443 \u043b\u044c\u0434\u0430, \u043d\u0430\u0432\u0435\u043a\u0438 \u043e\u043a\u0443\u0442\u044b\u0432\u0430\u044e\u0449\u0443\u044e \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0440\u0443\u0433 \u0438 \u043f\u0440\u043e\u0447\u043d\u043e \u0437\u0430\u043f\u0435\u0447\u0430\u0442\u044b\u0432\u0430\u044e\u0449\u0443\u044e \u0435\u0433\u043e. \u0427\u0442\u043e\u0431\u044b \u0440\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c \u044d\u0442\u0443 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0437\u0430\u043c\u043e\u0440\u043e\u0437\u043a\u0443, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b \u043f\u0435\u0447\u0430\u0442\u0438 \u0440\u044f\u0434\u043e\u043c \u0441 \u0430\u043b\u0442\u0430\u0440\u043d\u044b\u043c \u043a\u0440\u0443\u0433\u043e\u043c \u0438 \u0440\u0430\u0437\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043d\u0430 \u043d\u0438\u0445 \u043e\u0441\u043e\u0431\u044b\u0435 \u043f\u0438\u0440\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b.\n\u041f\u0438\u0440\u043e \u043f\u0435\u0447\u0430\u0442\u044c, \u043d\u0430\u043f\u0440\u043e\u0442\u0438\u0432, \u043e\u043a\u0443\u0442\u044b\u0432\u0430\u0435\u0442 \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0440\u0443\u0433, \u044f\u0440\u043a\u0438\u043c \u0438 \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u044b\u043c \u043e\u0433\u043d\u0451\u043c, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u0434\u0430\u0451\u0442 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u044c \u0440\u0438\u0442\u0443\u0430\u043b\u044b, \u043a\u0430\u043a \u0431\u0443\u0434\u0442\u043e \u043e\u043d\u043e \u0441\u0430\u043c\u043e \u0441\u0442\u0440\u0435\u043c\u0438\u0442\u0441\u044f \u043f\u043e\u0433\u043b\u043e\u0442\u0438\u0442\u044c \u043b\u044e\u0431\u0443\u044e \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u0432\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430. \u0414\u043b\u044f \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043e\u0433\u043d\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0435\u0433\u0440\u0430\u0434\u044b \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043d\u0430 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u0430\u0445 \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043a\u0440\u0438\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0435 \u0443\u043a\u0440\u043e\u0442\u0438\u0442\u044c \u043d\u0435\u043e\u0431\u0443\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u0436\u0430\u0440.\n\n\u041b\u0438\u0448\u044c \u0438\u0441\u0442\u0438\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0434\u043b\u044f \u0441\u043d\u044f\u0442\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0435\u0439, \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0442 \u043f\u0443\u0442\u043d\u0438\u043a\u0430\u043c \u043b\u0438\u0448\u044c \u0437\u0430\u0433\u0430\u0434\u043a\u0438 \u0434\u0440\u0435\u0432\u043d\u043e\u0441\u0442\u0438 \u0438 \u0442\u0430\u0439\u043d\u0443 \u043e \u0442\u043e\u043c, \u043a\u0430\u043a\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0442\u0440\u0435\u0431\u0443\u044e\u0442\u0441\u044f \u0434\u043b\u044f \u0441\u043d\u044f\u0442\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438.\n").addTranslation("ru_ru", "mage_micon.page.sender", "\u042d\u0442\u0438 \u0434\u0432\u0430 \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u0430 \u0432\u043e\u043f\u043b\u043e\u0449\u0430\u044e\u0442 \u043c\u0430\u0441\u0442\u0435\u0440\u0441\u0442\u0432\u043e \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432 \u0432 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u043e\u0442\u043e\u043a\u0430\u043c\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0438. \u00a7l\u041f\u0435\u0440\u0435\u0434\u0430\u0442\u0447\u0438\u043a\u00a7r, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c\u0438, \u043e\u0431\u0440\u0435\u0442\u0430\u0435\u0442 \u0441\u0432\u043e\u044e \u043c\u043e\u0449\u044c \u0432 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u044b\u043c\u0438 \u043f\u043e\u0442\u043e\u043a\u0430\u043c\u0438. \u041e\u043d \u0441\u043f\u043e\u0441\u043e\u0431\u0435\u043d \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u0445\u0440\u0430\u043d\u044f\u0449\u0438\u0435\u0441\u044f \u0432 \u0434\u0440\u0435\u0432\u043d\u0438\u0445 \u0441\u043e\u0441\u0440\u0435\u0434\u043e\u0442\u043e\u0447\u0438\u044f\u0445 - \u0441\u0443\u043d\u0434\u0443\u043a\u0438, - \u043a \u0441\u0432\u043e\u0435\u043c\u0443 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u043c\u0443 \u00a7l\u041f\u0440\u0438\u0451\u043c\u043d\u0438\u043a\u0443\u00a7r.{CRAFT1} \u0421\u0432\u044f\u0437\u044c \u043c\u0435\u0436\u0434\u0443 \u043d\u0438\u043c\u0438 \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043f\u0430\u043b\u043e\u0447\u043a\u0438, \u0447\u0442\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u044f\u0435\u0442 \u0438\u0445 \u044d\u0444\u0438\u0440\u043e\u0432\u044b\u043c\u0438 \u043f\u0443\u0442\u044f\u043c\u0438. \u042d\u0442\u0438 \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u044b \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0432 \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e\u0439 \u0433\u0430\u0440\u043c\u043e\u043d\u0438\u0438, \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0441\u043a\u0432\u043e\u0437\u044c \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0430, \u0441\u043b\u043e\u0432\u043d\u043e \u043f\u043e\u0434\u0447\u0438\u043d\u044f\u044f \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0437\u0430\u043a\u043e\u043d\u044b \u044d\u0444\u0438\u0440\u0443.").addTranslation("ru_ru", "mage_micon.page.ice_source", "\u00a7l\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u041b\u044c\u0434\u0430\u00a7r - \u044d\u0442\u043e \u043e\u0441\u043a\u043e\u043b\u043e\u043a \u0434\u0440\u0435\u0432\u043d\u0435\u0439 \u043c\u0430\u0433\u0438\u0438, \u0445\u0440\u0430\u043d\u044f\u0449\u0438\u0439\u0441\u044f \u0432 \u0433\u043b\u0443\u0431\u0438\u043d\u0430\u0445 \u043b\u0435\u0434\u044f\u043d\u044b\u0445 \u0440\u0443\u0438\u043d. \u042d\u0442\u043e\u0442 \u043b\u0435\u0434\u044f\u043d\u043e\u0439 \u043c\u043e\u043d\u043e\u043b\u0438\u0442 \u0438\u0441\u0442\u043e\u0447\u0430\u0435\u0442 \u0445\u043e\u043b\u043e\u0434 \u043d\u0430\u0441\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0438\u043b\u044c\u043d\u044b\u0439, \u0447\u0442\u043e \u0434\u0430\u0436\u0435 \u043a\u0440\u0430\u0442\u043a\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0435 \u043d\u0430\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0440\u044f\u0434\u043e\u043c \u0441 \u043d\u0438\u043c \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u0437\u0430\u043c\u0435\u0440\u0437\u0430\u043d\u0438\u044e. \u0415\u0433\u043e \u043f\u043e\u0432\u0435\u0440\u0445\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043a\u0440\u044b\u0442\u0430 \u043b\u0435\u0434\u044f\u043d\u043e\u0439 \u043a\u043e\u0440\u043a\u043e\u0439, \u043e\u0442\u0440\u0430\u0436\u0430\u044e\u0449\u0435\u0439 \u0441\u0432\u0435\u0442, \u0430 \u0432 \u0435\u0433\u043e \u044f\u0434\u0440\u0435 \u0437\u0430\u0442\u0430\u0438\u043b\u0441\u044f \u043c\u043e\u0440\u043e\u0437, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0439 \u0432\u044b\u0436\u0435\u0447\u044c \u0442\u0435\u043f\u043b\u043e \u0438\u0437 \u0432\u0441\u0435\u0433\u043e, \u0447\u0442\u043e \u043f\u0440\u0438\u0431\u043b\u0438\u0437\u0438\u0442\u0441\u044f. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438 \u0442\u0430\u043a\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 \u0434\u043b\u044f \u0441\u0432\u043e\u0438\u0445 \u043b\u0435\u0434\u044f\u043d\u044b\u0445 \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432, \u0447\u0435\u0440\u043f\u0430\u044f \u0438\u0437 \u043d\u0438\u0445 \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u0445\u043e\u043b\u043e\u0434\u0430 \u0438 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u044f \u0432\u0435\u0447\u043d\u044b\u0439 \u043b\u0451\u0434. \u0415\u0433\u043e \u0440\u0430\u0431\u043e\u0442\u0443 \u043c\u043e\u0436\u043d\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u00a7l\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u00a7r, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0432 \u043e\u0433\u043d\u0435\u043d\u043d\u044b\u0439 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b.").addTranslation("ru_ru", "mage_micon.page.base_runes", "\u00a7l\u0420\u0443\u043d\u044b\u00a7r - \u044d\u0442\u043e \u0434\u0440\u0435\u0432\u043d\u0438\u0435 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0435 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c\u0438 \u0432 \u0442\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430, \u043a\u043e\u0433\u0434\u0430 \u044d\u0444\u0438\u0440 \u0431\u044b\u043b \u0435\u0449\u0451 \u043c\u043e\u043b\u043e\u0434. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438 \u0440\u0443\u043d\u044b \u043a\u0430\u043a \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442, \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0449\u0438\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u043e\u0442\u043e\u043a \u044d\u0444\u0438\u0440\u0430 \u0432 \u043d\u0443\u0436\u043d\u043e\u0435 \u0440\u0443\u0441\u043b\u043e, \u0447\u0442\u043e\u0431\u044b \u0438\u0437\u0431\u0435\u0436\u0430\u0442\u044c \u0435\u0433\u043e \u0445\u0430\u043e\u0442\u0438\u0447\u043d\u043e\u0439 \u043f\u0440\u0438\u0440\u043e\u0434\u044b. \u042d\u0442\u0438 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0441\u0442\u0430\u043b\u0438 \u043a\u043b\u044e\u0447\u043e\u043c \u043a \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044e \u043d\u0430\u0434 \u044d\u0444\u0438\u0440\u043e\u043c.\n\n\u041a\u0430\u0436\u0434\u0430\u044f \u0440\u0443\u043d\u0430 \u0437\u0430\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0432 \u0441\u0435\u0431\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u0443 \u043c\u0443\u0434\u0440\u043e\u0441\u0442\u0438 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0437\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d\u043d\u0443\u044e \u0432 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u0441\u0438\u043c\u0432\u043e\u043b\u0435. \u041e\u043d\u0438 \u0441\u043b\u0443\u0436\u0430\u0442 \u0441\u0432\u044f\u0437\u0443\u044e\u0449\u0438\u043c \u0437\u0432\u0435\u043d\u043e\u043c \u043c\u0435\u0436\u0434\u0443 \u044d\u0444\u0438\u0440\u043e\u043c \u0438 \u043c\u0438\u0440\u043e\u043c, \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430\u043c\u0438. \u0418\u043c\u0435\u043d\u043d\u043e \u0440\u0443\u043d\u044b \u043f\u043e\u0437\u0432\u043e\u043b\u0438\u043b\u0438 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0441\u043b\u043e\u0436\u043d\u044b\u0435 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438, \u043d\u0435 \u0431\u043e\u044f\u0441\u044c \u0442\u043e\u0433\u043e, \u0447\u0442\u043e \u044d\u0444\u0438\u0440 \u0443\u0441\u043a\u043e\u043b\u044c\u0437\u043d\u0451\u0442 \u0438\u0437-\u043f\u043e\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f.\n\n\u00a7l\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0440\u0443\u043d\u00a7r\n\n\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0440\u0443\u043d - \u043f\u0440\u043e\u0446\u0435\u0441\u0441, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0437\u043d\u0430\u043d\u0438\u0439 \u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432. \u041a\u0430\u0436\u0434\u0430\u044f \u0440\u0443\u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u0451\u0442\u0441\u044f \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043f\u0440\u043e\u0441\u0442\u044b\u0445 \u0438\u043d\u0433\u0440\u0438\u0434\u0438\u0435\u043d\u0442\u043e\u0432 \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u0432\u0435\u0440\u0441\u0442\u0430\u043a\u0430. \u042d\u0442\u043e\u0442 \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0435\u0442 \u044d\u0444\u0438\u0440 \u0438 \u0437\u0430\u043f\u0435\u0447\u0430\u0442\u044b\u0432\u0430\u0435\u0442 \u0435\u0433\u043e \u0432 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u0441\u0438\u043c\u0432\u043e\u043b\u0435.\n{CRAFT1}\n\u041a\u0430\u0436\u0434\u0430\u044f \u0440\u0443\u043d\u0430 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u0430, \u0435\u0451 \u0441\u0438\u043b\u0443 \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u043e\u0434\u0447\u0438\u043d\u0438\u0442\u044c. \u0415\u0451 \u043c\u043e\u0436\u043d\u043e \u043b\u0438\u0448\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c, \u0440\u0430\u0441\u043a\u0440\u044b\u0432\u0430\u044f \u0435\u0451 \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0430\u043b \u0432 \u043d\u0443\u0436\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0432\u0435\u0440\u0438\u043b\u0438, \u0447\u0442\u043e \u0440\u0443\u043d\u044b - \u044d\u0442\u043e \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442, \u043d\u043e \u0438 \u0434\u0430\u0440, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0439 \u0441\u043e\u0435\u0434\u0438\u043d\u044f\u0442\u044c \u043c\u0438\u0440 \u0441 \u0447\u0438\u0441\u0442\u043e\u0439 \u043c\u0430\u0433\u0438\u0435\u0439 \u044d\u0444\u0438\u0440\u0430.\n\n\n\n\n\u00a7r\"\u00a7l\u0421\u0438\u043c\u0432\u043e\u043b\u044b, \u0447\u0442\u043e \u043c\u044b \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c, \u0441\u0442\u0430\u043d\u0443\u0442 \u043f\u0443\u0442\u0435\u0432\u043e\u0434\u043d\u043e\u0439 \u043d\u0438\u0442\u044c\u044e \u0434\u043b\u044f \u0442\u0435\u0445, \u043a\u0442\u043e \u043e\u0434\u043d\u0430\u0436\u0434\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u0437\u0430 \u043d\u0430\u043c\u0438. \u042d\u0444\u0438\u0440 \u0442\u0435\u0447\u0451\u0442 \u0432 \u043d\u0438\u0445, \u0430 \u043e\u043d\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0442 \u0435\u0433\u043e \u0432 \u043c\u0438\u0440.\u00a7r\"\n\u00a7r- \u0438\u0437 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430 \u042d\u043b\u044c'\u0422\u0430\u0440\u0430.\n").addTranslation("ru_ru", "mage_micon.page.rituals", "\u00a7l\u0420\u0438\u0442\u0443\u0430\u043b\u044b\u00a7r - \u044d\u0442\u043e \u0434\u0440\u0435\u0432\u043d\u044f\u044f \u043d\u0430\u0443\u043a\u0430 \u0438 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u043e, \u0443\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u043e\u0442 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0442\u0430\u044f\u0449\u0438\u0445 \u0432 \u0441\u0435\u0431\u0435 \u0441\u0438\u043b\u0443 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0444\u0438\u0440\u0430. \u041e\u043d\u0438 \u0432\u0435\u0440\u0438\u043b\u0438, \u0447\u0442\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u044b - \u044d\u0442\u043e \u043c\u043e\u0441\u0442 \u043c\u0435\u0436\u0434\u0443 \u043c\u0438\u0440\u0430\u043c\u0438, \u0433\u0434\u0435 \u0434\u0443\u0445 \u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u044f\u044e\u0442\u0441\u044f \u0432 \u0435\u0434\u0438\u043d\u043e\u043c \u0442\u0430\u043d\u0446\u0435. \u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u043e\u0447\u043d\u043e\u0441\u0442\u0438, \u043d\u043e \u0438 \u043c\u0443\u0434\u0440\u043e\u0441\u0442\u0438, \u0438\u0431\u043e \u043a\u0430\u0436\u0434\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0438\u0432\u0435\u0441\u0442\u0438 \u043a \u043d\u0435\u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0443\u0435\u043c\u044b\u043c \u043f\u043e\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u044f\u043c.\n\n\u00a7l\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u0440\u0443\u0433\u0430\u00a7r\n\n\u0414\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u043e\u0437\u0432\u0435\u0441\u0442\u0438 \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0440\u0443\u0433, \u0445\u043e\u0442\u044f \u0441\u0430\u043c\u043e \u043f\u043e\u043d\u044f\u0442\u0438\u0435 \u043a\u0440\u0443\u0433\u0430 \u0443\u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u043e \u0441\u043a\u043e\u0440\u0435\u0435 \u043e\u0442 \u0442\u0440\u0430\u0434\u0438\u0446\u0438\u0438, \u0447\u0435\u043c \u043e\u0442 \u0444\u043e\u0440\u043c\u044b. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0433\u043e\u0432\u043e\u0440\u0438\u043b\u0438: \"\u0413\u0430\u0440\u043c\u043e\u043d\u0438\u044f \u044d\u0444\u0438\u0440\u0430 \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0433\u0440\u0430\u043d\u0438\u0446, \u0435\u0451 \u043f\u043e\u0442\u043e\u043a\u0438 \u043f\u043e\u0434\u0447\u0438\u043d\u044f\u044e\u0442\u0441\u044f \u043b\u0438\u0448\u044c \u0432\u043e\u043b\u0435 \u043c\u0430\u0433\u0430.\" \u0422\u0430\u043a\u0438\u043c \u043e\u0431\u0440\u0430\u0437\u043e\u043c, \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b \u043a\u0440\u0443\u0433\u0430 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u044b \u0445\u0430\u043e\u0442\u0438\u0447\u043d\u043e, \u043d\u043e \u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0441\u0442\u0430\u044e\u0442\u0441\u044f \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u043c\u0438 \u0441 \u0435\u0433\u043e \u0441\u0435\u0440\u0434\u0446\u0435\u043c - \u0430\u043b\u0442\u0430\u0440\u0451\u043c.\n\n\u2022 \u00a7l\u0410\u043b\u0442\u0430\u0440\u044c\u00a7r - \u0426\u0435\u043d\u0442\u0440 \u0432\u0441\u044f\u043a\u043e\u0433\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u0430, \u043c\u0435\u0441\u0442\u043e \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f. \u0417\u0434\u0435\u0441\u044c \u0440\u0430\u0437\u043c\u0435\u0449\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442, \u0447\u0442\u043e \u0441\u0442\u0430\u043d\u0435\u0442 \u043e\u0441\u043d\u043e\u0432\u043e\u0439 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.\n\n\u2022 \u00a7l\u041f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b\u00a7r - \u041a\u0430\u043c\u043d\u0438 \u043f\u0440\u043e\u0432\u043e\u0434\u043d\u0438\u043a\u043e\u0432, \u0447\u0442\u043e \u0434\u0435\u0440\u0436\u0430\u0442 \u0432 \u0441\u0435\u0431\u0435 \u0441\u0438\u043b\u0443 \u044d\u0444\u0438\u0440\u0430. \u041d\u0430 \u043d\u0438\u0445 \u043f\u043e\u043a\u043e\u044f\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0434\u043b\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u0430. \u0418\u0445 \u044d\u043d\u0435\u0440\u0433\u0438\u044f \u0441\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432\u043e\u0435\u0434\u0438\u043d\u043e \u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a \u0430\u043b\u0442\u0430\u0440\u044e.\n{CRAFT1}\n\n\u2022 \u00a7l\u0420\u0443\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b\u00a7r - \u041e\u0441\u043e\u0431\u044b\u0435 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b, \u0432\u043f\u0438\u0442\u044b\u0432\u0430\u044e\u0449\u0438\u0435 \u043c\u0430\u0433\u0438\u044e \u0440\u0443\u043d, \u0447\u044c\u044f \u043c\u043e\u0449\u044c \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0442\u043e\u0433\u043e, \u0447\u0442\u043e\u0431\u044b \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u044d\u0444\u0438\u0440 \u0442\u043e\u0447\u043d\u043e \u0432 \u0446\u0435\u043b\u044c \u0440\u0438\u0442\u0443\u0430\u043b\u0430.\n\n\u2022 \u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u044b\u0439 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c\u00a7r - \u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0441\u0438\u043b\u044b, \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u0438\u0442\u0430\u043d\u0438\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u0430. \u0417\u0434\u0435\u0441\u044c \u0440\u0430\u0437\u043c\u0435\u0449\u0430\u044e\u0442\u0441\u044f \u0441\u043e\u0441\u0443\u0434\u044b \u044d\u0444\u0438\u0440\u0430, \u0431\u0435\u0437 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u0430\u0433\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.\n{CRAFT2}\n\n\u2022 \u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u043f\u0440\u0438\u0437\u043c\u0430\u00a7r - \u041a\u043b\u044e\u0447 \u0434\u043b\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u043e\u043d\u043a\u0438\u043c\u0438 \u044d\u043d\u0435\u0440\u0433\u0438\u044f\u043c\u0438 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432. \u041f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0441\u043d\u0438\u0437\u0438\u0442\u044c \u0440\u0438\u0441\u043a \u0438\u043b\u0438 \u0443\u0441\u0438\u043b\u0438\u0442\u044c \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435.\n{CRAFT3}\n\n\n\n\u00a7l\u0418\u0432\u0435\u043d\u0442\u044b \u0440\u0438\u0442\u0443\u0430\u043b\u0430\u00a7r\n\n\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0440\u0438\u0442\u0443\u0430\u043b\u0430 - \u044d\u0442\u043e \u0432\u0441\u0435\u0433\u0434\u0430 \u0440\u0438\u0441\u043a \u0438 \u0442\u0430\u0439\u043d\u0430. \u0414\u0430\u0436\u0435 \u0441\u0430\u043c\u044b\u0435 \u043c\u0443\u0434\u0440\u044b\u0435 \u043f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043d\u0435 \u043c\u043e\u0433\u043b\u0438 \u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435\u0445 \u0441\u043e\u0431\u044b\u0442\u0438\u0439, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0433\u0443\u0442 \u043f\u0440\u043e\u0438\u0437\u043e\u0439\u0442\u0438. \u0412\u043e\u0442 \u043e\u0441\u043d\u043e\u0432\u043d\u044b\u0435 \u0438\u0437 \u043d\u0438\u0445:\n\n\u2022 \u00a7l\u042d\u0441\u0441\u0435\u043d\u0446\u0438\u044f\u00a7r - \u0412 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438 \u0441\u043b\u043e\u0436\u043d\u044b\u0445 \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432 \u044d\u0444\u0438\u0440 \u043f\u043e\u0440\u043e\u0439 \u0440\u043e\u0436\u0434\u0430\u0435\u0442 \u044d\u0441\u0441\u0435\u043d\u0446\u0438\u044e - \u0440\u0435\u0434\u043a\u0438\u0439 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b, \u043d\u0435\u0441\u0443\u0449\u0438\u0439 \u0432 \u0441\u0435\u0431\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u0443\u044e \u043c\u0443\u0434\u0440\u043e\u0441\u0442\u044c \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432. \u042d\u0442\u0430 \u0441\u0443\u0431\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043d\u0443\u0436\u043d\u0430 \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0439 \u0438\u043b\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0443\u0442\u0438 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432 \u0432 \u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440\u0435.\n\n\n\u2022 \u00a7l\u041a\u0440\u0430\u0445 \u0440\u0438\u0442\u0443\u0430\u043b\u0430\u00a7r - \u041a\u043e\u0433\u0434\u0430 \u0441\u0438\u043b\u044b \u044d\u0444\u0438\u0440\u0430 \u0432\u044b\u0445\u043e\u0434\u044f\u0442 \u0438\u0437-\u043f\u043e\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f, \u0440\u0438\u0442\u0443\u0430\u043b \u043c\u043e\u0436\u0435\u0442 \u043e\u0431\u0440\u0443\u0448\u0438\u0442\u044c\u0441\u044f. \u0412\u0441\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u0440\u0430\u0437\u043c\u0435\u0449\u0451\u043d\u043d\u044b\u0435 \u043d\u0430 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u0430\u0445, \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0431\u0440\u043e\u0448\u0435\u043d\u044b, \u0430 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u0437 \u043d\u0438\u0445 \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c\u0441\u044f. \u041b\u0438\u0448\u044c \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u0441 \u0437\u0430\u0449\u0438\u0442\u043d\u043e\u0439 \u043c\u0430\u0433\u0438\u0435\u0439 \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b \u0441\u043d\u0438\u0437\u0438\u0442\u044c \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c \u043a\u0440\u0430\u0445\u0430.\n\n\u2022 \u00a7l\u0412\u0441\u043f\u044b\u0448\u043a\u0430 \u044d\u0444\u0438\u0440\u0430\u00a7r - \u041f\u043e\u0442\u043e\u043a\u0438 \u044d\u0444\u0438\u0440\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0443\u0435\u043c\u044b. \u041e\u043d\u0438 \u043c\u043e\u0433\u0443\u0442 \u0432\u043d\u0435\u0437\u0430\u043f\u043d\u043e \u0432\u0441\u043f\u044b\u0445\u043d\u0443\u0442\u044c, \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0432 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u043d\u043e\u0432\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439 \u0438\u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u0438\u0432 \u0441\u0432\u043e\u0439 \u0433\u043d\u0435\u0432 \u043d\u0430 \u043e\u043a\u0440\u0443\u0436\u0430\u044e\u0449\u0438\u0445. \u042d\u0442\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u0435\u0434\u043e\u0442\u0432\u0440\u0430\u0442\u0438\u0442\u044c, \u043d\u043e \u043a\u0430\u0436\u0434\u044b\u0439 \u043c\u0430\u0433 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0433\u043e\u0442\u043e\u0432 \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u0438\u0445.\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7l\u0418\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432 \u043f\u043e\u0434\u043e\u0431\u043d\u043e \u0432\u0435\u0442\u0440\u0443. \u041e\u043d\u043e \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0433\u0440\u0435\u0442\u044c \u043e\u0447\u0430\u0433 \u0438\u043b\u0438 \u0440\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u044c \u0441\u0442\u0435\u043d\u044b \u0434\u043e\u043c\u0430. \u041d\u043e \u0438\u043c\u0435\u043d\u043d\u043e \u0432 \u044d\u0442\u043e\u0439 \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0438\u0441\u0442\u0438\u043d\u043d\u0430\u044f \u043c\u0430\u0433\u0438\u044f - \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0442\u0435\u043c, \u0447\u0442\u043e \u0441\u0442\u0440\u0435\u043c\u0438\u0442\u0441\u044f \u0432\u044b\u0440\u0432\u0430\u0442\u044c\u0441\u044f \u043d\u0430 \u0441\u0432\u043e\u0431\u043e\u0434\u0443.\u00a7r\"\n\u00a7r- \u0438\u0437 \u0442\u0440\u0430\u043a\u0442\u0430\u0442\u0430 \u043f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432.").addTranslation("ru_ru", "mage_micon.page.ether", "\u00a7l\u042d\u0444\u0438\u0440\u00a7r - \u044d\u0442\u043e \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c, \u043f\u0440\u043e\u043d\u0438\u0437\u044b\u0432\u0430\u044e\u0449\u0430\u044f \u0441\u0430\u043c\u043e \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044b\u0442\u0438\u044f, \u0441\u0432\u044f\u0437\u0443\u044e\u0449\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u044f \u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u044e. \u041e\u043d \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043b \u0437\u0430\u0434\u043e\u043b\u0433\u043e \u0434\u043e \u0432\u0440\u0435\u043c\u0435\u043d \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0441\u0442\u0430\u0432 \u043e\u0441\u043d\u043e\u0432\u043e\u0439 \u043c\u0430\u0433\u0438\u0438 \u0438 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0447\u0443\u0434\u0435\u0441, \u043d\u0435\u043f\u043e\u0434\u0432\u043b\u0430\u0441\u0442\u043d\u044b\u0445 \u0440\u0430\u0437\u0443\u043c\u0443 \u0441\u043c\u0435\u0440\u0442\u043d\u044b\u0445. \u0412 \u0441\u0432\u043e\u0435\u0439 \u043d\u0435\u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u0444\u043e\u0440\u043c\u0435 \u044d\u0444\u0438\u0440 \u2013 \u044d\u0442\u043e \u043f\u043e\u0442\u043e\u043a\u0438 \u0447\u0438\u0441\u0442\u043e\u0439 \u0441\u0438\u043b\u044b, \u0434\u0432\u0438\u0436\u0443\u0449\u0438\u0435\u0441\u044f \u0441\u043a\u0432\u043e\u0437\u044c \u043c\u0438\u0440 \u0438 \u043f\u0438\u0442\u0430\u044e\u0449\u0438\u0435 \u0440\u0438\u0442\u0443\u0430\u043b\u044b, \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b. \u0412 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e\u043c \u0432\u0438\u0434\u0435 \u043e\u043d \u043f\u0440\u043e\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432 \u0432\u0438\u0434\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432, \u043c\u0438\u043d\u0435\u0440\u0430\u043b\u043e\u0432 \u0438 \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0441\u043b\u0438\u0442\u043a\u043e\u0432, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0445 \u0432 \u0430\u043b\u0445\u0438\u043c\u0438\u0438 \u0438 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u0440\u0435\u043c\u0435\u0441\u043b\u0435.\n\n\n\n\n\n\n\u00a7l\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u044d\u0444\u0438\u0440\u00a7r\n\n\u041c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u044b\u0439 \u044d\u0444\u0438\u0440 \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0432 \u0432\u0438\u0434\u0435 \u043e\u0441\u043e\u0431\u044b\u0445 \u043c\u0438\u043d\u0435\u0440\u0430\u043b\u043e\u0432, \u0432\u043f\u0438\u0442\u0430\u0432\u0448\u0438\u0445 \u0435\u0433\u043e \u0441\u0438\u043b\u0443 \u0432 \u0433\u043b\u0443\u0431\u0438\u043d\u0430\u0445 \u0437\u0435\u043c\u043b\u0438. \u042d\u0442\u0438 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b \u0445\u0440\u0430\u043d\u044f\u0442 \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0443\u044e \u044d\u043d\u0435\u0440\u0433\u0438\u044e, \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0443\u044e \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f, \u0438 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044e\u0442 \u043c\u0430\u0433\u0430\u043c \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0441 \u044d\u0444\u0438\u0440\u043d\u044b\u043c\u0438 \u043f\u043e\u0442\u043e\u043a\u0430\u043c\u0438.\n\n\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u0440\u0443\u0434\u0430\u00a7r \u2013 \u0440\u0435\u0434\u043a\u0438\u0439 \u043c\u0438\u043d\u0435\u0440\u0430\u043b, \u0441\u043a\u0440\u044b\u0442\u044b\u0439 \u0432 \u0433\u043b\u0443\u0431\u0438\u043d\u0430\u0445 \u0437\u0435\u043c\u043b\u0438. \u041f\u0440\u0438 \u0434\u043e\u0431\u044b\u0447\u0435 \u043e\u043d \u0440\u0430\u0441\u043f\u0430\u0434\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043e\u0441\u043a\u043e\u043b\u043a\u0438 \u044d\u0444\u0438\u0440\u0430, \u0430 \u0432 \u0440\u0435\u0434\u043a\u0438\u0445 \u0441\u043b\u0443\u0447\u0430\u044f\u0445 - \u043d\u0430 \u0446\u0435\u043b\u044c\u043d\u044b\u0435 \u044d\u0444\u0438\u0440\u043d\u044b\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0435 \u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u044d\u043d\u0435\u0440\u0433\u0438\u0438.\n\n\n\n\n\u00a7l\u0421\u043b\u0438\u0442\u043e\u043a \u044d\u0444\u0438\u0440\u0430\u00a7r - \u044d\u0442\u043e \u043e\u0447\u0438\u0449\u0435\u043d\u043d\u0430\u044f \u0438 \u043f\u0435\u0440\u0435\u043f\u043b\u0430\u0432\u043b\u0435\u043d\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430 \u044d\u0444\u0438\u0440\u043d\u044b\u0445 \u043e\u0441\u043a\u043e\u043b\u043a\u043e\u0432. \u041e\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432, \u043a\u0430\u043d\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e\u0449\u0438\u0445 \u044d\u0444\u0438\u0440, \u0438 \u0432 \u043e\u0441\u043e\u0431\u044b\u0445 \u0440\u0438\u0442\u0443\u0430\u043b\u0430\u0445.\n{CRAFT1}\n\n\u00a7l\u042d\u0444\u0438\u0440\u00a7r\n\n\u041d\u043e \u044d\u0444\u0438\u0440 - \u044d\u0442\u043e \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043a\u0430\u043c\u043d\u0438 \u0438 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b. \u041d\u0430\u0441\u0442\u043e\u044f\u0449\u0430\u044f \u0435\u0433\u043e \u0441\u0438\u043b\u0430 \u0442\u0435\u0447\u0435\u0442 \u0441\u043a\u0432\u043e\u0437\u044c \u043c\u0438\u0440, \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u044b\u043c\u0438 \u043f\u043e\u0442\u043e\u043a\u0430\u043c\u0438 \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u044f \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0435\u0434\u0438\u043d\u043e.\n\n\n\n\n\u00a7r\"\u00a7l\u042d\u0444\u0438\u0440 \u043f\u043e\u0434\u043e\u0431\u0435\u043d \u0434\u044b\u0445\u0430\u043d\u0438\u044e \u043c\u0438\u0440\u0430. \u041b\u0438\u0448\u044c \u043e\u0442\u043a\u0440\u044b\u0432 \u0441\u0435\u0440\u0434\u0446\u0435, \u0442\u044b \u043f\u043e\u0447\u0443\u0432\u0441\u0442\u0432\u0443\u0435\u0448\u044c \u0435\u0433\u043e, \u0430 \u043b\u0438\u0448\u044c \u043a\u043e\u0441\u043d\u0443\u0432\u0448\u0438\u0441\u044c - \u043e\u0431\u0440\u0435\u0442\u0435\u0448\u044c.\u00a7r\"\n\u00a7r- \u0438\u0437 \u0442\u0440\u0430\u043a\u0442\u0430\u0442\u0430 \u043f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432.\n").addTranslation("ru_ru", "mage_micon.page.catalyst", "\u0412 \u044d\u043f\u043e\u0445\u0443 \u0440\u0430\u0441\u0446\u0432\u0435\u0442\u0430 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043f\u043e\u043d\u044f\u043b\u0438, \u0447\u0442\u043e \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u042d\u0444\u0438\u0440\u043e\u043c \u0433\u043e\u043b\u044b\u043c\u0438 \u0440\u0443\u043a\u0430\u043c\u0438 - \u0437\u043d\u0430\u0447\u0438\u0442 \u0442\u0435\u0440\u044f\u0442\u044c \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0443 \u0435\u0433\u043e \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0430\u043b\u0430. \u0418\u043c \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043b\u0441\u044f \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0439 \u043d\u0435 \u043f\u0440\u043e\u0441\u0442\u043e \u0432\u044b\u043f\u0443\u0441\u043a\u0430\u0442\u044c \u043c\u0430\u0433\u0438\u044e, \u0430 \u0444\u043e\u043a\u0443\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c, \u043f\u0440\u0435\u043b\u043e\u043c\u043b\u044f\u0442\u044c \u0438 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u0435\u0451. \u0422\u0430\u043a \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u00a7l\u041a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u044b\u00a7r - \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b, \u0441\u0442\u0430\u0432\u0448\u0438\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435\u043c \u0432\u043e\u043b\u0438 \u043c\u0430\u0433\u0430.\n\u041a\u0430\u0436\u0434\u044b\u0439 \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u043d\u0435\u0440\u0430\u0437\u0440\u044b\u0432\u043d\u043e \u0441\u0432\u044f\u0437\u0430\u043d \u0441 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0441\u0442\u0438\u0445\u0438\u0435\u0439. \u042d\u0442\u043e \u043d\u0435 \u043f\u0440\u043e\u0441\u0442\u043e \u043e\u0440\u0443\u0436\u0438\u0435, \u0430 \u0441\u043b\u043e\u0436\u043d\u0430\u044f \u043f\u0440\u0438\u0437\u043c\u0430, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u043e\u043a\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u0442 \u043d\u0435\u0439\u0442\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u044d\u0444\u0438\u0440 \u0432 \u0446\u0432\u0435\u0442\u0430 \u0440\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432.\n{ITEMS1}\n\u00a7l\u0418\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u043e \u0431\u043e\u044f\u00a7r\n\n\u0412\u043b\u0430\u0434\u0435\u043d\u0438\u0435 \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u043e\u043c \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043f\u043e\u043d\u0438\u043c\u0430\u043d\u0438\u044f \u0440\u0438\u0442\u043c\u0430.\n\u00a7l\u041e\u0431\u044b\u0447\u043d\u044b\u0435 \u0430\u0442\u0430\u043a\u0438\u00a7r \u0431\u044b\u0441\u0442\u0440\u044b \u0438 \u0442\u043e\u0447\u043d\u044b. \u041e\u043d\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0437\u0430\u0440\u044f\u0434 \u0441\u0430\u043c\u043e\u0433\u043e \u043e\u0440\u0443\u0436\u0438\u044f, \u043d\u0430\u043d\u043e\u0441\u044f \u0443\u043c\u0435\u0440\u0435\u043d\u043d\u044b\u0439 \u0443\u0440\u043e\u043d.\n\u00a7l\u0417\u0430\u0440\u044f\u0436\u0435\u043d\u043d\u044b\u0435 \u0430\u0442\u0430\u043a\u0438\u00a7r - \u044d\u0442\u043e \u043f\u0440\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u044b\u0441\u0448\u0435\u0433\u043e \u043c\u0430\u0441\u0442\u0435\u0440\u0441\u0442\u0432\u0430. \u0417\u0430\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044f \u043f\u043e\u0442\u043e\u043a, \u043c\u0430\u0433 \u0437\u0430\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u0440\u0435\u0437\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441 \u043e\u043a\u0440\u0443\u0436\u0430\u044e\u0449\u0438\u043c \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u043e\u043c, \u0432\u044b\u0442\u044f\u0433\u0438\u0432\u0430\u044f \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0439 \u044d\u0444\u0438\u0440 \u043f\u0440\u044f\u043c\u043e \u0438\u0437 \u0432\u043e\u0437\u0434\u0443\u0445\u0430. \u042d\u0442\u043e\u0442 \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0432\u044b\u0431\u0440\u043e\u0441 \u043e\u0431\u043b\u0430\u0434\u0430\u0435\u0442 \u0441\u043e\u043a\u0440\u0443\u0448\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u0441\u0438\u043b\u043e\u0439, \u0437\u043d\u0430\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u043f\u0440\u0435\u0432\u043e\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0439 \u043e\u0431\u044b\u0447\u043d\u044b\u0435 \u0443\u0434\u0430\u0440\u044b.\n\n\n\n\u00a7l\u041d\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0438\u043b\u043e\u0439\u00a7r\n\n\u041a\u0430\u043a \u0438 \u0436\u0438\u0432\u043e\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e, \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u0441\u043f\u043e\u0441\u043e\u0431\u0435\u043d \u0440\u0430\u0441\u0442\u0438. \u041e\u043d \u043f\u043e\u0434\u043e\u0431\u0435\u043d \u0441\u043e\u0441\u0443\u0434\u0443, \u0434\u043d\u043e \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0441\u043a\u0440\u044b\u0442\u043e \u0432\u043e \u0442\u044c\u043c\u0435. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u042d\u0444\u0438\u0440\u043d\u0443\u044e \u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u044e, \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u043f\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u043e\u0440\u0443\u0436\u0438\u0435 \u0447\u0438\u0441\u0442\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439 \u043e\u0441\u043a\u043e\u043b\u043a\u043e\u0432, \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432 \u0438 \u044d\u0441\u0441\u0435\u043d\u0446\u0438\u0439.\n\u042d\u0442\u043e\u0442 \u043f\u0440\u043e\u0446\u0435\u0441\u0441, \u043d\u0430\u0437\u044b\u0432\u0430\u0435\u043c\u044b\u0439 \u041d\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c, \u0440\u0430\u0441\u043a\u0440\u044b\u0432\u0430\u0435\u0442 \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0430\u043b \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430, \u043f\u043e\u0432\u044b\u0448\u0430\u044f \u0435\u0433\u043e \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0438 \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u044f \u043d\u0430\u043d\u043e\u0441\u0438\u043c\u044b\u0439 \u0443\u0440\u043e\u043d.\n\n\u00a7l\u0412\u043e\u0437\u0432\u044b\u0448\u0435\u043d\u0438\u0435\u00a7r\n\n\u0423 \u043b\u044e\u0431\u043e\u0439 \u0444\u043e\u0440\u043c\u044b \u0435\u0441\u0442\u044c \u043f\u0440\u0435\u0434\u0435\u043b, \u043d\u043e \u0443 \u043c\u0430\u0433\u0438\u0438 \u0435\u0433\u043e \u043d\u0435\u0442. \u041a\u043e\u0433\u0434\u0430 \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440 \u0434\u043e\u0441\u0442\u0438\u0433\u0430\u0435\u0442 \u043f\u0438\u043a\u0430 \u0441\u0432\u043e\u0438\u0445 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0435\u0439, \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0436\u0435\u0440\u0442\u0432\u0430, \u0447\u0442\u043e\u0431\u044b \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0442\u044c \u043e\u043a\u043e\u0432\u044b \u0444\u043e\u0440\u043c\u044b.\n\u0421\u043b\u0438\u044f\u043d\u0438\u0435 \u0434\u0432\u0443\u0445 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0445 \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u043e\u0432 \u043d\u0430 \u042d\u0444\u0438\u0440\u043e\u0432\u043e\u0439 \u041d\u0430\u043a\u043e\u0432\u0430\u043b\u044c\u043d\u0435 \u043d\u0430\u0437\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0412\u043e\u0437\u0432\u044b\u0448\u0435\u043d\u0438\u0435\u043c. \u041f\u0440\u0438 \u044d\u0442\u043e\u043c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435 \u043e\u0434\u043d\u0430 \u043a\u043e\u043f\u0438\u044f \u0440\u0430\u0441\u0442\u0432\u043e\u0440\u044f\u0435\u0442\u0441\u044f \u0432 \u0434\u0440\u0443\u0433\u043e\u0439, \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u044f \u0435\u0439 \u0441\u0432\u043e\u044e \"\u043f\u0430\u043c\u044f\u0442\u044c\" \u0438 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443. \u042d\u0442\u043e \u043f\u0440\u043e\u0431\u0443\u0436\u0434\u0430\u0435\u0442 \u0434\u0440\u0435\u043c\u043b\u044e\u0449\u0443\u044e \u0437\u0432\u0435\u0437\u0434\u043d\u0443\u044e \u0441\u0438\u043b\u0443 \u043e\u0440\u0443\u0436\u0438\u044f, \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u044f \u0435\u0433\u043e \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0441\u0441\u0438\u0432\u043d\u044b\u0435 \u043d\u0430\u0432\u044b\u043a\u0438.\n\u00a7r\"\u00a7l\u041c\u0435\u0447 \u043c\u043e\u0436\u0435\u0442 \u0441\u043b\u043e\u043c\u0430\u0442\u044c\u0441\u044f, \u0441\u0442\u0440\u0435\u043b\u0430 - \u043f\u0440\u043e\u043c\u0430\u0445\u043d\u0443\u0442\u044c\u0441\u044f. \u041d\u043e \u0432\u043e\u043b\u044f, \u043e\u0431\u043b\u0430\u0447\u0435\u043d\u043d\u0430\u044f \u0432 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0443\u044e \u0444\u043e\u0440\u043c\u0443, \u0431\u044c\u0435\u0442 \u0432\u0441\u0435\u0433\u0434\u0430 \u0432 \u0446\u0435\u043b\u044c.\u00a7r\"\n\u00a7r\u2014 \u041d\u0430\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0410\u0440\u043a\u0430\u0441\u0430 \u043e \u043f\u0440\u0438\u0440\u043e\u0434\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432.\n").addTranslation("ru_ru", "mage_micon.page.bosses", "\u0412 \u0434\u0440\u0435\u0432\u043d\u0438\u0445 \u0440\u0443\u0438\u043d\u0430\u0445 \u0438 \u043d\u0430 \u0432\u0435\u0440\u0448\u0438\u043d\u0430\u0445 \u0448\u043f\u0438\u043b\u0435\u0439, \u043a\u0443\u0434\u0430 \u043d\u0435 \u0441\u0442\u0443\u043f\u0430\u043b\u0430 \u043d\u043e\u0433\u0430 \u0441\u043c\u0435\u0440\u0442\u043d\u043e\u0433\u043e, \u0434\u0440\u0435\u043c\u043b\u044e\u0442 \u00a7l\u0425\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u0438\u00a7r. \u042d\u0442\u043e \u043d\u0435 \u0436\u0438\u0432\u044b\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0441\u043b\u043e\u0436\u043d\u044b\u0435 \u0433\u043e\u043b\u0435\u043c\u044b-\u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u044b, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0435 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c\u0438 \u0434\u043b\u044f \u0437\u0430\u0449\u0438\u0442\u044b \u0441\u0432\u043e\u0438\u0445 \u0441\u0432\u044f\u0442\u044b\u043d\u044c. \u0414\u0430\u0436\u0435 \u0441\u043f\u0443\u0441\u0442\u044f \u0432\u0435\u043a\u0430 \u0438\u0445 \u043c\u0435\u0445\u0430\u043d\u0438\u0437\u043c\u044b \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0431\u0435\u0437\u0443\u043f\u0440\u0435\u0447\u043d\u043e, \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0432\u0435\u0447\u043d\u044b\u043c \u043f\u043e\u0442\u043e\u043a\u043e\u043c \u042d\u0444\u0438\u0440\u0430. \u041a\u0430\u0436\u0434\u044b\u0439 \u0438\u0437 \u043d\u0438\u0445 \u2014 \u044d\u0442\u043e \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435 \u0432\u043e\u043b\u0438 \u0438 \u043c\u0430\u0441\u0442\u0435\u0440\u0441\u0442\u0432\u0430 \u0434\u043b\u044f \u043b\u044e\u0431\u043e\u0433\u043e, \u043a\u0442\u043e \u043f\u043e\u0441\u043c\u0435\u0435\u0442 \u043f\u043e\u0441\u044f\u0433\u043d\u0443\u0442\u044c \u043d\u0430 \u0442\u0430\u0439\u043d\u044b \u0434\u0440\u0435\u0432\u043d\u0438\u0445.\n").addTranslation("ru_ru", "mage_micon.page.aerolith", "\u0412\u0435\u0440\u0448\u0438\u043d\u0443 \u041d\u0435\u0431\u0435\u0441\u043d\u043e\u0433\u043e \u0428\u043f\u0438\u043b\u044f \u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442 \u00a7l\u0410\u044d\u0440\u043e\u043b\u0438\u0442\u00a7r - \u0433\u0438\u0433\u0430\u043d\u0442\u0441\u043a\u0438\u0439 \u0433\u043e\u043b\u0435\u043c \u0432 \u0444\u043e\u0440\u043c\u0435 \u0445\u0438\u0449\u043d\u043e\u0439 \u043f\u0442\u0438\u0446\u044b, \u043f\u043e\u0432\u0435\u043b\u0435\u0432\u0430\u044e\u0449\u0438\u0439 \u0443\u0440\u0430\u0433\u0430\u043d\u0430\u043c\u0438.\n\u0411\u0438\u0442\u0432\u0430 \u0441 \u043d\u0438\u043c \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0440\u0435\u0430\u043a\u0446\u0438\u0438 \u0438 \u0432\u044b\u0434\u0435\u0440\u0436\u043a\u0438. \u0410\u044d\u0440\u043e\u043b\u0438\u0442 \u0441\u0442\u0440\u0435\u043c\u0438\u0442\u0435\u043b\u0435\u043d \u0438 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e \u043c\u0435\u043d\u044f\u0435\u0442 \u043f\u043e\u0437\u0438\u0446\u0438\u044e, \u043e\u0431\u0440\u0443\u0448\u0438\u0432\u0430\u044f \u043d\u0430 \u0432\u0440\u0430\u0433\u0430 \u043f\u043e\u0442\u043e\u043a\u0438 \u0432\u0435\u0442\u0440\u0430.\n\u041c\u0443\u0434\u0440\u044b\u0439 \u043c\u0430\u0433 \u0437\u043d\u0430\u0435\u0442: \u0433\u0440\u0443\u0431\u0430\u044f \u0441\u0438\u043b\u0430 \u0437\u0434\u0435\u0441\u044c \u043d\u0435 \u043f\u043e\u043c\u043e\u0436\u0435\u0442. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u00a7l\u0449\u0438\u0442\u00a7r, \u0447\u0442\u043e\u0431\u044b \u043f\u0430\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043d\u0430\u0440\u044f\u0434\u044b \u0425\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u044f \u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0438\u0445 \u043e\u0431\u0440\u0430\u0442\u043d\u043e \u0432 \u043d\u0435\u0433\u043e. \u042d\u0442\u043e \u0435\u0434\u0438\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u0441\u043f\u043e\u0441\u043e\u0431 \u043f\u0440\u043e\u0431\u0438\u0442\u044c \u0435\u0433\u043e \u0437\u0430\u0449\u0438\u0442\u0443, \u043a\u043e\u0433\u0434\u0430 \u043e\u043d \u0443\u043a\u0440\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u0444\u0430\u0437\u0435 \"\u041a\u043e\u043a\u043e\u043d\u0430 \u0411\u0443\u0440\u0438\".\n\n\n\n\n\n\n\u00a7l\u0421\u0438\u043d\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c\u00a7r\n\n\u041a\u043e\u0433\u0434\u0430 \u0444\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0431\u043e\u043b\u043e\u0447\u043a\u0430 \u0410\u044d\u0440\u043e\u043b\u0438\u0442\u0430 \u0431\u0443\u0434\u0435\u0442 \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0430 (0 HP), \u043e\u043d \u043d\u0435 \u043f\u043e\u0433\u0438\u0431\u043d\u0435\u0442 \u0441\u0440\u0430\u0437\u0443. \u0421\u0442\u0440\u0430\u0436 \u043f\u0440\u0438\u0437\u043e\u0432\u0435\u0442 \u0441\u0430\u043c\u0443 \u041f\u0443\u0441\u0442\u043e\u0442\u0443 \u2014 \u0427\u0451\u0440\u043d\u0443\u044e \u0414\u044b\u0440\u0443.\n\u0412 \u044d\u0442\u043e\u0439 \u0444\u0430\u0437\u0435 \u0425\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u044c \u043d\u0435\u0443\u044f\u0437\u0432\u0438\u043c \u0438 \u043d\u0430\u043a\u0430\u043f\u043b\u0438\u0432\u0430\u0435\u0442 \u0437\u0430\u0440\u044f\u0434 \u0434\u043b\u044f \u0441\u043e\u043a\u0440\u0443\u0448\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0432\u0437\u0440\u044b\u0432\u0430, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0433\u043e \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0438\u0442\u044c \u0432\u0441\u0451 \u0436\u0438\u0432\u043e\u0435. \u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0441\u0431\u0438\u0442\u044c \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0430\u0446\u0438\u044e \u0414\u044b\u0440\u044b \u043d\u0435\u043f\u0440\u0435\u0440\u044b\u0432\u043d\u044b\u043c \u0433\u0440\u0430\u0434\u043e\u043c \u0430\u0442\u0430\u043a.\n\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0443\u0434\u0430\u0440\u044b \u043e\u0441\u043b\u0430\u0431\u043b\u044f\u044e\u0442 \u0437\u0430\u0440\u044f\u0434, \u043d\u043e \u0443\u0434\u0430\u0440\u044b \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f\u043c\u0438 \u043d\u0430\u043c\u043d\u043e\u0433\u043e \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u0435\u0435 \u0440\u0430\u0441\u0441\u0435\u0438\u0432\u0430\u044e\u0442 \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u0443\u044e \u044d\u043d\u0435\u0440\u0433\u0438\u044e.\n\n\u0415\u0441\u043b\u0438 \u0432\u0430\u043c \u0443\u0434\u0430\u0441\u0442\u0441\u044f \u0441\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0437\u0430\u0440\u044f\u0434 (\u043d\u0438\u0436\u0435 70%) \u0434\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430 \u0434\u0435\u0442\u043e\u043d\u0430\u0446\u0438\u0438, \u0410\u044d\u0440\u043e\u043b\u0438\u0442 \u0431\u0443\u0434\u0435\u0442 \u043f\u043e\u0431\u0435\u0436\u0434\u0435\u043d \u0438 \u0440\u0430\u0441\u0442\u0432\u043e\u0440\u0438\u0442\u0441\u044f \u0432 \u043f\u043e\u0442\u043e\u043a\u0430\u0445 \u044d\u0444\u0438\u0440\u0430.\n\n\u00a7l\u0421\u0435\u0440\u0434\u0446\u0435 \u0411\u0443\u0440\u0438\u00a7r\n\n\u041d\u0430 \u043c\u0435\u0441\u0442\u0435 \u0433\u0438\u0431\u0435\u043b\u0438 \u0425\u0440\u0430\u043d\u0438\u0442\u0435\u043b\u044f \u043e\u0441\u0442\u0430\u043d\u0435\u0442\u0441\u044f \u0435\u0433\u043e \u044f\u0434\u0440\u043e \u2014 \u0421\u0435\u0440\u0434\u0446\u0435 \u0411\u0443\u0440\u0438. \u0412 \u043d\u0451\u043c \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u044f\u0440\u043e\u0441\u0442\u044c \u0443\u0440\u0430\u0433\u0430\u043d\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0438\u043a\u043e\u0433\u0434\u0430 \u043d\u0435 \u0443\u0442\u0438\u0445\u043d\u0435\u0442.\n\u042d\u0442\u043e \u043b\u0435\u0433\u0435\u043d\u0434\u0430\u0440\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0441 \u0434\u0432\u0443\u043c\u044f \u043f\u0443\u0442\u044f\u043c\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f:\n\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0432\u0435\u043b\u0438\u043a\u043e\u0433\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u0430 \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430 \"\u0422\u0430\u043d\u0435\u0446 \u0412\u0435\u0442\u0440\u043e\u0432\" - \u043e\u0440\u0443\u0436\u0438\u044f \u0441\u0430\u043c\u043e\u0433\u043e \u0410\u044d\u0440\u043e\u043b\u0438\u0442\u0430.\n\u0416\u0435\u0440\u0442\u0432\u0430 \u0441\u0435\u0440\u0434\u0446\u0435\u043c \u0440\u0430\u0434\u0438 \u043c\u0433\u043d\u043e\u0432\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u043a\u0430\u0447\u043a\u0438 \u043b\u044e\u0431\u043e\u0433\u043e \u0410\u044d\u0440\u043e-\u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u0430 \u0434\u043e \u0435\u0433\u043e \u0430\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u043e\u0433\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c\u0430.{ITEMS1}\n\n\n\n\u00a7r\"\u00a7l\u041b\u0438\u0448\u044c \u0442\u043e\u0442, \u043a\u0442\u043e \u0441\u043f\u043e\u0441\u043e\u0431\u0435\u043d \u0443\u0441\u0442\u043e\u044f\u0442\u044c \u043f\u0435\u0440\u0435\u0434 \u0431\u0443\u0440\u0435\u0439, \u0434\u043e\u0441\u0442\u043e\u0438\u043d \u043d\u043e\u0441\u0438\u0442\u044c \u0435\u0451 \u043a\u0440\u044b\u043b\u044c\u044f.\u00a7r\"\n\u00a7r\u2014 \u041d\u0430\u0434\u043f\u0438\u0441\u044c \u0443 \u0432\u0445\u043e\u0434\u0430 \u0432 \u041d\u0435\u0431\u0435\u0441\u043d\u044b\u0439 \u0428\u043f\u0438\u043b\u044c.\n").addTranslation("ru_ru", "mage_micon.page.spells", "\u00a7l\u0417\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f\u00a7r - \u044d\u0442\u043e \u0432\u0435\u0440\u0448\u0438\u043d\u0430 \u043c\u0430\u0433\u0438\u0438 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0442\u043e\u0433\u043e, \u0447\u0442\u043e\u0431\u044b \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u044d\u0444\u0438\u0440\u043e\u043c \u0438 \u043e\u0431\u043b\u0435\u0433\u0447\u0430\u0442\u044c \u0436\u0438\u0437\u043d\u044c. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0432\u0435\u0440\u0438\u043b\u0438, \u0447\u0442\u043e \u043c\u0430\u0433\u0438\u044f - \u044d\u0442\u043e \u043f\u0443\u0442\u044c \u043a \u0433\u0430\u0440\u043c\u043e\u043d\u0438\u0438 \u0441 \u043c\u0438\u0440\u043e\u043c, \u0438 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0441\u0442\u0430\u043b\u0438 \u043e\u0442\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c \u0438\u0445 \u043c\u0443\u0434\u0440\u043e\u0441\u0442\u0438. \u041e\u043d\u0438 \u0432\u043f\u043b\u0435\u0442\u0430\u043b\u0438 \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u044d\u0444\u0438\u0440\u0430 \u0432 \u0441\u043b\u043e\u0432\u0430 \u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u044b, \u0447\u0442\u043e\u0431\u044b \u043f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0442\u044c \u0435\u0451 \u0447\u0435\u0440\u0435\u0437 \u043f\u043e\u043a\u043e\u043b\u0435\u043d\u0438\u044f. \u041a\u0430\u0436\u0434\u043e\u0435 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435 - \u044d\u0442\u043e \u043d\u0430\u0441\u043b\u0435\u0434\u0438\u0435, \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442, \u0438 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0442\u0435\u0445, \u043a\u0442\u043e \u043e\u0441\u043c\u0435\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0435\u0433\u043e.\n{ITEMS1}\n\u00a7l\u0420\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u043c\u0430\u0433\u0438\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u00a7r\n\n\u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0438\u0437\u0443\u0447\u0430\u043b\u0438 \u044d\u0444\u0438\u0440, \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u044f \u0435\u0433\u043e \u043d\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0441\u043e\u0441\u0442\u043e\u0438\u0442 \u043c\u0438\u0440: \u043e\u0433\u043e\u043d\u044c, \u043b\u0435\u0434, \u0438 \u043c\u043d\u043e\u0433\u0438\u0435 \u0434\u0440\u0443\u0433\u0438\u0435, \u043d\u044b\u043d\u0435 \u0437\u0430\u0431\u044b\u0442\u044b\u0435. \u041e\u043d\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438 \u044d\u0442\u0438 \u0437\u043d\u0430\u043d\u0438\u044f, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0443\u044e \u0441\u0438\u043b\u0443. \u0421\u0447\u0438\u0442\u0430\u043b\u043e\u0441\u044c, \u0447\u0442\u043e \u0447\u0435\u043b\u043e\u0432\u0435\u043a \u0441\u0432\u044f\u0437\u0430\u043d \u0441 \u043e\u0434\u043d\u0438\u043c \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441 \u0441\u0430\u043c\u043e\u0433\u043e \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f, \u0438 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0441\u043e\u0437\u0434\u0430\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0438\u0442\u043a\u0438, \u0447\u0442\u043e\u0431\u044b \u0442\u0435, \u043a\u0442\u043e \u043e\u0441\u043e\u0437\u043d\u0430\u043b \u0441\u0432\u043e\u0439 \u043f\u0443\u0442\u044c, \u043c\u043e\u0433\u043b\u0438 \u0441\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0438\u0445\u0438\u044e, \u0435\u0441\u043b\u0438 \u043e\u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043b\u0430\u0441\u044c \u043d\u0435\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0439.\n\n\n\n\n\u00a7l\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0439\u00a7r\n\n\u0427\u0442\u043e\u0431\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0435\u0433\u043e \u00a7l\u0438\u0437\u0443\u0447\u0438\u0442\u044c\u00a7r. \u00a7r\u042d\u0442\u043e \u043f\u0440\u043e\u0441\u0442\u043e\u0439 \u0430\u043a\u0442, \u0441\u043e\u0435\u0434\u0438\u043d\u044f\u044e\u0449\u0438\u0439 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u043d\u0438\u0435 \u0441 \u0440\u0430\u0437\u0443\u043c\u043e\u043c \u0438 \u0434\u0443\u0448\u043e\u0439 \u043c\u0430\u0433\u0430. \u041f\u043e\u0441\u043b\u0435 \u0438\u0437\u0443\u0447\u0435\u043d\u0438\u044f \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u043c \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0447\u0435\u0440\u0435\u0437 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043f\u0430\u043b\u043e\u0447\u043a\u0438. \u041e\u0434\u043d\u0430\u043a\u043e \u0435\u0441\u0442\u044c \u0432\u0430\u0436\u043d\u043e\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435: \u043c\u0430\u0433 \u043c\u043e\u0436\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043b\u0438\u0448\u044c \u0442\u0435 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u00a7l\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0435\u0433\u043e \u0442\u0435\u043a\u0443\u0449\u0435\u043c\u0443 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0443\u00a7r.\n\u0418 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u00a7l\u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u044f\u043c \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f\u00a7r, \u00a7r\u0442\u0430\u043a\u0436\u0435 \u0438\u0433\u0440\u043e\u043a\u0443 \u043f\u043e\u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0438\u043c\u0435\u0442\u044c \u043f\u0440\u0438 \u0441\u0435\u0431\u0435 \u00a7l\u0441\u043e\u0441\u0443\u0434 \u0441 \u044d\u0444\u0438\u0440\u043e\u043c\u00a7r.\n{CRAFT1}\n\u00a7r\"\u00a7l\u041c\u0430\u0433\u0438\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0442\u0435\u0447\u0451\u0442 \u0432 \u043d\u0430\u0441, \u043f\u043e\u0434\u043e\u0431\u043d\u043e \u0440\u0435\u043a\u0430\u043c \u0432 \u0437\u0435\u043c\u043b\u0435. \u041e\u0433\u043e\u043d\u044c \u0441\u043e\u0433\u0440\u0435\u0432\u0430\u0435\u0442 \u0438 \u0441\u0436\u0438\u0433\u0430\u0435\u0442, \u043b\u0435\u0434 \u0445\u0440\u0430\u043d\u0438\u0442 \u0438 \u043e\u0431\u0435\u0440\u0435\u0433\u0430\u0435\u0442. \u041c\u0430\u0433 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u043e\u043c\u043d\u0438\u0442\u044c: \u043d\u0435 \u043e\u043d \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u0441\u0442\u0438\u0445\u0438\u044e, \u043d\u043e \u0441\u0442\u0438\u0445\u0438\u044f \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u043c\u0430\u0433\u0430.\u00a7r\"\n\u00a7r- \u0438\u0437  \"\u0417\u0430\u043f\u0438\u0441\u0435\u0439 \u041f\u0435\u0440\u0432\u044b\u0445 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432\".\n").addTranslation("ru_ru", "mage_micon.page.seers", "\u0412 \u0433\u043b\u0443\u0431\u0438\u043d\u0430\u0445 \u0438\u0441\u0442\u043e\u0440\u0438\u0438, \u0437\u0430 \u0433\u0440\u0430\u043d\u044c\u044e \u043f\u0430\u043c\u044f\u0442\u0438 \u0441\u043c\u0435\u0440\u0442\u043d\u044b\u0445, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043b\u0430 \u0432\u0435\u043b\u0438\u043a\u0430\u044f \u0440\u0430\u0441\u0430, \u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u0430\u043a \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b. \u042d\u0442\u0438 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0431\u044b\u043b\u0438 \u043d\u0435 \u043f\u0440\u043e\u0441\u0442\u043e \u043c\u0430\u0441\u0442\u0435\u0440\u0430\u043c\u0438 \u044d\u0444\u0438\u0440\u0430 - \u043e\u043d\u0438 \u0431\u044b\u043b\u0438 \u0435\u0433\u043e \u0437\u0430\u0449\u0438\u0442\u043d\u0438\u043a\u0430\u043c\u0438, \u0435\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0434\u043d\u0438\u043a\u0430\u043c\u0438 \u0432 \u043c\u0438\u0440 \u043c\u0430\u0442\u0435\u0440\u0438\u0438. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0432\u0438\u0434\u0435\u043b\u0438 \u0432 \u044d\u0444\u0438\u0440\u0435 \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0441\u0438\u043b\u0443, \u043d\u043e \u0438 \u0441\u0430\u043c\u0443 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u043c\u0438\u0440\u043e\u0437\u0434\u0430\u043d\u0438\u044f, \u0436\u0438\u0437\u043d\u0435\u043d\u043d\u0443\u044e \u044d\u043d\u0435\u0440\u0433\u0438\u044e, \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u044e\u0449\u0443\u044e \u0432\u0441\u0451 \u0432\u043e\u0435\u0434\u0438\u043d\u043e.\n\n\u041e\u043d\u0438 \u0432\u043e\u0437\u0432\u0435\u043b\u0438 \u0433\u043e\u0440\u043e\u0434\u0430, \u043f\u0430\u0440\u044f\u0449\u0438\u0435 \u043d\u0430 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u043e\u0442\u043e\u043a\u0430\u0445, \u0441\u043e\u0437\u0434\u0430\u043b\u0438 \u043c\u043e\u0433\u0443\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u0438 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0438 \u0438\u0445 \u043c\u0438\u0440 \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430. \u0418\u0445 \u0441\u0442\u0440\u0435\u043c\u043b\u0435\u043d\u0438\u0435 \u043a \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0441\u0442\u0432\u0443 \u0441\u0434\u0435\u043b\u0430\u043b\u043e \u0438\u0445 \u0430\u0440\u0445\u0438\u0442\u0435\u043a\u0442\u043e\u0440\u0430\u043c\u0438 \u044d\u0444\u0438\u0440\u0430, \u043d\u043e \u043d\u0435 \u0435\u0433\u043e \u0432\u043b\u0430\u0441\u0442\u0435\u043b\u0438\u043d\u0430\u043c\u0438. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0432\u0435\u0440\u0438\u043b\u0438, \u0447\u0442\u043e \u044d\u0444\u0438\u0440 - \u044d\u0442\u043e \u0434\u0430\u0440, \u043a\u043e\u0442\u043e\u0440\u044b\u043c \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0441 \u043c\u0443\u0434\u0440\u043e\u0441\u0442\u044c\u044e \u0438 \u043e\u0441\u0442\u043e\u0440\u043e\u0436\u043d\u043e\u0441\u0442\u044c\u044e.\n\n\u041e\u043d\u0438 \u043e\u0441\u0442\u0430\u0432\u0438\u043b\u0438 \u0441\u0432\u043e\u0451 \u043d\u0430\u0441\u043b\u0435\u0434\u0438\u0435 \u0432 \u0432\u0438\u0434\u0435 \u044d\u0444\u0438\u0440\u043d\u044b\u0445 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432, \u0432\u043f\u0438\u0442\u0430\u0432\u0448\u0438\u0445 \u0432 \u0441\u0435\u0431\u044f \u0438\u0445 \u043c\u0430\u0433\u0438\u044e. \u042d\u0442\u0438 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438 \u0440\u0430\u0437\u0431\u0440\u043e\u0441\u0430\u043d\u044b \u043f\u043e \u043c\u0438\u0440\u0443, \u043a\u0430\u043a \u043c\u0430\u044f\u043a\u0438, \u043f\u0440\u0438\u0437\u044b\u0432\u0430\u044e\u0449\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0438\u0441\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c \u0434\u0435\u043b\u043e \u0434\u0440\u0435\u0432\u043d\u0438\u0445. \u041e\u0434\u043d\u0430\u043a\u043e \u0438\u0445 \u0441\u0443\u0434\u044c\u0431\u0430 \u043e\u043a\u0430\u0437\u0430\u043b\u0430\u0441\u044c \u0442\u0440\u0430\u0433\u0438\u0447\u043d\u043e\u0439...\n\n").addTranslation("ru_ru", "mage_micon.page.nihilis", "\u041c\u0438\u0440 \u0432\u043e\u043a\u0440\u0443\u0433 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432 \u0431\u044b\u043b \u043e\u043a\u0440\u0443\u0436\u0435\u043d \u043f\u043e\u0442\u043e\u043a\u0430\u043c\u0438 \u044d\u0444\u0438\u0440\u0430, \u043d\u043e \u0441\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u043e\u043d\u0438 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b\u0438, \u0447\u0442\u043e \u043d\u0430 \u043c\u0435\u0441\u0442\u0430\u0445 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432 \u0438\u043b\u0438 \u043c\u0435\u0441\u0442\u0430\u0445 \u0441 \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0430\u0446\u0438\u0435\u0439 \u044d\u0444\u0438\u0440\u0430 \u043f\u043e\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0438\u043b\u0430 \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u044e\u0449\u0430\u044f \u0435\u0433\u043e. \u041f\u043e\u0441\u043b\u0435 \u0442\u043e\u0433\u043e \u043a\u0430\u043a \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0430\u0446\u0438\u044f \u044d\u0444\u0438\u0440\u0430 \u0432 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043b\u0430\u0441\u044c, \u0441\u0438\u043b\u0430 \u043f\u0440\u043e\u043f\u0430\u0434\u0430\u043b\u0430. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043d\u0430\u0437\u0432\u0430\u043b\u0438 \u044d\u0442\u043e \u044f\u0432\u043b\u0435\u043d\u0438\u0435 \u041d\u0438\u0445\u0438\u043b\u0438\u0441 - \u044d\u0442\u043e \u0441\u0438\u043b\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u044e\u0449\u0430\u044f \u0431\u0430\u043b\u0430\u043d\u0441 \u044d\u0444\u0438\u0440\u0430 \u0432 \u043c\u0438\u0440\u0435.\n\n\u0418\u0437\u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0435 \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u0430 \u043a\u0430\u0437\u0430\u043b\u043e\u0441\u044c \u043b\u0438\u0448\u044c \u0441\u043b\u0430\u0431\u044b\u043c \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435\u043c. \u041f\u043e\u0442\u043e\u043a\u0438 \u044d\u0444\u0438\u0440\u0430 \u043f\u0440\u0438\u0445\u043e\u0434\u0438\u043b\u0438 \u0432 \u043d\u043e\u0440\u043c\u0443 \u0432 \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0445 \u0442\u043e\u0447\u043a\u0430\u0445. \u0421 \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u0435\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u044f \u044d\u0444\u0438\u0440\u0430 \u0438 \u0432\u043e\u0437\u0440\u043e\u0441\u043b\u0438 \u0441\u043b\u0443\u0447\u0430\u0438 \u0432\u043e\u0437\u043d\u0438\u043a\u043d\u043e\u0432\u0435\u043d\u0438\u044f \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u0430 \u043d\u0430 \u043c\u0435\u0441\u0442\u0430\u0445 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c \u043d\u0435 \u043d\u0440\u0430\u0432\u0438\u043b\u0430\u0441\u044c, \u0447\u0442\u043e \u044d\u0442\u0430 \u0441\u0438\u043b\u0430 \u043c\u0435\u0448\u0430\u0435\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u043e\u0431\u0438\u043b\u044c\u043d\u044b\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u043c \u044d\u0444\u0438\u0440\u0430. \u0421\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u043e\u043d\u0438 \u0437\u0430\u043c\u0435\u0442\u0438\u043b\u0438, \u0447\u0442\u043e \u041d\u0438\u0445\u0438\u043b\u0438\u0441 \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u0435\u0442 \u044d\u0444\u0438\u0440 \u0441 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0439 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c\u044e \u0438 \u043f\u043e\u043d\u044f\u043b\u0438, \u0447\u0442\u043e \u0438\u043c \u043d\u0443\u0436\u043d\u043e \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043e\u0431\u0438\u0440\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u0444\u0438\u0440\u0430.\n\n\u0423\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u0435 \u0441\u0431\u043e\u0440\u0430 \u044d\u0444\u0438\u0440\u0430 \u0432 \u0442\u043e\u0447\u043a\u0430\u0445 \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u0430 \u0441\u0442\u043e\u043b\u043a\u043d\u0443\u043b\u043e\u0441\u044c \u0441 \u043d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u043e\u0439: \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0431\u044b\u043b\u043e \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0438\u0437-\u0437\u0430 \u043d\u0435\u043f\u0440\u0435\u0440\u044b\u0432\u043d\u043e\u0433\u043e \u043f\u043e\u0442\u043e\u043a\u0430 \u044d\u0444\u0438\u0440\u0430. \u0421\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0435\u043c \u044d\u0442\u0438 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0442\u043e\u0447\u043a\u0438 \u043d\u0430\u0447\u0430\u043b\u0438 \u043f\u043e\u0440\u043e\u0436\u0434\u0430\u0442\u044c \u043d\u0435\u0447\u0442\u043e \u0443\u0434\u0438\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 - \u0441\u0432\u043e\u0438 \u0442\u0435\u043d\u0438. \u042d\u0442\u0438 \u0442\u0435\u043d\u0438, \u043d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u044e\u0449\u0438\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b, \u043a\u0430\u0437\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u0438\u043c\u0438, \u043d\u043e \u0437\u0430\u043a\u043b\u044e\u0447\u0430\u043b\u0438 \u0432 \u0441\u0435\u0431\u0435 \u043a\u043e\u043b\u043e\u0441\u0441\u0430\u043b\u044c\u043d\u0443\u044e \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0430\u0446\u0438\u044e \u044d\u043d\u0435\u0440\u0433\u0438\u0438 \u044d\u0444\u0438\u0440\u0430. \u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u044d\u0442\u0438\u0445 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432 \u0441\u0442\u0430\u043b\u043e \u043f\u043e\u0432\u043e\u0440\u043e\u0442\u043d\u044b\u043c \u043c\u043e\u043c\u0435\u043d\u0442\u043e\u043c, \u043e\u0437\u043d\u0430\u043c\u0435\u043d\u043e\u0432\u0430\u0432\u0448\u0438\u043c \u043d\u0430\u0447\u0430\u043b\u043e \u043d\u043e\u0432\u043e\u0439 \u044d\u0440\u044b \u0432 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u0438 \u0446\u0438\u0432\u0438\u043b\u0438\u0437\u0430\u0446\u0438\u0438, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \u0442\u0435\u043f\u0435\u0440\u044c \u0441\u0442\u0440\u043e\u0438\u043b\u0430\u0441\u044c \u0432\u043e\u043a\u0440\u0443\u0433 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043d\u0435\u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0439 \u0441\u0438\u043b\u044b.\n\n\n\n\n\u00a7r\"\u00a7l\u041c\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u043c \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u044d\u0442\u043e\u0439 \u0441\u0438\u043b\u043e\u0439, \u043d\u043e \u043c\u043e\u0436\u0435\u043c \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0441 \u043d\u0435\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u044f \u043f\u043e\u0442\u043e\u043a\u0438 \u044d\u0444\u0438\u0440\u0430 \u0432 \u0442\u043e\u0447\u043a\u0443 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u0430.\u00a7r\"\n\u00a7r- \u0421\u043b\u043e\u0432\u0430 \u0410\u0440\u043a\u0430\u0441\u0430, \u043b\u0438\u0434\u0435\u0440\u0430 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432.\n").addTranslation("ru_ru", "mage_micon.page.kor_lunar", "\u00a7l\u0414\u0440\u0435\u0432\u043e \u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440\u00a7r - \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u043d\u0430\u0441\u043b\u0435\u0434\u0438\u0435 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u043e\u0435 \u0432 \u0434\u043d\u0438 \u0438\u0445 \u0432\u0435\u043b\u0438\u0447\u0438\u044f. \u042d\u0442\u043e \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0434\u0440\u0435\u0432\u043e \u0431\u044b\u043b\u043e \u0432\u043e\u043f\u043b\u043e\u0449\u0435\u043d\u0438\u0435\u043c \u0438\u0445 \u0437\u043d\u0430\u043d\u0438\u0439, \u0441\u0438\u043b\u044b \u0438 \u0441\u0442\u0440\u0435\u043c\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u0449\u0438\u0442\u0438\u0442\u044c \u043c\u0430\u0433\u0438\u044e \u044d\u0444\u0438\u0440\u0430 \u043e\u0442 \u0440\u0430\u0441\u043f\u0430\u0434\u0430. \u0415\u0433\u043e \u0432\u0435\u0442\u0432\u0438 \u043a\u0430\u0441\u0430\u044e\u0442\u0441\u044f \u0437\u0432\u0451\u0437\u0434, \u0430 \u043a\u043e\u0440\u043d\u0438 \u043f\u0438\u0442\u0430\u044e\u0442\u0441\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439 \u043c\u0438\u0440\u0430.\n\n\n\n\u0414\u0440\u0435\u0432\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0441\u043e\u0431\u043e\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0440\u043e\u0441\u0442\u0430 \u0434\u043b\u044f \u0442\u0435\u0445, \u043a\u0442\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u0442 \u0435\u0433\u043e. \u0427\u0435\u0440\u0435\u0437 \u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440 \u043c\u0430\u0433\u0438 \u043c\u043e\u0433\u0443\u0442:\n\n\u2022 \u0420\u0430\u0437\u0432\u0438\u0432\u0430\u0442\u044c \u0434\u0440\u0435\u0432\u043e \u043c\u0430\u0433\u0438\u0438, \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044f \u043d\u043e\u0432\u044b\u0435 \u043f\u0443\u0442\u0438 \u0438 \u0443\u043a\u0440\u0435\u043f\u043b\u044f\u044f \u0441\u0432\u044f\u0437\u044c \u0441 \u044d\u0444\u0438\u0440\u043e\u043c.\n\n\u2022 \u0423\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u0438 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f, \u0432\u043f\u043b\u0435\u0442\u0430\u044f \u0437\u0432\u0451\u0437\u0434\u043d\u0443\u044e \u043c\u0430\u0433\u0438\u044e \u0432 \u044d\u0444\u0438\u0440.\n\n\u2022 \u041f\u0440\u0435\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0438 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432, \u043c\u0435\u043d\u044f\u044f \u0438\u0445 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0438\u043b\u044b.\n\n\u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440 \u0436\u0438\u0432\u0451\u0442 \u044d\u0444\u0438\u0440\u043e\u043c, \u0438 \u0435\u0433\u043e \u0441\u0438\u043b\u0430 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441 \u043c\u0430\u0433\u0438\u0435\u0439 \u0438\u0433\u0440\u043e\u043a\u0430. \u041d\u043e \u044d\u0442\u0430 \u0441\u0438\u043b\u0430 \u043d\u0435 \u0434\u0430\u0451\u0442\u0441\u044f \u0434\u0430\u0440\u043e\u043c: \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0435\u0440\u0435\u0437 \u0433\u043b\u0443\u0431\u043e\u043a\u043e\u0435 \u043f\u043e\u043d\u0438\u043c\u0430\u043d\u0438\u0435 \u044d\u0444\u0438\u0440\u0430 \u0438 \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f \u043c\u0430\u0433 \u043c\u043e\u0436\u0435\u0442 \u0440\u0430\u0441\u043a\u0440\u044b\u0442\u044c \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0430\u043b \u0434\u0440\u0435\u0432\u0430.\n\n\u0418\u0441\u043a\u0430\u0442\u0435\u043b\u044f\u043c \u043f\u0440\u0435\u0434\u0441\u0442\u043e\u0438\u0442 \u043f\u0440\u043e\u0439\u0442\u0438 \u0447\u0435\u0440\u0435\u0437 \u0433\u043b\u0443\u0431\u043e\u043a\u0438\u0435 \u043f\u0435\u0449\u0435\u0440\u044b \u0438 \u0437\u0430\u0431\u044b\u0442\u044b\u0435 \u043a\u043e\u0440\u0438\u0434\u043e\u0440\u044b \u0440\u0443\u0438\u043d, \u0447\u0442\u043e\u0431\u044b \u0434\u043e\u0441\u0442\u0438\u0447\u044c \u0434\u0440\u0435\u0432\u0430.\n\n\u00a7l\u041f\u043e\u0438\u0441\u043a \u0414\u0440\u0435\u0432\u0430\u00a7r\n\n\u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440 \u043d\u0430\u0439\u0442\u0438 \u043d\u0435 \u0442\u0430\u043a \u0441\u043b\u043e\u0436\u043d\u043e, \u043a\u0430\u043a \u043a\u0430\u0436\u0435\u0442\u0441\u044f. \u041d\u0430 \u043f\u043e\u0432\u0435\u0440\u0445\u043d\u043e\u0441\u0442\u0438 \u043e\u043d \u0432\u044b\u0433\u043b\u044f\u0434\u0438\u0442 \u043a\u0430\u043a \u043d\u0435\u043f\u0440\u0438\u043c\u0435\u0442\u043d\u043e\u0435 \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0440\u043e\u0437\u043e\u0432\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e, \u043d\u043e \u0435\u0433\u043e \u043a\u043e\u0440\u043d\u0438 \u0441\u043a\u0440\u044b\u0432\u0430\u044e\u0442 \u0434\u0440\u0435\u0432\u043d\u0438\u0439 \u043f\u0440\u043e\u0445\u043e\u0434 \u043f\u043e\u0434 \u0437\u0435\u043c\u043b\u044e. \u042d\u0442\u043e\u0442 \u043f\u0443\u0442\u044c \u043f\u0440\u0438\u0432\u0435\u0434\u0451\u0442 \u0432\u0430\u0441 \u043a \u043c\u043e\u0433\u0443\u0447\u0435\u043c\u0443 \u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440, \u0447\u044c\u0438 \u0432\u0435\u0442\u0432\u0438 \u0438 \u043a\u043e\u0440\u043d\u0438 \u043d\u0430\u043f\u0438\u0442\u0430\u043d\u044b \u0447\u0438\u0441\u0442\u0435\u0439\u0448\u0438\u043c \u042d\u0444\u0438\u0440\u043e\u043c. \u0414\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u043e\u0432 \u0432\u0430\u043c \u043f\u043e\u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u042d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u042d\u043c\u0431\u043b\u0435\u043c\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0443\u043a\u0430\u0436\u0435\u0442 \u0434\u043e\u0440\u043e\u0433\u0443 \u043a \u044d\u0442\u043e\u043c\u0443 \u043c\u0435\u0441\u0442\u0443 \u0441\u0438\u043b\u044b.\n\n\u00a7r\"\u00a7l\u041a\u043e\u0440\u043d\u0438 \u0435\u0433\u043e \u043e\u0431\u0432\u0438\u0432\u0430\u044e\u0442 \u0437\u0435\u043c\u043b\u044e, \u0443\u043a\u0440\u044b\u0432\u0430\u044f \u0435\u0451 \u043c\u0430\u0433\u0438\u0435\u0439. \u041d\u043e \u043d\u0435 \u043a\u0430\u0436\u0434\u043e\u043c\u0443 \u0441\u0443\u0436\u0434\u0435\u043d\u043e \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0441\u0432\u0435\u0442 \u0435\u0433\u043e \u0437\u0432\u0451\u0437\u0434\u043d\u044b\u0445 \u0432\u0435\u0442\u0432\u0435\u0439\u00a7r\"\n\u00a7r- \u0441\u043b\u043e\u0432\u0430 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430 \u0422\u0430\u0439'\u0420\u0435\u043d\u043d\u0430.\n").addTranslation("ru_ru", "mage_micon.page.artifacts", "\u00a7l\u0410\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b\u00a7r - \u044d\u0442\u043e \u0440\u0435\u0434\u0447\u0430\u0439\u0448\u0438\u0435 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0435 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c\u0438 \u0432 \u0438\u0445 \u0441\u0442\u0440\u0435\u043c\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u0443\u0437\u0434\u0430\u0442\u044c \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432 \u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043c\u043e\u0449\u044c \u044d\u0444\u0438\u0440\u0430 \u0432 \u043d\u0443\u0436\u043d\u043e\u0435 \u0440\u0443\u0441\u043b\u043e. \u041a\u0430\u0436\u0434\u044b\u0439 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442 \u0432\u043e\u043f\u043b\u043e\u0449\u0430\u0435\u0442 \u0441\u043e\u0431\u043e\u0439 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u0443\u044e \u0441\u0432\u044f\u0437\u044c \u043c\u0435\u0436\u0434\u0443 \u044d\u0444\u0438\u0440\u043e\u043c \u0438 \u043c\u0438\u0440\u043e\u043c, \u0437\u0430\u043a\u043b\u044e\u0447\u0430\u044f \u0432 \u0441\u0435\u0431\u0435 \u0441\u0438\u043b\u0443, \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0438\u0442\u044c\u0441\u044f \u0438\u043d\u044b\u043c\u0438 \u043f\u0443\u0442\u044f\u043c\u0438. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0432\u0435\u0440\u0438\u043b\u0438, \u0447\u0442\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b \u0443\u043a\u0440\u0435\u043f\u0438\u0442\u044c \u0440\u0438\u0442\u0443\u0430\u043b\u044b \u0438 \u0437\u0430\u0449\u0438\u0442\u0438\u0442\u044c \u0438\u0445 \u043e\u0442 \u0440\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u0431\u043e\u0447\u043d\u044b\u0445 \u044d\u0444\u0444\u0435\u043a\u0442\u043e\u0432.\n{ITEMS1}\n\u00a7l\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432\u00a7r\n\n\u0410\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u0437\u0430\u043d\u0438\u043c\u0430\u044e\u0442 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0432 \u043c\u0430\u0433\u0438\u0438 \u044d\u0444\u0438\u0440\u0430. \u041e\u043d\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f:\n\n\u2022 \u0412 \u0440\u0438\u0442\u0443\u0430\u043b\u0430\u0445: \u0434\u043b\u044f \u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0430\u0433\u0438\u0438 \u0438 \u0441\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u0440\u0438\u0441\u043a\u043e\u0432, \u0442\u0430\u043a\u0438\u0445 \u043a\u0430\u043a \u043a\u0440\u0430\u0445 \u0440\u0438\u0442\u0443\u0430\u043b\u0430 \u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u0433\u0440\u0443\u0437\u043a\u0430 \u044d\u0444\u0438\u0440\u0430. \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0440\u0438\u0442\u0443\u0430\u043b\u044b \u0438 \u0432\u043e\u0432\u0441\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0431\u0435\u0437 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0433\u043e \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u0430.\n\n\u2022 \u0412 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f\u0445 \u0438 \u043e\u0440\u0443\u0436\u0438\u0438: \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043d\u0430\u043b\u043e\u0436\u0435\u043d\u044b \u043d\u0430 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043f\u043e\u0441\u043e\u0445\u0438 \u0438 \u043c\u0435\u0447\u0438, \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u044f \u0438\u0445 \u043c\u043e\u0449\u044c \u0438\u043b\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u044f \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0435 \u044d\u0444\u0444\u0435\u043a\u0442\u044b. \u041e\u043d\u0438 \u0442\u0430\u043a\u0436\u0435 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0443\u044e\u0442 \u0441 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f\u043c\u0438, \u0438\u0437\u043c\u0435\u043d\u044f\u044f \u0438\u0445 \u043f\u0440\u0438\u0440\u043e\u0434\u0443 \u0438\u043b\u0438 \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u044f \u0438\u0445 \u0441\u0438\u043b\u0443.\n\n\u00a7l\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432\u00a7r\n\n\u0410\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0438\u043b\u0438 \u0432\u044b\u043a\u043e\u0432\u0430\u0442\u044c \u043e\u0431\u044b\u0447\u043d\u044b\u043c \u043f\u0443\u0442\u0451\u043c. \u0418\u0445 \u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0448\u044c \u0432 \u0434\u0440\u0435\u0432\u043d\u0438\u0445 \u0440\u0443\u0438\u043d\u0430\u0445 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u0433\u0434\u0435 \u043c\u0430\u0433\u0438\u044f \u043f\u0440\u043e\u0448\u043b\u043e\u0433\u043e \u0434\u043e \u0441\u0438\u0445 \u043f\u043e\u0440 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0438\u0445 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u0435. \u042d\u0442\u0438 \u043c\u0435\u0441\u0442\u0430 \u043f\u043e\u043b\u043d\u044b \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0435\u0439, \u043d\u043e \u0442\u0435, \u043a\u0442\u043e \u043e\u0442\u0432\u0430\u0436\u0438\u0442\u0441\u044f \u043d\u0430 \u043f\u043e\u0438\u0441\u043a\u0438, \u043c\u043e\u0433\u0443\u0442 \u043d\u0430\u0439\u0442\u0438 \u0432 \u043d\u0438\u0445 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b, \u043f\u0440\u043e\u043f\u0438\u0442\u0430\u043d\u043d\u044b\u0435 \u0432\u0435\u043b\u0438\u0447\u0438\u0435\u043c \u0443\u0448\u0435\u0434\u0448\u0435\u0439 \u044d\u043f\u043e\u0445\u0438.\n\n\u041e\u0434\u043d\u0430\u043a\u043e \u0438\u0441\u0442\u0438\u043d\u043d\u0443\u044e \u043c\u043e\u0449\u044c \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432 \u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043a\u0440\u044b\u0442\u044c \u043b\u0438\u0448\u044c \u0447\u0435\u0440\u0435\u0437 \u0434\u0440\u0435\u0432\u043e \u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440. \u0422\u0430\u043c, \u043d\u0430 \u0433\u043b\u0443\u0431\u0438\u043d\u0430\u0445 \u043c\u0438\u0440\u0430, \u0441\u0442\u0430\u0442\u044b \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432 \u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c, \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u044f \u0438\u0445 \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u0432 \u0434\u0440\u0443\u0433\u043e\u0435 \u0440\u0443\u0441\u043b\u043e. \u042d\u0442\u043e\u0442 \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0437\u043d\u0430\u043d\u0438\u0439 \u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432, \u043d\u043e \u043e\u043d \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u0438\u0442\u044c \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442 \u0434\u043b\u044f \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f.\n\n\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7l\u041c\u044b \u043e\u0441\u0442\u0430\u0432\u0438\u043b\u0438 \u044d\u0442\u0438 \u043a\u043b\u044e\u0447\u0438 \u043d\u0435 \u0440\u0430\u0434\u0438 \u0441\u043b\u0430\u0432\u044b, \u043d\u043e \u0440\u0430\u0434\u0438 \u0431\u0443\u0434\u0443\u0449\u0438\u0445 \u043f\u0443\u0442\u0435\u0439. \u041b\u0438\u0448\u044c \u0442\u0435, \u043a\u0442\u043e \u043f\u043e\u043d\u0438\u043c\u0430\u0435\u0442 \u043f\u0440\u0438\u0440\u043e\u0434\u0443 \u044d\u0444\u0438\u0440\u0430, \u0441\u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u0445 \u0442\u0430\u043a, \u043a\u0430\u043a \u0437\u0430\u0434\u0443\u043c\u0430\u043d\u043e.\u00a7r\"\n\u00a7r-  \u0438\u0437 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430 \u041a\u0430\u044d'\u041b\u0430\u0440\u0430.\n").addTranslation("ru_ru", "mage_micon.page.elements_fundamentals", "\u00a7l\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u044b\u00a7r - \u044d\u0442\u043e \u043d\u0435\u043e\u0442\u044a\u0435\u043c\u043b\u0435\u043c\u0430\u044f \u0447\u0430\u0441\u0442\u044c \u044d\u0444\u0438\u0440\u0430, \u043e\u0442\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0435\u0433\u043e \u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0439 \u043c\u043d\u043e\u0433\u043e\u0433\u0440\u0430\u043d\u043d\u043e\u0441\u0442\u0438. \u041a\u0430\u0436\u0434\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0441\u043e\u0431\u043e\u0439 \u043f\u0440\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u0430\u0441\u043f\u0435\u043a\u0442\u043e\u0432 \u0431\u044b\u0442\u0438\u044f, \u0443\u043a\u043e\u0440\u0435\u043d\u0451\u043d\u043d\u043e\u0433\u043e \u0432 \u043f\u0440\u0438\u0440\u043e\u0434\u0435 \u043c\u0438\u0440\u0430. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b, \u0438\u0437\u0443\u0447\u0430\u044f \u044d\u0444\u0438\u0440, \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b\u0438, \u0447\u0442\u043e \u043e\u043d \u043e\u0431\u043b\u0430\u0434\u0430\u0435\u0442 \u043f\u0440\u0438\u0440\u043e\u0434\u043d\u043e\u0439 \u0441\u043a\u043b\u043e\u043d\u043d\u043e\u0441\u0442\u044c\u044e \u0440\u0430\u0437\u0434\u0435\u043b\u044f\u0442\u044c\u0441\u044f \u043d\u0430 \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u0435 \u043f\u043e\u0442\u043e\u043a\u0438, \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043c.\n\n\u00a7l\u041f\u0440\u043e\u0438\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u042d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432\u00a7r\n\n\u0413\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f, \u0447\u0442\u043e \u0432 \u0434\u0440\u0435\u0432\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0430 \u044d\u0444\u0438\u0440 \u0431\u044b\u043b \u0446\u0435\u043b\u044c\u043d\u044b\u043c, \u043d\u0435\u0434\u0435\u043b\u0438\u043c\u044b\u043c, \u0441\u043b\u043e\u0432\u043d\u043e \u0431\u0435\u0437\u0431\u0440\u0435\u0436\u043d\u044b\u0439 \u043e\u043a\u0435\u0430\u043d \u044d\u043d\u0435\u0440\u0433\u0438\u0438. \u041d\u043e \u043e\u0434\u043d\u0430\u0436\u0434\u044b \u043e\u043d \u0440\u0430\u0441\u043f\u0430\u043b\u0441\u044f \u043d\u0430 \u043f\u043e\u0442\u043e\u043a\u0438, \u043e\u0442\u0440\u0430\u0436\u0430\u044e\u0449\u0438\u0435 \u043e\u0441\u043d\u043e\u0432\u043e\u043f\u043e\u043b\u0430\u0433\u0430\u044e\u0449\u0438\u0435 \u0441\u0438\u043b\u044b \u043c\u0438\u0440\u0430: \u043e\u0433\u043e\u043d\u044c, \u043b\u0451\u0434, \u0432\u043e\u0434\u0443, \u0437\u0435\u043c\u043b\u044e \u0438 \u0434\u0440\u0443\u0433\u0438\u0435. \u042d\u0442\u0438 \u043f\u043e\u0442\u043e\u043a\u0438 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043b\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b - \u0444\u0443\u043d\u0434\u0430\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0430\u0441\u043f\u0435\u043a\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0432 \u0441\u0432\u043e\u0435\u0439 \u0433\u0430\u0440\u043c\u043e\u043d\u0438\u0438 \u0441\u043e\u0437\u0434\u0430\u044e\u0442 \u0440\u0430\u0432\u043d\u043e\u0432\u0435\u0441\u0438\u0435.\n\n\n\n\n\n\u00a7l\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0432\u0438\u0442\u043a\u043e\u0432\u00a7r\n\n\u042d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0441\u0432\u0438\u0442\u043a\u0438 - \u0434\u0440\u0435\u0432\u043d\u0438\u0435 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b, \u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c\u0438. \u041a\u0430\u0436\u0434\u044b\u0439 \u0441\u0432\u0438\u0442\u043e\u043a \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0437\u0430\u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0437\u043d\u0430\u043d\u0438\u044f \u043e \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0435 \u0438 \u0441\u043b\u0443\u0436\u0438\u0442 \u043a\u043b\u044e\u0447\u043e\u043c \u043a \u043f\u0440\u043e\u0431\u0443\u0436\u0434\u0435\u043d\u0438\u044e \u0441\u0438\u043b\u044b \u0432\u043d\u0443\u0442\u0440\u0438 \u0432\u0430\u0441.\n\n\u041f\u043e\u0441\u043b\u0435 \u0438\u0437\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0432\u0438\u0442\u043a\u0430 \u0441\u0432\u044f\u0437\u044c \u0441 \u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u043c \u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0441\u044f \u0447\u0430\u0441\u0442\u044c\u044e \u0432\u0430\u0448\u0435\u0439 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438. \u042d\u0442\u043e \u0437\u043d\u0430\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0431\u044b\u0442\u044c, \u043d\u043e \u0432\u044b\u0431\u043e\u0440 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u0442\u0435\u043b\u0435\u043d. \u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440, \u043a\u0430\u043a \u0446\u0435\u043d\u0442\u0440 \u044d\u0444\u0438\u0440\u043d\u043e\u0433\u043e \u0440\u0430\u0432\u043d\u043e\u0432\u0435\u0441\u0438\u044f, \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0432 \u043b\u044e\u0431\u043e\u0439 \u043c\u043e\u043c\u0435\u043d\u0442.\n\n\n\n\n\n\u00a7l\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u042d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0421\u0432\u0438\u0442\u043a\u043e\u0432\u00a7r\n\n\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u0432\u0438\u0442\u043a\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 - \u0441\u043b\u043e\u0436\u043d\u044b\u0439 \u0438 \u0434\u043e\u043b\u0433\u0438\u0439 \u043f\u0440\u043e\u0446\u0435\u0441\u0441, \u0442\u0440\u0435\u0431\u0443\u044e\u0449\u0438\u0439 \u0431\u043e\u043b\u044c\u0448\u0438\u0445 \u0437\u043d\u0430\u043d\u0438\u0439. \u041f\u0443\u0441\u0442\u044b\u0435 \u0441\u0432\u0438\u0442\u043a\u0438, \u043e\u0441\u0442\u0430\u0432\u0448\u0438\u0435\u0441\u044f \u043e\u0442 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0432 \u0438\u0445 \u0440\u0443\u0438\u043d\u0430\u0445 \u0438 \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u044f\u0445. \u041e\u0434\u043d\u0430\u043a\u043e \u0434\u043b\u044f \u0442\u043e\u0433\u043e, \u0447\u0442\u043e\u0431\u044b \u0441\u0432\u0438\u0442\u043e\u043a \u043e\u0431\u0440\u0451\u043b \u0441\u0438\u043b\u0443 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0432\u0435\u0441\u0442\u0438 \u043e\u0441\u043e\u0431\u044b\u0439 \u0440\u0438\u0442\u0443\u0430\u043b.\n\n\u042d\u0442\u043e\u0442 \u0440\u0438\u0442\u0443\u0430\u043b \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043b\u0438\u0448\u044c \u0432 \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u0435, \u043f\u043e\u0441\u0432\u044f\u0449\u0451\u043d\u043d\u043e\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0443 \u0441\u0432\u0438\u0442\u043a\u0430. \u041d\u043e \u0430\u043b\u0442\u0430\u0440\u044c \u0440\u0438\u0442\u0443\u0430\u043b\u0430 \u0432 \u044d\u0442\u0438\u0445 \u043c\u0435\u0441\u0442\u0430\u0445 \u0437\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0434\u0440\u0435\u0432\u043d\u0438\u043c\u0438 \u0447\u0430\u0440\u0430\u043c\u0438. \u0427\u0442\u043e\u0431\u044b \u043e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u0435\u0433\u043e, \u043f\u043e\u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u043d\u044f\u0442\u044c \u043f\u0435\u0447\u0430\u0442\u044c, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u00a7l\u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b \u043f\u0435\u0447\u0430\u0442\u0438\u00a7r, \u00a7r\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u0432\u043e\u0437\u043b\u0435 \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043a\u0440\u0443\u0433\u0430.\n\n\n\n\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7l\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u043d\u0435 \u0440\u0430\u0437\u0443\u043c, \u043d\u043e \u0434\u0443\u0448\u0443. \u041e\u043d\u0430 \u043f\u043e\u0437\u043d\u0430\u0451\u0442 \u0442\u0435\u0431\u044f, \u043f\u0440\u0435\u0436\u0434\u0435 \u0447\u0435\u043c \u0442\u044b \u043f\u043e\u0437\u043d\u0430\u0435\u0448\u044c \u0435\u0451.\u00a7r\"\n\u00a7r- \u0438\u0437 \u0434\u0440\u0435\u0432\u043d\u0438\u0445 \u0442\u0435\u043a\u0441\u0442\u043e\u0432 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432.\n").addTranslation("ru_ru", "mage_micon.page.distorted_nihilis", "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432 \u0437\u0430\u043d\u0438\u043c\u0430\u043b\u043e \u043e\u0447\u0435\u043d\u044c \u043c\u043d\u043e\u0433\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0445\u043e\u0442\u0435\u043b\u0438 \u0443\u0441\u043a\u043e\u0440\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u0440\u043e\u0446\u0435\u0441\u0441, \u043d\u043e \u0432\u0441\u0435 \u0438\u0445 \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0430\u0431\u043e\u0442\u044b \u043e\u0431\u044b\u0447\u043d\u043e\u0433\u043e \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u0430 \u043f\u0440\u043e\u0432\u0430\u043b\u0438\u043b\u0438\u0441\u044c. \u0422\u043e\u0433\u0434\u0430 \u043e\u043d\u0438 \u0440\u0435\u0448\u0438\u043b\u0438 \u043f\u043e\u043f\u0440\u043e\u0431\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u043f\u043e\u043c\u043e\u0449\u0438 \u044d\u0444\u0438\u0440\u0430 \u0432\u043e\u0441\u0441\u043e\u0437\u0434\u0430\u0442\u044c \u044d\u0442\u043e\u0442 \u0444\u0435\u043d\u043e\u043c\u0435\u043d \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u0435\u043d\u043d\u043e \u0438 \u0443 \u043d\u0438\u0445 \u044d\u0442\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c, \u043d\u043e \u0441\u043f\u0443\u0441\u0442\u044f \u0432\u0440\u0435\u043c\u044f \u043e\u043d\u0438 \u043e\u0441\u043e\u0437\u043d\u0430\u043b\u0438, \u0447\u0442\u043e \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u041d\u0438\u0445\u0438\u043b\u0438\u0441 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u0435\u0442 \u044d\u0444\u0438\u0440 \u043d\u0435 \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0443\u044f \u044d\u0444\u0438\u0440 \u0432 \u043c\u0438\u0440\u0435, \u0430 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0435\u0433\u043e \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u044f.\n\n\u0421\u043f\u0443\u0441\u0442\u044f \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u043d \u043d\u0430\u0447\u0430\u043b \u043f\u043e\u0440\u0442\u0438\u0442\u044c \u043e\u043a\u0440\u0443\u0436\u0430\u044e\u0449\u0438\u0439 \u043c\u0438\u0440 \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u044f \u044d\u0444\u0438\u0440 \u0438\u0437 \u0432\u0441\u0435\u0433\u043e \u0441\u0443\u0449\u0435\u0433\u043e \u0438 \u0442\u043e\u0433\u0434\u0430 \u0435\u0433\u043e \u043d\u0430\u0437\u0432\u0430\u043b\u0438 \u0418\u0441\u043a\u0430\u0436\u0451\u043d\u043d\u044b\u0439 \u041d\u0438\u0445\u0438\u043b\u0438\u0441 \u0438 \u043a\u0430\u0437\u0430\u043b\u043e\u0441\u044c, \u0447\u0442\u043e \u043e\u043d\u043e \u0438\u043c\u0435\u0435\u0442 \u0441\u0432\u043e\u0439 \u0440\u0430\u0437\u0443\u043c. \u041d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043e\u0437\u043b\u0435 \u044d\u0442\u043e\u0439 \u0441\u0438\u043b\u044b \u0441\u0442\u0430\u043b\u043e \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437-\u0437\u0430 \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 \u0436\u0438\u0437\u043d\u0438.\n\n\u0421 \u043a\u0430\u0436\u0434\u044b\u043c \u0433\u043e\u0434\u043e\u043c \u0418\u0441\u043a\u0430\u0436\u0435\u043d\u043d\u044b\u0439 \u041d\u0438\u0445\u0438\u043b\u0438\u0441 \u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0441\u044f \u0441\u0438\u043b\u044c\u043d\u0435\u0435, \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0430\u044f \u044d\u0444\u0438\u0440, \u0440\u0430\u0437\u0440\u0443\u0448\u0430\u044f \u043c\u0438\u0440 \u0438 \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u044f \u0441\u0432\u0435\u0442. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043e\u0441\u043e\u0437\u043d\u0430\u043b\u0438, \u0447\u0442\u043e \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u0434\u0435\u044f\u043d\u043d\u043e\u0435 \u043c\u043e\u0436\u043d\u043e \u043b\u0438\u0448\u044c \u0446\u0435\u043d\u043e\u0439 \u0432\u0441\u0435\u0433\u043e, \u0447\u0442\u043e \u043e\u043d\u0438 \u0438\u043c\u0435\u043b\u0438. \u0412 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u043c \u0430\u043a\u0442\u0435 \u0441\u0430\u043c\u043e\u043f\u043e\u0436\u0435\u0440\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u043d\u0438 \u0441\u043e\u0437\u0434\u0430\u043b\u0438 \u0432\u0435\u043b\u0438\u0447\u0430\u0439\u0448\u0438\u0439 \u0440\u0438\u0442\u0443\u0430\u043b, \u0437\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0432 \u0418\u0441\u043a\u0430\u0436\u0435\u043d\u043d\u044b\u0439 \u041d\u0438\u0445\u0438\u043b\u0438\u0441. \u042d\u0442\u043e \u0441\u0442\u0430\u043b\u043e \u0438\u0445 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u043c \u043f\u043e\u0434\u0432\u0438\u0433\u043e\u043c. \u041e\u043d\u0438 \u0438\u0441\u0447\u0435\u0437\u043b\u0438, \u043e\u0441\u0442\u0430\u0432\u0438\u0432 \u043b\u0438\u0448\u044c \u0440\u0443\u0438\u043d\u044b, \u0442\u0430\u0439\u043d\u044b \u0441\u0432\u043e\u0438\u0445 \u0437\u043d\u0430\u043d\u0438\u0439 \u0438 \u043b\u0435\u0433\u0435\u043d\u0434\u044b.\n\n\u0422\u0430\u043a \u0418\u0441\u043a\u0430\u0436\u0435\u043d\u043d\u044b\u0439 \u041d\u0438\u0445\u0438\u043b\u0438\u0441 \u0431\u044b\u043b \u043f\u043e\u0431\u0435\u0436\u0434\u0451\u043d, \u043d\u043e \u043d\u0435 \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d. \u0415\u0433\u043e \u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u0430\u044f \u0441\u0438\u043b\u0430 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043c\u0438\u0440\u0435, \u0432 \u0432\u043e\u043f\u043b\u043e\u0449\u0435\u043d\u0438\u0438 \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0431\u0438\u043e\u043c\u0430 \u0441 \u0418\u0441\u043a\u0430\u0436\u0435\u043d\u0438\u0435\u043c.\n\n\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7l\u041c\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u043c \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0438\u0442\u044c \u041d\u0438\u0445\u0438\u043b\u0438\u0441. \u041d\u043e \u043c\u044b \u043c\u043e\u0436\u0435\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0435\u0433\u043e \u0432 \u0433\u043b\u0443\u0431\u0438\u043d\u044b, \u0442\u0443\u0434\u0430, \u0433\u0434\u0435 \u043e\u043d \u0441\u0442\u0430\u043d\u0435\u0442 \u043b\u0438\u0448\u044c \u0442\u0435\u043d\u044c\u044e. \u041f\u0443\u0441\u0442\u044c \u043d\u0430\u0448 \u0441\u0432\u0435\u0442 \u0431\u0443\u0434\u0435\u0442 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u043c \u043c\u0430\u044f\u043a\u043e\u043c \u0434\u043b\u044f \u0433\u0440\u044f\u0434\u0443\u0449\u0438\u0445 \u043f\u043e\u043a\u043e\u043b\u0435\u043d\u0438\u0439.\u00a7r\"\n\u00a7r- \u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0441\u043b\u043e\u0432\u0430 \u0410\u0440\u043a\u0430\u0441\u0430, \u043b\u0438\u0434\u0435\u0440\u0430 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432.\n").addTranslation("ru_ru", "mage_micon.page.element_reaction", "\u041c\u0438\u0440 \u0441\u043e\u0442\u043a\u0430\u043d \u0438\u0437 \u043f\u043e\u0442\u043e\u043a\u043e\u0432 \u044d\u0444\u0438\u0440\u0430, \u0438 \u043a\u0430\u0436\u0434\u0430\u044f \u0435\u0433\u043e \u0447\u0430\u0441\u0442\u0438\u0446\u0430 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u0430\u043a\u043e\u043c\u0443-\u043b\u0438\u0431\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0443. \u041a\u043e\u0433\u0434\u0430 \u044d\u0442\u0438 \u043f\u043e\u0442\u043e\u043a\u0438 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u044e\u0442\u0441\u044f, \u043e\u043d\u0438 \u0432\u0441\u0442\u0443\u043f\u0430\u044e\u0442 \u0432\u043e \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435, \u043f\u043e\u0440\u043e\u0436\u0434\u0430\u044f \u043c\u043e\u0433\u0443\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u0438 \u043f\u043e\u0440\u043e\u0439 \u043d\u0435\u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0443\u0435\u043c\u044b\u0435 \u044f\u0432\u043b\u0435\u043d\u0438\u044f. \u042d\u0442\u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0430\u0437\u044b\u0432\u0430\u044e\u0442 \u042d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u043c\u0438 \u0420\u0435\u0430\u043a\u0446\u0438\u044f\u043c\u0438 - \u0434\u0440\u0435\u0432\u043d\u0438\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043c\u0430\u0433\u0438\u0438, \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u044e\u0449\u0438\u043c \u0441\u0442\u0438\u0445\u0438\u0438 \u0432\u043e\u0435\u0434\u0438\u043d\u043e.\n\n\u041a\u043e\u0433\u0434\u0430 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0434 \u0432\u043b\u0438\u044f\u043d\u0438\u0435\u043c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u0441\u0442\u0438\u0445\u0438\u0439, \u0438\u0445 \u0441\u0438\u043b\u044b \u043d\u0430\u0447\u0438\u043d\u0430\u044e\u0442 \u0431\u043e\u0440\u043e\u0442\u044c\u0441\u044f \u0434\u0440\u0443\u0433 \u0441 \u0434\u0440\u0443\u0433\u043e\u043c, \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u044f \u0432\u0441\u043f\u043b\u0435\u0441\u043a\u0438 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0438. \u041e\u0433\u043e\u043d\u044c \u043f\u0440\u043e\u0431\u0443\u0436\u0434\u0430\u0435\u0442 \u0431\u0443\u0440\u044e, \u043b\u0435\u0434 \u0440\u0430\u0441\u043a\u0430\u043b\u044b\u0432\u0430\u0435\u0442 \u0437\u0435\u043c\u043b\u044e, \u044d\u0444\u0438\u0440\u043d\u044b\u0435 \u0442\u043e\u043a\u0438 \u0440\u0430\u0437\u0440\u044b\u0432\u0430\u044e\u0442 \u043f\u043b\u043e\u0442\u044c. \u0420\u0435\u0430\u043a\u0446\u0438\u0438 \u0431\u044b\u0432\u0430\u044e\u0442 \u0440\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438, \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u044e\u0449\u0438\u043c\u0438 \u0438\u043b\u0438 \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u044b\u043c\u0438, \u043d\u043e \u043a\u0430\u0436\u0434\u0430\u044f \u0438\u0437 \u043d\u0438\u0445 - \u043f\u0440\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u0435\u043b\u0438\u043a\u043e\u0439 \u0441\u0438\u043b\u044b, \u0441\u043a\u0440\u044b\u0442\u043e\u0439 \u0432 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u0445 \u043c\u0438\u0440\u0430.\n\n\n\n\u00a7l\u041f\u0440\u043e\u0431\u0443\u0436\u0434\u0435\u043d\u0438\u0435 \u0421\u0442\u0438\u0445\u0438\u0439\u00a7r\n\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0443\u044e \u0440\u0435\u0430\u043a\u0446\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e\u043c \u0441\u043f\u043e\u0441\u043e\u0431\u043e\u0432. \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f \u043d\u0430\u0441\u044b\u0449\u0430\u044e\u0442 \u0446\u0435\u043b\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u043c \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u043c, \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044f \u043d\u0430 \u043d\u0435\u0439 \u0435\u0433\u043e \u0441\u043b\u0435\u0434. \u041e\u0434\u043d\u0430\u043a\u043e \u043c\u0430\u0433\u0438\u044f - \u043d\u0435 \u0435\u0434\u0438\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u043f\u0443\u0442\u044c. \u041c\u0438\u0440 \u0441\u0430\u043c \u043f\u043e \u0441\u0435\u0431\u0435 \u0441\u043f\u043e\u0441\u043e\u0431\u0435\u043d \u0437\u0430\u043f\u0435\u0447\u0430\u0442\u043b\u0435\u0432\u0430\u0442\u044c \u0441\u0442\u0438\u0445\u0438\u0438:\n\n\n\u2022 \u041f\u043b\u0430\u043c\u044f \u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043e\u0436\u043e\u0433\u0438, \u0438 \u0435\u0441\u043b\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u0433\u043e\u0440\u0438\u0442, \u0435\u0451 \u0442\u0435\u043b\u043e \u0443\u0436\u0435 \u043e\u0445\u0432\u0430\u0447\u0435\u043d\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u043c \u041e\u0433\u043d\u044f.\n\u2022 \u0421\u0442\u0443\u0436\u0430 \u0441\u043a\u043e\u0432\u044b\u0432\u0430\u0435\u0442 \u0445\u043e\u043b\u043e\u0434\u043e\u043c, \u0438 \u0435\u0441\u043b\u0438 \u043b\u0451\u0434 \u043f\u043e\u0433\u043b\u043e\u0449\u0430\u0435\u0442 \u043f\u043b\u043e\u0442\u044c, \u0437\u043d\u0430\u0447\u0438\u0442, \u041b\u0435\u0434\u044f\u043d\u043e\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0443\u0436\u0435 \u0432\u0441\u0442\u0443\u043f\u0438\u043b \u0432 \u0438\u0433\u0440\u0443.\n\n\n\n\n\n\n\u041d\u043e \u043e\u0434\u043d\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u044f\u0441\u043d\u043e: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0440\u0435\u0430\u043a\u0446\u0438\u0438 - \u043d\u0435 \u043f\u0440\u043e\u0441\u0442\u043e \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u044b \u043c\u0430\u0433\u0438\u0438. \u042d\u0442\u043e \u043f\u0440\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0430\u043c\u043e\u0439 \u0441\u0443\u0442\u0438 \u044d\u0444\u0438\u0440\u0430, \u0445\u0430\u043e\u0442\u0438\u0447\u043d\u044b\u0435 \u0438 \u0432\u0435\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435. \u0422\u0435, \u043a\u0442\u043e \u0441\u0443\u043c\u0435\u044e\u0442 \u043f\u043e\u0441\u0442\u0438\u0447\u044c \u0438\u0445 \u043f\u0440\u0438\u0440\u043e\u0434\u0443, \u043e\u0431\u0440\u0435\u0442\u0443\u0442 \u0438\u0441\u0442\u0438\u043d\u043d\u0443\u044e \u0432\u043b\u0430\u0441\u0442\u044c \u043d\u0430\u0434 \u0441\u0442\u0438\u0445\u0438\u044f\u043c\u0438\u2026\n").addTranslation("ru_ru", "mage_micon.page.enigma", "\u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b\u0438 \u044d\u0442\u0443 \u0441\u0438\u043b\u0443 \u043f\u0443\u0442\u0451\u043c \u0434\u043e\u043b\u0433\u043e\u0433\u043e \u043f\u043e\u0433\u043b\u043e\u0449\u0435\u043d\u0438\u044f \u044d\u0444\u0438\u0440\u0430 \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u043e\u043c. \u041a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u043c\u044b\u0435 \u0442\u0430\u043a\u0438\u043c \u043f\u0443\u0442\u0451\u043c \u0438\u043c\u0435\u0435\u0442 \u043e\u0433\u0440\u043e\u043c\u043d\u0443\u044e \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0430\u0446\u0438\u044e \u044d\u0444\u0438\u0440\u0430. \u0414\u043e\u043b\u0433\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u0441\u0447\u0438\u0442\u0430\u043b\u043e\u0441\u044c, \u0447\u0442\u043e \u0442\u0430\u043a\u0438\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b \u044d\u0442\u043e \u043f\u0440\u043e\u0441\u0442\u043e \u0441\u043f\u0440\u0435\u0441\u0441\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u044f \u044d\u0444\u0438\u0440\u0430. \u0421\u043f\u0443\u0441\u0442\u044f \u0432\u0440\u0435\u043c\u044f \u0431\u044b\u043b\u043e \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e, \u0447\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442 \u043e\u043d\u0430 \u0442\u0430\u043a \u0436\u0435 \u043a\u0430\u043a \u0438 \u044d\u0444\u0438\u0440, \u043d\u043e \u0440\u0435\u0430\u0433\u0438\u0440\u0443\u0435\u0442 \u043d\u0430 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0441\u043e\u0432\u0441\u0435\u043c \u043f\u043e \u0434\u0440\u0443\u0433\u043e\u043c\u0443. \u041f\u043e\u0441\u043b\u0435 \u044d\u0442\u043e\u0433\u043e \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u0432 \u044d\u0442\u0438\u0445 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u0430\u0445 \u0440\u0435\u0448\u0438\u043b\u0438 \u043d\u0430\u0437\u0432\u0430\u0442\u044c \u042d\u043d\u0438\u0433\u043c\u043e\u0439.\n\n\u0420\u0438\u0442\u0443\u0430\u043b\u044b \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u043c\u044b\u0435 \u0441 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435\u043c \u042d\u043d\u0438\u0433\u043c\u044b \u0438 \u0435\u0451 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432 \u0438\u043c\u0435\u043b\u0438 \u043e\u0447\u0435\u043d\u044c \u0441\u0438\u043b\u044c\u043d\u0443\u044e \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c. \u0415\u0441\u043b\u0438 \u0440\u0438\u0442\u0443\u0430\u043b \u0434\u043e\u0445\u043e\u0434\u0438\u043b \u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0431\u0435\u0437 \u043f\u0440\u043e\u0438\u0441\u0448\u0435\u0441\u0442\u0432\u0438\u0439, \u0442\u043e \u043f\u043e\u043b\u0443\u0447\u0430\u043b\u0438\u0441\u044c \u043e\u0447\u0435\u043d\u044c \u0441\u0438\u043b\u044c\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043d\u043e \u0447\u0430\u0441\u0442\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u043a\u0438\u0445 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0438\u0441\u0442\u043e\u0449\u0430\u043b\u043e \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043c.\n\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7l\u042d\u0442\u043e \u0441\u0438\u043b\u0430 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u044d\u0444\u0438\u0440\u043e\u043c, \u043d\u043e \u043f\u0440\u0435\u0432\u043e\u0441\u0445\u043e\u0434\u0438\u0442 \u0435\u0433\u043e. \u0417\u0430 \u0435\u0433\u043e \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u0443\u044e \u0441\u0438\u043b\u0443 \u043f\u0440\u0438\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u043f\u043b\u0430\u0442\u0438\u0442\u044c.\u00a7r\"\n\u00a7r- \u0421\u043b\u043e\u0432\u0430 \u0410\u0440\u043a\u0430\u0441\u0430, \u043b\u0438\u0434\u0435\u0440\u0430 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432.\n").addTranslation("ru_ru", "mage_micon.page.enigma_secret", "\u041a\u043e\u0433\u0434\u0430 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0432\u043f\u0435\u0440\u0432\u044b\u0435 \u0441\u0442\u043e\u043b\u043a\u043d\u0443\u043b\u0438\u0441\u044c \u0441 \u042d\u043d\u0438\u0433\u043c\u043e\u0439, \u043e\u043d\u0438 \u043d\u0435 \u043e\u0441\u043e\u0437\u043d\u0430\u0432\u0430\u043b\u0438 \u0435\u0451 \u0438\u0441\u0442\u0438\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u0440\u043e\u0434\u044b. \u0414\u043e\u043b\u0433\u0438\u0435 \u0432\u0435\u043a\u0430 \u043f\u043e\u0433\u043b\u043e\u0449\u0435\u043d\u0438\u044f \u044d\u0444\u0438\u0440\u0430 \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u043e\u043c \u043f\u043e\u0440\u043e\u0434\u0438\u043b\u0438 \u044f\u0432\u043b\u0435\u043d\u0438\u0435, \u043f\u0440\u043e\u0442\u0438\u0432\u043e\u0440\u0435\u0447\u0430\u0449\u0435\u0435 \u0441\u0430\u043c\u043e\u0439 \u0441\u0443\u0442\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430. \u0412 \u043c\u0435\u0441\u0442\u0430\u0445, \u0433\u0434\u0435 \u044d\u0444\u0438\u0440 \u0438\u0441\u0447\u0435\u0437\u0430\u043b \u0431\u0435\u0437 \u0441\u043b\u0435\u0434\u0430, \u0440\u043e\u0436\u0434\u0430\u043b\u0438\u0441\u044c \u0441\u0442\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b. \u0418\u0445 \u043c\u0435\u0440\u0446\u0430\u044e\u0449\u0430\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430, \u043d\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u0430\u044f \u0432\u0438\u0445\u0440\u044f\u043c\u0438 \u043d\u0435\u0435\u0441\u0442\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0432\u0435\u0442\u0430, \u0431\u044b\u043b\u0430 \u0437\u043d\u0430\u043a\u043e\u043c\u043e\u0439, \u043d\u043e \u0432 \u0442\u043e \u0436\u0435 \u0432\u0440\u0435\u043c\u044f \u0447\u0443\u0436\u0434\u043e\u0439.\n\n\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445 \u043f\u0440\u0438\u043d\u0438\u043c\u0430\u043b\u0438 \u0437\u0430 \u043e\u0431\u044b\u0447\u043d\u044b\u0435 \u0441\u0433\u0443\u0441\u0442\u043a\u0438 \u044d\u0444\u0438\u0440\u0430, \u0441\u0436\u0430\u0442\u044b\u0435 \u0432 \u043d\u0435\u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e \u043f\u043b\u043e\u0442\u043d\u0443\u044e \u0444\u043e\u0440\u043c\u0443. \u041d\u043e \u0447\u0435\u043c \u0434\u043e\u043b\u044c\u0448\u0435 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0438\u0437\u0443\u0447\u0430\u043b\u0438 \u044d\u0442\u0438 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b, \u0442\u0435\u043c \u0431\u043e\u043b\u044c\u0448\u0435 \u043e\u0441\u043e\u0437\u043d\u0430\u0432\u0430\u043b\u0438 \u2013 \u043e\u043d\u0438 \u043e\u0442\u043b\u0438\u0447\u0430\u043b\u0438\u0441\u044c \u043e\u0442 \u0432\u0441\u0435\u0433\u043e, \u0441 \u0447\u0435\u043c \u0438\u043c \u043f\u0440\u0438\u0445\u043e\u0434\u0438\u043b\u043e\u0441\u044c \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c. \u0412 \u043e\u0442\u043b\u0438\u0447\u0438\u0435 \u043e\u0442 \u044d\u0444\u0438\u0440\u0430, \u043f\u043e\u043a\u043e\u0440\u043d\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0433\u043e \u0432 \u0440\u0438\u0442\u0443\u0430\u043b\u0430\u0445, \u042d\u043d\u0438\u0433\u043c\u0430 \u0436\u0438\u043b\u0430 \u0441\u0432\u043e\u0435\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0432\u043e\u043b\u0435\u0439. \u041e\u043d\u0430 \u043f\u043e\u0434\u0447\u0438\u043d\u044f\u043b\u0430\u0441\u044c \u043d\u0435 \u0437\u0430\u043a\u043e\u043d\u0430\u043c \u043c\u0438\u0440\u0430, \u0430 \u0441\u0432\u043e\u0438\u043c \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u043c.\n\n\u00a7l\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u042d\u043d\u0438\u0433\u043c\u044b\u00a7r\n\u042d\u043d\u0438\u0433\u043c\u0430 \u043f\u0440\u043e\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432 \u043c\u0438\u0440\u0435 \u0432 \u0432\u0438\u0434\u0435 \u043e\u0441\u043e\u0431\u044b\u0445 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u043e\u0432, \u0441\u043a\u0440\u044b\u0442\u044b\u0445 \u0432 \u043c\u0435\u0441\u0442\u0430\u0445, \u043d\u0435\u043a\u043e\u0433\u0434\u0430 \u043f\u043e\u0440\u0430\u0436\u0451\u043d\u043d\u044b\u0445 \u0418\u0441\u043a\u0430\u0436\u0451\u043d\u043d\u044b\u043c \u041d\u0438\u0445\u0438\u043b\u0438\u0441\u043e\u043c. \u042d\u0442\u0438 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u043f\u043e\u0442\u043e\u043a\u0438 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0438, \u0434\u0435\u043b\u0430\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u044b \u043f\u043e\u0434 \u043d\u0438\u043c\u0438 \u043d\u0435\u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0443\u0435\u043c\u043e \u043c\u043e\u0449\u043d\u044b\u043c\u0438. \u0422\u0430\u043c, \u0433\u0434\u0435 \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0440\u0438\u0442\u0443\u0430\u043b \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043b \u043e\u0433\u0440\u043e\u043c\u043d\u044b\u0445 \u0437\u0430\u0442\u0440\u0430\u0442, \u042d\u043d\u0438\u0433\u043c\u0430 \u0432\u043e\u0441\u043f\u043e\u043b\u043d\u044f\u043b\u0430 \u044d\u0442\u0443 \u0441\u0438\u043b\u0443, \u0434\u0430\u0440\u0443\u044f \u0432\u0435\u043b\u0438\u0447\u0430\u0439\u0448\u0438\u0435 \u0434\u0430\u0440\u044b\u2026 \u043d\u043e \u0438 \u0441\u0430\u043c\u0443\u044e \u0441\u0435\u0440\u044c\u0451\u0437\u043d\u0443\u044e \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c.\n\n\n\u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0438\u043b\u0438, \u0447\u0442\u043e \u0432 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u0438 \u042d\u043d\u0438\u0433\u043c\u044b \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 \u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442 \u0441 \u0443\u0434\u0432\u043e\u0435\u043d\u043d\u043e\u0439 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c\u044e. \u0421\u0431\u043e\u0440\u0449\u0438\u043a\u0438 \u042d\u0444\u0438\u0440\u0430 \u0432\u043f\u0438\u0442\u044b\u0432\u0430\u043b\u0438 \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u0432\u0434\u0432\u043e\u0435 \u0431\u044b\u0441\u0442\u0440\u0435\u0435, \u0430 \u042d\u0444\u0438\u0440\u043e\u0432\u044b\u0435 \u041f\u0440\u0438\u0437\u043c\u044b \u0445\u0440\u0430\u043d\u0438\u043b\u0438 \u043d\u0435 \u0447\u0435\u0442\u044b\u0440\u0435 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u0430, \u0430 \u0432\u043e\u0441\u0435\u043c\u044c. \u041a\u0430\u0437\u0430\u043b\u043e\u0441\u044c, \u042d\u043d\u0438\u0433\u043c\u0430 \u043d\u0430\u0440\u0443\u0448\u0430\u043b\u0430 \u0441\u0430\u043c\u0443 \u0442\u043a\u0430\u043d\u044c \u043c\u0430\u0433\u0438\u0438, \u043f\u043e\u0434\u0447\u0438\u043d\u044f\u044f \u0435\u0451 \u0441\u0432\u043e\u0438\u043c \u0437\u0430\u043a\u043e\u043d\u0430\u043c.\n\n\u041d\u043e \u0443 \u0441\u0438\u043b\u044b \u0432\u0441\u0435\u0433\u0434\u0430 \u0435\u0441\u0442\u044c \u0446\u0435\u043d\u0430. \u0422\u0435, \u043a\u0442\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0441\u044f \u0434\u0430\u0440\u0430\u043c\u0438 \u042d\u043d\u0438\u0433\u043c\u044b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0447\u0430\u0441\u0442\u043e, \u0437\u0430\u043c\u0435\u0447\u0430\u043b\u0438, \u0447\u0442\u043e \u0438\u0445 \u0442\u0435\u043b\u0430 \u043d\u0430\u0447\u0438\u043d\u0430\u043b\u0438 \u0441\u043b\u0430\u0431\u0435\u0442\u044c. \u0418\u0445 \u0441\u043e\u0437\u043d\u0430\u043d\u0438\u0435 \u0437\u0430\u0442\u0443\u043c\u0430\u043d\u0438\u0432\u0430\u043b\u043e\u0441\u044c, \u0430 \u044d\u0444\u0438\u0440 \u0432\u043d\u0443\u0442\u0440\u0438 \u043d\u0438\u0445 \u043d\u0430\u0447\u0438\u043d\u0430\u043b \u0443\u0433\u0430\u0441\u0430\u0442\u044c. \u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e\u0435 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0441 \u042d\u043d\u0438\u0433\u043c\u043e\u0439 \u0438\u0441\u0442\u043e\u0449\u0430\u0435\u0442 \u0441\u0430\u043c\u0443 \u0434\u0443\u0448\u0443.\n\u00a7l\u041d\u0430\u0441\u043b\u0435\u0434\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0442\u043d\u043e\u0439 \u0441\u0438\u043b\u044b\u00a7r\n\u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b, \u043e\u0441\u043e\u0437\u043d\u0430\u0432\u0448\u0438\u0435 \u0440\u0438\u0441\u043a, \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0443\u043a\u0440\u043e\u0442\u0438\u0442\u044c \u042d\u043d\u0438\u0433\u043c\u0443, \u043d\u043e \u043e\u043d\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0430\u0432\u0430\u043b\u0430\u0441\u044c \u0438\u0445 \u0432\u043e\u043b\u0435. \u041e\u043d\u0438 \u0432\u0435\u0440\u0438\u043b\u0438, \u0447\u0442\u043e \u0441\u043c\u043e\u0433\u0443\u0442 \u0432\u0437\u044f\u0442\u044c \u0435\u0451 \u043f\u043e\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c, \u043d\u043e \u043a\u0430\u0436\u0434\u044b\u0439 \u0440\u0430\u0437 \u0438\u0445 \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u043e\u0431\u043e\u0440\u0430\u0447\u0438\u0432\u0430\u043b\u0438\u0441\u044c \u043f\u0440\u043e\u0432\u0430\u043b\u043e\u043c. \u042d\u0442\u043e \u043d\u0435 \u0431\u044b\u043b\u0430 \u043f\u0440\u043e\u0441\u0442\u043e \u044d\u043d\u0435\u0440\u0433\u0438\u044f \u2013 \u044d\u0442\u043e \u0431\u044b\u043b\u043e \u043d\u0435\u0447\u0442\u043e \u0431\u043e\u043b\u044c\u0448\u0435\u0435, \u043d\u0435\u0447\u0442\u043e, \u0447\u0442\u043e \u043e\u043d\u0438 \u0442\u0430\u043a \u0438 \u043d\u0435 \u0441\u043c\u043e\u0433\u043b\u0438 \u043e\u0431\u044a\u044f\u0441\u043d\u0438\u0442\u044c.\n\n\u0422\u0435\u043f\u0435\u0440\u044c, \u0441\u043f\u0443\u0441\u0442\u044f \u0432\u0435\u043a\u0430, \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u044b \u042d\u043d\u0438\u0433\u043c\u044b \u0432\u0441\u0451 \u0435\u0449\u0451 \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u044e\u0442\u0441\u044f \u0432 \u043c\u0435\u0441\u0442\u0430\u0445, \u0433\u0434\u0435 \u043a\u043e\u0433\u0434\u0430-\u0442\u043e \u0431\u0443\u0448\u0435\u0432\u0430\u043b \u041d\u0438\u0445\u0438\u043b\u0438\u0441. \u0418 \u0442\u0435, \u043a\u0442\u043e \u043e\u0441\u043c\u0435\u043b\u0438\u0442\u0441\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0438\u0445 \u0441\u0438\u043b\u0443, \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u043e\u043c\u043d\u0438\u0442\u044c: \u042d\u043d\u0438\u0433\u043c\u0430 \u043d\u0435 \u0434\u0430\u0451\u0442 \u043d\u0438\u0447\u0435\u0433\u043e \u043f\u0440\u043e\u0441\u0442\u043e \u0442\u0430\u043a. \u041e\u043d\u0430 \u043b\u0438\u0448\u044c \u043e\u0434\u0430\u043b\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u0432\u043e\u044e \u043c\u043e\u0449\u044c\u2026\n").addTranslation("ru_ru", "mage_micon.page.essence", "\u00a7l\u042d\u0441\u0441\u0435\u043d\u0446\u0438\u0438\u00a7r - \u044d\u0442\u043e \u0440\u0435\u0434\u0447\u0430\u0439\u0448\u0430\u044f \u0444\u043e\u0440\u043c\u0430 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0441\u0443\u0431\u0441\u0442\u0430\u043d\u0446\u0438\u0438, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0430\u044f \u0447\u0438\u0441\u0442\u0443\u044e \u0432\u043e\u043b\u044e \u044d\u0444\u0438\u0440\u0430 \u0438 \u043c\u0443\u0434\u0440\u043e\u0441\u0442\u044c \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432. \u042d\u0442\u043e \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0444\u0440\u0430\u0433\u043c\u0435\u043d\u0442\u044b \u044d\u043d\u0435\u0440\u0433\u0438\u0438, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u043c\u043e\u043c\u0435\u043d\u0442\u044b \u0432\u044b\u0441\u0448\u0435\u0439 \u0433\u0430\u0440\u043c\u043e\u043d\u0438\u0438 \u043c\u0430\u0433\u0438\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435 \u0432 \u0440\u0438\u0442\u0443\u0430\u043b\u0430\u0445 \u0438 \u041a\u043e\u0440-\u041b\u0443\u043d\u0430\u0440\u0435, \u043e\u043d\u0438 \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u0438 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f, \u043f\u0440\u0438\u0434\u0430\u0432\u0430\u044f \u0438\u043c \u043d\u043e\u0432\u044b\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430.\n\n{ITEMS1}\n\u00a7l\u0420\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u044d\u0441\u0441\u0435\u043d\u0446\u0438\u0439\u00a7r\n\n\u042d\u0441\u0441\u0435\u043d\u0446\u0438\u0438 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0432 \u043c\u0438\u0440\u0435 \u0441\u0430\u043c\u0438 \u043f\u043e \u0441\u0435\u0431\u0435 - \u0438\u0445 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0432\u043c\u0435\u0448\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u044d\u0444\u0438\u0440\u0430 \u0438 \u0433\u043b\u0443\u0431\u043e\u043a\u043e\u0433\u043e \u043f\u043e\u043d\u0438\u043c\u0430\u043d\u0438\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u043c\u0430\u0433\u0438\u0438.\n\n\u0412 \u0440\u0435\u0434\u043a\u0438\u0445 \u0441\u043b\u0443\u0447\u0430\u044f\u0445, \u043a\u043e\u0433\u0434\u0430 \u0440\u0438\u0442\u0443\u0430\u043b \u0434\u043e\u0441\u0442\u0438\u0433\u0430\u0435\u0442 \u0441\u0432\u043e\u0435\u0433\u043e \u0430\u043f\u043e\u0433\u0435\u044f, \u044d\u0444\u0438\u0440\u043d\u0430\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u044f \u0443\u043f\u043b\u043e\u0442\u043d\u044f\u0435\u0442\u0441\u044f, \u043f\u043e\u0440\u043e\u0436\u0434\u0430\u044f \u044d\u0441\u0441\u0435\u043d\u0446\u0438\u044e. \u042d\u0442\u043e \u044f\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043f\u0440\u0435\u0434\u0441\u043a\u0430\u0437\u0430\u0442\u044c, \u043d\u043e \u043e\u043d\u043e \u0447\u0430\u0449\u0435 \u0441\u043b\u0443\u0447\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0441\u043b\u043e\u0436\u043d\u044b\u0445 \u043e\u0431\u0440\u044f\u0434\u0430\u0445, \u0442\u0440\u0435\u0431\u0443\u044e\u0449\u0438\u0445 \u0431\u043e\u043b\u044c\u0448\u0438\u0445 \u0437\u0430\u0442\u0440\u0430\u0442 \u0441\u0438\u043b\u044b.\n\n\u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0441\u0447\u0438\u0442\u0430\u043b\u0438, \u0447\u0442\u043e \u0441\u0430\u043c \u044d\u0444\u0438\u0440 \u0440\u0435\u0448\u0430\u0435\u0442, \u0434\u043e\u0441\u0442\u043e\u0439\u043d\u043e \u043b\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u0440\u0438\u0442\u0443\u0430\u043b\u0430 \u0442\u0430\u043a\u043e\u0433\u043e \u0434\u0430\u0440\u0430. \u041f\u043e\u044d\u0442\u043e\u043c\u0443 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u044d\u0441\u0441\u0435\u043d\u0446\u0438\u0438 - \u0432\u0441\u0435\u0433\u0434\u0430 \u0441\u043e\u0431\u044b\u0442\u0438\u0435, \u0440\u0435\u0434\u043a\u043e\u0435.\n").addTranslation("ru_ru", "mage_micon.page.ether_vessels", "\u042d\u0444\u0438\u0440 - \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c, \u043d\u0435 \u0442\u0435\u0440\u043f\u044f\u0449\u0430\u044f \u043d\u0435\u043f\u043e\u0434\u0432\u0438\u0436\u043d\u043e\u0441\u0442\u0438. \u041e\u043d \u0442\u0435\u0447\u0451\u0442, \u0438\u0441\u0447\u0435\u0437\u0430\u0435\u0442 \u0438 \u0432\u043e\u0437\u0440\u043e\u0436\u0434\u0430\u0435\u0442\u0441\u044f, \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u044f \u043c\u0430\u0433\u0438\u044e \u0441 \u043c\u0430\u0442\u0435\u0440\u0438\u0435\u0439. \u0427\u0442\u043e\u0431\u044b \u0443\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0435\u0433\u043e \u0441\u0438\u043b\u0443, \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u0441\u043e\u0437\u0434\u0430\u043b\u0438 \u043e\u0441\u043e\u0431\u044b\u0435 \u0441\u043e\u0441\u0443\u0434\u044b - \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0435 \u043d\u0430\u043a\u0430\u043f\u043b\u0438\u0432\u0430\u0442\u044c \u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u044d\u0444\u0438\u0440 \u0434\u043b\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f. \u042d\u0442\u0438 \u0441\u043e\u0441\u0443\u0434\u044b \u0440\u0430\u0437\u043b\u0438\u0447\u0430\u044e\u0442\u0441\u044f \u043f\u043e \u0441\u0432\u043e\u0435\u0439 \u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u0438, \u0443\u0441\u0442\u043e\u0439\u0447\u0438\u0432\u043e\u0441\u0442\u0438 \u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044e \u0441 \u043f\u043e\u0442\u043e\u043a\u0430\u043c\u0438 \u043c\u0430\u0433\u0438\u0438.\n{ITEMS1}\n\n\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u044b\u0439 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u00a7r\n\n\u042d\u0444\u0438\u0440\u043e\u0432\u044b\u0439 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b - \u044d\u0442\u043e \u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u0441\u043e\u0441\u0443\u0434, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u0438\u0437 \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u044d\u0444\u0438\u0440\u0430. \u041e\u043d \u0441\u043f\u043e\u0441\u043e\u0431\u0435\u043d \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0442\u044c \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u0444\u0438\u0440\u0430, \u043d\u043e \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u043e\u0441\u0442\u0430\u0451\u0442\u0441\u044f \u043d\u0430\u0438\u0431\u043e\u043b\u0435\u0435 \u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u044b\u043c.\n{CRAFT1}\n\n\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u0441\u0444\u0435\u0440\u0430\u00a7r\n\n\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u0441\u0444\u0435\u0440\u0430 - \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u0441\u043e\u0441\u0443\u0434\u0430, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u0430\u044f \u0432\u043c\u0435\u0449\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u044d\u0444\u0438\u0440\u0430. \u0412 \u043e\u0442\u043b\u0438\u0447\u0438\u0435 \u043e\u0442 \u044d\u0444\u0438\u0440\u043e\u0432\u043e\u0433\u043e \u043a\u0440\u0438\u0441\u0442\u0430\u043b\u043b\u0430, \u0441\u0444\u0435\u0440\u0430 \u043c\u043e\u0436\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0443 \u044d\u0444\u0438\u0440\u0430 \u0432\u043d\u0443\u0442\u0440\u0438 \u0441\u0435\u0431\u044f, \u043f\u043e\u0434\u0441\u0442\u0440\u0430\u0438\u0432\u0430\u044f \u0435\u0433\u043e \u043f\u043e\u0434 \u043d\u0443\u0436\u0434\u044b \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u0442\u0435\u043b\u044f.\n{CRAFT2}\n\n\u00a7l\u0421\u0444\u0435\u0440\u0430 \u042d\u043d\u0438\u0433\u043c\u044b\u00a7r\n\n\u0421\u0444\u0435\u0440\u0430 \u042d\u043d\u0438\u0433\u043c\u044b - \u0435\u0434\u0438\u043d\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u0441\u043e\u0441\u0443\u0434, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0439 \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0442\u044c \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u0443\u044e \u043f\u0440\u0438\u0440\u043e\u0434\u0443 \u044d\u0444\u0438\u0440\u0430. \u042d\u0442\u043e\u0442 \u043f\u0440\u0435\u0434\u043c\u0435\u0442, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0439 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0430\u043c\u0438 \u0432 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043f\u043e\u043d\u044f\u0442\u044c \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c \u042d\u043d\u0438\u0433\u043c\u044b, \u0441\u0442\u0430\u043b \u0441\u043a\u043e\u0440\u0435\u0435 \u043f\u0440\u043e\u043a\u043b\u044f\u0442\u0438\u0435\u043c, \u0447\u0435\u043c \u0431\u043b\u0430\u0433\u043e\u0441\u043b\u043e\u0432\u0435\u043d\u0438\u0435\u043c.\n{RITUAL1}\n").addTranslation("ru_ru", "mage_micon.page.ritual_constructs", "\u0420\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u0430\u0433\u0438\u044f \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u043d\u0430\u043d\u0438\u0439, \u043d\u043e \u0438 \u043e\u0441\u043e\u0431\u044b\u0445 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0439, \u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u043f\u043e\u0442\u043e\u043a\u0438 \u044d\u0444\u0438\u0440\u0430, \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0442\u044c \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0432\u0438\u0431\u0440\u0430\u0446\u0438\u0438 \u0438 \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u0442\u0438\u0445\u0438\u0439\u043d\u044b\u0435 \u0441\u0438\u043b\u044b \u0432\u043e\u0435\u0434\u0438\u043d\u043e. \u0411\u0435\u0437 \u044d\u0442\u0438\u0445 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440 \u043c\u0430\u0433\u0438\u044f \u043e\u0441\u0442\u0430\u0432\u0430\u043b\u0430\u0441\u044c \u0431\u044b \u043d\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u044c\u043d\u043e\u0439 \u0438 \u0445\u0430\u043e\u0442\u0438\u0447\u043d\u043e\u0439, \u0430 \u0441\u043b\u043e\u0436\u043d\u044b\u0435 \u043e\u0431\u0440\u044f\u0434\u044b - \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u043c\u0438. \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b, \u0438\u0437\u0443\u0447\u0430\u044f \u043f\u0440\u0438\u0440\u043e\u0434\u0443 \u044d\u0444\u0438\u0440\u0430, \u0441\u043e\u0437\u0434\u0430\u043b\u0438 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0445 \u0431\u043b\u043e\u043a\u043e\u0432, \u043a\u0430\u0436\u0434\u044b\u0439 \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0441\u0432\u043e\u044e \u0440\u043e\u043b\u044c: \u043e\u0434\u043d\u0438 \u043a\u043e\u043d\u0446\u0435\u043d\u0442\u0440\u0438\u0440\u0443\u044e\u0442 \u044d\u043d\u0435\u0440\u0433\u0438\u044e, \u0434\u0440\u0443\u0433\u0438\u0435 \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0442 \u0435\u0451 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435\u043c, \u0430 \u0442\u0440\u0435\u0442\u044c\u0438 \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0443\u044e\u0442 \u0441 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u0430\u043c\u0438 \u0438\u043b\u0438 \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u044e\u0442 \u044d\u0444\u0444\u0435\u043a\u0442\u044b \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0439.\n\n\n\u00a7l\u0410\u043b\u0442\u0430\u0440\u044c\u00a7r\n\n\u0410\u043b\u0442\u0430\u0440\u044c - \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043b\u044e\u0431\u043e\u0433\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u0430. \u041e\u043d \u0441\u043b\u0443\u0436\u0438\u0442 \u0442\u043e\u0447\u043a\u043e\u0439 \u0441\u043e\u0441\u0440\u0435\u0434\u043e\u0442\u043e\u0447\u0435\u043d\u0438\u044f \u043c\u0430\u0433\u0438\u0438, \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u044f \u044d\u0444\u0438\u0440\u043d\u044b\u0435 \u043f\u043e\u0442\u043e\u043a\u0438. \u0412 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u0440\u0438\u0442\u0443\u0430\u043b\u0430, \u0430\u043b\u0442\u0430\u0440\u044c \u043c\u043e\u0436\u0435\u0442 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u0442\u044c \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u0435 \u043a\u0430\u0442\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u044b, \u0440\u0430\u0437\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u044d\u0444\u0438\u0440\u0430 \u0434\u043b\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u044f\u0434\u0430.\n{CRAFT1}\n\n\u00a7l\u041f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b\u00a7r\n\n\u041f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u044b \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0434\u043b\u044f \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u0438\u043d\u0433\u0440\u0438\u0434\u0438\u0435\u043d\u0442\u043e\u0432 \u0440\u0438\u0442\u0443\u0430\u043b\u0430. \u041e\u043d\u0438 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0441\u0432\u044f\u0437\u0430\u043d\u044b \u0441 \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u043c\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043c\u0438. \u0418\u0445 \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u044f - \u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0440\u0438\u0442\u0443\u0430\u043b\u0430.\n{CRAFT2}\n\n\u00a7l\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c \u042d\u0444\u0438\u0440\u0430\u00a7r\n\n\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u044c \u042d\u0444\u0438\u0440\u0430 \u0443\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u0442 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0435\u043c \u044d\u0444\u0438\u0440\u0430, \u0440\u0430\u0432\u043d\u043e\u043c\u0435\u0440\u043d\u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u044f \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u043c\u0435\u0436\u0434\u0443 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u0430\u043c\u0438 \u0438 \u0430\u043b\u0442\u0430\u0440\u0451\u043c. \u0411\u0435\u0437 \u043d\u0435\u0433\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u043f\u0440\u043e\u0445\u043e\u0434\u0438\u0442\u044c.\n{CRAFT3}\n\n\u00a7l\u0420\u0443\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b\u00a7r\n\n\u042d\u0442\u043e\u0442 \u043f\u044c\u0435\u0434\u0435\u0441\u0442\u0430\u043b \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u0440\u0443\u043d, \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u044e\u0449\u0438\u0445 \u0440\u0438\u0442\u0443\u0430\u043b. \u0420\u0443\u043d\u044b, \u0440\u0430\u0437\u043c\u0435\u0449\u0451\u043d\u043d\u044b\u0435 \u043d\u0430 \u043d\u0451\u043c, \u043c\u043e\u0433\u0443\u0442 \u0438\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0441\u0443\u0442\u044c \u043e\u0431\u0440\u044f\u0434\u0430.\n{CRAFT4}\n\n\u00a7l\u042d\u0444\u0438\u0440\u043e\u0432\u0430\u044f \u041f\u0440\u0438\u0437\u043c\u0430\u00a7r\n\n\u042d\u0442\u043e\u0442 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0431\u043b\u043e\u043a \u0438\u0433\u0440\u0430\u0435\u0442 \u0440\u043e\u043b\u044c \u0432 \u0441\u0432\u044f\u0437\u044b\u0432\u0430\u043d\u0438\u0438 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432 \u0441 \u044d\u0444\u0438\u0440\u043d\u044b\u043c\u0438 \u043f\u043e\u0442\u043e\u043a\u0430\u043c\u0438. \u0421 \u0435\u0433\u043e \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432, \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u044f \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u0442\u0435\u043b\u044e \u0440\u0430\u0441\u043a\u0440\u044b\u0442\u044c \u0438\u0445 \u0438\u0441\u0442\u0438\u043d\u043d\u044b\u0439 \u043f\u043e\u0442\u0435\u043d\u0446\u0438\u0430\u043b.\n{CRAFT5}\n").addTranslation("ru_ru", "mage_micon.page.trials", "\u0412 \u0441\u0432\u043e\u0438\u0445 \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u044f\u0445, \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u044b \u043e\u0441\u0442\u0430\u0432\u0438\u043b\u0438 \u0437\u0430 \u0441\u043e\u0431\u043e\u0439 \u0441\u043b\u0435\u0434 \u0432 \u0432\u0438\u0434\u0435 \u043e\u0441\u043e\u0431\u044b\u0445 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0439 - \u0436\u0435\u0441\u0442\u043e\u043a\u0438\u0445 \u043f\u0440\u043e\u0432\u0435\u0440\u043e\u043a \u0434\u043b\u044f \u0442\u0435\u0445, \u043a\u0442\u043e \u043e\u0441\u043c\u0435\u043b\u0438\u0442\u0441\u044f \u0432\u043e\u0439\u0442\u0438 \u0432 \u044d\u0442\u0438 \u0437\u0430\u0431\u044b\u0442\u044b\u0435 \u0437\u0435\u043c\u043b\u0438. \u042d\u0442\u0438 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u044f \u043d\u0435 \u0431\u044b\u043b\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u044b \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u043e; \u043e\u043d\u0438 \u0441\u0442\u0430\u043b\u0438 \u0447\u0430\u0441\u0442\u044c\u044e \u0432\u0435\u043b\u0438\u043a\u043e\u0433\u043e \u0440\u0438\u0442\u0443\u0430\u043b\u0430, \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044f \u043f\u0443\u0442\u0438 \u0434\u043b\u044f \u0442\u0435\u0445, \u043a\u0442\u043e \u0433\u043e\u0442\u043e\u0432 \u043a \u0432\u0435\u043b\u0438\u043a\u0438\u043c \u0441\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f\u043c.\n\n\u0418\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u044f \u0431\u044b\u0432\u0430\u044e\u0442 \u0434\u0432\u0443\u0445 \u0442\u0438\u043f\u043e\u0432: \u0432\u043e\u043b\u043d\u044b \u043c\u043e\u0431\u043e\u0432 \u0438 \u043b\u0443\u0447\u0438 \u044d\u0444\u0438\u0440\u0430. \u041a\u0430\u0436\u0434\u044b\u0439 \u0438\u0437 \u044d\u0442\u0438\u0445 \u0432\u0438\u0434\u043e\u0432 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u0442 \u0441\u0438\u043b\u0443 \u0438 \u043c\u0443\u0434\u0440\u043e\u0441\u0442\u044c \u0442\u043e\u0433\u043e, \u043a\u0442\u043e \u0440\u0435\u0448\u0438\u0442\u0441\u044f \u0432\u0441\u0442\u0440\u0435\u0442\u0438\u0442\u044c\u0441\u044f \u0441 \u0438\u0445 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u044f\u043c\u0438.\n{ITEMS1}\n\u00a7l\u0412\u043e\u043b\u043d\u044b \u043c\u043e\u0431\u043e\u0432\u00a7r\n\n\u042d\u0442\u043e \u043e\u0434\u043d\u043e \u0438\u0437 \u0441\u0430\u043c\u044b\u0445 \u0434\u0440\u0435\u0432\u043d\u0438\u0445 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0439, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0441\u0438\u043b\u044b \u044d\u0444\u0438\u0440\u0430 \u043e\u0436\u0438\u0432\u0430\u044e\u0442, \u043f\u0440\u0435\u0432\u0440\u0430\u0449\u0430\u044f \u0438\u0445 \u0432 \u0447\u0443\u0434\u043e\u0432\u0438\u0449, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u043c\u0430\u0433\u0438\u0438 \u0438 \u043c\u0430\u0442\u0435\u0440\u0438\u0438. \u0412 \u0442\u0430\u043a\u043e\u043c \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0438 \u043e\u0442 \u0410\u043b\u0442\u0430\u0440\u044f \u0418\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0439 \u043d\u0430\u0447\u0438\u043d\u0430\u044e\u0442 \u043f\u043e\u044f\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0432\u043e\u043b\u043d\u044b \u0432\u0440\u0430\u0436\u0434\u0435\u0431\u043d\u044b\u0445 \u0441\u0443\u0449\u0435\u0441\u0442\u0432. \u041a\u0430\u0436\u0434\u0430\u044f \u0432\u043e\u043b\u043d\u0430 \u0441\u0438\u043b\u044c\u043d\u0435\u0435 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439, \u0438 \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435, \u043a\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c\u0441\u044f \u0441 \u044d\u0442\u0438\u043c \u043d\u0435\u0441\u043a\u043e\u043d\u0447\u0430\u0435\u043c\u044b\u043c \u043f\u043e\u0442\u043e\u043a\u043e\u043c, \u0441\u043c\u043e\u0433\u0443\u0442 \u0434\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0432\u043e\u044e \u0441\u0438\u043b\u0443.\n\n\n\n\n\n\n\n\n\n\n\u00a7l\u041b\u0443\u0447\u0438 \u042d\u0444\u0438\u0440\u0430\u00a7r\n\n\u0414\u0440\u0443\u0433\u0438\u043c \u0432\u0438\u0434\u043e\u043c \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043f\u0440\u043e\u0446\u0435\u0441\u0441, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u044d\u0444\u0438\u0440 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0432\u0435\u043b\u0438\u043a\u0438\u0439 \u0430\u043a\u0442. \u0418\u0437\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u0438 \u041b\u0443\u0447\u0435\u0439, \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u043f\u043e \u043f\u0435\u0440\u0438\u043c\u0435\u0442\u0440\u0443 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u044f, \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u044e\u0442 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u044d\u043d\u0435\u0440\u0433\u0438\u044e \u043e\u0442 \u0410\u043b\u0442\u0430\u0440\u044f \u0418\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0439 \u043a \u041f\u0440\u0438\u043b\u043e\u043c\u0438\u0442\u0435\u043b\u044e \u041b\u0443\u0447\u0435\u0439. \u042d\u0442\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e, \u0432 \u0441\u0432\u043e\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c, \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u0443\u0435\u0442 \u043f\u043e\u0442\u043e\u043a \u044d\u0444\u0438\u0440\u043d\u043e\u0439 \u0441\u0438\u043b\u044b, \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044f \u043f\u0443\u0442\u0438 \u043a \u043d\u043e\u0432\u044b\u043c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044f\u043c \u0438 \u043c\u0430\u0433\u0438\u0438.\n{ITEMS2}\n\u00a7l\u041d\u0430\u0433\u0440\u0430\u0434\u044b\u00a7r\n\n\u041f\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044e \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u044f, \u0431\u0443\u0434\u044c \u0442\u043e \u043f\u043e\u0431\u0435\u0434\u0430 \u043d\u0430\u0434 \u0432\u043e\u043b\u043d\u0430\u043c\u0438 \u043c\u043e\u0431\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u0430\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043b\u0443\u0447\u0435\u0439, \u0433\u0435\u0440\u043e\u0439 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0421\u0444\u0435\u0440\u044b \u0416\u0435\u043b\u0430\u043d\u0438\u0439 - \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u0441\u0438\u043b\u044b, \u043d\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u044b\u0435 \u044d\u0444\u0438\u0440\u043d\u043e\u0439 \u044d\u043d\u0435\u0440\u0433\u0438\u0435\u0439. \u042d\u0442\u0438 \u0421\u0444\u0435\u0440\u044b \u043d\u0435\u0441\u0443\u0442 \u0432 \u0441\u0435\u0431\u0435 \u0441\u0438\u043b\u0443 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0441 \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u0435\u043c, \u0438 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u044b \u043d\u0430 \u00a7l\u0410\u043b\u0442\u0430\u0440\u0435 \u0421\u0443\u0434\u044c\u0431\u044b\u00a7r, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d \u0432 \u043d\u0430\u0447\u0430\u043b\u0435 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u044f.\n{ITEMS3}\n\u00a7l\u0410\u043b\u0442\u0430\u0440\u044c \u0421\u0443\u0434\u044c\u0431\u044b\u00a7r - \u044d\u0442\u043e \u0441\u0432\u044f\u0449\u0435\u043d\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e, \u0433\u0434\u0435 \u043d\u0438\u0442\u0438 \u044d\u0444\u0438\u0440\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u044f\u044e\u0442\u0441\u044f, \u0441\u043f\u043b\u0435\u0442\u0430\u044f \u0440\u0430\u0437\u043b\u0438\u0447\u043d\u044b\u0435 \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b. \u0417\u0430 \u043e\u0434\u043d\u0443 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c 1 \u0438\u043b\u0438 10 \u0421\u0444\u0435\u0440 \u0416\u0435\u043b\u0430\u043d\u0438\u0439. \u041a\u043e\u0433\u0434\u0430 \u0421\u0444\u0435\u0440\u044b \u0440\u0430\u0437\u043c\u0435\u0449\u0430\u044e\u0442\u0441\u044f \u043d\u0430 \u0410\u043b\u0442\u0430\u0440\u0435, \u0435\u0433\u043e \u043c\u0430\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0438\u043b\u0430 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432, \u043a\u043d\u0438\u0433 \u0441 \u0447\u0430\u0440\u0443\u044e\u0449\u0438\u043c\u0438 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u044f\u043c\u0438, \u0440\u0435\u0434\u043a\u0438\u0445 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u043e\u0432, \u0440\u0435\u0441\u0443\u0440\u0441\u043d\u044b\u0445 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0438 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u043a\u043b\u0438\u043d\u0430\u043d\u0438\u0439.\n{ITEMS4}\n").addTranslation("ru_ru", "mage_micon.page.resource_items", "\u0420\u0435\u0441\u0443\u0440\u0441\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b - \u044d\u0442\u043e \u0440\u0435\u0434\u043a\u0438\u0435 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435 \u0432 \u0440\u0438\u0442\u0443\u0430\u043b\u0430\u0445 \u0438 \u0440\u0435\u043c\u0435\u0441\u043b\u0435, \u0431\u0435\u0437 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043d\u0435 \u043e\u0431\u043e\u0439\u0442\u0438\u0441\u044c \u0432 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u044d\u0444\u0438\u0440\u043d\u044b\u0445 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0439. \u041e\u043d\u0438 \u0445\u0440\u0430\u043d\u044f\u0442 \u0432 \u0441\u0435\u0431\u0435 \u043e\u0442\u0433\u043e\u043b\u043e\u0441\u043a\u0438 \u0441\u0438\u043b\u044b \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432 \u0438 \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u044e\u0442\u0441\u044f \u0432 \u0434\u0440\u0435\u0432\u043d\u0438\u0445 \u0440\u0443\u0438\u043d\u0430\u0445 \u0438 \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u044f\u0445 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432.\n\u041e\u0434\u043d\u0430\u043a\u043e \u0434\u043b\u044f \u0442\u0435\u0445, \u043a\u0442\u043e \u043d\u0435 \u0436\u0435\u043b\u0430\u0435\u0442 \u043f\u043e\u043b\u0430\u0433\u0430\u0442\u044c\u0441\u044f \u043b\u0438\u0448\u044c \u043d\u0430 \u0443\u0434\u0430\u0447\u0443, \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043d\u043e\u0439 \u043f\u0443\u0442\u044c. \u042d\u0442\u0438 \u0446\u0435\u043d\u043d\u044b\u0435 \u0430\u0440\u0442\u0435\u0444\u0430\u043a\u0442\u044b \u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442\u044b\u0441\u043a\u0430\u0442\u044c \u0432 \u043f\u043e\u0434\u0437\u0435\u043c\u0435\u043b\u044c\u044f\u0445 \u041f\u0440\u043e\u0432\u0438\u0434\u0446\u0435\u0432, \u043d\u043e \u0438 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043f\u0440\u043e\u0441\u0442\u044b\u0445 \u0440\u0438\u0442\u0443\u0430\u043b\u043e\u0432.\n{ITEMS1}\n").addTranslation("en_us", "mage_micon.page.catalyst", "In the Age of Ascendance, the Seers realized that manipulating Ether with bare hands meant losing half its potential. They required a tool capable not merely of releasing magic, but of focusing, refracting, and amplifying it. Thus, \u00a7lCatalysts\u00a7r were born \u2014 artifacts that became an extension of the mage's will.\nEach catalyst is inextricably bound to a specific element. It is not simply a weapon, but a complex prism that tints neutral Ether into the hues of destructive forces.\n{ITEMS1}\n\u00a7lThe Art of Combat\u00a7r\n\nWielding a catalyst requires an understanding of rhythm.\n\u00a7lNormal attacks\u00a7r are swift and precise. They utilize the weapon's internal charge, dealing moderate damage.\n\u00a7lCharged attacks\u00a7r are a manifestation of supreme mastery. By delaying the flow, the mage forces the catalyst to resonate with the surrounding space, drawing free Ether directly from the air. This concentrated burst possesses crushing power, far exceeding ordinary strikes.\n\n\u00a7lImbuing with Power\u00a7r\n\nLike a living being, a catalyst is capable of growth. It is akin to a vessel whose bottom is shrouded in darkness. Using the Ether Anvil, you can imbue the weapon with the pure energy of shards, crystals, and essences.\nThis process, known as Infusion, unlocks the item's potential, raising its level and increasing damage dealt.\n\n\n\u00a7lAscension\u00a7r\n\nEvery form has a limit, but magic has none. When a catalyst reaches the peak of its capabilities, a sacrifice is required to shatter the fetters of form.\nMerging two identical catalysts on the Ether Anvil is called Ascension. In this process, one copy dissolves into the other, transferring its \"memory\" and structure. This awakens the weapon's dormant stellar power, enhancing its unique passive skills.\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7lA sword may break, an arrow may miss. But will, clad in the proper form, always strikes true.\u00a7r\"\n\u00a7r\u2014 Teachings of Arkas on the nature of tools.\n").addTranslation("en_us", "mage_micon.page.bosses", "In ancient ruins and atop spires untrodden by mortal feet, the \u00a7lGuardians\u00a7r slumber. These are not living beings, but complex golem-constructs created by the Seers to protect their shrines. Even centuries later, their mechanisms function flawlessly, sustained by an eternal flow of Ether. Each of them is a trial of will and mastery for anyone daring to encroach upon the secrets of the ancients.\n").addTranslation("en_us", "mage_micon.page.aerolith", "The summit of the Sky Spire is guarded by \u00a7lAerolith\u00a7r \u2014 a colossal golem in the form of a predatory bird, commanding hurricanes.\nBattle with it demands reaction and endurance. Aerolith is swift and constantly shifts position, unleashing torrents of wind upon the enemy.\nA wise mage knows: brute force will not avail here. Use a standard \u00a7lshield\u00a7r to parry the Guardian's projectiles and deflect them back. This is the only way to pierce its defense when it shelters within the \"Storm Cocoon\" phase.\n\n\n\n\n\n\n\n\u00a7lSingularity\u00a7r\n\nWhen Aerolith's physical shell is shattered (0 HP), it will not perish immediately. The Guardian will summon the Void itself \u2014 a Black Hole.\nIn this phase, the Guardian is invulnerable and accumulates charge for a devastating explosion capable of obliterating all life. You must disrupt the Hole's concentration with a ceaseless hail of attacks.\nPhysical strikes weaken the charge, but spell impacts are far more effective at dissipating the unstable energy.\n\nIf you manage to contain the charge (below 70%) until the moment of detonation, Aerolith will be vanquished and dissolve into streams of Ether.\n\n\u00a7lHeart of the Storm\u00a7r\n\nAt the site of the Guardian's demise, its core remains \u2014 the Heart of the Storm. It holds the fury of a hurricane that will never subside.\nThis is a legendary component with two paths of use:\nPerforming a grand ritual to create the \"Dance of Winds\" catalyst \u2014 the weapon of Aerolith itself.\nSacrificing the heart for the instant advancement of any Aero-artifact to its absolute maximum.{ITEMS1}\n\n\n\n\u00a7r\"\u00a7lOnly he who can withstand the storm is worthy to wear its wings.\u00a7r\"\n\u00a7r\u2014 Inscription at the entrance to the Sky Spire.\n").addTranslation("en_us", "mage_micon.page.ether_mirror", "\u00a7lEtherial Mirror\u00a7r is an ancient invention of the Seers, drawing power from pure ether stored in ether vessels. This artifact allows its wielder to imprint a location by reflecting it in the mirror [SHIFT] + [RMB] and later teleport there. {CRAFT1}").addTranslation("en_us", "mage_micon.page.elemental_compass", "\u00a7lElemental Emblem\u00a7r is an ancient artifact of the Seers, designed to guide the seeker to sources of elemental power. However, in its current state, it is dormant. To awaken its guidance, it \u00a7lmust be infused with a specific element via a ritual\u00a7r.\n {CRAFT1}\n {RITUAL1} {RITUAL2} {RITUAL3}").addTranslation("en_us", "mage_micon.page.ether_source", "\u00a7lEther Sources\u00a7r \u2013 ancient nodes of power left behind by the Seers. They infuse the world with energy and can be used to extract pure ether.\n\nTo draw ether from a source, one requires an ether pedestal and a vessel capable of storing energy, such as an\u00a7l Ether \u00a7lCrystal\u00a7r.\n\nBy placing the vessel on the pedestal, one can direct the flow of ether into it, accumulating energy for future use.\n\nHowever, sources are not infinite \u2013 over time, their reserves are depleted. They can, however, be restored using ether shards, which awaken the nodes and allow them to radiate etheric power once more.\n\nThe Seers called this process the Ether Flow \u2013 invisible yet perceivable to those who can sense the breath of magic.\n{CRAFT1}\nUpon destroying the Ether Source, it will drop an \u00a7lEther Core\u00a7r.\n").addTranslation("en_us", "mage_micon.page.ether_collector", "\u00a7lEther Collector\u00a7r is an ancient mechanism left by the Seers, designed to gather the invisible etheric flows that traverse the world. It activates only at night, when the skies are filled with the hidden energy of Ether. However, its functionality is limited: within a radius of 20 blocks, no other Ether Collectors can exist. If another Collector is within this range, both devices will cease functioning, as the etheric flows can only be absorbed by one.\n\nTo \u00a7lextract\u00a7r Ether from the Collector, an ether pedestal and a vessel capable of storing this precious magical flow are required.\n{CRAFT1}\n").addTranslation("en_us", "mage_micon.page.ether_anvil", "\u00a7lEther Anvil\u00a7r - a Seers' tool connecting their craft to ether's power. It enhances artifacts and applies their power to spells and weapons. {CRAFT1}").addTranslation("en_us", "mage_micon.page.ether_anvil2", "\u00a7lEther Anvil\u00a7r - a Seers' tool connecting their craft to ether's power. It enhances artifacts and applies their power to spells and weapons.").addTranslation("en_us", "mage_micon.page.ether_anvil3", "\u00a7lEther Anvil\u00a7r - a Seers' tool connecting their craft to ether's power. It enhances artifacts and applies their power to spells and weapons.\nPlace a Catalyst in the left slot. Place the material in the second slot.").addTranslation("en_us", "mage_micon.page.seal_pedestal", "\u00a7lSeal Pedestals\u00a7r - keys to uncovering ancient altars sealed by magic. These pedestals can be found in the elemental ruins of the Seers, in rooms with ritual circles hidden behind powerful elemental barriers.\n{ITEMS1}\nThe Cryo Seal is a massive block of ice eternally encasing the ritual circle and securely sealing it. To break this magical freeze, seal pedestals near the altar circle must be activated and special pyro items placed on them.\nThe Pyro Seal, on the other hand, encases the ritual circle in a bright and invisible fire, preventing rituals from being performed, as if it seeks to consume any attempt at interference. To remove this fiery barrier, special cryo items capable of taming the untamed heat must be placed on the seal pedestals.\n\nOnly true items required to break the seals leave travelers with only the mysteries of antiquity and the enigma of which items are needed to lift the seal.\n").addTranslation("en_us", "mage_micon.page.sender", "These two mechanisms embody the Seers' mastery of controlling the flows of matter. \u00a7lThe Sender\u00a7r, created by the Seers, harnesses its power to manage material flows. It can direct items stored in ancient receptacles - chests - to its connected \u00a7lReceiver\u00a7r. {CRAFT1} The connection between them is established using a magical wand or staff, linking them via etheric pathways. These mechanisms work in perfect harmony, transferring items across spaces as if bending the physical laws to ether.").addTranslation("en_us", "mage_micon.page.ice_source", "\u00a7lIce Source\u00a7r - this is a shard of ancient magic preserved in the depths of icy ruins. This icy monolith exudes cold so intense that even a brief presence near it can cause freezing. Its surface is covered with an icy crust reflecting light, and its core hides a frost capable of extinguishing heat from anything that approaches. The Seers used such sources for their ice rituals, drawing from them the energy of cold and creating eternal ice. Its operation can be temporarily \u00a7lstopped\u00a7r using a fire crystal.").addTranslation("en_us", "mage_micon.page.base_runes", "\u00a7lRunes\u00a7r - these are ancient magical symbols created by the Seers in times when ether was still young. The Seers used runes as a tool to direct the flow of ether in the desired direction, avoiding its chaotic nature. These magical symbols became the key to controlling ether.\nEach rune holds a fragment of the Seers' wisdom and strength, sealed in a magical symbol. They serve as a link between ether and the world, as catalysts that enhance or stabilize rituals. It was the runes that allowed the Seers to create complex magical constructions without fearing that ether would slip out of control.\n\n\n\u00a7lObtaining Runes\u00a7r\n\nThe creation of runes is a process that requires knowledge and resources. Each rune is crafted using simple ingredients and a crafting table. This process activates the ether and seals it within a magical symbol, enabling the rune to be used in rituals.\n{CRAFT1}\n\nEach rune is unique, its power cannot be controlled. It can only be guided, revealing its potential at the right moment. The Seers believed that runes are not just tools but gifts capable of connecting the world to the pure magic of ether.\n\n\n\u00a7r\"\u00a7lThe symbols we leave will become the guiding thread for those who will one day follow us. Ether flows in them, and they direct it into the world.\u00a7r\"\n\u00a7r- from the writings of Seer El'Tar.\n").addTranslation("en_us", "mage_micon.page.rituals", "\u00a7lRituals\u00a7r - this is the ancient science and art inherited from the Seers, bearing the power to transform ether. They believed that rituals are a bridge between worlds, where spirit and matter unite in a single dance. Performing rituals requires not only precision but also wisdom, as every mistake can lead to unpredictable consequences.\n\n\u00a7lThe Structure of a Ritual Circle\u00a7r\n\nTo perform a ritual, a ritual circle must be constructed, though the concept of a circle is inherited more from tradition than form. The Seers said: \"The harmony of ether has no boundaries; its flows obey only the mage's will.\" Thus, the circle's elements can be arranged chaotically but are always connected to its heart - the altar.\n\n\u2022 \u00a7lAltar\u00a7r - The center of every ritual, the place where transformation begins. Here lies the item that becomes the basis of the magical act.\n\n\n\u2022 \u00a7lPedestals\u00a7r - Stones of conduits that hold the power of ether. On them rest the items necessary for the ritual. Their energy merges and is directed to the altar.\n{CRAFT1}\n\u2022 \u00a7lRunic Pedestals\u00a7r - Special pedestals absorbing the magic of runes whose power is required to direct ether precisely into the ritual's target.\n\n\u2022 \u00a7lEther Distributor\u00a7r - A power reservoir, the source of the ritual's energy. Here lie vessels of ether, without which magic is impossible.\n{CRAFT2}\n\u2022 \u00a7lEther Prism\u00a7r - A key to managing the subtle energies of artifacts. It reduces risk or enhances the ritual's effect.\n{CRAFT3}\n\u00a7lRitual Events\u00a7r\n\nPerforming a ritual is always a risk and a mystery. Even the wisest Seers could not predict every event that might occur. Here are the main ones:\n\n\u2022 \u00a7lEssence\u00a7r - Upon completing complex rituals, ether sometimes creates an essence - a rare material containing the Seers' crystallized wisdom. This substance is needed to enhance spells or alter artifacts' nature in Kor-Lunar.\n\n\u2022 \u00a7lRitual Crash\u00a7r - When ether's forces spiral out of control, the ritual may collapse. All items placed on pedestals will be expelled, and some may be destroyed. Only artifacts with protective magic can reduce the likelihood of a crash.\n\n\u2022 \u00a7lEther Overload\u00a7r - Ether is unstable by nature. Sometimes its volume exceeds the ritual's limits, causing an overload. To tame this energy, an \u00a7lEther \u00a7lDischarger \u00a7ris needed to safely dissipate the excess.\n\n\u2022 \u00a7lEther Flash\u00a7r - Ether flows are unpredictable. They can suddenly flare up, filling the reservoir with new energy or turning their wrath upon those around. These events cannot be prevented, but every mage must be ready to face them.\n\n\n\n\n\n\u00a7r\"\u00a7lThe art of rituals is like the wind. It can warm a hearth or tear down the house's walls. But in this danger lies true magic - to control that which seeks to break free.\u00a7r\"\n\u00a7r- from the Seers' treatise.\n").addTranslation("en_us", "mage_micon.page.ether", "\u00a7lEther\u00a7r is an essence that permeates the very foundation of existence, binding energy and matter together. It existed long before the time of the Seers, becoming the basis of magic and the source of wonders beyond mortal comprehension. In its immaterial form, ether is a flow of pure energy, coursing through the world, fueling rituals, spells, and artifacts. In its material form, it manifests as crystals, minerals, and refined ingots, used in alchemy and magical craftsmanship.\n\n\n\n\n\n\n\n\n\u00a7lPhysical Ether\u00a7r\n\nMaterial ether appears in the form of special minerals that have absorbed its power from the depths of the earth. These crystals store concentrated energy, making it accessible for use and allowing mages to interact with etheric currents.\n\n\u00a7lEther Ore\u00a7r \u2013 a rare mineral hidden deep underground. When mined, it breaks into ether shards, and in rare cases, into whole ether crystals, which can store even greater energy.\n\n\n\n\n\n\n\u00a7lEther Ingot\u00a7r \u2013 a purified and reforged form of ether shards. It is used in the creation of artifacts that channel ether and in special rituals.\n{CRAFT1}\n\n\u00a7lEther\u00a7r\n\nBut ether is more than just stones and crystals. Its true power flows invisibly through the world, binding reality together.\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7lEther is like the breath of the world. Only by opening your heart will you feel it, and only by touching it will you claim it.\u00a7r\"\n\u00a7r- from the Seers' treatise.\n").addTranslation("en_us", "mage_micon.page.spells", "\u00a7lSpells\u00a7r are the pinnacle of the Seers' magic, crafted to harness ether and simplify life. The Seers believed that magic was a path to harmony with the world, and spells reflected their wisdom. They wove etheric energy into words and symbols, ensuring it could be passed down through generations. Each spell is a legacy, a tool, and a challenge for those daring to wield it.\n{ITEMS1}\n\u00a7lThe Birth of Elemental Magic\u00a7r\n\nThe Seers studied ether, dividing it into the elements that make up the world: fire, ice, and many others now forgotten. They used this knowledge to create spells capable of channeling elemental power. It was believed that every person is connected to one element from birth, and the Seers created elemental scrolls so that those who understood their path could change their element if it proved incompatible.\n\n\n\n\n\n\n\n\n\u00a7lUsing Spells\u00a7r\n\nTo use a spell, it must first be \u00a7lstudied\u00a7r. This is a simple act that connects magical knowledge with the mind and soul. Once studied, the spell becomes available for use through magical wands. However, there is an important limitation: a mage can only use spells that \u00a7lmatch their current element\u00a7r.\nAdditionally, the \u00a7lKor-Lunar level must meet the spell's requirements\u00a7r,\n\u00a7rand the player will also need to carry an \u00a7lether vessel\u00a7r.\n{CRAFT1}\n\u00a7r\"\u00a7lElemental magic flows through us like rivers through the earth. Fire warms and burns, ice preserves and protects. A mage must remember: it is not they who choose the element, but the element that chooses the mage.\u00a7r\"\n\u00a7r- from \"Records of the First Seers.\"\n").addTranslation("en_us", "mage_micon.page.seers", "Deep in the annals of history, beyond the reach of mortal memory, existed a great race known as the Seers. These beings were not merely masters of ether - they were its guardians, its conduits into the material world. The Seers saw ether not only as a magical force but as the essence of creation, the life energy binding everything together.\n\nThey built cities floating on magical currents, created powerful spells and artifacts that forever changed their world. Their pursuit of perfection made them the architects of ether, but not its rulers. The Seers believed that ether was a gift to be used with wisdom and care.\n\nThey left their legacy in the form of etheric sources, which absorbed their magic. Scattered across the world, these sources act as beacons, calling on new explorers to continue the work of the ancients. Yet their fate was a tragic one...\n").addTranslation("en_us", "mage_micon.page.nihilis", "The world around the Seers was surrounded by streams of Ether, but over time, they discovered a force that appeared in places where rituals were performed or where Ether concentration was high-this force absorbed Ether. Once the Ether concentration in the area stabilized, the force would disappear. The Seers named this phenomenon Nihilis-a power that maintains the balance of Ether in the world.\n\nAt first, the presence of Nihilis seemed like a minor anomaly. Ether streams would return to normal in isolated spots. However, as Ether consumption increased, Nihilis began appearing more frequently at ritual sites. The Seers disliked this force, as it interfered with their ability to use large amounts of Ether freely. Over time, they noticed that Nihilis absorbed Ether at a specific rate, leading them to seek ways to gather more Ether.\n\n\nAs Ether harvesting increased, Nihilis points were unable to complete their work due to the constant influx of Ether. After some time, these continuously active Nihilis points began forming crystals. Though small, these crystals held an immense concentration of Ether's power. This discovery marked the beginning of a new era of civilization, one built upon the use of these crystals.\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7lWe cannot control this power, but we can interact with it by directing Ether streams to Nihilis emergence points.\u00a7r\"\n\u00a7r- Words of Arcas, leader of the Seers.\n").addTranslation("en_us", "mage_micon.page.kor_lunar", "\u00a7lThe Kor-Lunar Tree\u00a7r is the final legacy of the Seers, created in the days of their greatness. This magical tree embodies their knowledge, strength, and desire to protect etheric magic from decay. Its branches touch the stars, and its roots are nourished by the energy of the world.\n\n\n\nThe tree serves as a source of magical growth for those who discover it. Through Kor-Lunar, mages can:\n\n\u2022 Develop their magic tree, unlocking new paths and strengthening their bond with ether.\n\n\u2022 Enhance their spells, weaving starlight magic into the ether.\n\n\u2022 Transform the attributes of artifacts, altering their essence and power direction.\n\nKor-Lunar thrives on ether, and its strength grows through interaction with the mage's magic. But this power does not come freely: only through a deep understanding of ether and responsible choices can a mage unlock the tree's potential.\n\nSeekers must venture through deep caves and forgotten corridors of ruins to reach the tree.\n\n\u00a7lFinding the Tree\u00a7r\n\nKor-Lunar is not as difficult to find as it might seem. On the surface, it appears as an unremarkable small pink tree, but its roots conceal an ancient passage underground. This path will lead you to the mighty Kor-Lunar, whose branches and roots are infused with the purest Ether. To locate it, you will need the Elemental Emblem, which will guide you to this place of power.\n\n\n\n\n\n\u00a7r\"\u00a7lIts roots wrap around the earth, shrouding it in magic. But not everyone is destined to see the light of its starlit branches.\u00a7r\"\n\u00a7r- Words of the Seer Tai'Renn.\n").addTranslation("en_us", "mage_micon.page.artifacts", "\u00a7lArtifacts\u00a7r are rare magical items created by the Seers in their quest to tame the instability of rituals and channel etheric power effectively. Each artifact represents a unique bond between ether and the world, containing power unattainable by other means. The Seers believed that only artifacts could stabilize rituals and protect them from destructive side effects.\n{ITEMS1}\n\u00a7lUsing Artifacts\u00a7r\n\nArtifacts are central to etheric magic. They are used:\n\u2022 In rituals: to stabilize magic and reduce risks like ritual failure or ether overload. Some rituals are impossible without specific artifacts.\n\u2022 In spells and weapons: artifacts can be infused into magical staves and swords, amplifying their power or adding unique effects. They also interact with spells, altering their nature or enhancing their strength.\n\n\u00a7lObtaining Artifacts\u00a7r\n\nArtifacts cannot be created or forged by ordinary means. They can only be found in the ancient ruins of the Seers, where the magic of the past still sustains them. These places are full of dangers, but those brave enough to search may find artifacts imbued with the grandeur of a bygone era.\n\nHowever, the true power of artifacts can only be unlocked through the Kor-Lunar Tree. There, deep in the world, artifact stats can be reconfigured, redirecting their energy for a more suitable purpose. This process requires knowledge and resources but prepares the artifact for optimal use.\n\n\n\n\n\n\n\u00a7r\"\u00a7lWe left these keys not for glory, but for future paths. Only those who understand the nature of ether will use them as intended.\u00a7r\"\n\u00a7r- from the writings of the Seer Kae'Lar.\n").addTranslation("en_us", "mage_micon.page.elements_fundamentals", "\u00a7lElements\u00a7r are an integral part of Ether, a reflection of its infinite multifaceted nature. Each element represents a manifestation of one of the aspects of existence, deeply rooted in the nature of the world. Seers, while studying Ether, discovered that it has a natural tendency to split into various streams corresponding to the elements.\n\n\u00a7lOrigin of Elements\u00a7r\n\nIt is said that in ancient times, Ether was whole and indivisible, like a boundless ocean of energy. But one day, it fractured into streams reflecting the fundamental forces of the world: fire, ice, water, earth, and others. These streams formed the elements - fundamental aspects that, in harmony, create balance.\n\n\u00a7lUsing Scrolls\u00a7r\n\nElemental Scrolls are ancient artifacts left behind by the Seers. Each scroll contains encoded knowledge of a specific element and serves as a key to awakening its power within you.\n\nOnce a scroll is studied, the connection to its element becomes a part of your essence. This knowledge cannot be forgotten, but the choice of element is not final. Kor-Lunar, as the center of etheric balance, allows you to change your element at any time.\n\n\n\u00a7lCreating Scrolls\u00a7r\n\nThe process of obtaining an Element Scroll is complex and lengthy, requiring extensive knowledge. Empty scrolls left behind by the Seers can be found in their ruins and dungeons. However, for the scroll to gain the power of an element, a special ritual must be performed.\n\nThis ritual can only take place in a dungeon dedicated to the element of the scroll. However, the ritual altar in these locations is sealed by ancient magic. To unseal it, special \u00a7lSeal Pedestals\u00a7r located near the ritual circle must be activated.\n\n\n\n\n\n\u00a7r\"\u00a7lAn element chooses not the mind but the soul. It knows you before you know it.\u00a7r\"\n\u00a7r- from the ancient texts of the Seers.\n").addTranslation("en_us", "mage_micon.page.distorted_nihilis", "The process of creating Nihilis crystals took an enormous amount of time. The Seers sought ways to accelerate it, but every attempt to increase the speed of a natural Nihilis failed. They then turned to an alternative approach: recreating the phenomenon artificially using Ether. Their experiment was a success-at first. But in time, they realized that artificial Nihilis did not stabilize Ether as the natural one did. Instead, it consumed Ether completely, without balance.\n\nBefore long, it began corrupting the world, draining Ether from all things. It was then named Distorted Nihilis, and it seemed as if it had gained a mind of its own. Staying near this force became impossible, as it posed a grave threat to all life.\n\nWith each passing year, Distorted Nihilis grew stronger, devouring Ether, unraveling reality, and swallowing the light itself. The Seers realized that the only way to undo their mistake was through the ultimate sacrifice. In a final act of selflessness, they performed the greatest ritual ever conceived, sealing Distorted Nihilis away. This was their last stand. They vanished, leaving only ruins, the secrets of their knowledge, and the legends of their fate.\n\nThus, Distorted Nihilis was defeated-but not destroyed. Its residual power still lingers in the world, manifesting as a corrupted biome known as the Distortion.\n\n\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7lWe cannot destroy Nihilis. But we can cast it into the depths of Ether, where it will become nothing but a shadow. Let our light be the final beacon for the generations to come.\u00a7r\"\n\u00a7r- The last words of Arcas, leader of the Seers.\n").addTranslation("en_us", "mage_micon.page.element_reaction", "The world is woven from currents of Aether, and every fragment of its essence belongs to an element. When these currents intertwine, they clash and react, giving birth to powerful and often unpredictable phenomena. These interactions are known as Elemental Reactions-an ancient law of magic that binds the elements together.\n\nWhen a being is affected by multiple elements, their forces begin to struggle against one another, unleashing surges of raw magical energy. Fire awakens the storm, ice fractures the earth, and aetheric currents tear through flesh. Reactions can be destructive, amplifying, or unstable, but each one is a manifestation of the great power hidden within the world\u2019s elements.\n\n\u00a7lAwakening the Elements\u00a7r\nElemental reactions can be triggered in many ways. Some spells infuse their target with a specific element, leaving its mark upon them. However, magic is not the only path. The world itself imprints the elements upon those who dwell within it:\n\n\u2022 Flames leave searing burns, and if a being is ablaze, the Fire element has already taken hold.\n\u2022 Frost binds with chilling force, and if ice claims the flesh, then the Ice element has entered the fray.\n\n\n\nBut one truth remains: Elemental Reactions are not merely tools of magic. They are the very essence of Aether, chaotic and magnificent. Those who master their nature will wield true dominion over the elements\u2026\n").addTranslation("en_us", "mage_micon.page.enigma", "The Seers discovered this power through the long process of Nihilis absorbing Ether. The crystals obtained in this way contain an immense concentration of Ether. For a long time, it was believed that these crystals were merely compressed Ether energy. However, over time, it was discovered that while it functions similarly to Ether, it reacts very differently to certain interactions. After this revelation, the energy within these crystals was named Enigma.\n\nRituals conducted using Enigma and its crystals exhibited extreme instability. If a ritual was completed without incident, it produced incredibly powerful items, but frequent use of such items drained the body.\n\n\n\n\n\n\n\n\n\n\n\n\n\u00a7r\"\u00a7lThis power is Ether, yet it surpasses it. Its unstable strength comes at a price.\u00a7r\"\n\u00a7r- Words of Arcas, leader of the Seers.\n").addTranslation("en_us", "mage_micon.page.enigma_secret", "When the Seers first encountered the Enigma, they did not comprehend its true nature. Centuries of ether consumption by Nihilis had given rise to a phenomenon that defied the very essence of balance. In places where ether vanished without a trace, strange crystals began to form. Their shimmering structure, filled with swirling unnatural light, was both familiar and alien.\n\nAt first, they were mistaken for mere ether clusters, compressed into an incredibly dense form. But the longer the Seers studied these crystals, the more they realized-they were unlike anything they had ever worked with. Unlike ether, which could be obediently guided in rituals, the Enigma followed its own will. It did not abide by the laws of the world but instead created its own.\n\n\u00a7lProperties of the Enigma\u00a7r\nThe Enigma manifests in the world as unique crystals, hidden in places once tainted by the Corrupted Nihilis. These crystals amplify magical energy flows, making rituals beneath them unpredictably powerful. Where an ordinary ritual would demand immense resources, the Enigma replenished its strength, granting the greatest of boons\u2026 but also the gravest instability.\n\nThe Seers discovered that in the presence of the Enigma, magical devices functioned with twice the efficiency. Ether Collectors absorbed energy at double the rate, and Ether Prisms could hold not four artifacts, but eight. It seemed as if the Enigma twisted the very fabric of magic, bending it to its own mysterious laws.\n\nBut power always has a price. Those who relied too often on the Enigma\u2019s gifts found their bodies weakening. Their minds grew clouded, their thoughts scattered, and the ether within them began to fade. Prolonged exposure to the Enigma drains the soul itself.\n\n\n\n\n\n\u00a7lForbidden Power\u00a7r\nThe Seers, realizing the danger, sought to tame the Enigma, but it refused to submit. They believed they could bring it under control, yet every attempt ended in failure. This was no mere energy-it was something more, something they could never fully understand.\n\n\nNow, centuries later, Enigma crystals can still be found in places once ravaged by Nihilis. And those who dare to wield their power must remember: the Enigma gives nothing freely. It merely lends its strength\u2026\n").addTranslation("en_us", "mage_micon.page.ritual_constructs", "Ritual magic requires not only knowledge but also special structures capable of directing ether flows, amplifying magical vibrations, and binding elemental forces together. Without these structures, magic would remain unstable and chaotic, and complex rituals would be impossible. The Seers, studying the nature of ether, created numerous ritual blocks, each fulfilling a unique role: some concentrate energy, others control its distribution, while others interact with artifacts or enhance spell effects.\n\n\n\n\n\n\n\n\u00a7lAltar\u00a7r\n\nThe altar is the central element of any ritual. It serves as the focal point of magic, directing etheric flows. Depending on the ritual, the altar may require different catalysts and varying amounts of ether for the successful completion of the ceremony.\n{CRAFT1}\n\n\u00a7lPedestals\u00a7r\n\nPedestals are used to hold ritual ingredients. They can be associated with different elements. Their primary function is to hold the items necessary for conducting the ritual.\n{CRAFT2}\n\n\u00a7lEther Distributor\u00a7r\n\nThe Ether Distributor regulates the movement of ether, evenly distributing energy between the pedestals and the altar. Without it, ritual processes cannot take place.\n{CRAFT3}\n\n\u00a7lRunic Pedestal\u00a7r\n\nThis pedestal is designed to hold runes that enhance the ritual. Runes placed upon it can alter the essence of the ceremony.\n{CRAFT4}\n\n\u00a7lEther Prism\u00a7r\n\nThis unique magical block plays a role in linking artifacts with etheric flows. With its help, the properties of artifacts can be activated, allowing the spellcaster to unlock their true potential.\n{CRAFT5}\n").addTranslation("en_us", "mage_micon.page.resource_items", "Resource items are rare materials used in rituals and crafting, essential for creating ethereal structures. They hold echoes of the Seers' power and can be found in ancient ruins and the Seers' dungeons.\nHowever, for those who do not wish to rely solely on luck, there is another way. These valuable artifacts can not only be discovered in the Seers' dungeons but also created through simple rituals.\n{ITEMS1}\n").addTranslation("en_us", "mage_micon.page.ether_vessels", "Ether is an essence that does not tolerate stillness. It flows, vanishes, and is reborn, binding magic to matter. To contain its power, the Seers created special vessels-magical constructs capable of accumulating and preserving ether for future use. These vessels vary in capacity, stability, and interaction with magical currents.\n{ITEMS1}\n\n\u00a7lEther Crystal\u00a7r\n\nThe Ether Crystal is a basic vessel crafted from crystallized ether. It can hold a small amount of ether while remaining the most stable option.\n{CRAFT1}\n\n\u00a7lEther Orb\u00a7r\n\nThe Ether Orb is an enhanced vessel capable of storing significantly more ether. Unlike the Ether Crystal, the orb can alter the structure of ether within itself, adapting it to the caster\u2019s needs.\n{CRAFT2}\n\n\u00a7lEnigma Orb\u00a7r\n\nThe Enigma Orb is the only vessel capable of containing the unstable nature of ether. Created by the Seers in an attempt to understand the essence of Enigma, this artifact became more of a curse than a blessing.\n{RITUAL1}\n").addTranslation("en_us", "mage_micon.page.essence", "\u00a7lEssences\u00a7r are the rarest form of magical substance, containing the pure will of ether and the wisdom of the Seers. These are crystallized fragments of energy, formed in moments of ultimate magical harmony. Used in rituals and Kor-Lunar, they can alter artifacts and enhance spells, granting them new properties.\n\n\n\n\n{ITEMS1}\n\u00a7lBirth of Essences\u00a7r\n\nEssences do not naturally exist in the world-their creation requires the intervention of ether and a deep understanding of ritual magic.\n\nOn rare occasions, when a ritual reaches its peak, etherial energy condenses, giving birth to an essence. This phenomenon cannot be entirely predicted, but it occurs more often during complex ceremonies that demand great amounts of power.\n\nThe Seers believed that ether itself decides whether the ritual's master is worthy of such a gift. Thus, obtaining an essence is always a rare and momentous event.\n").addTranslation("en_us", "mage_micon.page.trials", "In their dungeons, the Seers left behind a legacy in the form of special trials-harsh tests for those who dare to enter these forgotten lands. These trials were not created by chance; they became part of a grand ritual, opening paths for those prepared for great achievements.\n\n\nTrials come in two types: waves of mobs and ether beams. Each of these tests the strength and wisdom of those who dare to face them.\n{ITEMS1}\n\u00a7lWaves of Mobs\u00a7r\n\nThis is one of the oldest trials, where the forces of ether come to life, turning into monsters made of magic and matter. In this challenge, waves of hostile creatures begin to emerge from the Trial Altar. Each wave is stronger than the last, and only those who can withstand this endless onslaught will prove their strength.\n\n\n\n\n\n\n\n\n\n\n\n\n\u00a7lEther Beams\u00a7r\n\nAnother type of trial is a magical process where ether must be directed through several devices to complete a great act. Beam Emitters, positioned around the trial, channel magical energy from the Trial Altar to the Beam Refractor. This device, in turn, activates the flow of etheric power, unlocking new opportunities and magic.\n{ITEMS2}\n\u00a7lRewards\u00a7r\n\nUpon completing each trial, whether by defeating waves of mobs or successfully activating the beams, the hero receives Wish Spheres-artifacts of magical power filled with etheric energy. These Spheres carry the essence of the dungeon's element and can be used at the \u00a7lAltar of Fate\u00a7r, located at the entrance of each dungeon.\n{ITEMS3}\nThe \u00a7lAltar of Fate\u00a7r is a sacred place where the threads of ether intertwine, weaving various magical items. A player can use 1 or 10 Wish Spheres at a time.\n\nWhen the Spheres are placed on the Altar, its magical power channels into the creation of items, enchanted books, rare artifacts, resource materials, and new spells.\n{ITEMS4}\n");
    }
}

