/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class StructureHandler {
    private static final Map<ResourceLocation, Map<Block, List<BlockPos>>> CACHE = new HashMap<ResourceLocation, Map<Block, List<BlockPos>>>();
    private static final Map<ResourceLocation, List<StructureTemplate.StructureBlockInfo>> BLOCK_INFO_CACHE = new HashMap<ResourceLocation, List<StructureTemplate.StructureBlockInfo>>();
    private static final Queue<PlacementTask> queue = new ConcurrentLinkedQueue<PlacementTask>();

    public static void schedulePlacement(ServerLevel level, BlockPos pos, ResourceLocation location, Rotation rotation, Block block) {
        Optional<BlockPos> optional = StructureHandler.getAnchor(level, location, block);
        if (optional.isEmpty()) {
            return;
        }
        List<StructureTemplate.StructureBlockInfo> blocks = StructureHandler.getBlockInfo(level, location);
        if (blocks.isEmpty()) {
            return;
        }
        BlockPos result = pos.m_121996_((Vec3i)optional.get().m_7954_(rotation));
        queue.add(new PlacementTask(level, result, rotation, blocks));
    }

    public static void preloadStructure(ServerLevel level, ResourceLocation location, Block block) {
        StructureHandler.getAnchor(level, location, block);
        StructureHandler.getBlockInfo(level, location);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || queue.isEmpty()) {
            return;
        }
        PlacementTask task = queue.peek();
        if (task != null) {
            task.placeBlocks(4000);
            if (task.isFinished()) {
                queue.poll();
            }
        }
    }

    private static Optional<BlockPos> getAnchor(ServerLevel level, ResourceLocation location, Block block) {
        List poses = CACHE.computeIfAbsent(location, k -> new HashMap()).computeIfAbsent(block, k -> StructureHandler.findAnchorsInTemplate(level, location, k));
        if (poses.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(poses.size() == 1 ? (BlockPos)poses.get(0) : (BlockPos)poses.get(level.m_213780_().m_188503_(poses.size())));
    }

    private static List<StructureTemplate.StructureBlockInfo> getBlockInfo(ServerLevel level, ResourceLocation location) {
        return BLOCK_INFO_CACHE.computeIfAbsent(location, k -> {
            Optional templateOpt = level.m_215082_().m_230407_(k);
            return templateOpt.map(template -> StructureHandler.getAllBlocksFromTemplate(template, level)).orElse(Collections.emptyList());
        });
    }

    private static List<BlockPos> findAnchorsInTemplate(ServerLevel level, ResourceLocation location, Block block) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        List<StructureTemplate.StructureBlockInfo> allBlocks = StructureHandler.getBlockInfo(level, location);
        for (StructureTemplate.StructureBlockInfo info : allBlocks) {
            if (!info.f_74676_().m_60713_(block)) continue;
            found.add(info.f_74675_());
        }
        return found;
    }

    private static List<StructureTemplate.StructureBlockInfo> getAllBlocksFromTemplate(StructureTemplate template, ServerLevel level) {
        ArrayList<StructureTemplate.StructureBlockInfo> allBlocks = new ArrayList<StructureTemplate.StructureBlockInfo>();
        CompoundTag nbt = template.m_74618_(new CompoundTag());
        ListTag paletteNBT = nbt.m_128437_("palette", 10);
        ListTag blocksNBT = nbt.m_128437_("blocks", 10);
        for (int i = 0; i < blocksNBT.size(); ++i) {
            CompoundTag blockData = blocksNBT.m_128728_(i);
            int stateIndex = blockData.m_128451_("state");
            CompoundTag stateData = paletteNBT.m_128728_(stateIndex);
            BlockState state = NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)stateData);
            ListTag posNBT = blockData.m_128437_("pos", 3);
            BlockPos pos = new BlockPos(posNBT.m_128763_(0), posNBT.m_128763_(1), posNBT.m_128763_(2));
            CompoundTag blockNbt = blockData.m_128441_("nbt") ? blockData.m_128469_("nbt") : null;
            allBlocks.add(new StructureTemplate.StructureBlockInfo(pos, state, blockNbt));
        }
        return allBlocks;
    }

    private static class PlacementTask {
        private final ServerLevel level;
        private final BlockPos origin;
        private final Rotation rotation;
        private final List<StructureTemplate.StructureBlockInfo> blockInfoList;
        private int currentIndex = 0;

        public PlacementTask(ServerLevel level, BlockPos origin, Rotation rotation, List<StructureTemplate.StructureBlockInfo> allBlocks) {
            this.level = level;
            this.origin = origin;
            this.rotation = rotation;
            ArrayList<StructureTemplate.StructureBlockInfo> list = new ArrayList<StructureTemplate.StructureBlockInfo>(allBlocks);
            list.sort(Comparator.comparing(info -> info.f_74676_().m_60713_(Blocks.f_50016_)));
            this.blockInfoList = list;
        }

        public void placeBlocks(int count) {
            int placed = 0;
            while (placed < count && !this.isFinished()) {
                StructureTemplate.StructureBlockInfo info = this.blockInfoList.get(this.currentIndex);
                BlockPos rotated = info.f_74675_().m_7954_(this.rotation);
                BlockPos targetPos = this.origin.m_121955_((Vec3i)rotated);
                BlockState newState = info.f_74676_().m_60717_(this.rotation);
                BlockState targetState = this.level.m_8055_(targetPos);
                if (!newState.m_60713_(Blocks.f_50016_) && targetState == newState) {
                    ++this.currentIndex;
                    continue;
                }
                if (newState.m_60713_(Blocks.f_50678_)) {
                    ++this.currentIndex;
                    continue;
                }
                if (newState.m_60713_(Blocks.f_50454_)) {
                    ++this.currentIndex;
                    continue;
                }
                this.level.m_7731_(targetPos, newState, 18);
                ++this.currentIndex;
                ++placed;
            }
        }

        public boolean isFinished() {
            return this.currentIndex >= this.blockInfoList.size();
        }

        public ServerLevel getLevel() {
            return this.level;
        }

        public BlockPos getOrigin() {
            return this.origin;
        }

        public Rotation getRotation() {
            return this.rotation;
        }

        public List<StructureTemplate.StructureBlockInfo> getBlockInfoList() {
            return this.blockInfoList;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlacementTask)) {
                return false;
            }
            PlacementTask other = (PlacementTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCurrentIndex() != other.getCurrentIndex()) {
                return false;
            }
            ServerLevel this$level = this.getLevel();
            ServerLevel other$level = other.getLevel();
            if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
                return false;
            }
            BlockPos this$origin = this.getOrigin();
            BlockPos other$origin = other.getOrigin();
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            Rotation this$rotation = this.getRotation();
            Rotation other$rotation = other.getRotation();
            if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
                return false;
            }
            List<StructureTemplate.StructureBlockInfo> this$blockInfoList = this.getBlockInfoList();
            List<StructureTemplate.StructureBlockInfo> other$blockInfoList = other.getBlockInfoList();
            return !(this$blockInfoList == null ? other$blockInfoList != null : !((Object)this$blockInfoList).equals(other$blockInfoList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlacementTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCurrentIndex();
            ServerLevel $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : $level.hashCode());
            BlockPos $origin = this.getOrigin();
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            Rotation $rotation = this.getRotation();
            result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
            List<StructureTemplate.StructureBlockInfo> $blockInfoList = this.getBlockInfoList();
            result = result * 59 + ($blockInfoList == null ? 43 : ((Object)$blockInfoList).hashCode());
            return result;
        }

        public String toString() {
            return "StructureHandler.PlacementTask(level=" + String.valueOf(this.getLevel()) + ", origin=" + String.valueOf(this.getOrigin()) + ", rotation=" + String.valueOf(this.getRotation()) + ", blockInfoList=" + String.valueOf(this.getBlockInfoList()) + ", currentIndex=" + this.getCurrentIndex() + ")";
        }
    }
}

