/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.handlers;

import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.handlers.AchievementHandler;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.PacketCheckDungeon;
import it.mralxart.etheria.network.packets.PacketDungeonResponse;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.registry.SoundsRegistry;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SoundsHandler {
    private static SoundInstance currentSound;
    public static ResourceLocation resourceLocation;
    public static boolean isActive;

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (currentSound == null) {
            return;
        }
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (!soundManager.m_120403_(currentSound)) {
            ResourceLocation location = new ResourceLocation("etheria", "pyro");
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.m_91403_() != null) {
                Networking.sendToServer(new PacketCheckDungeon(location));
            }
        }
    }

    public static void setSound(SoundInstance sound) {
        currentSound = sound;
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    private static void playSound(ResourceLocation location) {
        if (currentSound != null && Minecraft.m_91087_().m_91106_().m_120403_(currentSound)) {
            return;
        }
        SoundEvent event = SoundEvents.f_271165_;
        Random random = new Random();
        if (location.m_135815_().equals("pyro")) {
            i = random.nextInt(1, 3);
            switch (i) {
                case 1: {
                    event = (SoundEvent)SoundsRegistry.PYRO_1.get();
                    break;
                }
                case 2: {
                    event = (SoundEvent)SoundsRegistry.PYRO_2.get();
                    break;
                }
                case 3: {
                    event = (SoundEvent)SoundsRegistry.PYRO_3.get();
                }
            }
        } else if (location.m_135815_().equals("cryo")) {
            i = random.nextInt(1, 3);
            switch (i) {
                case 1: {
                    event = (SoundEvent)SoundsRegistry.CRYO_1.get();
                    break;
                }
                case 2: {
                    event = (SoundEvent)SoundsRegistry.CRYO_2.get();
                    break;
                }
                case 3: {
                    event = (SoundEvent)SoundsRegistry.CRYO_2.get();
                }
            }
        } else if (location.m_135815_().equals("aero")) {
            i = random.nextInt(1, 4);
            switch (i) {
                case 1: {
                    event = (SoundEvent)SoundsRegistry.AERO_1.get();
                    break;
                }
                case 2: {
                    event = (SoundEvent)SoundsRegistry.AERO_2.get();
                    break;
                }
                case 3: {
                    event = (SoundEvent)SoundsRegistry.AERO_3.get();
                    break;
                }
                case 4: {
                    event = (SoundEvent)SoundsRegistry.AERO_4.get();
                }
            }
        } else if (location.m_135815_().equals("aerolith")) {
            boolean flag = random.nextBoolean();
            event = flag ? (SoundEvent)SoundsRegistry.AEROLITH_1.get() : (SoundEvent)SoundsRegistry.AEROLITH_2.get();
        } else if (location.m_135815_().equals("aerolith_bh")) {
            event = (SoundEvent)SoundsRegistry.BLACK_HOLE.get();
        }
        resourceLocation = location;
        SimpleSoundInstance sound = SimpleSoundInstance.m_119755_((SoundEvent)event, (float)1.0f, (float)0.3f);
        SoundsHandler.setSound((SoundInstance)sound);
    }

    private static void stop() {
        if (currentSound == null || !Minecraft.m_91087_().m_91106_().m_120403_(currentSound)) {
            return;
        }
        float initialVolume = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER);
        new Thread(() -> {
            try {
                for (float volume = initialVolume; volume > 0.0f; volume -= 0.01f) {
                    Minecraft.m_91087_().m_91106_().m_120358_(SoundSource.MASTER, volume);
                    Thread.sleep(10L);
                }
                Minecraft.m_91087_().m_91106_().m_120399_(currentSound);
                Minecraft.m_91087_().m_91106_().m_120358_(SoundSource.MASTER, initialVolume);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    public static void updateIsActive(ResourceLocation location, boolean active) {
        isActive = active;
        if (active) {
            SoundsHandler.playSound(location);
        } else if (resourceLocation.equals((Object)location)) {
            SoundsHandler.stop();
        }
    }

    @Mod.EventBusSubscriber
    public static class ServerEvents {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (!(event.phase == TickEvent.Phase.END && event.player.m_9236_().f_46443_ || event.player.f_19797_ % 20 != 0)) {
                Player sender = event.player;
                Level level = sender.m_9236_();
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                AABB box = sender.m_20191_().m_82400_(25.0);
                List aeroliths = serverLevel.m_6249_((Entity)null, box, entity -> entity.m_6095_() == EntityRegistry.AEROLITH.get());
                if (!aeroliths.isEmpty()) {
                    Aerolith aerolith;
                    Object e;
                    ResourceLocation location = new ResourceLocation("etheria", "aerolith");
                    if (sender instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)sender;
                        AchievementHandler.grantAdvancement(serverPlayer, "dungeons");
                    }
                    if ((e = aeroliths.get(0)) instanceof Aerolith && (aerolith = (Aerolith)e).getAction().equalsIgnoreCase("black_hole")) {
                        Networking.sendToClient((ServerPlayer)sender, new PacketDungeonResponse(location, false));
                        Networking.sendToClient((ServerPlayer)sender, new PacketDungeonResponse(new ResourceLocation("etheria", "aerolith_bh"), true));
                        return;
                    }
                    Networking.sendToClient((ServerPlayer)sender, new PacketDungeonResponse(location, true));
                    return;
                }
                ResourceLocation location = new ResourceLocation("etheria", "aerolith");
                Networking.sendToClient((ServerPlayer)sender, new PacketDungeonResponse(location, false));
                Registry structureRegistry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
                List<ResourceLocation> structures = List.of(new ResourceLocation("etheria", "pyro"), new ResourceLocation("etheria", "cryo"), new ResourceLocation("etheria", "aero"));
                for (ResourceLocation resourceLocation : structures) {
                    Optional structureHolder = structureRegistry.m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)resourceLocation));
                    if (structureHolder.isEmpty()) continue;
                    StructureManager structureManager = serverLevel.m_215010_();
                    Optional<StructureStart> structureStart = Optional.of(structureManager.m_220494_(sender.m_20183_(), (Structure)((Holder.Reference)structureHolder.get()).m_203334_()));
                    StructureStart start = structureStart.get();
                    boolean isInside = false;
                    try {
                        BoundingBox originalBox = start.m_73601_();
                        BoundingBox adjustedBox = new BoundingBox(originalBox.m_162395_(), originalBox.m_162396_() - 5, originalBox.m_162398_(), originalBox.m_162399_(), originalBox.m_162400_() - 5, originalBox.m_162401_());
                        isInside = adjustedBox.m_71051_((Vec3i)sender.m_20183_());
                    }
                    catch (IllegalStateException originalBox) {
                        // empty catch block
                    }
                    if (sender instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)sender;
                        if (isInside) {
                            AchievementHandler.grantAdvancement(serverPlayer, "dungeons");
                        }
                    }
                    Networking.sendToClient((ServerPlayer)sender, new PacketDungeonResponse(resourceLocation, isInside));
                }
            }
        }
    }
}

