/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.handlers;

import it.mralxart.etheria.blocks.base.IFreezingBlock;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.tiles.IceSourceTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="etheria", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FreezeHandler {
    private static final int FREEZE_THRESHOLD = 100;
    private static final int MAX_FREEZE_TIME = 140;
    private static final int CHECK_INTERVAL = 10;
    private int tickCount = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int currentFreezeTime;
        boolean nearFreezingSource;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_7500_() || player.m_5833_()) {
            if (CapabilityRegistry.getCap(player).getFreezingTime() > 0) {
                CapabilityRegistry.getCap(player).setFreezingTime(0);
                player.m_146917_(0);
                this.tickCount = 0;
                SyncCapabilityManager.sync(player);
            }
            return;
        }
        if (player.f_19797_ % 10 == 0) {
            nearFreezingSource = this.isNearFreezingSource(player);
            CapabilityRegistry.getCap(player).setNearSource(nearFreezingSource);
        } else {
            nearFreezingSource = CapabilityRegistry.getCap(player).isNearSource();
        }
        int oldFreezeTime = CapabilityRegistry.getCap(player).getFreezingTime();
        if (nearFreezingSource) {
            currentFreezeTime = Math.min(140, oldFreezeTime + 1);
            ++this.tickCount;
        } else {
            currentFreezeTime = Math.max(0, oldFreezeTime - 1);
        }
        if (currentFreezeTime == oldFreezeTime) {
            return;
        }
        if (currentFreezeTime >= 100) {
            if (player.f_19797_ % 20 == 0) {
                player.m_6469_(player.m_269291_().m_269109_(), (float)this.tickCount / 400.0f);
            }
        } else {
            this.tickCount = 0;
        }
        player.m_146917_(currentFreezeTime);
        CapabilityRegistry.getCap(player).setFreezingTime(currentFreezeTime);
        SyncCapabilityManager.sync(player);
    }

    private boolean isNearFreezingSource(Player player) {
        Level world = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        int chunkRadius = 1;
        for (int chunkX = (playerPos.m_123341_() >> 4) - chunkRadius; chunkX <= (playerPos.m_123341_() >> 4) + chunkRadius; ++chunkX) {
            for (int chunkZ = (playerPos.m_123343_() >> 4) - chunkRadius; chunkZ <= (playerPos.m_123343_() >> 4) + chunkRadius; ++chunkZ) {
                LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
                for (BlockEntity be : chunk.m_62954_().values()) {
                    IceSourceTile iceSource;
                    if (!(be instanceof IFreezingBlock)) continue;
                    IFreezingBlock freezingBlock = (IFreezingBlock)be;
                    if (be instanceof IceSourceTile && (iceSource = (IceSourceTile)be).getThawing() > 0) continue;
                    double radius = freezingBlock.getFreezingRadius();
                    if (!(be.m_58899_().m_123331_((Vec3i)playerPos) <= radius * radius)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

