/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.handlers;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import it.mralxart.etheria.config.RitualsConfig;
import it.mralxart.etheria.config.SkillsConfig;
import it.mralxart.etheria.config.TrialsConfig;
import it.mralxart.etheria.config.base.BaseConfig;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.S2CPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ConfigCommandHandler {
    private static final Map<String, Supplier<BaseConfig<?>>> CONFIG_REGISTRY = new HashMap();
    private static final Map<String, String> MOD_NAMES = new HashMap<String, String>();
    private static final SuggestionProvider<CommandSourceStack> CONFIG_SUGGESTIONS = (context, builder) -> {
        for (String configKey : CONFIG_REGISTRY.keySet()) {
            builder.suggest(configKey);
        }
        return builder.buildFuture();
    };

    public static void registerConfig(String modId, String configName, Supplier<BaseConfig<?>> constructor) {
        String key = modId + "_" + configName;
        CONFIG_REGISTRY.put(key, constructor);
        MOD_NAMES.put(modId, modId);
    }

    public static String getModName(String modId) {
        return MOD_NAMES.getOrDefault(modId, modId);
    }

    public static LiteralCommandNode<CommandSourceStack> createConfigCommand() {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"config");
        builder.then(Commands.m_82127_((String)"mod").then(Commands.m_82129_((String)"mod_id", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionsBuilder) -> {
            for (String modId : MOD_NAMES.keySet()) {
                suggestionsBuilder.suggest(modId);
            }
            return suggestionsBuilder.buildFuture();
        }).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"config", (ArgumentType)StringArgumentType.string()).suggests(CONFIG_SUGGESTIONS).then(Commands.m_82127_((String)"construct").executes(context -> ConfigCommandHandler.handleConfigCommand((CommandContext<CommandSourceStack>)context, false, false)))).then(Commands.m_82127_((String)"apply").executes(context -> ConfigCommandHandler.handleConfigCommand((CommandContext<CommandSourceStack>)context, true, false)))).then(Commands.m_82127_((String)"reset").executes(context -> ConfigCommandHandler.handleConfigCommand((CommandContext<CommandSourceStack>)context, false, true))))));
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"config", (ArgumentType)StringArgumentType.string()).suggests(CONFIG_SUGGESTIONS).then(Commands.m_82127_((String)"construct").executes(context -> ConfigCommandHandler.handleConfigCommand((CommandContext<CommandSourceStack>)context, false, false)))).then(Commands.m_82127_((String)"apply").executes(context -> ConfigCommandHandler.handleConfigCommand((CommandContext<CommandSourceStack>)context, true, false)))).then(Commands.m_82127_((String)"reset").executes(context -> ConfigCommandHandler.handleConfigCommand((CommandContext<CommandSourceStack>)context, false, true))));
        return builder.build();
    }

    private static int handleConfigCommand(CommandContext<CommandSourceStack> context, boolean apply, boolean reset) {
        String configKey = (String)context.getArgument("config", String.class);
        Supplier<BaseConfig<?>> constructor = CONFIG_REGISTRY.get(configKey);
        BaseConfig<?> config = constructor.get();
        if (apply) {
            config.save();
            String json = config.getJson();
            config.loadFromJson(json);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("configKey", configKey);
                tag.m_128359_("json", json);
                Networking.sendToClient(player, new S2CPacket(tag, 111));
            }
        } else {
            config.constructAndSave(reset);
        }
        return 1;
    }

    public static void handeSyncAllConfigs(ServerPlayer player) {
        for (String configKey : CONFIG_REGISTRY.keySet()) {
            ConfigCommandHandler.handeSyncConfig(player, configKey);
        }
    }

    public static void handeSyncConfig(ServerPlayer player, String configKey) {
        Supplier<BaseConfig<?>> constructor = CONFIG_REGISTRY.get(configKey);
        BaseConfig<?> config = constructor.get();
        config.save();
        String json = config.getJson();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("configKey", configKey);
        tag.m_128359_("json", json);
        Networking.sendToClient(player, new S2CPacket(tag, 111));
    }

    public static void loadConfig(String configKey, String json) {
        Supplier<BaseConfig<?>> constructor = CONFIG_REGISTRY.get(configKey);
        BaseConfig<?> config = constructor.get();
        config.loadFromJson(json);
    }

    static {
        ConfigCommandHandler.registerConfig("etheria", "skills", SkillsConfig::new);
        ConfigCommandHandler.registerConfig("etheria", "rituals", RitualsConfig::new);
        ConfigCommandHandler.registerConfig("etheria", "trials", TrialsConfig::new);
    }
}

