/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.events;

import it.mralxart.etheria.artifacts.ArtifactStatCalculator;
import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.config.EtheriaConfig;
import it.mralxart.etheria.entities.ShockwaveEntity;
import it.mralxart.etheria.epicora.animations.base.IAnimated;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.handlers.AchievementHandler;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.spells.entities.ScreenShakeEntity;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.EntityVelocityPacket;
import it.mralxart.etheria.network.packets.S2CPacket;
import it.mralxart.etheria.registry.BlockRegistry;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.EntityRegistry;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CommonSetup {

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="etheria")
    public static class GameEvents {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="etheria")
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onTrackingEntity(PlayerEvent.StartTracking event) {
            Entity entity = event.getTarget();
            if (entity instanceof IAnimated) {
                IAnimated iAnimated = (IAnimated)entity;
                AnimationController controller = iAnimated.getController();
                CompoundTag tag = controller.serializeNBT();
                Networking.sendTrackingEntity(event.getTarget(), new S2CPacket(tag, 112));
            }
        }

        @SubscribeEvent
        public static void onJoin(PlayerEvent.PlayerLoggedInEvent event) {
            if (((Boolean)EtheriaConfig.COMMON.giveBookOnStart.get()).booleanValue()) {
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    AchievementHandler.grantAdvancement(serverPlayer, "magemicon");
                }
                if (!CapabilityRegistry.getCap(player).isFirst()) {
                    CapabilityRegistry.getCap(player).setFirst(true);
                    SyncCapabilityManager.sync(player);
                    player.m_36356_(((Item)BlockRegistry.MAGEMICON.get()).m_7968_());
                }
            }
        }

        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent event) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && (player = (Player)livingEntity).m_19880_().contains("etheria:sky_crashing")) {
                Level level = player.m_9236_();
                event.setDamageMultiplier(0.0f);
                event.setCanceled(true);
                float fallDist = event.getDistance();
                float baseDamage = SpellsUtils.getSpellValue(player, "sky_crash", "damage");
                float damage = baseDamage + fallDist * 1.5f;
                float radius = SpellsUtils.getSpellValue(player, "sky_crash", "radius") + fallDist * 0.1f;
                player.m_20334_(0.0, 0.0, 0.0);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.f_9742_.m_129512_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("item.elytra.flying"), SoundSource.PLAYERS));
                    Networking.sendToClient(serverPlayer, new EntityVelocityPacket(0.0, 0.0, 0.0));
                }
                ShockwaveEntity shockwave = new ShockwaveEntity(player.m_9236_(), player.m_20182_(), (LivingEntity)player, radius, 8.0f);
                shockwave.setDamage(damage);
                shockwave.setContext(ArtifactStatCalculator.createContext((LivingEntity)player, damage, Element.AERO));
                level.m_7967_((Entity)shockwave);
                ScreenShakeEntity.summonShake(level, player.m_20182_(), 8.0f, 0.2f, 10, 20);
                if (!level.f_46443_) {
                    List<ParticleUtils.CrackPoint> cracks = ParticleUtils.generateSmartFractureSystem(player.m_20182_(), radius, 20, 3.0f, 2);
                    ParticleUtils.renderCrackSystem(level, cracks, new Color(123, 126, 100), 100, 70);
                }
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.5f);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.8f, 0.5f);
                player.m_19880_().remove("etheria:sky_crashing");
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="etheria")
    public static class ModEvents {
        @SubscribeEvent
        public static void onAttributeCreation(EntityAttributeCreationEvent event) {
            event.put((EntityType)EntityRegistry.AEROLITH.get(), Aerolith.createAttributes());
        }
    }
}

