/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.geometry.data;

import it.mralxart.etheria.utils.NbtUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.joml.Vector3f;

public class TexVertex
implements INBTSerializable<CompoundTag> {
    private Vector3f pos;
    private float texU;
    private float texV;

    public TexVertex(float x, float y, float z) {
        this.pos = new Vector3f(x, y, z);
        this.texU = 0.0f;
        this.texV = 0.0f;
    }

    public TexVertex setUv(float texU, float texV) {
        return new TexVertex(this.pos, texU, texV);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("pos", (Tag)NbtUtils.writeVector3f(this.pos));
        tag.m_128350_("texU", this.texU);
        tag.m_128350_("texV", this.texV);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.pos = NbtUtils.readVector3f(tag.m_128469_("pos"));
        this.texU = tag.m_128457_("texU");
        this.texV = tag.m_128457_("texV");
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public float getTexU() {
        return this.texU;
    }

    public float getTexV() {
        return this.texV;
    }

    public void setPos(Vector3f pos) {
        this.pos = pos;
    }

    public void setTexU(float texU) {
        this.texU = texU;
    }

    public void setTexV(float texV) {
        this.texV = texV;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TexVertex)) {
            return false;
        }
        TexVertex other = (TexVertex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTexU(), other.getTexU()) != 0) {
            return false;
        }
        if (Float.compare(this.getTexV(), other.getTexV()) != 0) {
            return false;
        }
        Vector3f this$pos = this.getPos();
        Vector3f other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TexVertex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTexU());
        result = result * 59 + Float.floatToIntBits(this.getTexV());
        Vector3f $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result;
    }

    public String toString() {
        return "TexVertex(pos=" + String.valueOf(this.getPos()) + ", texU=" + this.getTexU() + ", texV=" + this.getTexV() + ")";
    }

    public TexVertex(Vector3f pos, float texU, float texV) {
        this.pos = pos;
        this.texU = texU;
        this.texV = texV;
    }

    public TexVertex() {
    }
}

