/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.geometry.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.mralxart.etheria.epicora.geometry.components.GeometryQuad;
import it.mralxart.etheria.epicora.geometry.data.GeoUVs;
import it.mralxart.etheria.epicora.geometry.data.GeometryUV;
import it.mralxart.etheria.epicora.geometry.data.TexVertex;
import it.mralxart.etheria.utils.NbtUtils;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class GeometryCube
implements INBTSerializable<CompoundTag> {
    private Vector3f origin;
    private Vector3f size;
    private Vector3f pivot;
    private Vector3f rotation;
    private GeoUVs uvs;
    private int texWidth;
    private int texHeight;
    private double inflate;
    private GeometryQuad[] quads;

    public GeometryCube(Vector3f origin, Vector3f size, Vector3f pivot, Vector3f rotation, double inflate, int textureWidth, int textureHeight) {
        this.origin = origin;
        this.size = size;
        this.pivot = pivot;
        this.rotation = rotation;
        this.inflate = inflate;
        this.uvs = new GeoUVs();
        this.texWidth = textureWidth;
        this.texHeight = textureHeight;
    }

    public void setupQuads(TexVertex[] texVertices) {
        GeometryQuad[] geometryQuads = new GeometryQuad[]{this.constructQuad(texVertices, Direction.NORTH), this.constructQuad(texVertices, Direction.SOUTH), this.constructQuad(texVertices, Direction.WEST), this.constructQuad(texVertices, Direction.EAST), this.constructQuad(texVertices, Direction.UP), this.constructQuad(texVertices, Direction.DOWN)};
        this.quads = geometryQuads;
    }

    public TexVertex[] transformVertices(TexVertex[] texVertices, Direction direction, boolean boxUv) {
        TexVertex[] texVertexArray;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WEST: {
                TexVertex[] texVertexArray2 = new TexVertex[4];
                texVertexArray2[0] = texVertices[3];
                texVertexArray2[1] = texVertices[2];
                texVertexArray2[2] = texVertices[0];
                texVertexArray = texVertexArray2;
                texVertexArray2[3] = texVertices[1];
                break;
            }
            case EAST: {
                TexVertex[] texVertexArray3 = new TexVertex[4];
                texVertexArray3[0] = texVertices[4];
                texVertexArray3[1] = texVertices[5];
                texVertexArray3[2] = texVertices[7];
                texVertexArray = texVertexArray3;
                texVertexArray3[3] = texVertices[6];
                break;
            }
            case NORTH: {
                TexVertex[] texVertexArray4 = new TexVertex[4];
                texVertexArray4[0] = texVertices[2];
                texVertexArray4[1] = texVertices[4];
                texVertexArray4[2] = texVertices[6];
                texVertexArray = texVertexArray4;
                texVertexArray4[3] = texVertices[0];
                break;
            }
            case SOUTH: {
                TexVertex[] texVertexArray5 = new TexVertex[4];
                texVertexArray5[0] = texVertices[5];
                texVertexArray5[1] = texVertices[3];
                texVertexArray5[2] = texVertices[1];
                texVertexArray = texVertexArray5;
                texVertexArray5[3] = texVertices[7];
                break;
            }
            case UP: {
                if (!boxUv) {
                    TexVertex[] texVertexArray6 = new TexVertex[4];
                    texVertexArray6[0] = texVertices[0];
                    texVertexArray6[1] = texVertices[6];
                    texVertexArray6[2] = texVertices[7];
                    texVertexArray = texVertexArray6;
                    texVertexArray6[3] = texVertices[1];
                    break;
                }
                TexVertex[] texVertexArray7 = new TexVertex[4];
                texVertexArray7[0] = texVertices[3];
                texVertexArray7[1] = texVertices[5];
                texVertexArray7[2] = texVertices[4];
                texVertexArray = texVertexArray7;
                texVertexArray7[3] = texVertices[2];
                break;
            }
            case DOWN: {
                if (!boxUv) {
                    TexVertex[] texVertexArray8 = new TexVertex[4];
                    texVertexArray8[0] = texVertices[3];
                    texVertexArray8[1] = texVertices[5];
                    texVertexArray8[2] = texVertices[4];
                    texVertexArray = texVertexArray8;
                    texVertexArray8[3] = texVertices[2];
                    break;
                }
                TexVertex[] texVertexArray9 = new TexVertex[4];
                texVertexArray9[0] = texVertices[0];
                texVertexArray9[1] = texVertices[6];
                texVertexArray9[2] = texVertices[7];
                texVertexArray = texVertexArray9;
                texVertexArray9[3] = texVertices[1];
            }
        }
        return texVertexArray;
    }

    public GeometryQuad constructQuad(TexVertex[] texVertices, Direction direction) {
        float[][] fArrayArray;
        if (!this.uvs.isBoxUv()) {
            String directionName = direction.name().toLowerCase(Locale.ROOT);
            GeometryUV uvDetails = this.uvs.getUvMap().get(directionName);
            if (uvDetails == null) {
                return null;
            }
            TexVertex[] modifiedVertices = this.transformVertices(texVertices, direction, !this.uvs.isBoxUv());
            return this.createQuad(modifiedVertices, uvDetails, direction);
        }
        float[] baseUv = this.uvs.getUvMap().get("default").getUv();
        Vector3f calculatedUvSize = new Vector3f((float)Math.floor(this.size.x), (float)Math.floor(this.size.y), (float)Math.floor(this.size.z));
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case WEST: {
                float[][] fArrayArray2 = new float[2][];
                fArrayArray2[0] = new float[]{baseUv[0] + calculatedUvSize.z + calculatedUvSize.x, baseUv[1] + calculatedUvSize.z};
                fArrayArray = fArrayArray2;
                fArrayArray2[1] = new float[]{calculatedUvSize.z, calculatedUvSize.y};
                break;
            }
            case EAST: {
                float[][] fArrayArray3 = new float[2][];
                fArrayArray3[0] = new float[]{baseUv[0], baseUv[1] + calculatedUvSize.z};
                fArrayArray = fArrayArray3;
                fArrayArray3[1] = new float[]{calculatedUvSize.z, calculatedUvSize.y};
                break;
            }
            case NORTH: {
                float[][] fArrayArray4 = new float[2][];
                fArrayArray4[0] = new float[]{baseUv[0] + calculatedUvSize.z, baseUv[1] + calculatedUvSize.z};
                fArrayArray = fArrayArray4;
                fArrayArray4[1] = new float[]{calculatedUvSize.x, calculatedUvSize.y};
                break;
            }
            case SOUTH: {
                float[][] fArrayArray5 = new float[2][];
                fArrayArray5[0] = new float[]{baseUv[0] + calculatedUvSize.z + calculatedUvSize.x + calculatedUvSize.z, baseUv[1] + calculatedUvSize.z};
                fArrayArray = fArrayArray5;
                fArrayArray5[1] = new float[]{calculatedUvSize.x, calculatedUvSize.y};
                break;
            }
            case UP: {
                float[][] fArrayArray6 = new float[2][];
                fArrayArray6[0] = new float[]{baseUv[0] + calculatedUvSize.z, baseUv[1]};
                fArrayArray = fArrayArray6;
                fArrayArray6[1] = new float[]{calculatedUvSize.x, calculatedUvSize.z};
                break;
            }
            case DOWN: {
                float[][] fArrayArray7 = new float[2][];
                fArrayArray7[0] = new float[]{baseUv[0] + calculatedUvSize.z + calculatedUvSize.x, baseUv[1] + calculatedUvSize.z};
                fArrayArray = fArrayArray7;
                fArrayArray7[1] = new float[]{calculatedUvSize.x, -calculatedUvSize.z};
            }
        }
        float[][] uvCoords = fArrayArray;
        TexVertex[] modifiedVertices = this.transformVertices(texVertices, direction, this.uvs.isBoxUv());
        GeometryUV geometryUV = new GeometryUV("default", uvCoords[0], uvCoords[1]);
        return this.createQuad(modifiedVertices, geometryUV, direction);
    }

    public GeometryQuad createQuad(TexVertex[] texVertices, GeometryUV geometryUV, Direction direction) {
        float[] uvStart = geometryUV.getUv();
        float startU = uvStart[0];
        float startV = uvStart[1];
        float[] uvDimensions = geometryUV.getUvSize();
        float endU = (startU + uvDimensions[0]) / (float)this.texWidth;
        float endV = (startV + uvDimensions[1]) / (float)this.texHeight;
        Vector3f faceNormal = direction.m_253071_();
        float tempU = endU;
        endU = startU /= (float)this.texWidth;
        startU = tempU;
        texVertices[0] = texVertices[0].setUv(startU, startV /= (float)this.texHeight);
        texVertices[1] = texVertices[1].setUv(endU, startV);
        texVertices[2] = texVertices[2].setUv(endU, endV);
        texVertices[3] = texVertices[3].setUv(startU, endV);
        return new GeometryQuad(texVertices, direction, faceNormal);
    }

    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_252880_(this.pivot.x() / 16.0f, this.pivot.y() / 16.0f, this.pivot.z() / 16.0f);
        poseStack.m_252781_(new Quaternionf().rotateZYX(this.rotation.z(), this.rotation.y(), this.rotation.x()));
        poseStack.m_252880_(-this.pivot.x() / 16.0f, -this.pivot.y() / 16.0f, -this.pivot.z() / 16.0f);
        Matrix4f positionMatrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        for (GeometryQuad quad : this.quads) {
            if (quad == null) continue;
            Vector3f normal = normalMatrix.transform(new Vector3f((Vector3fc)quad.getNormal()));
            for (TexVertex vertex : quad.getTexVertices()) {
                Vector3f position = vertex.getPos();
                Vector4f vector4f = positionMatrix.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
                vertexConsumer.m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), red / 255.0f, green / 255.0f, blue / 255.0f, alpha, vertex.getTexU(), vertex.getTexV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("origin", (Tag)NbtUtils.writeVector3f(this.origin));
        tag.m_128365_("size", (Tag)NbtUtils.writeVector3f(this.size));
        tag.m_128365_("pivot", (Tag)NbtUtils.writeVector3f(this.pivot));
        tag.m_128365_("rotation", (Tag)NbtUtils.writeVector3f(this.rotation));
        tag.m_128365_("uvs", (Tag)this.uvs.serializeNBT());
        tag.m_128405_("texWidth", this.texWidth);
        tag.m_128405_("texHeight", this.texHeight);
        tag.m_128347_("inflate", this.inflate);
        ListTag quadsTag = new ListTag();
        for (GeometryQuad quad : this.quads) {
            quadsTag.add((Object)quad.serializeNBT());
        }
        tag.m_128365_("quads", (Tag)quadsTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        GeoUVs geoUVs = new GeoUVs();
        geoUVs.deserializeNBT(tag.m_128469_("uvs"));
        this.origin = NbtUtils.readVector3f(tag.m_128469_("origin"));
        this.size = NbtUtils.readVector3f(tag.m_128469_("size"));
        this.pivot = NbtUtils.readVector3f(tag.m_128469_("pivot"));
        this.rotation = NbtUtils.readVector3f(tag.m_128469_("rotation"));
        this.uvs = geoUVs;
        this.texWidth = tag.m_128451_("texWidth");
        this.texHeight = tag.m_128451_("texHeight");
        this.inflate = tag.m_128459_("inflate");
        ListTag quadsTag = tag.m_128437_("quads", 10);
        this.quads = new GeometryQuad[quadsTag.size()];
        for (int i = 0; i < quadsTag.size(); ++i) {
            GeometryQuad quad = new GeometryQuad();
            quad.deserializeNBT((CompoundTag)quadsTag.get(i));
            this.quads[i] = quad;
        }
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public Vector3f getSize() {
        return this.size;
    }

    public Vector3f getPivot() {
        return this.pivot;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public GeoUVs getUvs() {
        return this.uvs;
    }

    public int getTexWidth() {
        return this.texWidth;
    }

    public int getTexHeight() {
        return this.texHeight;
    }

    public double getInflate() {
        return this.inflate;
    }

    public GeometryQuad[] getQuads() {
        return this.quads;
    }

    public void setOrigin(Vector3f origin) {
        this.origin = origin;
    }

    public void setSize(Vector3f size) {
        this.size = size;
    }

    public void setPivot(Vector3f pivot) {
        this.pivot = pivot;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setUvs(GeoUVs uvs) {
        this.uvs = uvs;
    }

    public void setTexWidth(int texWidth) {
        this.texWidth = texWidth;
    }

    public void setTexHeight(int texHeight) {
        this.texHeight = texHeight;
    }

    public void setInflate(double inflate) {
        this.inflate = inflate;
    }

    public void setQuads(GeometryQuad[] quads) {
        this.quads = quads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeometryCube)) {
            return false;
        }
        GeometryCube other = (GeometryCube)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTexWidth() != other.getTexWidth()) {
            return false;
        }
        if (this.getTexHeight() != other.getTexHeight()) {
            return false;
        }
        if (Double.compare(this.getInflate(), other.getInflate()) != 0) {
            return false;
        }
        Vector3f this$origin = this.getOrigin();
        Vector3f other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        Vector3f this$size = this.getSize();
        Vector3f other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        Vector3f this$pivot = this.getPivot();
        Vector3f other$pivot = other.getPivot();
        if (this$pivot == null ? other$pivot != null : !this$pivot.equals(other$pivot)) {
            return false;
        }
        Vector3f this$rotation = this.getRotation();
        Vector3f other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        GeoUVs this$uvs = this.getUvs();
        GeoUVs other$uvs = other.getUvs();
        if (this$uvs == null ? other$uvs != null : !((Object)this$uvs).equals(other$uvs)) {
            return false;
        }
        return Arrays.deepEquals(this.getQuads(), other.getQuads());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeometryCube;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTexWidth();
        result = result * 59 + this.getTexHeight();
        long $inflate = Double.doubleToLongBits(this.getInflate());
        result = result * 59 + (int)($inflate >>> 32 ^ $inflate);
        Vector3f $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        Vector3f $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        Vector3f $pivot = this.getPivot();
        result = result * 59 + ($pivot == null ? 43 : $pivot.hashCode());
        Vector3f $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        GeoUVs $uvs = this.getUvs();
        result = result * 59 + ($uvs == null ? 43 : ((Object)$uvs).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getQuads());
        return result;
    }

    public String toString() {
        return "GeometryCube(origin=" + String.valueOf(this.getOrigin()) + ", size=" + String.valueOf(this.getSize()) + ", pivot=" + String.valueOf(this.getPivot()) + ", rotation=" + String.valueOf(this.getRotation()) + ", uvs=" + String.valueOf(this.getUvs()) + ", texWidth=" + this.getTexWidth() + ", texHeight=" + this.getTexHeight() + ", inflate=" + this.getInflate() + ", quads=" + Arrays.deepToString(this.getQuads()) + ")";
    }

    public GeometryCube() {
    }
}

