/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.data;

import it.mralxart.etheria.epicora.data.Vec3Rot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class CameraPath
implements INBTSerializable<CompoundTag> {
    private final List<Vec3Rot> points;
    private double speed;
    private int type;
    private final List<Double> segmentLengths;
    private final double totalLength;

    public CameraPath(List<Vec3Rot> points, double speed, int type) {
        this.points = points;
        this.speed = speed;
        this.type = type;
        this.segmentLengths = new ArrayList<Double>();
        double total = 0.0;
        if (!points.isEmpty()) {
            for (int i = 0; i < points.size() - 1; ++i) {
                double length = points.get((int)i).position.m_82554_(points.get((int)(i + 1)).position);
                this.segmentLengths.add(length);
                total += length;
            }
        }
        this.totalLength = total;
    }

    public Vec3Rot getPositionAt(double progress) {
        if (this.points.isEmpty()) {
            return null;
        }
        if (this.points.size() == 1) {
            return this.points.get(0);
        }
        progress = Mth.m_14008_((double)progress, (double)0.0, (double)1.0);
        if (this.type == 0) {
            return this.getLinearPosition(progress);
        }
        if (this.type == 1) {
            return this.getCatmullRomPosition(progress);
        }
        return this.points.get(0);
    }

    private Vec3Rot getLinearPosition(double progress) {
        if (progress >= 1.0) {
            return this.points.get(this.points.size() - 1);
        }
        if (progress <= 0.0) {
            return this.points.get(0);
        }
        double targetDist = this.totalLength * progress;
        double currentDist = 0.0;
        for (int i = 0; i < this.segmentLengths.size(); ++i) {
            double segmentLength = this.segmentLengths.get(i);
            if (currentDist + segmentLength >= targetDist) {
                double progressInSegment = segmentLength > 0.0 ? (targetDist - currentDist) / segmentLength : 0.0;
                Vec3Rot start = this.points.get(i);
                Vec3Rot end = this.points.get(i + 1);
                Vec3 lerpedPos = start.position.m_165921_(end.position, progressInSegment);
                float lerpedPitch = (float)Mth.m_14139_((double)progressInSegment, (double)start.pitch, (double)end.pitch);
                float lerpedYaw = Mth.m_14189_((float)((float)progressInSegment), (float)start.yaw, (float)end.yaw);
                return new Vec3Rot(lerpedPos, lerpedPitch, lerpedYaw);
            }
            currentDist += segmentLength;
        }
        return this.points.get(this.points.size() - 1);
    }

    private Vec3Rot getCatmullRomPosition(double progress) {
        if (this.points.size() < 2) {
            return this.getLinearPosition(progress);
        }
        int numSegments = this.points.size() - 1;
        double segmentProgress = progress * (double)numSegments;
        int segmentIndex = (int)Math.min(segmentProgress, (double)(numSegments - 1));
        double t = segmentProgress - (double)segmentIndex;
        Vec3Rot p0 = this.points.get(Math.max(0, segmentIndex - 1));
        Vec3Rot p1 = this.points.get(segmentIndex);
        Vec3Rot p2 = this.points.get(Math.min(this.points.size() - 1, segmentIndex + 1));
        Vec3Rot p3 = this.points.get(Math.min(this.points.size() - 1, segmentIndex + 2));
        Vec3 position = CameraPath.catmullRomInterpolate(p0.position, p1.position, p2.position, p3.position, t);
        float yaw = CameraPath.catmullRomInterpolate(p0.yaw, p1.yaw, p2.yaw, p3.yaw, t);
        float pitch = CameraPath.catmullRomInterpolate(p0.pitch, p1.pitch, p2.pitch, p3.pitch, t);
        return new Vec3Rot(position, pitch, yaw);
    }

    public static Vec3 catmullRomInterpolate(Vec3 p0, Vec3 p1, Vec3 p2, Vec3 p3, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double x = 0.5 * (2.0 * p1.m_7096_() + (-p0.m_7096_() + p2.m_7096_()) * t + (2.0 * p0.m_7096_() - 5.0 * p1.m_7096_() + 4.0 * p2.m_7096_() - p3.m_7096_()) * t2 + (-p0.m_7096_() + 3.0 * p1.m_7096_() - 3.0 * p2.m_7096_() + p3.m_7096_()) * t3);
        double y = 0.5 * (2.0 * p1.m_7098_() + (-p0.m_7098_() + p2.m_7098_()) * t + (2.0 * p0.m_7098_() - 5.0 * p1.m_7098_() + 4.0 * p2.m_7098_() - p3.m_7098_()) * t2 + (-p0.m_7098_() + 3.0 * p1.m_7098_() - 3.0 * p2.m_7098_() + p3.m_7098_()) * t3);
        double z = 0.5 * (2.0 * p1.m_7094_() + (-p0.m_7094_() + p2.m_7094_()) * t + (2.0 * p0.m_7094_() - 5.0 * p1.m_7094_() + 4.0 * p2.m_7094_() - p3.m_7094_()) * t2 + (-p0.m_7094_() + 3.0 * p1.m_7094_() - 3.0 * p2.m_7094_() + p3.m_7094_()) * t3);
        return new Vec3(x, y, z);
    }

    public static float catmullRomInterpolate(float p0, float p1, float p2, float p3, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        return (float)(0.5 * (2.0 * (double)p1 + (double)(-p0 + p2) * t + (2.0 * (double)p0 - 5.0 * (double)p1 + 4.0 * (double)p2 - (double)p3) * t2 + ((double)(-p0) + 3.0 * (double)p1 - 3.0 * (double)p2 + (double)p3) * t3));
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("speed", this.speed);
        tag.m_128405_("type", this.type);
        ListTag pointsTag = new ListTag();
        for (Vec3Rot point : this.points) {
            pointsTag.add((Object)point.serializeNBT());
        }
        tag.m_128365_("points", (Tag)pointsTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.speed = tag.m_128459_("speed");
        this.type = tag.m_128451_("type");
        ListTag pointsTag = tag.m_128437_("points", 10);
        ArrayList<Vec3Rot> points = new ArrayList<Vec3Rot>();
        for (Tag t : pointsTag) {
            Vec3Rot rot = new Vec3Rot();
            rot.deserializeNBT((CompoundTag)t);
            points.add(rot);
        }
    }

    public List<Vec3Rot> getPoints() {
        return this.points;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getType() {
        return this.type;
    }

    public List<Double> getSegmentLengths() {
        return this.segmentLengths;
    }

    public double getTotalLength() {
        return this.totalLength;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CameraPath)) {
            return false;
        }
        CameraPath other = (CameraPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSpeed(), other.getSpeed()) != 0) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (Double.compare(this.getTotalLength(), other.getTotalLength()) != 0) {
            return false;
        }
        List<Vec3Rot> this$points = this.getPoints();
        List<Vec3Rot> other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        List<Double> this$segmentLengths = this.getSegmentLengths();
        List<Double> other$segmentLengths = other.getSegmentLengths();
        return !(this$segmentLengths == null ? other$segmentLengths != null : !((Object)this$segmentLengths).equals(other$segmentLengths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CameraPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $speed = Double.doubleToLongBits(this.getSpeed());
        result = result * 59 + (int)($speed >>> 32 ^ $speed);
        result = result * 59 + this.getType();
        long $totalLength = Double.doubleToLongBits(this.getTotalLength());
        result = result * 59 + (int)($totalLength >>> 32 ^ $totalLength);
        List<Vec3Rot> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        List<Double> $segmentLengths = this.getSegmentLengths();
        result = result * 59 + ($segmentLengths == null ? 43 : ((Object)$segmentLengths).hashCode());
        return result;
    }

    public String toString() {
        return "CameraPath(points=" + String.valueOf(this.getPoints()) + ", speed=" + this.getSpeed() + ", type=" + this.getType() + ", segmentLengths=" + String.valueOf(this.getSegmentLengths()) + ", totalLength=" + this.getTotalLength() + ")";
    }
}

