/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.molang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MolangParser {
    public static float count(String value, float animTime) {
        try {
            value = value.replace("query.anim_time", Float.toString(animTime)).replace("q.anim_time", Float.toString(animTime));
            value = MolangParser.replaceMath(value, Pattern.compile("math\\.sin\\(([^)]+)\\)"), (double v) -> Math.sin(Math.toRadians(v)));
            value = MolangParser.replaceMath(value, Pattern.compile("math\\.cos\\(([^)]+)\\)"), (double v) -> Math.cos(Math.toRadians(v)));
            value = MolangParser.replaceMath(value, Pattern.compile("math\\.min\\(([^,]+),([^)]+)\\)"), Math::min);
            value = MolangParser.replaceMath(value, Pattern.compile("math\\.max\\(([^,]+),([^)]+)\\)"), Math::max);
            return (float)MolangParser.parse(value);
        }
        catch (Exception e) {
            System.out.println("Molang parse error: " + e.getMessage() + " in '" + value + "'");
            return 0.0f;
        }
    }

    private static String replaceMath(String expr, Pattern pattern, SingleArgFunction func) {
        Matcher matcher = pattern.matcher(expr);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String inside = matcher.group(1);
            double value = MolangParser.parse(inside);
            double result = func.apply(value);
            matcher.appendReplacement(sb, Float.toString((float)result));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String replaceMath(String expr, Pattern pattern, DoubleArgFunction func) {
        Matcher matcher = pattern.matcher(expr);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String inside1 = matcher.group(1);
            String inside2 = matcher.group(2);
            double value1 = MolangParser.parse(inside1);
            double value2 = MolangParser.parse(inside2);
            double result = func.apply(value1, value2);
            matcher.appendReplacement(sb, Float.toString((float)result));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static double parse(final String expr) {
        return new Object(){
            int pos = -1;
            int ch;

            void nextChar() {
                this.ch = ++this.pos < expr.length() ? (int)expr.charAt(this.pos) : -1;
            }

            boolean eat(int charToEat) {
                while (this.ch == 32) {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            double parse() {
                this.nextChar();
                double x = this.parseExpression();
                if (this.pos < expr.length()) {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }

            double parseExpression() {
                double x = this.parseTerm();
                while (true) {
                    if (this.eat(43)) {
                        x += this.parseTerm();
                        continue;
                    }
                    if (!this.eat(45)) break;
                    x -= this.parseTerm();
                }
                return x;
            }

            double parseTerm() {
                double x = this.parseFactor();
                while (true) {
                    if (this.eat(42)) {
                        x *= this.parseFactor();
                        continue;
                    }
                    if (!this.eat(47)) break;
                    x /= this.parseFactor();
                }
                return x;
            }

            double parseFactor() {
                double x;
                if (this.eat(43)) {
                    return this.parseFactor();
                }
                if (this.eat(45)) {
                    return -this.parseFactor();
                }
                int startPos = this.pos;
                if (this.eat(40)) {
                    x = this.parseExpression();
                    if (!this.eat(41)) {
                        throw new RuntimeException("Missing ')'");
                    }
                } else if (this.ch >= 48 && this.ch <= 57 || this.ch == 46 || this.ch == 45) {
                    while ((this.ch >= 48 && this.ch <= 57 || this.ch == 46 || this.ch == 45 || this.ch == 101 || this.ch == 69 || this.ch == 43) && (this.ch != 45 && this.ch != 43 || expr.charAt(this.pos - 1) == 'e' || expr.charAt(this.pos - 1) == 'E')) {
                        this.nextChar();
                    }
                    x = Double.parseDouble(expr.substring(startPos, this.pos));
                } else {
                    throw new RuntimeException("Unexpected: " + (char)this.ch);
                }
                return x;
            }
        }.parse();
    }

    private static interface SingleArgFunction {
        public double apply(double var1);
    }

    private static interface DoubleArgFunction {
        public double apply(double var1, double var3);
    }
}

