/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.controller;

import it.mralxart.etheria.epicora.animations.base.IAnimated;
import it.mralxart.etheria.epicora.animations.base.IAnimatedEntity;
import it.mralxart.etheria.epicora.animations.base.IAnimatedTile;
import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.AnimationInstance;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationLayer;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.C2SPacket;
import it.mralxart.etheria.network.packets.S2CPacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.INBTSerializable;

public class AnimationController
implements INBTSerializable<CompoundTag> {
    public IAnimated object;
    public float tickCount;
    public boolean hasSync = false;
    public Map<String, AnimationLayer> layers = new HashMap<String, AnimationLayer>();

    public AnimationController(IAnimated object) {
        this.object = object;
    }

    public void tick() {
        if (!this.hasSync) {
            IAnimatedTile tile;
            Level level;
            IAnimated iAnimated = this.object;
            if (iAnimated instanceof IAnimatedTile && (level = (tile = (IAnimatedTile)iAnimated).getAnimatedTile().m_58904_()) != null && level.f_46443_) {
                this.syncClient();
            }
            this.hasSync = true;
        }
        this.tickCount += 0.05f;
        for (AnimationLayer layer : this.layers.values()) {
            layer.tick(this.tickCount);
        }
    }

    public GeometryChanges apply(float partialTicks) {
        GeometryChanges geometryChanges = new GeometryChanges();
        float controllerTime = this.getControllerTime(partialTicks);
        for (AnimationLayer layer : this.layers.values()) {
            layer.apply(geometryChanges, controllerTime);
        }
        return geometryChanges;
    }

    public float getControllerTime(float partialTicks) {
        return this.tickCount + partialTicks * 0.05f;
    }

    public AnimationLayer getLayer(String layerName) {
        AnimationLayer layer = this.layers.get(layerName);
        if (layer == null) {
            layer = this.layers.computeIfAbsent(layerName, name -> new AnimationLayer((String)name, this));
        }
        return layer;
    }

    public float getCurrentTime(String layer, float partialTicks) {
        return this.getLayer(layer).getAnimTime(this.getLayer(layer).getAnimation(), this.getControllerTime(partialTicks));
    }

    public boolean startAnimation(String layerName, Animation animation, LoopMode loopMode) {
        AnimationLayer layer = this.getLayer(layerName);
        layer.setLoopMode(loopMode);
        return layer.startAnimation(animation);
    }

    public boolean startAnimation(String layerName, Animation animation) {
        AnimationLayer layer = this.getLayer(layerName);
        return layer.startAnimation(animation);
    }

    public boolean stopAnimation(String layerName) {
        return this.startAnimation(layerName, Animation.EMPTY);
    }

    public boolean isCurrentAnimation(String layer, String key) {
        AnimationInstance current = this.getLayer(layer).getCurrentAnimation();
        return current != null && current.getAnimation().getKey().equals(key);
    }

    public void trySync() {
        IAnimated iAnimated = this.object;
        if (iAnimated instanceof IAnimatedEntity) {
            IAnimatedEntity entity = (IAnimatedEntity)iAnimated;
            level = entity.getAnimatedEntity().m_9236_();
            if (!((Level)level).f_46443_ && level.m_46749_(entity.getAnimatedEntity().m_20097_())) {
                CompoundTag tag = this.serializeNBT();
                Networking.sendTrackingEntity(entity.getAnimatedEntity(), new S2CPacket(tag, 112));
            }
        } else {
            BlockPos pos;
            IAnimatedTile tile;
            level = this.object;
            if (level instanceof IAnimatedTile && (level = (tile = (IAnimatedTile)level).getAnimatedTile().m_58904_()) != null && !((Level)level).f_46443_ && level.m_46749_(pos = tile.getAnimatedTile().m_58899_())) {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("x", pos.m_123341_());
                tag.m_128405_("y", pos.m_123342_());
                tag.m_128405_("z", pos.m_123343_());
                tag.m_128365_("controller", (Tag)this.serializeNBT());
                Networking.sendTrackingChunk(new LevelChunk((Level)level, new ChunkPos(pos)), new S2CPacket(tag, 113));
            }
        }
    }

    public void syncClient() {
        IAnimatedTile tile;
        BlockPos pos;
        IAnimated iAnimated;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (iAnimated = this.object) instanceof IAnimatedTile && level.m_46749_(pos = (tile = (IAnimatedTile)iAnimated).getAnimatedTile().m_58899_())) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            Networking.sendToServer(new C2SPacket(tag, 312));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        IAnimated iAnimated = this.object;
        if (iAnimated instanceof IAnimatedEntity) {
            IAnimatedEntity entity = (IAnimatedEntity)iAnimated;
            tag.m_128405_("entityId", entity.getAnimatedEntity().m_19879_());
        }
        tag.m_128350_("tickCount", this.tickCount);
        CompoundTag layersTag = new CompoundTag();
        for (Map.Entry entry : this.layers.entrySet()) {
            layersTag.m_128365_((String)entry.getKey(), (Tag)((AnimationLayer)entry.getValue()).serializeNBT());
        }
        tag.m_128365_("layers", (Tag)layersTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.tickCount = tag.m_128457_("tickCount");
        this.layers.clear();
        CompoundTag layersTag = tag.m_128469_("layers");
        for (String key : layersTag.m_128431_()) {
            AnimationLayer layer = new AnimationLayer(key, this);
            layer.deserializeNBT(layersTag.m_128469_(key));
            this.layers.put(key, layer);
        }
    }
}

