/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.components;

import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.BlendMode;
import it.mralxart.etheria.epicora.animations.components.bone.BoneAnimation;
import it.mralxart.etheria.epicora.animations.components.bone.BoneTransform;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GeometryChanges {
    public Map<String, BoneTransform> boneTransforms = new HashMap<String, BoneTransform>();
    public Map<String, BoneTransform> boneTransformsCopy = new HashMap<String, BoneTransform>();

    public void apply(Animation animation, BlendMode mode, float animTime, float progress) {
        for (Map.Entry<String, BoneAnimation> boneEntry : animation.getBones().entrySet()) {
            String boneName = boneEntry.getKey();
            this.boneTransforms.put(boneName, this.getBoneTransform(boneEntry.getValue(), this.boneTransforms.get(boneName), mode, animTime, progress));
        }
    }

    public BoneTransform getBoneTransform(BoneAnimation animation, @Nullable BoneTransform boneTransform, BlendMode mode, float animTime, float progress) {
        if (boneTransform == null) {
            boneTransform = new BoneTransform(animation.getName());
        }
        if (mode == BlendMode.OVERRIDE) {
            boneTransform.setPosition(this.lerp(boneTransform.getPosition(), animation.getPositionAtTime(animTime), progress));
            boneTransform.setRotation(this.lerp(boneTransform.getRotation(), animation.getRotationAtTime(animTime), progress));
            boneTransform.setScale(this.lerp(boneTransform.getScale(), animation.getScaleAtTime(animTime), progress));
        } else if (mode == BlendMode.ADD) {
            Vector3f posDelta = animation.getPositionAtTime(animTime);
            Vector3f rotDelta = animation.getRotationAtTime(animTime);
            if (!(this.hasNaN(posDelta) || this.hasNaN(rotDelta) || Float.isNaN(progress))) {
                boneTransform.setPosition(boneTransform.getPosition().add((Vector3fc)posDelta.mul(progress)));
                boneTransform.setRotation(boneTransform.getRotation().add((Vector3fc)rotDelta.mul(progress)));
            }
            boneTransform.setScale(GeometryChanges.multiply(boneTransform.getScale(), this.lerp(new Vector3f(1.0f, 1.0f, 1.0f), animation.getScaleAtTime(animTime), progress)));
        }
        return boneTransform;
    }

    private boolean hasNaN(Vector3f vec) {
        return Float.isNaN(vec.x()) || Float.isNaN(vec.y()) || Float.isNaN(vec.z());
    }

    private Vector3f lerp(Vector3f start, Vector3f end, float progress) {
        if (start == null || end == null || !this.isFinite(start) || !this.isFinite(end) || Float.isNaN(progress)) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return new Vector3f(this.lerp(start.x(), end.x(), progress), this.lerp(start.y(), end.y(), progress), this.lerp(start.z(), end.z(), progress));
    }

    public static Vector3f multiply(Vector3f start, Vector3f end) {
        return new Vector3f(start.x * end.x, start.y * end.y, start.z * end.z);
    }

    private float lerp(float a, float b, float progress) {
        if (Float.isNaN(a) || Float.isNaN(b) || Float.isNaN(progress)) {
            return 0.0f;
        }
        return Mth.m_14179_((float)progress, (float)a, (float)b);
    }

    private boolean isFinite(Vector3f vec) {
        return Float.isFinite(vec.x()) && Float.isFinite(vec.y()) && Float.isFinite(vec.z());
    }

    public Map<String, BoneTransform> getBoneTransforms() {
        return this.boneTransforms;
    }

    public Map<String, BoneTransform> getBoneTransformsCopy() {
        return this.boneTransformsCopy;
    }

    public void setBoneTransforms(Map<String, BoneTransform> boneTransforms) {
        this.boneTransforms = boneTransforms;
    }

    public void setBoneTransformsCopy(Map<String, BoneTransform> boneTransformsCopy) {
        this.boneTransformsCopy = boneTransformsCopy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeometryChanges)) {
            return false;
        }
        GeometryChanges other = (GeometryChanges)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, BoneTransform> this$boneTransforms = this.getBoneTransforms();
        Map<String, BoneTransform> other$boneTransforms = other.getBoneTransforms();
        if (this$boneTransforms == null ? other$boneTransforms != null : !((Object)this$boneTransforms).equals(other$boneTransforms)) {
            return false;
        }
        Map<String, BoneTransform> this$boneTransformsCopy = this.getBoneTransformsCopy();
        Map<String, BoneTransform> other$boneTransformsCopy = other.getBoneTransformsCopy();
        return !(this$boneTransformsCopy == null ? other$boneTransformsCopy != null : !((Object)this$boneTransformsCopy).equals(other$boneTransformsCopy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeometryChanges;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BoneTransform> $boneTransforms = this.getBoneTransforms();
        result = result * 59 + ($boneTransforms == null ? 43 : ((Object)$boneTransforms).hashCode());
        Map<String, BoneTransform> $boneTransformsCopy = this.getBoneTransformsCopy();
        result = result * 59 + ($boneTransformsCopy == null ? 43 : ((Object)$boneTransformsCopy).hashCode());
        return result;
    }

    public String toString() {
        return "GeometryChanges(boneTransforms=" + String.valueOf(this.getBoneTransforms()) + ", boneTransformsCopy=" + String.valueOf(this.getBoneTransformsCopy()) + ")";
    }
}

