/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations.components;

import it.mralxart.etheria.epicora.animations.components.AnimationFrame;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AnimationSequence {
    private List<AnimationFrame> frames;
    private int totalDuration;
    private int maxHeight = 0;

    private AnimationSequence(List<AnimationFrame> frames, int totalDuration) {
        this.frames = frames;
        this.totalDuration = totalDuration;
    }

    public AnimationFrame getFrameForTime(long elapsedTime) {
        long time = elapsedTime % (long)this.totalDuration;
        int accumulatedTime = 0;
        for (AnimationFrame frame : this.frames) {
            if (time >= (long)(accumulatedTime += frame.getDuration())) continue;
            return frame;
        }
        return this.frames.get(this.frames.size() - 1);
    }

    @Nullable
    public AnimationFrame getFrame(int index) {
        if (this.frames.isEmpty()) {
            return null;
        }
        int correctedIndex = index % this.frames.size();
        return this.frames.get(correctedIndex);
    }

    private static List<AnimationFrame> $default$frames() {
        return new ArrayList<AnimationFrame>();
    }

    public static AnimationSequenceBuilder builder() {
        return new AnimationSequenceBuilder();
    }

    public List<AnimationFrame> getFrames() {
        return this.frames;
    }

    public int getTotalDuration() {
        return this.totalDuration;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setFrames(List<AnimationFrame> frames) {
        this.frames = frames;
    }

    public void setTotalDuration(int totalDuration) {
        this.totalDuration = totalDuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimationSequence)) {
            return false;
        }
        AnimationSequence other = (AnimationSequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalDuration() != other.getTotalDuration()) {
            return false;
        }
        if (this.getMaxHeight() != other.getMaxHeight()) {
            return false;
        }
        List<AnimationFrame> this$frames = this.getFrames();
        List<AnimationFrame> other$frames = other.getFrames();
        return !(this$frames == null ? other$frames != null : !((Object)this$frames).equals(other$frames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnimationSequence;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalDuration();
        result = result * 59 + this.getMaxHeight();
        List<AnimationFrame> $frames = this.getFrames();
        result = result * 59 + ($frames == null ? 43 : ((Object)$frames).hashCode());
        return result;
    }

    public String toString() {
        return "AnimationSequence(frames=" + String.valueOf(this.getFrames()) + ", totalDuration=" + this.getTotalDuration() + ", maxHeight=" + this.getMaxHeight() + ")";
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public static class AnimationSequenceBuilder {
        private boolean frames$set;
        private List<AnimationFrame> frames$value;
        private int maxHeight;
        private final List<AnimationFrame> frames = new ArrayList<AnimationFrame>();
        private int totalDuration = 0;

        public AnimationSequenceBuilder addFrame(int frameIndex, int duration) {
            this.frames.add(new AnimationFrame(frameIndex, duration));
            this.totalDuration += duration;
            return this;
        }

        public AnimationSequence build() {
            return new AnimationSequence(this.frames, this.totalDuration);
        }

        AnimationSequenceBuilder() {
        }

        public AnimationSequenceBuilder frames(List<AnimationFrame> frames) {
            this.frames$value = frames;
            this.frames$set = true;
            return this;
        }

        public AnimationSequenceBuilder totalDuration(int totalDuration) {
            this.totalDuration = totalDuration;
            return this;
        }

        public AnimationSequenceBuilder maxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public String toString() {
            return "AnimationSequence.AnimationSequenceBuilder(frames$value=" + String.valueOf(this.frames$value) + ", totalDuration=" + this.totalDuration + ", maxHeight=" + this.maxHeight + ")";
        }
    }
}

