/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.epicora.animations;

import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.AnimationSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class AnimationStorage {
    private static final Map<ResourceLocation, AnimationSet> STORAGE = new HashMap<ResourceLocation, AnimationSet>();

    public static void storeAnimation(ResourceLocation key, Map<String, Animation> data) {
        STORAGE.put(key, new AnimationSet(data));
    }

    public static AnimationSet getAnimations(String id) {
        return AnimationStorage.getAnimationSet(new ResourceLocation("etheria", "animations/" + id));
    }

    public static Animation getAnimationByKey(String animationKey, float animationLength) {
        for (AnimationSet set : STORAGE.values()) {
            Animation animation = set.get(animationKey);
            if (animation == null || animation.getAnimationLength() != animationLength) continue;
            return animation;
        }
        return Animation.EMPTY;
    }

    public static AnimationSet getAnimationSet(ResourceLocation path) {
        if (!path.m_135815_().endsWith(".animation.json")) {
            return STORAGE.get(new ResourceLocation(path.m_135827_(), path.m_135815_() + ".animation.json"));
        }
        if (STORAGE.get(path) != null) {
            return STORAGE.get(path);
        }
        return new AnimationSet(new HashMap<String, Animation>());
    }

    @Deprecated
    public static Map<String, Animation> getAnimations(ResourceLocation path) {
        if (!path.m_135815_().endsWith(".animation.json")) {
            return new HashMap<String, Animation>(STORAGE.get(new ResourceLocation(path.m_135827_(), path.m_135815_() + ".animation.json")).getAnimations());
        }
        if (STORAGE.get(path) != null) {
            return new HashMap<String, Animation>(STORAGE.get(path).getAnimations());
        }
        return new HashMap<String, Animation>();
    }

    public static Animation getAnimation(ResourceLocation path, String key) {
        if (!path.m_135815_().endsWith(".animation.json")) {
            return STORAGE.get(new ResourceLocation(path.m_135827_(), path.m_135815_() + ".animation.json")).get(key);
        }
        return STORAGE.get(path).get(key);
    }
}

