/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import it.mralxart.etheria.entities.FlyingBlockEntity;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.magic.weapon.base.DamageContext;
import it.mralxart.etheria.registry.EntityRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class ShockwaveEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(ShockwaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float maxRadius = 15.0f;
    private float speed = 0.5f;
    private float damage = 15.0f;
    private LivingEntity owner;
    private DamageContext context;
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    private static int COUNTER = -10000;
    private final Set<BlockPos> hitBlocks = new HashSet<BlockPos>();

    public ShockwaveEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
        COUNTER = -10000;
    }

    public ShockwaveEntity(Level level, Vec3 position, LivingEntity owner, float maxRadius, float damage) {
        this((EntityType)EntityRegistry.SHOCKWAVE.get(), level);
        this.m_146884_(position);
        this.owner = owner;
        this.maxRadius = maxRadius;
        this.damage = damage;
        COUNTER = -10000;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_RADIUS, (Object)Float.valueOf(0.5f));
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)Float.valueOf(radius));
    }

    public void m_8119_() {
        float currentRadius;
        super.m_8119_();
        float previousRadius = currentRadius = this.getRadius();
        float newRadius = currentRadius + this.speed;
        this.setRadius(newRadius);
        if (this.getRadius() > this.maxRadius) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            double waveHeight = 1.5;
            AABB damageBox = new AABB(this.m_20185_() - (double)newRadius, this.m_20186_(), this.m_20189_() - (double)newRadius, this.m_20185_() + (double)newRadius, this.m_20186_() + waveHeight, this.m_20189_() + (double)newRadius);
            this.m_9236_().m_6443_(LivingEntity.class, damageBox, player -> !this.hitEntities.contains(player.m_20148_())).forEach(player -> {
                double distanceSq = player.m_20275_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                double radiusSq = newRadius * newRadius;
                double prevRadiusSq = previousRadius * previousRadius;
                if (distanceSq <= radiusSq && distanceSq > prevRadiusSq && player.m_20096_() && player.m_20186_() < this.m_20186_() + waveHeight) {
                    if (this.context == null) {
                        player.m_6469_(this.m_269291_().m_269425_(), this.damage);
                    } else {
                        DamageContext.DamageResult resolve = this.context.resolve();
                        ElementHandler.addElement(this.owner, player, Element.AERO, resolve.damage(), 40, true, resolve.isCrit());
                    }
                    Vec3 knockbackDir = player.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                    player.m_20256_(player.m_20184_().m_82520_(knockbackDir.f_82479_ * 1.5, 0.6, knockbackDir.f_82481_ * 1.5));
                    player.f_19864_ = true;
                    this.hitEntities.add(player.m_20148_());
                }
            });
        }
        if (this.m_9236_().f_46443_) {
            int particleCount = (int)(newRadius * 4.0f);
            for (int i = 0; i < particleCount; ++i) {
                if (!this.m_9236_().f_46441_.m_188499_()) continue;
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double dx = Math.cos(angle) * (double)newRadius;
                double dz = Math.sin(angle) * (double)newRadius;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() + dx, this.m_20186_(), this.m_20189_() + dz, 0.0, 0.0, 0.0);
            }
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int blockCheckCount = (int)(newRadius * 6.0f);
            for (int i = 0; i < blockCheckCount; ++i) {
                BlockPos originalPos;
                double angle = Math.PI * 2 * (double)i / (double)blockCheckCount;
                double x = this.m_20185_() + Math.cos(angle) * (double)newRadius;
                double z = this.m_20189_() + Math.sin(angle) * (double)newRadius;
                mutablePos.m_122169_(x, this.m_20186_() + 2.0, z);
                int checkLimit = 0;
                BlockState state = this.m_9236_().m_8055_((BlockPos)mutablePos);
                while (state.m_60795_() && mutablePos.m_123342_() > this.m_9236_().m_141937_() && checkLimit++ < 8) {
                    mutablePos.m_122184_(0, -1, 0);
                    state = this.m_9236_().m_8055_((BlockPos)mutablePos);
                }
                if (state.m_60795_() || state.m_60734_() instanceof LiquidBlock || state.m_60799_() == RenderShape.INVISIBLE || this.hitBlocks.contains(originalPos = mutablePos.m_7949_())) continue;
                this.hitBlocks.add(originalPos);
                this.createBlock(originalPos, state, newRadius);
            }
        }
    }

    private void createBlock(BlockPos pos, BlockState state, float currentRadius) {
        FlyingBlockEntity flyingBlock = new FlyingBlockEntity(this.m_9236_(), pos, state);
        double baseLift = 0.3;
        double upBlock = 0.01;
        double yOff = baseLift + (double)currentRadius * upBlock;
        flyingBlock.m_20234_(COUNTER--);
        flyingBlock.m_20334_(0.0, yOff, 0.0);
        this.onClient(this.m_9236_(), flyingBlock);
        this.m_9236_().m_245747_(pos, state.getSoundType((LevelReader)this.m_9236_(), pos, null).m_56775_(), SoundSource.BLOCKS, 1.0f, 0.8f, false);
        for (int k = 0; k < 2; ++k) {
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5 + (this.f_19796_.m_188500_() - 0.5), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + (this.f_19796_.m_188500_() - 0.5), 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient(Level level, FlyingBlockEntity entity) {
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            clientLevel.m_104627_(entity.m_19879_(), (Entity)entity);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("MaxRadius")) {
            this.maxRadius = tag.m_128457_("MaxRadius");
        }
        if (tag.m_128441_("Damage")) {
            this.damage = tag.m_128457_("Damage");
        }
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_("MaxRadius", this.maxRadius);
        tag.m_128350_("Damage", this.damage);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setMaxRadius(float maxRadius) {
        this.maxRadius = maxRadius;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public void setContext(DamageContext context) {
        this.context = context;
    }
}

