/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import it.mralxart.etheria.client.particles.BlockParticleData;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.entities.ShockwaveEntity;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.elements.handlers.ElementHandler;
import it.mralxart.etheria.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class Meteorite
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> DAMAGE = SynchedEntityData.m_135353_(Meteorite.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> ELEMENT_NAME = SynchedEntityData.m_135353_(Meteorite.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private Vec3 centerPos = Vec3.f_82478_;
    private float explosionRadius = 2.5f;
    private Color cachedColor = null;

    public Meteorite(EntityType<? extends Meteorite> entityType, Level level) {
        super(entityType, level);
    }

    public void setElement(Element element) {
        this.f_19804_.m_135381_(ELEMENT_NAME, (Object)element.name());
        this.cachedColor = ElementsUtils.getRandomColorByElement(element);
    }

    public Element getElement() {
        try {
            return Element.valueOf((String)this.f_19804_.m_135370_(ELEMENT_NAME));
        }
        catch (IllegalArgumentException e) {
            return Element.AERO;
        }
    }

    public void setDamage(int baseDamage) {
        this.m_20088_().m_135381_(DAMAGE, (Object)baseDamage);
    }

    public int getDamage() {
        return (Integer)this.m_20088_().m_135370_(DAMAGE);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
        }
        if (this.m_9236_().f_46443_) {
            this.render();
        }
        if (this.m_20186_() < (double)(this.m_9236_().m_141937_() - 10)) {
            this.m_146870_();
        }
    }

    private void render() {
        if (this.cachedColor == null) {
            this.cachedColor = ElementsUtils.getRandomColorByElement(this.getElement());
        }
        Vec3 pos = this.m_20182_();
        Vec3 motion = this.m_20184_();
        for (int i = 0; i < 3; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleData(this.cachedColor, 0.4f + this.f_19796_.m_188501_() * 0.3f, 10, 1.5f), pos.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 0.5, pos.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * 0.5, pos.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 0.5, motion.f_82479_ * 0.1, motion.f_82480_ * 0.1, motion.f_82481_ * 0.1);
        }
        double speed = motion.m_82553_();
        Vec3 prev = new Vec3(this.f_19854_, this.f_19855_, this.f_19856_);
        Vec3 dir = pos.m_82546_(prev).m_82541_();
        int particleCount = (int)(speed * 15.0) + 2;
        for (int i = 0; i < particleCount; ++i) {
            Object pType;
            double progress = (double)i / (double)particleCount;
            double lx = prev.f_82479_ + (pos.f_82479_ - prev.f_82479_) * progress;
            double ly = prev.f_82480_ + (pos.f_82480_ - prev.f_82480_) * progress;
            double lz = prev.f_82481_ + (pos.f_82481_ - prev.f_82481_) * progress;
            double jitter = 0.3 + progress * 0.2;
            double px = lx + (this.f_19796_.m_188500_() - 0.5) * jitter;
            double py = ly + (this.f_19796_.m_188500_() - 0.5) * jitter;
            double pz = lz + (this.f_19796_.m_188500_() - 0.5) * jitter;
            Object object = pType = this.f_19796_.m_188499_() ? new GlowingParticleData(this.cachedColor, 0.2f, 20, 0.5f) : ParticleTypes.f_123796_;
            if (pType == ParticleTypes.f_123796_) {
                this.m_9236_().m_7106_((ParticleOptions)pType, px, py, pz, 0.0, 0.05, 0.0);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)pType, px, py, pz, 0.0, 0.0, 0.0);
        }
        ParticleUtils.drawAnimatedCyl(this.m_9236_(), new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.PYRO), 0.35f, 20, 0.025f), this.getCenterPos(), this.f_19797_, this.getExplosionRadius(), 10);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity target = result.m_82443_();
            target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)this.getDamage());
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                ElementHandler.addElement(living, this.getElement(), this.getDamage(), 500, true);
            }
            this.explode(result.m_82450_());
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_) {
            this.explode(result.m_82450_());
        }
    }

    private void explode(Vec3 impactPos) {
        LivingEntity l;
        Level level = this.m_9236_();
        Entity entity = this.m_19749_();
        LivingEntity owner = entity instanceof LivingEntity ? (l = (LivingEntity)entity) : null;
        ShockwaveEntity shockwave = new ShockwaveEntity(level, impactPos, owner, this.explosionRadius * 1.5f, (float)this.getDamage() / 2.0f);
        level.m_7967_((Entity)shockwave);
        AABB area = new AABB(impactPos, impactPos).m_82400_((double)this.explosionRadius);
        level.m_45976_(LivingEntity.class, area).forEach(e -> {
            if (e != owner) {
                ElementHandler.addElement(e, this.getElement(), this.getDamage() / 2, 200, true);
            }
        });
        this.m_146870_();
    }

    public void m_6043_() {
        if (this.f_19797_ > 300) {
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)5);
        this.f_19804_.m_135372_(ELEMENT_NAME, (Object)Element.AERO.name());
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("damage", this.getDamage());
        compound.m_128359_("element", this.getElement().name());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDamage(compound.m_128451_("damage"));
        if (compound.m_128441_("element")) {
            try {
                this.setElement(Element.valueOf(compound.m_128461_("element")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Vec3 getCenterPos() {
        return this.centerPos;
    }

    public float getExplosionRadius() {
        return this.explosionRadius;
    }

    public Color getCachedColor() {
        return this.cachedColor;
    }

    public void setCenterPos(Vec3 centerPos) {
        this.centerPos = centerPos;
    }

    public void setExplosionRadius(float explosionRadius) {
        this.explosionRadius = explosionRadius;
    }

    public void setCachedColor(Color cachedColor) {
        this.cachedColor = cachedColor;
    }
}

