/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.registry.EntityRegistry;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class FlyingBlockEntity
extends Entity {
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.m_135353_(FlyingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    public int life = 20;

    public FlyingBlockEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public FlyingBlockEntity(Level level, BlockPos pos, BlockState blockState) {
        this((EntityType)EntityRegistry.FLYING_BLOCK.get(), level);
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        this.setBlockState(blockState);
    }

    public void m_8119_() {
        super.m_8119_();
        --this.life;
        if (this.life <= 0) {
            this.m_146870_();
            return;
        }
        Vec3 oldPos = this.m_20182_();
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.07, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public void setBlockState(BlockState state) {
        this.f_19804_.m_135381_(BLOCK_STATE, (Object)state);
    }

    public BlockState getBlockState() {
        return (BlockState)this.f_19804_.m_135370_(BLOCK_STATE);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_STATE, (Object)Blocks.f_50493_.m_49966_());
    }

    protected void m_7378_(CompoundTag tag) {
        this.setBlockState(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("blockState")));
        this.life = tag.m_128451_("life");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)this.getBlockState()));
        tag.m_128405_("life", this.life);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6043_() {
        if (this.life <= 0) {
            this.m_146870_();
        }
    }

    public static class Render
    extends EntityRenderer<FlyingBlockEntity> {
        private final BlockRenderDispatcher blockRenderer;

        public Render(EntityRendererProvider.Context context) {
            super(context);
            this.f_114477_ = 0.5f;
            this.blockRenderer = context.m_234597_();
        }

        public void render(FlyingBlockEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
            BlockState blockState = entity.getBlockState();
            if (blockState.m_60799_() != RenderShape.MODEL) {
                return;
            }
            if (packedLight == 0) {
                packedLight = 0xF00020;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            this.blockRenderer.m_110912_(blockState, poseStack, buffer, packedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }

        public ResourceLocation getTextureLocation(FlyingBlockEntity entity) {
            return TextureAtlas.f_118259_;
        }
    }
}

