/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.entities;

import it.mralxart.etheria.epicora.data.CameraPath;
import it.mralxart.etheria.epicora.data.PlayerPos;
import it.mralxart.etheria.epicora.data.Vec3Rot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;

public class EntityCamera
extends Entity {
    @Nullable
    private CameraPath path;
    private double progress = 0.0;
    private final List<UUID> entities = new ArrayList<UUID>();
    private final Map<UUID, PlayerPos> resetPoses = new HashMap<UUID, PlayerPos>();

    public EntityCamera(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    public void setup(CameraPath path, List<Entity> entitiesToControl) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.path = path;
        Vec3Rot startPos = path.getPositionAt(0.0);
        if (startPos != null) {
            this.m_6034_(startPos.position.f_82479_, startPos.position.f_82480_, startPos.position.f_82481_);
            this.m_146926_(startPos.pitch);
            this.m_146922_(startPos.yaw);
        }
        for (Entity entity : entitiesToControl) {
            UUID uuid = entity.m_20148_();
            this.entities.add(uuid);
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            this.resetPoses.put(uuid, new PlayerPos(player.m_20182_(), player.f_8941_.m_9290_()));
            player.m_143403_(GameType.SPECTATOR);
            player.m_9213_((Entity)this);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ || this.path == null) {
            return;
        }
        double speedFactor = this.path.getSpeed() > 0.0 ? 1.0 / (this.path.getSpeed() * 20.0) : 0.01;
        this.progress += speedFactor;
        Vec3Rot currentPoint = this.path.getPositionAt(this.progress);
        if (this.progress >= 1.0 || currentPoint == null) {
            this.m_146870_();
            return;
        }
        currentPoint.position = currentPoint.position.m_82520_(0.5, 0.5, 0.5);
        this.m_146884_(currentPoint.position);
        this.m_146926_(currentPoint.pitch);
        this.m_146922_(currentPoint.yaw);
        for (UUID uuid : this.entities) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
            if (entity == null) continue;
            entity.m_146884_(currentPoint.position);
            entity.m_146926_(currentPoint.pitch);
            entity.m_146922_(currentPoint.getYaw());
            entity.m_146926_(currentPoint.getPitch());
            entity.m_5616_(currentPoint.yaw);
            entity.m_5618_(currentPoint.getYaw());
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            player.f_8906_.m_9774_(currentPoint.getPosition().f_82479_, currentPoint.getPosition().f_82480_, currentPoint.getPosition().f_82481_, currentPoint.pitch, currentPoint.yaw);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_) {
            this.restoreControlledEntities();
        }
        super.m_142687_(reason);
    }

    private void restoreControlledEntities() {
        if (this.entities.isEmpty()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.m_9236_();
        for (UUID uuid : this.entities) {
            Entity entity = serverLevel.m_8791_(uuid);
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            PlayerPos originalState = this.resetPoses.get(uuid);
            if (originalState == null || originalState.position == null) continue;
            if (this.path != null) {
                player.m_8999_(serverLevel, originalState.position.f_82479_, originalState.position.f_82480_, originalState.position.f_82481_, this.path.getPositionAt((double)this.progress).pitch, this.path.getPositionAt((double)this.progress).yaw);
            } else {
                player.m_8999_(serverLevel, originalState.position.f_82479_, originalState.position.f_82480_, originalState.position.f_82481_, player.m_146908_(), player.m_146909_());
            }
            player.m_143403_(originalState.gameType);
            player.m_9213_((Entity)player);
        }
        this.entities.clear();
        this.resetPoses.clear();
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("CameraPath", 10)) {
            CameraPath cameraPath = new CameraPath(new ArrayList<Vec3Rot>(), 0.0, 0);
            cameraPath.deserializeNBT(compound.m_128469_("CameraPath"));
            this.path = cameraPath;
        }
        this.progress = compound.m_128459_("Progress");
        this.entities.clear();
        ListTag entitiesTag = compound.m_128437_("entities", 8);
        for (Tag tag : entitiesTag) {
            this.entities.add(UUID.fromString(tag.m_7916_()));
        }
        this.resetPoses.clear();
        ListTag statesTag = compound.m_128437_("resetPoses", 10);
        for (Tag tag : statesTag) {
            CompoundTag stateCompound = (CompoundTag)tag;
            UUID uuid = stateCompound.m_128342_("UUID");
            PlayerPos pos = new PlayerPos();
            pos.deserializeNBT(stateCompound.m_128469_("State"));
            this.resetPoses.put(uuid, pos);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.path != null) {
            compound.m_128365_("CameraPath", (Tag)this.path.serializeNBT());
        }
        compound.m_128347_("Progress", this.progress);
        ListTag entitiesTag = new ListTag();
        for (UUID uuid : this.entities) {
            entitiesTag.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        compound.m_128365_("entities", (Tag)entitiesTag);
        ListTag statesTag = new ListTag();
        for (Map.Entry<UUID, PlayerPos> entry : this.resetPoses.entrySet()) {
            CompoundTag stateCompound = new CompoundTag();
            stateCompound.m_128362_("UUID", entry.getKey());
            stateCompound.m_128365_("State", (Tag)entry.getValue().serializeNBT());
            statesTag.add((Object)stateCompound);
        }
        compound.m_128365_("resetPoses", (Tag)statesTag);
    }
}

