/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.config.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class BaseConfig<T> {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128, 8}).disableHtmlEscaping().create();

    public abstract Path path();

    public abstract T construct();

    public abstract void load(T var1);

    public void constructAndSave(boolean is) {
        try {
            if (is || !Files.exists(this.path(), new LinkOption[0]) || Files.size(this.path()) == 0L) {
                T data = this.construct();
                this.save(data);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save() {
        if (!Files.exists(this.path(), new LinkOption[0])) {
            return;
        }
        try {
            Object data = GSON.fromJson((Reader)Files.newBufferedReader(this.path()), this.getType());
            this.load(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFromJson(String json) {
        try {
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            String utf8String = new String(bytes, StandardCharsets.UTF_8);
            Object data = GSON.fromJson(utf8String, this.getType());
            this.load(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(T override) {
        try {
            Files.createDirectories(this.path().getParent(), new FileAttribute[0]);
            Files.write(this.path(), GSON.toJson(override).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        try {
            Files.deleteIfExists(this.path());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.constructAndSave(true);
    }

    public String getJson() {
        try {
            return Files.readString(this.path());
        }
        catch (IOException e) {
            return "{}";
        }
    }

    protected abstract Class<T> getType();
}

