/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.config;

import it.mralxart.etheria.config.base.BaseConfig;
import it.mralxart.etheria.items.RuneItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.rituals.RitualRegistry;
import it.mralxart.etheria.magic.rituals.RitualResult;
import it.mralxart.etheria.magic.rituals.data.RitualData;
import it.mralxart.etheria.magic.rituals.data.RitualDifficulty;
import it.mralxart.etheria.magic.rituals.results.CreateItemResult;
import it.mralxart.etheria.magic.rituals.results.EnigmaResult;
import it.mralxart.etheria.magic.rituals.results.KorLunarLevelUp;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.utils.ItemUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fml.loading.FMLPaths;

public class RitualsConfig
extends BaseConfig<Data> {
    @Override
    public Path path() {
        return FMLPaths.CONFIGDIR.get().resolve("etheria/ritual_config.json");
    }

    @Override
    public Data construct() {
        HashMap<String, Data.RitualConfigData> info = new HashMap<String, Data.RitualConfigData>();
        for (RitualData data : RitualRegistry.getAllRituals().values()) {
            info.put(data.getId(), RitualsConfig.toConfigData(data));
        }
        return new Data(info);
    }

    @Override
    public void load(Data data) {
        for (Data.RitualConfigData ritual : data.info.values()) {
            RitualRegistry.registerRitual(ritual.id, RitualsConfig.fromConfigData(ritual));
        }
    }

    @Override
    protected Class<Data> getType() {
        return Data.class;
    }

    public static Data.RitualConfigData toConfigData(RitualData data) {
        Data.RitualConfigData config = new Data.RitualConfigData();
        config.setId(data.getId());
        config.setRequiredLevel(data.getRequiredLevel());
        config.setRequiredEther(data.getRequiredEther());
        config.setEnigma(data.isEnigma());
        config.setCrashChance(data.getCrashChance());
        config.setDescription(data.getDescription());
        config.setMainIngredient(ItemUtils.serialize(data.getMainIngredient()));
        config.setIngredients(data.getIngredients() != null ? data.getIngredients().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ItemUtils.serialize((Ingredient)e.getValue()))) : new HashMap<String, String>());
        config.setRunes(data.getRunes() != null ? data.getRunes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ItemUtils.getIdString((Item)e.getValue()))) : new HashMap<String, String>());
        config.setElement(data.getElement());
        config.setRitualDifficulty(data.getRitualDifficulty());
        config.setResult(RitualsConfig.toConfigResult(data.getResult()));
        config.setResultItem(ItemUtils.getIdString(data.getResult().getResultItem().m_41720_()));
        return config;
    }

    public static RitualData fromConfigData(Data.RitualConfigData config) {
        return RitualData.builder(config.getId()).requiredLevel(config.getRequiredLevel()).requiredEther(config.getRequiredEther()).isEnigma(config.isEnigma()).crashChance(config.getCrashChance()).description(config.getDescription()).mainIngredient(ItemUtils.deserialize(config.getMainIngredient())).ingredients(config.getIngredients() != null ? config.getIngredients().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ItemUtils.deserialize((String)e.getValue()))) : new HashMap<String, Ingredient>()).runes(config.getRunes() != null ? config.getRunes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            RuneItem runeItem;
            Item patt5570$temp = ItemUtils.byIdString((String)e.getValue());
            return patt5570$temp instanceof RuneItem ? (runeItem = (RuneItem)patt5570$temp) : (RuneItem)ItemRegistry.RUNE_WISDOM.get();
        })) : new HashMap<String, RuneItem>()).element(config.getElement()).ritualDifficulty(config.getRitualDifficulty()).result(RitualsConfig.fromConfigResult(config.getResult(), config.getResultItem())).build();
    }

    private static Data.RitualConfigResult toConfigResult(RitualResult result) {
        if (result instanceof CreateItemResult) {
            return Data.RitualConfigResult.CREATE_ITEM;
        }
        if (result instanceof EnigmaResult) {
            return Data.RitualConfigResult.ENIGMA;
        }
        if (result instanceof KorLunarLevelUp) {
            return Data.RitualConfigResult.KOR_LUNAR;
        }
        return Data.RitualConfigResult.CREATE_ITEM;
    }

    private static RitualResult fromConfigResult(Data.RitualConfigResult configResult, String itemId) {
        return switch (configResult) {
            default -> throw new IncompatibleClassChangeError();
            case Data.RitualConfigResult.CREATE_ITEM -> new CreateItemResult(ItemUtils.byIdString(itemId).m_7968_());
            case Data.RitualConfigResult.ENIGMA -> new EnigmaResult(ItemUtils.byIdString(itemId).m_7968_());
            case Data.RitualConfigResult.KOR_LUNAR -> new KorLunarLevelUp();
        };
    }

    public static class Data {
        public Map<String, RitualConfigData> info;

        public Data(Map<String, RitualConfigData> info) {
            this.info = info;
        }

        public static enum RitualConfigResult {
            CREATE_ITEM,
            KOR_LUNAR,
            ENIGMA;

        }

        public static class RitualConfigData {
            private String id = "";
            private int requiredLevel = 0;
            private int requiredEther = 10;
            private boolean isEnigma = false;
            private float crashChance = 0.0f;
            private String description = "";
            private String mainIngredient = "";
            private Map<String, String> ingredients = new HashMap<String, String>();
            private Map<String, String> runes = new HashMap<String, String>();
            private Element element = Element.ETHER;
            private RitualDifficulty ritualDifficulty = RitualDifficulty.BASIC;
            private RitualConfigResult result = RitualConfigResult.CREATE_ITEM;
            private String resultItem = "";

            public String getId() {
                return this.id;
            }

            public int getRequiredLevel() {
                return this.requiredLevel;
            }

            public int getRequiredEther() {
                return this.requiredEther;
            }

            public boolean isEnigma() {
                return this.isEnigma;
            }

            public float getCrashChance() {
                return this.crashChance;
            }

            public String getDescription() {
                return this.description;
            }

            public String getMainIngredient() {
                return this.mainIngredient;
            }

            public Map<String, String> getIngredients() {
                return this.ingredients;
            }

            public Map<String, String> getRunes() {
                return this.runes;
            }

            public Element getElement() {
                return this.element;
            }

            public RitualDifficulty getRitualDifficulty() {
                return this.ritualDifficulty;
            }

            public RitualConfigResult getResult() {
                return this.result;
            }

            public String getResultItem() {
                return this.resultItem;
            }

            public void setId(String id) {
                this.id = id;
            }

            public void setRequiredLevel(int requiredLevel) {
                this.requiredLevel = requiredLevel;
            }

            public void setRequiredEther(int requiredEther) {
                this.requiredEther = requiredEther;
            }

            public void setEnigma(boolean isEnigma) {
                this.isEnigma = isEnigma;
            }

            public void setCrashChance(float crashChance) {
                this.crashChance = crashChance;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public void setMainIngredient(String mainIngredient) {
                this.mainIngredient = mainIngredient;
            }

            public void setIngredients(Map<String, String> ingredients) {
                this.ingredients = ingredients;
            }

            public void setRunes(Map<String, String> runes) {
                this.runes = runes;
            }

            public void setElement(Element element) {
                this.element = element;
            }

            public void setRitualDifficulty(RitualDifficulty ritualDifficulty) {
                this.ritualDifficulty = ritualDifficulty;
            }

            public void setResult(RitualConfigResult result) {
                this.result = result;
            }

            public void setResultItem(String resultItem) {
                this.resultItem = resultItem;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RitualConfigData)) {
                    return false;
                }
                RitualConfigData other = (RitualConfigData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getRequiredLevel() != other.getRequiredLevel()) {
                    return false;
                }
                if (this.getRequiredEther() != other.getRequiredEther()) {
                    return false;
                }
                if (this.isEnigma() != other.isEnigma()) {
                    return false;
                }
                if (Float.compare(this.getCrashChance(), other.getCrashChance()) != 0) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$mainIngredient = this.getMainIngredient();
                String other$mainIngredient = other.getMainIngredient();
                if (this$mainIngredient == null ? other$mainIngredient != null : !this$mainIngredient.equals(other$mainIngredient)) {
                    return false;
                }
                Map<String, String> this$ingredients = this.getIngredients();
                Map<String, String> other$ingredients = other.getIngredients();
                if (this$ingredients == null ? other$ingredients != null : !((Object)this$ingredients).equals(other$ingredients)) {
                    return false;
                }
                Map<String, String> this$runes = this.getRunes();
                Map<String, String> other$runes = other.getRunes();
                if (this$runes == null ? other$runes != null : !((Object)this$runes).equals(other$runes)) {
                    return false;
                }
                Element this$element = this.getElement();
                Element other$element = other.getElement();
                if (this$element == null ? other$element != null : !((Object)((Object)this$element)).equals((Object)other$element)) {
                    return false;
                }
                RitualDifficulty this$ritualDifficulty = this.getRitualDifficulty();
                RitualDifficulty other$ritualDifficulty = other.getRitualDifficulty();
                if (this$ritualDifficulty == null ? other$ritualDifficulty != null : !((Object)((Object)this$ritualDifficulty)).equals((Object)other$ritualDifficulty)) {
                    return false;
                }
                RitualConfigResult this$result = this.getResult();
                RitualConfigResult other$result = other.getResult();
                if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
                    return false;
                }
                String this$resultItem = this.getResultItem();
                String other$resultItem = other.getResultItem();
                return !(this$resultItem == null ? other$resultItem != null : !this$resultItem.equals(other$resultItem));
            }

            protected boolean canEqual(Object other) {
                return other instanceof RitualConfigData;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getRequiredLevel();
                result = result * 59 + this.getRequiredEther();
                result = result * 59 + (this.isEnigma() ? 79 : 97);
                result = result * 59 + Float.floatToIntBits(this.getCrashChance());
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $mainIngredient = this.getMainIngredient();
                result = result * 59 + ($mainIngredient == null ? 43 : $mainIngredient.hashCode());
                Map<String, String> $ingredients = this.getIngredients();
                result = result * 59 + ($ingredients == null ? 43 : ((Object)$ingredients).hashCode());
                Map<String, String> $runes = this.getRunes();
                result = result * 59 + ($runes == null ? 43 : ((Object)$runes).hashCode());
                Element $element = this.getElement();
                result = result * 59 + ($element == null ? 43 : ((Object)((Object)$element)).hashCode());
                RitualDifficulty $ritualDifficulty = this.getRitualDifficulty();
                result = result * 59 + ($ritualDifficulty == null ? 43 : ((Object)((Object)$ritualDifficulty)).hashCode());
                RitualConfigResult $result = this.getResult();
                result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
                String $resultItem = this.getResultItem();
                result = result * 59 + ($resultItem == null ? 43 : $resultItem.hashCode());
                return result;
            }

            public String toString() {
                return "RitualsConfig.Data.RitualConfigData(id=" + this.getId() + ", requiredLevel=" + this.getRequiredLevel() + ", requiredEther=" + this.getRequiredEther() + ", isEnigma=" + this.isEnigma() + ", crashChance=" + this.getCrashChance() + ", description=" + this.getDescription() + ", mainIngredient=" + this.getMainIngredient() + ", ingredients=" + String.valueOf(this.getIngredients()) + ", runes=" + String.valueOf(this.getRunes()) + ", element=" + String.valueOf((Object)this.getElement()) + ", ritualDifficulty=" + String.valueOf((Object)this.getRitualDifficulty()) + ", result=" + String.valueOf((Object)this.getResult()) + ", resultItem=" + this.getResultItem() + ")";
            }
        }
    }
}

