/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.mralxart.etheria.artifacts.ArtifactStatsManager;
import it.mralxart.etheria.capability.SyncCapabilityManager;
import it.mralxart.etheria.epicora.animations.util.AnimationsLoader;
import it.mralxart.etheria.epicora.geometry.util.GeometryLoader;
import it.mralxart.etheria.handlers.ConfigCommandHandler;
import it.mralxart.etheria.items.ArtifactItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.korlunar.KorLunarLevels;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.S2CPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.EnumArgument;

public class EtheriaCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"etheria").requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 1;
            }
            GeometryLoader.init();
            AnimationsLoader.init();
            Networking.sendToClients(PacketDistributor.ALL.noArg(), new S2CPacket(new CompoundTag(), 201));
            SyncCapabilityManager.sync((Player)player);
            return 1;
        }))).then(ConfigCommandHandler.createConfigCommand())).then(Commands.m_82127_((String)"skill_points").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(FullAction.class)).then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer owner = ((CommandSourceStack)context.getSource()).m_230896_();
            if (owner == null) {
                return 1;
            }
            Collection players = EntityArgument.m_91477_((CommandContext)context, (String)"players");
            FullAction action = (FullAction)((Object)((Object)context.getArgument("action", FullAction.class)));
            int num = IntegerArgumentType.getInteger((CommandContext)context, (String)"number");
            for (ServerPlayer player : players) {
                int points = CapabilityRegistry.getCap((Player)player).getSkillPoints();
                switch (action) {
                    case add: {
                        CapabilityRegistry.getCap((Player)player).setSkillPoints(points + num);
                        break;
                    }
                    case set: {
                        CapabilityRegistry.getCap((Player)player).setSkillPoints(num);
                        break;
                    }
                    case take: {
                        CapabilityRegistry.getCap((Player)player).setSkillPoints(Math.min(0, points - num));
                        break;
                    }
                    case get: {
                        owner.m_5661_((Component)Component.m_237113_((String)(player.m_7755_().getString() + " skill_points: " + points)), false);
                    }
                }
                SyncCapabilityManager.sync((Player)player);
            }
            return 1;
        })))))).then(Commands.m_82127_((String)"kor-lunar").then(Commands.m_82127_((String)"lvl").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(Action.class)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            if (amount > KorLunarLevels.getMaxLevel()) {
                amount = KorLunarLevels.getMaxLevel();
            }
            Action action = (Action)((Object)((Object)context.getArgument("action", Action.class)));
            Collection players = null;
            try {
                players = EntityArgument.m_91477_((CommandContext)context, (String)"players");
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            for (ServerPlayer player : players) {
                switch (action) {
                    case set: {
                        CapabilityRegistry.getCap((Player)player).setKorLunar(amount);
                        break;
                    }
                    case add: {
                        CapabilityRegistry.getCap((Player)player).setKorLunar(CapabilityRegistry.getCap((Player)player).getKorLunar() + amount);
                        break;
                    }
                    case take: {
                        CapabilityRegistry.getCap((Player)player).setKorLunar(CapabilityRegistry.getCap((Player)player).getKorLunar() - amount);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.m_82127_((String)"spells").then(Commands.m_82127_((String)"lvl").then(Commands.m_82129_((String)"spell", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])EtheriaCommand.getSpells(), (SuggestionsBuilder)builder)).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(Action.class)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String spellId = StringArgumentType.getString((CommandContext)context, (String)"spell");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            Action action = (Action)((Object)((Object)context.getArgument("action", Action.class)));
            Collection players = null;
            try {
                players = EntityArgument.m_91477_((CommandContext)context, (String)"players");
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            for (ServerPlayer player : players) {
                Spell spell = SpellsUtils.getSpell((Player)player, spellId);
                switch (action) {
                    case set: {
                        spell.setLevel(amount);
                        break;
                    }
                    case add: {
                        spell.setLevel(spell.getLevel() + amount);
                        break;
                    }
                    case take: {
                        spell.setLevel(spell.getLevel() - amount);
                    }
                }
                if ((double)spell.getLevel() > SpellsUtils.getMaxLvl(spellId)) {
                    spell.setLevel((int)SpellsUtils.getMaxLvl(spellId));
                }
                if (spell.getLevel() < 0) {
                    spell.setLevel(0);
                }
                SpellsUtils.putSpell((Player)player, spell);
                SyncCapabilityManager.sync((Player)player);
            }
            return 1;
        })))))))).then(Commands.m_82127_((String)"element").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(GetSetAction.class)).then(Commands.m_82129_((String)"element", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])EtheriaCommand.getElementStream(), (SuggestionsBuilder)builder)).executes(context -> {
            Collection players;
            String element = StringArgumentType.getString((CommandContext)context, (String)"element");
            GetSetAction action = (GetSetAction)((Object)((Object)context.getArgument("action", GetSetAction.class)));
            try {
                players = EntityArgument.m_91477_((CommandContext)context, (String)"players");
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            for (ServerPlayer player : players) {
                switch (action) {
                    case set: {
                        ElementsUtils.setElement((Player)player, element);
                    }
                }
            }
            return 1;
        })))))).then(Commands.m_82127_((String)"artifacts").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"stars").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Collection players;
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            try {
                players = EntityArgument.m_91477_((CommandContext)context, (String)"players");
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
            for (ServerPlayer player : players) {
                ItemStack itemStack = player.m_21205_();
                if (!(itemStack.m_41720_() instanceof ArtifactItem)) continue;
                itemStack.m_41784_().m_128405_("etheria$stars", amount);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                ArtifactStatsManager.init(itemStack);
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            }
            return 1;
        }))))));
    }

    private static String[] getElementStream() {
        return (String[])Arrays.stream(new String[]{Element.PYRO.name(), Element.CRYO.name()}).toArray(String[]::new);
    }

    private static String[] getSpells() {
        return (String[])SpellsUtils.getStringSpells().toArray(String[]::new);
    }

    public static enum FullAction {
        set,
        add,
        take,
        get;

    }

    public static enum Action {
        set,
        add,
        take;

    }

    public static enum GetSetAction {
        set;

    }
}

