/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.renderer.tiles;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.components.Animation;
import it.mralxart.etheria.epicora.animations.components.AnimationSet;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.components.LoopMode;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.animations.controller.AnimationLayer;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.magic.trial.TrialType;
import it.mralxart.etheria.tiles.TrialTile;
import it.mralxart.etheria.utils.RenderUtils;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrialRenderer
implements BlockEntityRenderer<TrialTile> {
    private final EntityRenderDispatcher entityRenderer;
    public static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::m_234223_);
    public static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    public static final Function<ResourceLocation, RenderType> RENDER_TYPE_FUNCTION = Util.m_143827_(texture -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.m_173215_((String)"glowing_layer", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(SHADER_STATE).m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110685_(RenderUtils.ADDITIVE_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(new ResourceLocation("etheria", "textures/block/trial_glow.png"), false, false)).m_110687_(WRITE_MASK).m_110691_(false));
    });
    final ResourceLocation texture = new ResourceLocation("etheria", "textures/block/trial.png");
    final ResourceLocation texture_glow = new ResourceLocation("etheria", "textures/block/trial_glow.png");

    public TrialRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.m_234446_();
    }

    public void render(TrialTile tile, float partialTicks, PoseStack poseStack, MultiBufferSource buf, int lighting, int overlay) {
        AnimationLayer layer;
        poseStack.m_85837_(0.5, 0.0, 0.5);
        GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/trial"));
        AnimationController controller = tile.getController();
        GeometryChanges changes = controller.apply(partialTicks);
        AnimationSet animations = AnimationStorage.getAnimations("trial");
        if (tile.trialType.equals((Object)TrialType.BEAM)) {
            if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46467_() >= tile.cooldownEndTime) {
                controller.startAnimation("inactive", animations.get("animation.trial.active"), LoopMode.LOOP);
            } else {
                controller.startAnimation("inactive", animations.get("animation.trial.inactive"), LoopMode.LOOP);
            }
        }
        model.applyAnimChanges(changes);
        model.renderModel(poseStack, buf.m_6299_(RenderType.m_110452_((ResourceLocation)this.texture)), lighting, overlay);
        if (tile.trialType.equals((Object)TrialType.BEAM)) {
            RenderType glowRenderType = RENDER_TYPE_FUNCTION.apply(this.texture_glow);
            model.renderModel(poseStack, buf.m_6299_(glowRenderType), 0xF00000, overlay);
        }
        if ((layer = tile.controller.getLayer("active")) != null && !layer.getAnimation().getAnimation().same(Animation.EMPTY)) {
            Entity entity;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.7f, 0.0f);
            RenderUtils.renderDragonEffect(poseStack, buf, (float)(Blaze3D.m_83640_() * 40.0), partialTicks, 0.4f, 0.7882353f, 0.58431375f, 0.9254902f, 42.0f);
            poseStack.m_85849_();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && tile.getEntityType() != null && (entity = tile.getEntityType().m_20615_((Level)level)) != null && tile.getEntityType() != null) {
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.5f, 0.0f);
                float g = 0.53125f;
                float h = Math.max(entity.m_20205_(), entity.m_20206_());
                if ((double)h > 1.0) {
                    g /= h;
                }
                poseStack.m_252880_(0.0f, 0.4f, 0.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)Mth.m_14139_((double)partialTicks, (double)((float)(Blaze3D.m_83640_() * 20.0)), (double)((float)(Blaze3D.m_83640_() * 20.0))) * 10.0f));
                poseStack.m_252880_(0.0f, -0.2f, 0.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
                poseStack.m_85841_(g, g, g);
                this.entityRenderer.m_114384_(entity, 0.0, 0.0, 0.0, 1.0f, partialTicks, poseStack, buf, lighting);
                poseStack.m_85849_();
            }
        }
    }
}

