/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.renderer.tiles;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.epicora.base.CustomTileRenderer;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.tiles.EtherPedestalTile;
import it.mralxart.etheria.utils.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class EtherPedestalRenderer
extends CustomTileRenderer<EtherPedestalTile> {
    public EtherPedestalRenderer(BlockEntityRendererProvider.Context context) {
        super("ether_pedestal");
    }

    @Override
    public ResourceLocation getTextureLocation(EtherPedestalTile block) {
        String textureName = BuiltInRegistries.f_256975_.m_7981_((Object)block.m_58900_().m_60734_()).m_135815_().split("_")[0];
        return new ResourceLocation("etheria", "textures/block/" + textureName + "_pedestal.png");
    }

    public void render(EtherPedestalTile tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.m_6922_(tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        String elementName = BuiltInRegistries.f_256975_.m_7981_((Object)tileEntity.m_58900_().m_60734_()).m_135815_().split("_")[0];
        Element element = Element.ofString(elementName);
        ItemStack stack = tileEntity.getItemStack();
        if (tileEntity.isBlocked()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            if (tileEntity.getProgress() > 160.0f) {
                Color color = ElementsUtils.getColorByElement(element);
                RenderUtils.renderDragonEffect(poseStack, buffer, (float)(Blaze3D.m_83640_() * 20.0), partialTicks, tileEntity.getProgress() / 300.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, tileEntity.randomId);
                poseStack.m_252880_(0.0f, -(tileEntity.getProgress() - 160.0f) / 400.0f, 0.0f);
            }
            poseStack.m_85849_();
            return;
        }
        if (tileEntity.getProgress() > 160.0f) {
            poseStack.m_85837_(0.5, 0.0, 0.5);
            Color color = ElementsUtils.getColorByElement(element);
            RenderUtils.renderDragonEffect(poseStack, buffer, (float)(Blaze3D.m_83640_() * 20.0), partialTicks, tileEntity.getProgress() / 300.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, tileEntity.randomId);
            poseStack.m_252880_(0.0f, -(tileEntity.getProgress() - 160.0f) / 400.0f, 0.0f);
        }
        if (stack == null || stack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.9, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)Blaze3D.m_83640_()));
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_115143_(stack, ItemDisplayContext.GROUND, true, poseStack, buffer, combinedLight, combinedOverlay, itemRenderer.m_174264_(stack, tileEntity.m_58904_(), null, 0));
        poseStack.m_85849_();
    }
}

