/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.renderer.tiles;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.epicora.base.CustomTileRenderer;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.items.EssenceItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.registry.ItemRegistry;
import it.mralxart.etheria.tiles.EtherAltarTile;
import it.mralxart.etheria.utils.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EtherAltarRenderer
extends CustomTileRenderer<EtherAltarTile> {
    public EtherAltarRenderer(BlockEntityRendererProvider.Context context) {
        super("ether_altar");
    }

    @Override
    public ResourceLocation getTextureLocation(EtherAltarTile block) {
        return new ResourceLocation("etheria", "textures/block/" + block.getElement().name().toLowerCase() + "_altar.png");
    }

    public void render(@NotNull EtherAltarTile tileEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        super.m_6922_(tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        ItemStack stack = tileEntity.getStack();
        if (tileEntity.getRitualManager().isBlocked()) {
            if (tileEntity.getRitualManager().getAltarElement().equals((Object)Element.CRYO)) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.5, 0.0, 0.5);
                if (tileEntity.getRitualManager().getTickCountUnlock() > 160) {
                    Color color = ElementsUtils.getColorByElement(Element.PYRO);
                    RenderUtils.renderDragonEffect(poseStack, buffer, (float)(Blaze3D.m_83640_() * 20.0), partialTicks, (float)tileEntity.getRitualManager().getTickCountUnlock() / 300.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 43.0f);
                    poseStack.m_252880_(0.0f, (float)(-(tileEntity.getRitualManager().getTickCountUnlock() - 160)) / 400.0f, 0.0f);
                }
                poseStack.m_85841_(1.3f, 1.3f, 1.3f);
                poseStack.m_252781_(Axis.f_252436_.m_252961_(20.0f));
                GeometryData model = GeometryStorage.getGeometry(new ResourceLocation("etheria", "geometry/ice_seal.geo.json"));
                model.renderModel(poseStack, buffer.m_6299_(RenderType.m_110470_((ResourceLocation)new ResourceLocation("etheria", "textures/block/ice_seal.png"))), combinedLight, OverlayTexture.f_118083_, 0.9f);
                poseStack.m_85849_();
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, -0.5, 0.0);
                poseStack.m_85841_(5.0f, 5.0f, 5.0f);
                poseStack.m_252781_(Axis.f_252436_.m_252961_(0.0f));
                model.renderModel(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)new ResourceLocation("etheria", "textures/block/ice_seal.png"))), combinedLight, OverlayTexture.f_118083_, 0.7f);
                poseStack.m_85849_();
            }
            if (tileEntity.getRitualManager().getAltarElement().equals((Object)Element.PYRO)) {
                // empty if block
            }
            return;
        }
        if (tileEntity.getRitualManager().getTickCountUnlock() > 160) {
            poseStack.m_85837_(0.5, 0.0, 0.5);
            Color color = ElementsUtils.getColorByElement(Element.ETHER);
            RenderUtils.renderDragonEffect(poseStack, buffer, (float)(Blaze3D.m_83640_() * 20.0), partialTicks, (float)tileEntity.getRitualManager().getTickCountUnlock() / 300.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 43.0f);
            poseStack.m_252880_(0.0f, (float)(-(tileEntity.getRitualManager().getTickCountUnlock() - 160)) / 400.0f, 0.0f);
        }
        if (tileEntity.getRitualManager().getTickCountEssence() > 200 && tileEntity.getRitualManager().getTickCountEssence() < 222) {
            poseStack.m_85836_();
            long time = System.currentTimeMillis();
            float angle = (float)(time % 3600L) / 10.0f;
            float yOffset = Mth.m_14031_((float)((float)Math.toRadians(angle))) * 0.09f;
            poseStack.m_85837_(0.5, 1.1 + (double)yOffset + 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252961_((float)Blaze3D.m_83640_()));
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            Element element = tileEntity.getRitualManager().getElement();
            ItemStack essence = switch (element) {
                default -> ((EssenceItem)ItemRegistry.ESSENCE_ETHER.get()).m_7968_();
                case Element.CRYO -> ((EssenceItem)ItemRegistry.ESSENCE_CRYO.get()).m_7968_();
                case Element.PYRO -> ((EssenceItem)ItemRegistry.ESSENCE_PYRO.get()).m_7968_();
            };
            itemRenderer.m_115143_(essence, ItemDisplayContext.GROUND, true, poseStack, buffer, 0xF000F0, combinedOverlay, itemRenderer.m_174264_(essence, tileEntity.m_58904_(), null, 0));
            poseStack.m_85849_();
        }
        if (stack == null || stack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.9, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)Blaze3D.m_83640_()));
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_115143_(stack, ItemDisplayContext.GROUND, true, poseStack, buffer, combinedLight, combinedOverlay, itemRenderer.m_174264_(stack, tileEntity.m_58904_(), null, 0));
        poseStack.m_85849_();
    }
}

