/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.renderer.bosses;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import it.mralxart.etheria.EtheriaClient;
import it.mralxart.etheria.bosses.golems.Aerolith;
import it.mralxart.etheria.client.particles.GlowingParticleData;
import it.mralxart.etheria.client.renderer.tiles.BeamEmitterRenderer;
import it.mralxart.etheria.epicora.animations.AnimationStorage;
import it.mralxart.etheria.epicora.animations.components.AnimationSet;
import it.mralxart.etheria.epicora.animations.components.GeometryChanges;
import it.mralxart.etheria.epicora.animations.controller.AnimationController;
import it.mralxart.etheria.epicora.geometry.GeometryStorage;
import it.mralxart.etheria.epicora.geometry.components.GeometryBone;
import it.mralxart.etheria.epicora.geometry.components.GeometryCube;
import it.mralxart.etheria.epicora.geometry.data.GeometryData;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.utils.ParticleUtils;
import it.mralxart.etheria.utils.RandomUtils;
import it.mralxart.etheria.utils.RenderUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class GaiaarRenderer
extends EntityRenderer<Aerolith> {
    public GaiaarRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(Aerolith p_114485_, float p_114486_, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        poseStack.m_85836_();
        GeometryData model = GeometryStorage.getGeometry("aerolith");
        AnimationController controller = p_114485_.getController();
        AnimationSet animations = AnimationStorage.getAnimations("aerolith");
        p_114485_.animations = animations.getAnimations();
        GeometryChanges changes = controller.apply(partialTicks);
        model.applyAnimChanges(changes);
        if (!p_114485_.getAction().equals("dash")) {
            this.headLook(p_114485_, model, partialTicks);
        }
        float animTimeIdle = controller.getLayer("idle").getAnimTime(controller.getLayer("idle").getAnimation(), controller.getControllerTime(partialTicks));
        if (controller.getLayer("idle").getAnimation().getAnimation().getKey().equals("animation.model.idle") && animTimeIdle >= 0.33f && (double)animTimeIdle <= 0.38 && Minecraft.m_91087_().f_91073_ != null) {
            Minecraft.m_91087_().f_91073_.m_5594_((Player)Minecraft.m_91087_().f_91074_, p_114485_.m_20183_(), SoundEvents.f_11893_, SoundSource.PLAYERS, 1.0f, 0.8f);
        }
        model.getBone("left_arm").setChildren(new ArrayList<GeometryBone>());
        model.getBone("left_arm").setCubes(new ArrayList<GeometryCube>());
        model.getBone("right_arm").setChildren(new ArrayList<GeometryBone>());
        model.getBone("right_arm").setCubes(new ArrayList<GeometryCube>());
        if (!Minecraft.m_91087_().m_91104_()) {
            model.getBone((String)"wing_placeholder_left").callback = (allBones, bone, poseStack1, worldPos) -> {
                Vec3 entityPos = p_114485_.m_20182_();
                worldPos.add((float)entityPos.f_82479_, (float)entityPos.f_82480_, (float)entityPos.f_82481_);
                Vec3 pos = new Vec3((double)worldPos.x, (double)worldPos.y, (double)worldPos.z);
                ParticleUtils.createParticle((Level)Minecraft.m_91087_().f_91073_, (ParticleOptions)ParticleTypes.f_123783_, pos, 2, 0.01, 0.01, 0.01, 0.001);
            };
            model.getBone((String)"wing_placeholder_right").callback = (allBones, bone, poseStack1, worldPos) -> {
                Vec3 entityPos = p_114485_.m_20182_();
                worldPos.add((float)entityPos.f_82479_, (float)entityPos.f_82480_, (float)entityPos.f_82481_);
                Vec3 pos = new Vec3((double)worldPos.x, (double)worldPos.y, (double)worldPos.z);
                ParticleUtils.createParticle((Level)Minecraft.m_91087_().f_91073_, (ParticleOptions)ParticleTypes.f_123783_, pos, 1, 0.01, 0.01, 0.01, 0.001);
            };
            model.getBone((String)"right_placeholder").callback = model.getBone((String)"left_placeholder").callback = (allBones, bone, poseStack1, worldPos) -> {
                float animTime;
                PoseStack poseStack2 = poseStack;
                Vec3 entityPos = p_114485_.m_20182_();
                worldPos.add((float)entityPos.f_82479_, (float)entityPos.f_82480_, (float)entityPos.f_82481_);
                Vec3 pos = new Vec3((double)worldPos.x, (double)worldPos.y, (double)worldPos.z);
                if (controller.getLayer("action").getAnimation().getAnimation().getKey().equals("animation.model.energy2") && (animTime = controller.getLayer("action").getAnimTime(controller.getLayer("action").getAnimation(), controller.getControllerTime(0.0f))) >= 0.25f && animTime <= 2.5f) {
                    ParticleUtils.drawParticlesToCenter(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO).getRGB(), Math.max(0.1f, RandomUtils.random().nextFloat() / 6.0f), 10 + RandomUtils.random().nextInt(3, 30), 0.025f, 1.0f), (Level)Minecraft.m_91087_().f_91073_, pos, 20, 0.3f, 0.01f, 0.01f);
                }
            };
            model.getBone((String)"black_hole").callback = (allBones, bone, poseStack1, worldPos) -> {
                if (Minecraft.m_91087_().m_91104_()) {
                    return;
                }
                Vec3 entityPos = p_114485_.m_20182_();
                worldPos.add((float)entityPos.f_82479_, (float)entityPos.f_82480_, (float)entityPos.f_82481_);
                Vec3 pos = new Vec3((double)worldPos.x, (double)worldPos.y, (double)worldPos.z);
                float animTime = controller.getLayer("black_hole").getAnimTime(controller.getLayer("black_hole").getAnimation(), controller.getControllerTime(0.0f));
                if (controller.getLayer("black_hole").getAnimation().getAnimation().getKey().equals("animation.model.black_hole") && animTime >= 0.25f || p_114485_.m_21525_()) {
                    ShaderInstance finalBLACK_HOLE_SHADER;
                    ParticleUtils.drawParticlesToCenterWithSpiral(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.AERO), RandomUtils.random().nextFloat(0.2f, 0.6f), (int)(60.0f + animTime * 0.5f), 0.025f + animTime * 0.005f), (Level)Minecraft.m_91087_().f_91073_, pos, p_114485_.m_20182_().f_82480_, (int)(2.0f + animTime * 0.4f), 12.0f, 0.01f + animTime * 0.01f, 0.5f);
                    if (animTime >= 20.0f) {
                        ParticleUtils.drawParticlesToCenterWithSpiral(new GlowingParticleData(ElementsUtils.getRandomColorByElement(Element.PYRO), RandomUtils.random().nextFloat(0.2f, 0.6f), (int)(60.0f + animTime * 0.5f), 0.025f + animTime * 0.005f), (Level)Minecraft.m_91087_().f_91073_, pos, p_114485_.m_20182_().f_82480_, (int)(1.0f + animTime * 0.4f), 12.0f, 0.01f + animTime * 0.01f, 0.5f);
                    }
                    if ((finalBLACK_HOLE_SHADER = EtheriaClient.getBLACK_HOLE_SHADER()) == null) {
                        try {
                            finalBLACK_HOLE_SHADER = EtheriaClient.BLACK_HOLE_SHADER = new ShaderInstance((ResourceProvider)Minecraft.m_91087_().m_91098_(), new ResourceLocation("etheria", "black_hole"), DefaultVertexFormat.f_85814_);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                    Minecraft mc = Minecraft.m_91087_();
                    Camera camera = mc.f_91063_.m_109153_();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.disableDepthTest();
                    RenderSystem.depthMask((boolean)false);
                    ShaderInstance finalfinalBLACK_HOLE_SHADER = finalBLACK_HOLE_SHADER;
                    RenderSystem.setShader(() -> finalfinalBLACK_HOLE_SHADER);
                    RenderSystem.activeTexture((int)33985);
                    RenderSystem.bindTexture((int)mc.m_91385_().m_83980_());
                    RenderSystem.activeTexture((int)33986);
                    mc.m_91097_().m_174784_(new ResourceLocation("etheria", "textures/noise.png"));
                    RenderSystem.activeTexture((int)33984);
                    if (finalfinalBLACK_HOLE_SHADER.m_173348_("DepthSampler") != null) {
                        finalfinalBLACK_HOLE_SHADER.m_173348_("DepthSampler").m_142617_(1);
                    }
                    if (finalfinalBLACK_HOLE_SHADER.m_173348_("NoiseSampler") != null) {
                        finalfinalBLACK_HOLE_SHADER.m_173348_("NoiseSampler").m_142617_(2);
                    }
                    Vec3 cameraPos = camera.m_90583_();
                    Vec3 corePos = pos;
                    float blackHoleScale = 0.0f;
                    if (animTime >= 0.5f && (double)animTime < 1.25) {
                        blackHoleScale = 0.6f;
                    } else if ((double)animTime >= 1.25) {
                        blackHoleScale = 0.7f + Math.min(8.0f, animTime * 0.07f);
                    }
                    finalfinalBLACK_HOLE_SHADER.m_173356_("CameraPosition").m_5889_((float)(cameraPos.f_82479_ - corePos.f_82479_), (float)(cameraPos.f_82480_ - corePos.f_82480_), (float)(cameraPos.f_82481_ - corePos.f_82481_));
                    Matrix3f rotationMatrix = new Matrix3f().identity();
                    finalfinalBLACK_HOLE_SHADER.m_173356_("BlackHoleRotation").m_200759_(rotationMatrix);
                    if (mc.f_91073_ != null) {
                        finalfinalBLACK_HOLE_SHADER.m_173356_("STime").m_5985_(((float)mc.f_91073_.m_46467_() + partialTicks) / 20.0f);
                    }
                    float breakProgress = 0.0f;
                    if (animTime >= 10.0f) {
                        breakProgress = animTime * 0.1f - 1.0f;
                    }
                    finalfinalBLACK_HOLE_SHADER.m_173356_("Quality").m_142617_(0);
                    finalfinalBLACK_HOLE_SHADER.m_173356_("BreakingProgress").m_5985_(breakProgress);
                    finalfinalBLACK_HOLE_SHADER.m_173356_("BlackHoleScale").m_5985_(blackHoleScale);
                    finalfinalBLACK_HOLE_SHADER.m_173356_("InverseTransformMatrix").m_5679_(new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_()).invert());
                    int fbWidth = mc.m_91268_().m_85441_();
                    int fbHeight = mc.m_91268_().m_85442_();
                    finalfinalBLACK_HOLE_SHADER.m_173356_("OutSize").m_7971_((float)fbWidth, (float)fbHeight);
                    finalfinalBLACK_HOLE_SHADER.m_173356_("ViewPort").m_142492_(0, 0, fbWidth, fbHeight);
                    double windowRatio = (double)fbWidth / (double)fbHeight;
                    double fov = Math.tan(Math.toRadians((double)((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue() / 2.0)) * 0.05;
                    double finalRatio = fov * windowRatio;
                    Vector3f front = camera.m_253058_().mul(0.05f, new Vector3f());
                    Vector3f left = camera.m_252775_().mul((float)finalRatio, new Vector3f());
                    Vector3f up = camera.m_253028_().mul((float)fov, new Vector3f());
                    Quaternionf yawRotation = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, EtheriaClient.ForgeEvents.lastShakeYaw);
                    Quaternionf pitchRotation = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, EtheriaClient.ForgeEvents.lastShakePitch);
                    Quaternionf rollRotation = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, EtheriaClient.ForgeEvents.lastShakeRoll);
                    front.rotate((Quaternionfc)yawRotation).rotate((Quaternionfc)pitchRotation).rotate((Quaternionfc)rollRotation);
                    left.rotate((Quaternionfc)yawRotation).rotate((Quaternionfc)pitchRotation).rotate((Quaternionfc)rollRotation);
                    up.rotate((Quaternionfc)yawRotation).rotate((Quaternionfc)pitchRotation).rotate((Quaternionfc)rollRotation);
                    finalfinalBLACK_HOLE_SHADER.m_173356_("CameraFront").m_5889_(front.x(), front.y(), front.z());
                    finalfinalBLACK_HOLE_SHADER.m_173356_("CameraLeft").m_5889_(left.x(), left.y(), left.z());
                    finalfinalBLACK_HOLE_SHADER.m_173356_("CameraUp").m_5889_(up.x(), up.y(), up.z());
                    Matrix4f backupProjection = RenderSystem.getProjectionMatrix();
                    RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)fbWidth, (float)fbHeight, 0.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.f_276633_);
                    Tesselator tessellator = Tesselator.m_85913_();
                    BufferBuilder buffer = tessellator.m_85915_();
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                    buffer.m_5483_(0.0, (double)fbHeight, 0.0).m_5752_();
                    buffer.m_5483_((double)fbWidth, (double)fbHeight, 0.0).m_5752_();
                    buffer.m_5483_((double)fbWidth, 0.0, 0.0).m_5752_();
                    buffer.m_5483_(0.0, 0.0, 0.0).m_5752_();
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
                    RenderSystem.setProjectionMatrix((Matrix4f)backupProjection, (VertexSorting)VertexSorting.f_276633_);
                    RenderSystem.enableDepthTest();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.disableBlend();
                }
            };
        }
        poseStack.m_252781_(Axis.f_252392_.m_252977_(p_114485_.f_20883_ - 180.0f));
        float deathTime = controller.getLayer("death").getAnimTime(controller.getLayer("death").getAnimation(), controller.getControllerTime(partialTicks));
        if (controller.getLayer("death").getAnimation().getAnimation().getKey().equals("animation.model.energy3") && deathTime >= 0.05f && deathTime <= 3.0f) {
            PoseStack particleStack = new PoseStack();
            float rawProgress = (deathTime - 0.05f) / 1.95f;
            float progress = Mth.m_14036_((float)rawProgress, (float)0.0f, (float)1.0f);
            float resultProgress = progress * progress;
            particleStack.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14189_((float)partialTicks, (float)p_114485_.f_20884_, (float)p_114485_.f_20883_) - 180.0f));
            this.spawnSurfaceParticles(p_114485_, model, particleStack, partialTicks, resultProgress);
        }
        model.renderModel(poseStack, bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("etheria", "textures/entity/aerolith2.png"))), packedLightIn, OverlayTexture.f_118083_);
        if (p_114485_.getShield() != -1) {
            Function function = Util.m_143827_(textureGlow -> {
                RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(textureGlow, false, false);
                return RenderType.m_173215_((String)"glowing_layer", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(BeamEmitterRenderer.SHADER_STATE).m_173290_((RenderStateShard.EmptyTextureStateShard)textureState).m_110685_(RenderUtils.ADDITIVE_TRANSPARENCY).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureGlow, false, false)).m_110687_(BeamEmitterRenderer.WRITE_MASK).m_110691_(false));
            });
            RenderType glowRenderType = (RenderType)function.apply(new ResourceLocation("etheria", "textures/entity/aerolith2_e.png"));
            model.renderModel(poseStack, bufferSource.m_6299_(glowRenderType), 0xF00000, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_252781_(Axis.f_252392_.m_252977_(p_114485_.f_20883_ - 180.0f));
        model.renderModel(poseStack2);
    }

    private void spawnSurfaceParticles(Aerolith entity, GeometryData model, PoseStack poseStack, float partialTicks, float progress) {
        for (GeometryBone topBone : model.getTopBones().values()) {
            if (topBone.getName().equalsIgnoreCase("hitbox")) continue;
            this.processBoneRecursively(entity, topBone, model.getBones(), poseStack, partialTicks, progress);
        }
    }

    private void processBoneRecursively(Aerolith entity, GeometryBone bone, Map<String, GeometryBone> allBones, PoseStack poseStack, float partialTicks, float progress) {
        GeometryBone animBone = allBones.getOrDefault(bone.getName(), bone);
        poseStack.m_85836_();
        Vector3f bonePos = animBone.getPos();
        if (!bonePos.equals((Object)new Vector3f(0.0f, 0.0f, 0.0f))) {
            poseStack.m_252880_(-bonePos.x() / 16.0f, -bonePos.y() / 16.0f, bonePos.z() / 16.0f);
        }
        Vector3f pivot = bone.getPivot();
        poseStack.m_252880_(pivot.x() / 16.0f, pivot.y() / 16.0f, pivot.z() / 16.0f);
        Vector3f rot = animBone.getRotation();
        Quaternionf rotationQuat = new Quaternionf().rotateZYX(rot.z(), -rot.y(), rot.x());
        poseStack.m_252781_(rotationQuat);
        Vector3f scale = animBone.getScale();
        if (scale.x() != 1.0f || scale.y() != 1.0f || scale.z() != 1.0f) {
            poseStack.m_85841_(scale.x(), scale.y(), scale.z());
        }
        poseStack.m_252880_(-pivot.x() / 16.0f, -pivot.y() / 16.0f, -pivot.z() / 16.0f);
        Matrix4f poseMatrix = poseStack.m_85850_().m_252922_();
        Random random = RandomUtils.random();
        for (GeometryCube cube : bone.getCubes()) {
            int actualCount;
            float areaYZ;
            float sizeZ;
            float areaXZ;
            float sizeY;
            float sizeX = cube.getSize().x() / 16.0f;
            float areaXY = sizeX * (sizeY = cube.getSize().y() / 16.0f);
            float totalArea = 2.0f * (areaXY + (areaXZ = sizeX * (sizeZ = cube.getSize().z() / 16.0f)) + (areaYZ = sizeY * sizeZ));
            int baseCount = (int)Math.ceil(totalArea / 0.6f);
            if (baseCount > 25) {
                baseCount = 25;
            }
            if ((actualCount = (int)((float)baseCount * progress)) == 0 && progress > 0.05f && random.nextFloat() < progress) {
                actualCount = 1;
            }
            for (int i = 0; i < actualCount; ++i) {
                Vector3f localPoint = this.getPoint(cube.getOrigin(), sizeX, sizeY, sizeZ, areaXY, areaXZ, areaYZ, totalArea, random);
                Vector4f vector4f = new Vector4f(localPoint.x(), localPoint.y(), localPoint.z(), 1.0f);
                vector4f.mul((Matrix4fc)poseMatrix);
                double entityX = Mth.m_14139_((double)partialTicks, (double)entity.f_19854_, (double)entity.m_20185_());
                double entityY = Mth.m_14139_((double)partialTicks, (double)entity.f_19855_, (double)entity.m_20186_());
                double entityZ = Mth.m_14139_((double)partialTicks, (double)entity.f_19856_, (double)entity.m_20189_());
                double worldX = entityX + (double)vector4f.x();
                double worldY = entityY + (double)vector4f.y();
                double worldZ = entityZ + (double)vector4f.z();
                int[] colors = new int[]{new Color(213, 185, 237).getRGB(), new Color(253, 249, 255).getRGB(), new Color(190, 153, 222).getRGB()};
                int color = colors[random.nextInt(colors.length)];
                float time = ((float)entity.f_19797_ + partialTicks) * 0.1f;
                float waveFrequency = 1.5f;
                float waveX = (float)Math.sin((double)time + worldY * (double)waveFrequency) * 0.02f;
                float waveZ = (float)Math.cos((double)time + worldY * (double)waveFrequency * (double)0.8f) * 0.02f;
                float driftX = 0.015f;
                float driftZ = 0.01f;
                float upSpeed = 0.03f + random.nextFloat() * 0.04f;
                float motionX = driftX + waveX + (random.nextFloat() - 0.5f) * 0.04f;
                float motionY = upSpeed;
                float motionZ = driftZ + waveZ + (random.nextFloat() - 0.5f) * 0.04f;
                ParticleUtils.createParticle(entity.m_9236_(), new GlowingParticleData(color, 0.1f + random.nextFloat() * 0.1f, 50 + random.nextInt(40), 0.025f, 0.75f, 1.05f, true, false, false), new Vec3(worldX, worldY, worldZ), 0, motionX, motionY, motionZ, 0.2f);
            }
        }
        for (GeometryBone child : bone.getChildren()) {
            this.processBoneRecursively(entity, child, allBones, poseStack, partialTicks, progress);
        }
        poseStack.m_85849_();
    }

    private Vector3f getPoint(Vector3f origin, float sX, float sY, float sZ, float areaXY, float areaXZ, float areaYZ, float totalArea, Random random) {
        float z;
        float y;
        float x;
        float r = random.nextFloat() * (totalArea / 2.0f);
        boolean isMaxFace = random.nextBoolean();
        if (r < areaXY) {
            x = random.nextFloat() * sX;
            y = random.nextFloat() * sY;
            z = isMaxFace ? sZ : 0.0f;
        } else if (r < areaXY + areaXZ) {
            x = random.nextFloat() * sX;
            y = isMaxFace ? sY : 0.0f;
            z = random.nextFloat() * sZ;
        } else {
            x = isMaxFace ? sX : 0.0f;
            y = random.nextFloat() * sY;
            z = random.nextFloat() * sZ;
        }
        return new Vector3f(origin.x() + x, origin.y() + y, origin.z() + z);
    }

    public void headLook(Aerolith entity, GeometryData model, float partialTicks) {
        boolean shouldSit;
        GeometryBone bone = model.getBone("h_head");
        if (bone == null) {
            return;
        }
        float initialPitch = bone.getRotation().x();
        float initialYaw = bone.getRotation().y();
        float initialRoll = bone.getRotation().z();
        boolean falling = entity.m_21256_() > 4;
        boolean swimming = entity.m_6067_();
        float swimAmount = entity.m_20998_(partialTicks);
        float bodyYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float headYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
        float netHeadYaw = headYaw - bodyYaw;
        float headPitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        boolean bl = shouldSit = entity.m_20159_() && entity.m_20202_() instanceof LivingEntity;
        if (shouldSit) {
            LivingEntity vehicle = (LivingEntity)entity.m_20202_();
            bodyYaw = Mth.m_14189_((float)partialTicks, (float)vehicle.f_20884_, (float)vehicle.f_20883_);
            netHeadYaw = headYaw - bodyYaw;
            netHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
        }
        float finalPitch = headPitch;
        if (falling) {
            finalPitch = 45.0f;
        } else if (swimAmount > 0.0f && swimming) {
            finalPitch = Mth.m_14179_((float)swimAmount, (float)headPitch, (float)45.0f);
        }
        bone.setRotationY(initialYaw + (float)Math.PI / 180 * netHeadYaw);
        bone.setRotationX(initialPitch + (float)Math.PI / 180 * finalPitch);
        bone.setRotationZ(initialRoll);
    }

    private Vector3f lerp(Vector3f start, Vector3f end, float progress) {
        return start != null && end != null && !Float.isNaN(progress) ? new Vector3f(Mth.m_14179_((float)progress, (float)start.x(), (float)end.x()), Mth.m_14179_((float)progress, (float)start.y(), (float)end.y()), Mth.m_14179_((float)progress, (float)start.z(), (float)end.z())) : new Vector3f(0.0f, 0.0f, 0.0f);
    }

    private float lerpRad(float angle, float maxAngle, float mul) {
        float var = (mul - maxAngle) % ((float)Math.PI * 2);
        if (var < (float)(-Math.PI)) {
            var += (float)Math.PI * 2;
        }
        if (var >= (float)Math.PI) {
            var -= (float)Math.PI * 2;
        }
        return maxAngle + angle * var;
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull Aerolith entity) {
        return new ResourceLocation("etheria", "textures/bosses/golems/gaiaar.png");
    }
}

