/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles.data;

import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractParticle {
    private ResourceLocation texture;
    private final Color color;
    private final float xStart;
    private final float yStart;
    public final int maxLifeTime;
    public int lifeTime;
    private float scale;
    private float x;
    private float y;
    private float z;
    private float deltaX;
    private float deltaY;
    private boolean isRemoved;

    public AbstractParticle(ResourceLocation texture, float xStart, float yStart, float scale, int lifeTime, Color color) {
        this.texture = texture;
        this.color = color;
        this.xStart = xStart;
        this.yStart = yStart;
        this.scale = scale;
        this.lifeTime = 0;
        this.maxLifeTime = lifeTime;
        this.x = xStart;
        this.y = yStart;
        this.z = 0.0f;
        this.isRemoved = false;
    }

    public void remove() {
        this.isRemoved = true;
    }

    public abstract void tick(Screen var1);

    public abstract void render(Screen var1, GuiGraphics var2, int var3, int var4, float var5);

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public Color getColor() {
        return this.color;
    }

    public float getXStart() {
        return this.xStart;
    }

    public float getYStart() {
        return this.yStart;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public float getScale() {
        return this.scale;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getDeltaX() {
        return this.deltaX;
    }

    public float getDeltaY() {
        return this.deltaY;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setDeltaX(float deltaX) {
        this.deltaX = deltaX;
    }

    public void setDeltaY(float deltaY) {
        this.deltaY = deltaY;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractParticle)) {
            return false;
        }
        AbstractParticle other = (AbstractParticle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getXStart(), other.getXStart()) != 0) {
            return false;
        }
        if (Float.compare(this.getYStart(), other.getYStart()) != 0) {
            return false;
        }
        if (this.getMaxLifeTime() != other.getMaxLifeTime()) {
            return false;
        }
        if (this.getLifeTime() != other.getLifeTime()) {
            return false;
        }
        if (Float.compare(this.getScale(), other.getScale()) != 0) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getDeltaX(), other.getDeltaX()) != 0) {
            return false;
        }
        if (Float.compare(this.getDeltaY(), other.getDeltaY()) != 0) {
            return false;
        }
        if (this.isRemoved() != other.isRemoved()) {
            return false;
        }
        ResourceLocation this$texture = this.getTexture();
        ResourceLocation other$texture = other.getTexture();
        if (this$texture == null ? other$texture != null : !this$texture.equals(other$texture)) {
            return false;
        }
        Color this$color = this.getColor();
        Color other$color = other.getColor();
        return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractParticle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getXStart());
        result = result * 59 + Float.floatToIntBits(this.getYStart());
        result = result * 59 + this.getMaxLifeTime();
        result = result * 59 + this.getLifeTime();
        result = result * 59 + Float.floatToIntBits(this.getScale());
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        result = result * 59 + Float.floatToIntBits(this.getDeltaX());
        result = result * 59 + Float.floatToIntBits(this.getDeltaY());
        result = result * 59 + (this.isRemoved() ? 79 : 97);
        ResourceLocation $texture = this.getTexture();
        result = result * 59 + ($texture == null ? 43 : $texture.hashCode());
        Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractParticle(texture=" + String.valueOf(this.getTexture()) + ", color=" + String.valueOf(this.getColor()) + ", xStart=" + this.getXStart() + ", yStart=" + this.getYStart() + ", maxLifeTime=" + this.getMaxLifeTime() + ", lifeTime=" + this.getLifeTime() + ", scale=" + this.getScale() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", deltaX=" + this.getDeltaX() + ", deltaY=" + this.getDeltaY() + ", isRemoved=" + this.isRemoved() + ")";
    }
}

