/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.data.AbstractParticle;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScreenGlowingParticle
extends AbstractParticle {
    private float quadSize;
    private float roll;
    private float oRoll;
    private float rotationSpeed;
    public float lineProgress;
    private float xOffset = (new Random().nextFloat() - 0.5f) * 2.0f;
    private float xSpeed = 0.1f + new Random().nextFloat() * 0.2f;
    private float xDirection = new Random().nextFloat() > 0.5f ? 1.0f : -1.0f;
    private float nextDirectionChange = 20.0f + new Random().nextFloat() * 60.0f;

    public ScreenGlowingParticle(float xStart, float yStart, float deltaX, float deltaY, float scale, int lifeTime, float rotationSpeed, Color color) {
        super(new ResourceLocation("etheria", "textures/particle/glow.png"), xStart, yStart, scale, lifeTime, color);
        this.rotationSpeed = rotationSpeed;
        this.setDeltaX(deltaX);
        this.setDeltaY(deltaY);
        this.quadSize = 0.0f;
    }

    public void updatePosition() {
        if ((float)this.getLifeTime() > this.nextDirectionChange) {
            this.xDirection *= -1.0f;
            this.nextDirectionChange = (float)this.getLifeTime() + 60.0f + new Random().nextFloat() * 90.0f;
            this.xSpeed = 0.1f + new Random().nextFloat() * 0.15f;
        }
        this.xOffset += (this.xDirection * this.xSpeed - this.xOffset) * 0.05f;
        this.setX(this.getX() + this.xOffset * 0.4f);
        float ySpeed = 0.2f * (0.9f + new Random().nextFloat() * 0.2f);
        this.setY(this.getY() - ySpeed);
    }

    @Override
    public void tick(Screen screen) {
        this.applyRotation();
        float xo = this.getX();
        float yo = this.getY();
        float zo = this.getZ();
        this.setX(xo + this.getDeltaX());
        this.setY(yo + this.getDeltaY());
        this.setZ(zo);
        float sizeFactor = Math.max(0.0f, (float)(this.getMaxLifeTime() - this.lifeTime) / (float)this.getMaxLifeTime());
        this.quadSize = this.getScale() * sizeFactor;
        if (this.quadSize <= 0.05f) {
            this.remove();
            return;
        }
        if (++this.lifeTime >= this.getMaxLifeTime()) {
            this.remove();
        }
        this.updatePosition();
    }

    private void applyRotation() {
        this.oRoll = this.roll;
        this.roll += this.rotationSpeed;
    }

    @Override
    public void render(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)771);
        Color currentColor = this.getColor();
        float[] hsv = new float[3];
        Color.RGBtoHSB(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), hsv);
        float offset = 0.1f + (float)(Math.sin(((float)this.getLifeTime() + partialTick) * 0.4f) * (double)0.4f);
        hsv[2] = Math.min(1.0f, Math.max(0.7f, hsv[2] + offset));
        int rgb = Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]);
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)0.7f);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float interpolatedX = Mth.m_14179_((float)partialTick, (float)(this.getX() - this.getDeltaX()), (float)this.getX());
        float interpolatedY = Mth.m_14179_((float)partialTick, (float)(this.getY() - this.getDeltaY()), (float)this.getY());
        poseStack.m_85841_(this.quadSize, this.quadSize, 100.0f);
        poseStack.m_252880_((interpolatedX + 8.0f) / this.quadSize, (interpolatedY + 8.0f) / this.quadSize, 0.0f);
        float interpolatedRoll = Mth.m_14179_((float)partialTick, (float)this.oRoll, (float)this.roll);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(interpolatedRoll));
        guiGraphics.m_280163_(this.getTexture(), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        poseStack.m_85849_();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

