/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.particles.data.AbstractParticle;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class KorLunarParticle
extends AbstractParticle {
    private float quadSize;
    private float roll;
    private float oRoll;
    private float rotationSpeed;
    private Random random = new Random();

    public KorLunarParticle(float xStart, float yStart, float deltaX, float deltaY, float scale, int lifeTime, float rotationSpeed, Color color) {
        super(new ResourceLocation("minecraft", "textures/particle/cherry_1.png"), xStart, yStart, scale, lifeTime, color);
        this.rotationSpeed = rotationSpeed;
        this.setDeltaX(deltaX);
        this.setDeltaY(deltaY);
        this.quadSize = 0.0f;
        this.setTexture(new ResourceLocation("minecraft", "textures/particle/cherry_" + this.random.nextInt(0, 11) + ".png"));
    }

    @Override
    public void tick(Screen screen) {
        this.applyRotation();
        float xo = this.getX();
        float yo = this.getY();
        float zo = this.getZ();
        this.setX(xo + this.getDeltaX());
        this.setY(yo + this.getDeltaY());
        this.setZ(zo);
        float sizeFactor = Math.max(0.0f, (float)(this.getMaxLifeTime() - this.lifeTime) / (float)this.getMaxLifeTime());
        this.quadSize = this.getScale() * sizeFactor;
        if (this.quadSize <= 0.05f) {
            this.remove();
            return;
        }
        if (++this.lifeTime >= this.getMaxLifeTime()) {
            this.remove();
        }
    }

    private void applyRotation() {
        this.oRoll = this.roll;
        this.roll += this.rotationSpeed;
    }

    @Override
    public void render(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        float interpolatedX = Mth.m_14179_((float)partialTick, (float)(this.getX() - this.getDeltaX()), (float)this.getX());
        float interpolatedY = Mth.m_14179_((float)partialTick, (float)(this.getY() - this.getDeltaY()), (float)this.getY());
        poseStack.m_85841_(this.quadSize, this.quadSize, 1.0f);
        poseStack.m_252880_((interpolatedX + 8.0f) / this.quadSize, (interpolatedY + 8.0f) / this.quadSize, 0.0f);
        float interpolatedRoll = Mth.m_14179_((float)partialTick, (float)this.oRoll, (float)this.roll);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(interpolatedRoll));
        guiGraphics.m_280163_(this.getTexture(), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }
}

