/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.mralxart.etheria.registry.ParticleRegistry;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GlowingParticleData
implements ParticleOptions {
    private final int rgbColor;
    private final float size;
    private final int lifespan;
    private final float rotationSpeed;
    private final float alpha;
    private final boolean staticSize;
    private boolean optimized = true;
    private boolean physic = false;
    private float modify = 1.0f;
    public static final Codec<GlowingParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("rgbColor").forGetter(data -> data.rgbColor), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size)), (App)Codec.INT.fieldOf("lifespan").forGetter(data -> data.lifespan), (App)Codec.FLOAT.fieldOf("rotationSpeed").forGetter(data -> Float.valueOf(data.rotationSpeed)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(data -> Float.valueOf(data.alpha)), (App)Codec.FLOAT.fieldOf("modify").forGetter(data -> Float.valueOf(data.modify)), (App)Codec.BOOL.fieldOf("staticSize").forGetter(data -> data.staticSize), (App)Codec.BOOL.fieldOf("optimized").forGetter(data -> data.optimized), (App)Codec.BOOL.fieldOf("physic").forGetter(data -> data.physic)).apply((Applicative)instance, GlowingParticleData::new));
    public static final ParticleOptions.Deserializer<GlowingParticleData> DESERIALIZER = new ParticleOptions.Deserializer<GlowingParticleData>(){

        @Nonnull
        public GlowingParticleData fromCommand(@Nonnull ParticleType<GlowingParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int rgbColor = reader.readInt();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            int lifespan = reader.readInt();
            reader.expect(' ');
            float rotationSpeed = reader.readFloat();
            reader.expect(' ');
            float alpha = reader.readFloat();
            reader.expect(' ');
            float modify = reader.readFloat();
            reader.expect(' ');
            boolean small = reader.readBoolean();
            reader.expect(' ');
            boolean optimized = reader.readBoolean();
            reader.expect(' ');
            boolean physic = reader.readBoolean();
            return new GlowingParticleData(rgbColor, size, lifespan, rotationSpeed, alpha, modify, small, optimized, physic);
        }

        @NotNull
        public GlowingParticleData fromNetwork(@Nonnull ParticleType<GlowingParticleData> type, FriendlyByteBuf buffer) {
            int rgbColor = buffer.readInt();
            float size = buffer.readFloat();
            int lifespan = buffer.readInt();
            float rotationSpeed = buffer.readFloat();
            float alpha = buffer.readFloat();
            float modify = buffer.readFloat();
            boolean small = buffer.readBoolean();
            boolean optimized = buffer.readBoolean();
            boolean physic = buffer.readBoolean();
            return new GlowingParticleData(rgbColor, size, lifespan, rotationSpeed, alpha, modify, small, optimized, physic);
        }
    };

    public GlowingParticleData(int color, float size, int lifespan, float rotationSpeed, float alpha) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = alpha;
        this.staticSize = true;
    }

    public GlowingParticleData(Color color, float size, int lifespan, float rotationSpeed) {
        this.rgbColor = color.getRGB();
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = true;
    }

    public GlowingParticleData(int color, float size, int lifespan, float rotationSpeed) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = true;
    }

    public GlowingParticleData(Color color, float size, int lifespan, float rotationSpeed, boolean small) {
        this.rgbColor = color.getRGB();
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = small;
    }

    public GlowingParticleData(int color, float size, int lifespan, float rotationSpeed, boolean small) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = small;
    }

    public GlowingParticleData(int color, float size, int lifespan, float rotationSpeed, float alpha, boolean small, boolean optimized, boolean physic) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = alpha;
        this.staticSize = small;
        this.optimized = optimized;
        this.physic = physic;
    }

    public GlowingParticleData(int color, float size, int lifespan, float rotationSpeed, float alpha, float modify, boolean small, boolean optimized, boolean physic) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = alpha;
        this.staticSize = small;
        this.optimized = optimized;
        this.physic = physic;
        this.modify = modify;
    }

    public GlowingParticleData setOptimized(boolean optimized) {
        this.optimized = optimized;
        return this;
    }

    public GlowingParticleData setPhysic(boolean physic) {
        this.physic = physic;
        return this;
    }

    @Nonnull
    public ParticleType<GlowingParticleData> m_6012_() {
        return (ParticleType)ParticleRegistry.GLOW_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.rgbColor);
        buffer.writeFloat(this.size);
        buffer.writeInt(this.lifespan);
        buffer.writeFloat(this.rotationSpeed);
        buffer.writeFloat(this.alpha);
        buffer.writeFloat(this.modify);
        buffer.writeBoolean(this.staticSize);
        buffer.writeBoolean(this.optimized);
        buffer.writeBoolean(this.physic);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f %d %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.rgbColor, Float.valueOf(this.size), this.lifespan, Float.valueOf(this.rotationSpeed));
    }

    public int getRgbColor() {
        return this.rgbColor;
    }

    public float getSize() {
        return this.size;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public boolean isStaticSize() {
        return this.staticSize;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public boolean isPhysic() {
        return this.physic;
    }

    public float getModify() {
        return this.modify;
    }

    public void setModify(float modify) {
        this.modify = modify;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlowingParticleData)) {
            return false;
        }
        GlowingParticleData other = (GlowingParticleData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRgbColor() != other.getRgbColor()) {
            return false;
        }
        if (Float.compare(this.getSize(), other.getSize()) != 0) {
            return false;
        }
        if (this.getLifespan() != other.getLifespan()) {
            return false;
        }
        if (Float.compare(this.getRotationSpeed(), other.getRotationSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        if (this.isStaticSize() != other.isStaticSize()) {
            return false;
        }
        if (this.isOptimized() != other.isOptimized()) {
            return false;
        }
        if (this.isPhysic() != other.isPhysic()) {
            return false;
        }
        return Float.compare(this.getModify(), other.getModify()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlowingParticleData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRgbColor();
        result = result * 59 + Float.floatToIntBits(this.getSize());
        result = result * 59 + this.getLifespan();
        result = result * 59 + Float.floatToIntBits(this.getRotationSpeed());
        result = result * 59 + Float.floatToIntBits(this.getAlpha());
        result = result * 59 + (this.isStaticSize() ? 79 : 97);
        result = result * 59 + (this.isOptimized() ? 79 : 97);
        result = result * 59 + (this.isPhysic() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getModify());
        return result;
    }

    public String toString() {
        return "GlowingParticleData(rgbColor=" + this.getRgbColor() + ", size=" + this.getSize() + ", lifespan=" + this.getLifespan() + ", rotationSpeed=" + this.getRotationSpeed() + ", alpha=" + this.getAlpha() + ", staticSize=" + this.isStaticSize() + ", optimized=" + this.isOptimized() + ", physic=" + this.isPhysic() + ", modify=" + this.getModify() + ")";
    }
}

