/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.mralxart.etheria.config.EtheriaConfig;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DamageTextParticle
extends Particle {
    private String text;
    private final boolean isCrit;
    private final int color;
    private final int endColor;
    private static final int LIFE_TIME = 25;

    public DamageTextParticle(ClientLevel level, double x, double y, double z, float damage, boolean isCrit, Element element) {
        super(level, x, y, z);
        this.f_107225_ = 25;
        this.f_107226_ = 0.05f;
        this.f_107219_ = false;
        this.text = damage == (float)((long)damage) ? String.valueOf((long)damage) : String.format("%.1f", Float.valueOf(damage));
        this.isCrit = isCrit;
        if (isCrit) {
            this.text = "!" + this.text;
        }
        this.color = ElementsUtils.getColorByElement(element).getRGB();
        this.endColor = ElementsUtils.getEndColorByElement(element).getRGB();
        this.f_107215_ = (Math.random() - 0.5) * 0.05;
        this.f_107216_ = 0.15;
        this.f_107217_ = (Math.random() - 0.5) * 0.05;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.008;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= 0.98;
            this.f_107216_ *= 0.98;
            this.f_107217_ *= 0.98;
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        if (!((Boolean)EtheriaConfig.CLIENT.showElementalDamage.get()).booleanValue()) {
            return;
        }
        Vec3 camPos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y + 0.5f, z);
        poseStack.m_252781_(camera.m_253121_());
        float baseScale = -0.035f;
        poseStack.m_85841_(baseScale, baseScale, baseScale);
        float progress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        float scaleCurve = this.getElasticOut(progress);
        float multiplier = this.isCrit ? 3.5f : 2.0f;
        float currentScale = scaleCurve * multiplier;
        poseStack.m_85841_(currentScale, currentScale, currentScale);
        float alphaVal = 1.0f;
        if (progress > 0.7f) {
            alphaVal = 1.0f - (progress - 0.7f) * 3.33f;
        }
        alphaVal = Mth.m_14036_((float)alphaVal, (float)0.0f, (float)1.0f);
        int alphaInt = (int)(alphaVal * 255.0f) << 24;
        int textC = 0xFFFFFF | alphaInt;
        int shadowC = this.endColor & 0xFFFFFF | alphaInt;
        Font font = Minecraft.m_91087_().f_91062_;
        float width = (float)font.m_92895_(this.text) / 2.0f;
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));
        poseStack.m_85836_();
        poseStack.m_252880_(-0.8f, -0.8f, 0.01f);
        font.m_271703_(this.text, -width, 0.0f, textC, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
        poseStack.m_252880_(0.0f, 0.0f, -0.01f);
        font.m_271703_(this.text, -width, 0.0f, shadowC, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffers.m_109911_();
        poseStack.m_85849_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
        RenderSystem.setShader(GameRenderer::m_172829_);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private float getElasticOut(float t) {
        float p = 0.3f;
        if (t < 0.2f) {
            float st = t / 0.2f;
            return (float)(Math.pow(2.0, -10.0f * st) * Math.sin((double)(st - p / 4.0f) * (Math.PI * 2) / (double)p) + 1.0);
        }
        return 1.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }
}

