/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.mralxart.etheria.registry.ParticleRegistry;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BlockParticleData
implements ParticleOptions {
    private final int rgbColor;
    private final float size;
    private final int lifespan;
    private final float rotationSpeed;
    private final float alpha;
    private final boolean staticSize;
    private boolean optimized = true;
    private boolean physic = false;
    public static final Codec<BlockParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("rgbColor").forGetter(data -> data.rgbColor), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size)), (App)Codec.INT.fieldOf("lifespan").forGetter(data -> data.lifespan), (App)Codec.FLOAT.fieldOf("rotationSpeed").forGetter(data -> Float.valueOf(data.rotationSpeed)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(data -> Float.valueOf(data.alpha)), (App)Codec.BOOL.fieldOf("staticSize").forGetter(data -> data.staticSize), (App)Codec.BOOL.fieldOf("optimized").forGetter(data -> data.optimized), (App)Codec.BOOL.fieldOf("physic").forGetter(data -> data.physic)).apply((Applicative)instance, BlockParticleData::new));
    public static final ParticleOptions.Deserializer<BlockParticleData> DESERIALIZER = new ParticleOptions.Deserializer<BlockParticleData>(){

        @Nonnull
        public BlockParticleData fromCommand(@Nonnull ParticleType<BlockParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int rgbColor = reader.readInt();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            int lifespan = reader.readInt();
            reader.expect(' ');
            float rotationSpeed = reader.readFloat();
            reader.expect(' ');
            float alpha = reader.readFloat();
            reader.expect(' ');
            boolean small = reader.readBoolean();
            reader.expect(' ');
            boolean optimized = reader.readBoolean();
            reader.expect(' ');
            boolean physic = reader.readBoolean();
            return new BlockParticleData(rgbColor, size, lifespan, rotationSpeed, alpha, small, optimized, physic);
        }

        @NotNull
        public BlockParticleData fromNetwork(@Nonnull ParticleType<BlockParticleData> type, FriendlyByteBuf buffer) {
            int rgbColor = buffer.readInt();
            float size = buffer.readFloat();
            int lifespan = buffer.readInt();
            float rotationSpeed = buffer.readFloat();
            float alpha = buffer.readFloat();
            boolean small = buffer.readBoolean();
            boolean optimized = buffer.readBoolean();
            boolean physic = buffer.readBoolean();
            return new BlockParticleData(rgbColor, size, lifespan, rotationSpeed, alpha, small, optimized, physic);
        }
    };

    public BlockParticleData(int color, float size, int lifespan, float rotationSpeed, float alpha) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = alpha;
        this.staticSize = true;
    }

    public BlockParticleData(Color color, float size, int lifespan, float rotationSpeed) {
        this.rgbColor = color.getRGB();
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = true;
    }

    public BlockParticleData(int color, float size, int lifespan, float rotationSpeed) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = true;
    }

    public BlockParticleData(Color color, float size, int lifespan, float rotationSpeed, boolean small) {
        this.rgbColor = color.getRGB();
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = small;
    }

    public BlockParticleData(int color, float size, int lifespan, float rotationSpeed, boolean small) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = 1.0f;
        this.staticSize = small;
    }

    public BlockParticleData(int color, float size, int lifespan, float rotationSpeed, float alpha, boolean small, boolean optimized, boolean physic) {
        this.rgbColor = color;
        this.size = size;
        this.lifespan = lifespan;
        this.rotationSpeed = rotationSpeed;
        this.alpha = alpha;
        this.staticSize = small;
        this.optimized = optimized;
        this.physic = physic;
    }

    public BlockParticleData setOptimized(boolean optimized) {
        this.optimized = optimized;
        return this;
    }

    public BlockParticleData setPhysic(boolean physic) {
        this.physic = physic;
        return this;
    }

    @Nonnull
    public ParticleType<BlockParticleData> m_6012_() {
        return (ParticleType)ParticleRegistry.BLOCK_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.rgbColor);
        buffer.writeFloat(this.size);
        buffer.writeInt(this.lifespan);
        buffer.writeFloat(this.rotationSpeed);
        buffer.writeFloat(this.alpha);
        buffer.writeBoolean(this.staticSize);
        buffer.writeBoolean(this.optimized);
        buffer.writeBoolean(this.physic);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f %d %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.rgbColor, Float.valueOf(this.size), this.lifespan, Float.valueOf(this.rotationSpeed));
    }

    public int getRgbColor() {
        return this.rgbColor;
    }

    public float getSize() {
        return this.size;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public boolean isStaticSize() {
        return this.staticSize;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public boolean isPhysic() {
        return this.physic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockParticleData)) {
            return false;
        }
        BlockParticleData other = (BlockParticleData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRgbColor() != other.getRgbColor()) {
            return false;
        }
        if (Float.compare(this.getSize(), other.getSize()) != 0) {
            return false;
        }
        if (this.getLifespan() != other.getLifespan()) {
            return false;
        }
        if (Float.compare(this.getRotationSpeed(), other.getRotationSpeed()) != 0) {
            return false;
        }
        if (Float.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        if (this.isStaticSize() != other.isStaticSize()) {
            return false;
        }
        if (this.isOptimized() != other.isOptimized()) {
            return false;
        }
        return this.isPhysic() == other.isPhysic();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockParticleData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRgbColor();
        result = result * 59 + Float.floatToIntBits(this.getSize());
        result = result * 59 + this.getLifespan();
        result = result * 59 + Float.floatToIntBits(this.getRotationSpeed());
        result = result * 59 + Float.floatToIntBits(this.getAlpha());
        result = result * 59 + (this.isStaticSize() ? 79 : 97);
        result = result * 59 + (this.isOptimized() ? 79 : 97);
        result = result * 59 + (this.isPhysic() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BlockParticleData(rgbColor=" + this.getRgbColor() + ", size=" + this.getSize() + ", lifespan=" + this.getLifespan() + ", rotationSpeed=" + this.getRotationSpeed() + ", alpha=" + this.getAlpha() + ", staticSize=" + this.isStaticSize() + ", optimized=" + this.isOptimized() + ", physic=" + this.isPhysic() + ")";
    }
}

