/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.gui.MiconScreen;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.handlers.ClientTickHandler;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.leveling.data.ConditionInfo;
import it.mralxart.etheria.leveling.data.ConditionType;
import it.mralxart.etheria.leveling.data.ImageType;
import it.mralxart.etheria.leveling.data.SkillData;
import it.mralxart.etheria.leveling.data.SkillInfo;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.C2SSkillButtonPacket;
import it.mralxart.etheria.utils.RandomUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.controls.KeyBindsScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkillWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private Minecraft MC = Minecraft.m_91087_();
    public final SkillInfo info;
    private final MiconScreen screen;
    private boolean hovered = false;
    private float size = 1.5f;
    private float sizeOff = 1.0f;
    private int index;
    private boolean wasPurchased = false;

    public SkillWidget(int p_93365_, int p_93366_, int p_93367_, int p_93368_, SkillInfo info, MiconScreen screen, int index) {
        super(p_93365_, p_93366_, p_93367_, p_93368_);
        this.info = info;
        this.screen = screen;
        this.index = index;
        this.wasPurchased = SkillsUtils.isSkillUnlockd((Player)this.MC.f_91074_, info.getId());
    }

    public void m_88315_(GuiGraphics p_282421_, int p_93658_, int p_93659_, float p_93660_) {
    }

    @Override
    public void tick() {
        float maxScale = 1.4f;
        float minScale = 1.0f;
        if (this.screen.widgetSize.containsKey(this.info.getId()) && this.screen.widgetSize.get(this.info.getId()).floatValue() != 1.0f) {
            this.sizeOff = this.screen.widgetSize.get(this.info.getId()).floatValue();
        }
        if (this.hovered) {
            if (this.sizeOff < maxScale) {
                this.sizeOff = Math.min(maxScale, this.sizeOff + (maxScale - this.sizeOff) * 0.25f);
            }
        } else if (this.sizeOff != minScale) {
            this.sizeOff = Math.max(minScale, this.sizeOff - 0.05f);
        }
        this.screen.widgetSize.put(this.info.getId(), Float.valueOf(this.sizeOff));
        boolean isCurrentlyPurchased = SkillsUtils.isSkillUnlockd((Player)this.MC.f_91074_, this.info.getId());
        if (isCurrentlyPurchased && !this.wasPurchased) {
            this.screen.animationProgress = 0.0f;
            this.createParticleBurst();
        }
        this.wasPurchased = isCurrentlyPurchased;
    }

    private void createParticleBurst() {
        float centerX = (float)this.m_252754_() + (float)this.f_93618_ / 2.0f - (float)this.screen.getOffX();
        float centerY = (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - (float)this.screen.getOffY();
        Color particleColor = new Color(15516037);
        for (int i = 0; i < 40; ++i) {
            float angle = RandomUtils.random().nextFloat() * 2.0f * (float)Math.PI;
            float speed = 1.5f + RandomUtils.random().nextFloat() * 2.5f;
            float velX = (float)Math.cos(angle) * speed;
            float velY = (float)Math.sin(angle) * speed;
            this.screen.getParticleContainer().addParticle(new ScreenGlowingParticle(centerX - 9.0f, centerY - 11.0f, velX, velY, 0.3f + RandomUtils.random().nextFloat() * 0.4f, 20 + RandomUtils.random().nextInt(30), -0.1f, particleColor));
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float ticks, int mX, int mY) {
        ItemStack stack;
        float flashAlpha;
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mX, mY);
        float offSize = 1.0f;
        if (this.screen.widgetSize.containsKey(this.info.getId()) && this.screen.widgetSize.get(this.info.getId()).floatValue() != 1.0f) {
            offSize = this.screen.widgetSize.get(this.info.getId()).floatValue();
        }
        this.size = this.screen.zoom * 1.5f + offSize - 1.0f;
        long time = System.currentTimeMillis() / 50L;
        float colorr = (float)((double)0.85f + Math.sin((double)time * Math.ceil(2.0) * (double)0.075f) * (double)0.3f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        boolean isPurchased = SkillsUtils.isSkillUnlockd((Player)this.MC.f_91074_, this.info.getId());
        boolean isConnectedSkillPurchased = SkillsUtils.isParentSkillUnlockd((Player)this.MC.f_91074_, this.info.getId());
        boolean canPurchase = SkillsUtils.mayPlayerPurchase((Player)this.MC.f_91074_, this.info.getId());
        if (canPurchase && !isPurchased && isConnectedSkillPurchased) {
            RenderSystem.setShaderColor((float)colorr, (float)colorr, (float)colorr, (float)1.0f);
        }
        if (!isConnectedSkillPurchased || !canPurchase && !isPurchased) {
            RenderSystem.setShaderColor((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        int[] numbers = new int[]{1, 2, 3, 4};
        int cyclicIndex = (this.index - 1) % numbers.length;
        int color = 14456567;
        ResourceLocation skill_template = new ResourceLocation("etheria", "textures/gui/widget/star" + numbers[cyclicIndex] + ".png");
        if (!isConnectedSkillPurchased || !canPurchase && !isPurchased) {
            skill_template = new ResourceLocation("etheria", "textures/gui/widget/star_gray.png");
            color = 0xB7B7B7;
        } else if (isPurchased && SkillsUtils.getSkillById((Player)this.MC.f_91074_, this.info.getId()).get().getLvl() >= this.info.getMaxLvl()) {
            skill_template = new ResourceLocation("etheria", "textures/gui/widget/active_star" + (this.index % 2 == 0 ? "" : "2") + ".png");
            color = 15516037;
        }
        if (ClientTickHandler.clientTickCount % 6 == 0) {
            this.screen.getParticleContainer().addParticle(new ScreenGlowingParticle((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - 9.0f - (float)this.screen.getOffX() + (float)(new Random().nextInt(6) - new Random().nextInt(6)) * this.size, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 11.0f - (float)this.screen.getOffY(), 0.0f, -0.15f, 0.2f * this.size, 10 + new Random().nextInt(60), 3.0f, new Color(color)));
        }
        poseStack.m_85836_();
        float finalScale = this.size;
        if (this.screen.animationProgress >= 0.0f && this.screen.animationId.equals(this.info.getId())) {
            float pulse = (float)Math.sin((double)this.screen.animationProgress * Math.PI);
            float extraScale = 1.05f * pulse;
            finalScale += extraScale;
        }
        poseStack.m_85841_(finalScale, finalScale, 1.0f);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / finalScale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / finalScale, 0.0f);
        if (this.screen.animationProgress >= 0.0f && this.screen.animationId.equals(this.info.getId()) && (flashAlpha = (float)Math.sin((double)this.screen.animationProgress * Math.PI)) > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)0.95f, (float)0.8f, (float)flashAlpha);
            ResourceLocation flashTexture = new ResourceLocation("etheria", "textures/gui/widget/active_star.png");
            guiGraphics.m_280163_(flashTexture, -16, -16, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        long currentTimeMillis = System.currentTimeMillis();
        long period = 10000L;
        float rotation = (float)(Math.sin(Math.PI * 2 * (double)currentTimeMillis * ((double)this.index * 0.1) / (double)period) * 30.0);
        if (this.index % 2 == 0) {
            rotation -= 45.0f;
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
        guiGraphics.m_280163_(skill_template, -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        poseStack.m_85836_();
        poseStack.m_85841_(1.35f, 1.35f, 1.0f);
        guiGraphics.m_280163_(skill_template, -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(this.size / 2.0f, this.size / 2.0f, 1.0f);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / (this.size / 2.0f), ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / (this.size / 2.0f), 0.0f);
        poseStack.m_252880_(-8.0f, -8.0f, 150.0f);
        if (this.info.getInfo().getType().equals((Object)ImageType.ITEM)) {
            stack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.info.getInfo().getId()))));
            RenderSystem.setShaderColor((float)227.0f, (float)201.0f, (float)250.0f, (float)1.0f);
            guiGraphics.m_280480_(stack, 1, 0);
            guiGraphics.m_280480_(stack, -1, 0);
            guiGraphics.m_280480_(stack, 0, 1);
            guiGraphics.m_280480_(stack, 0, -1);
        }
        poseStack.m_252880_(8.0f, 8.0f, 150.0f);
        if (this.info.getInfo().getType().equals((Object)ImageType.TEXTURE)) {
            guiGraphics.m_280163_(new ResourceLocation(this.info.getInfo().getId()), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(this.size / 2.0f, this.size / 2.0f, 1.0f);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / (this.size / 2.0f), ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / (this.size / 2.0f), 0.0f);
        poseStack.m_252880_(-8.0f, -8.0f, 181.0f);
        if (this.info.getInfo().getType().equals((Object)ImageType.ITEM)) {
            stack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.info.getInfo().getId()))));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280480_(stack, 0, 0);
        }
        poseStack.m_85849_();
    }

    @Override
    public void m_5691_() {
        boolean isPurchased = SkillsUtils.isSkillUnlockd((Player)this.MC.f_91074_, this.info.getId());
        boolean isConnectedSkillPurchased = SkillsUtils.isParentSkillUnlockd((Player)this.MC.f_91074_, this.info.getId());
        boolean canPurchase = SkillsUtils.mayPlayerPurchase((Player)this.MC.f_91074_, this.info.getId());
        boolean mayPlayerUpgrade = SkillsUtils.mayPlayerUpgrade((Player)this.MC.f_91074_, this.info.getId());
        if (this.MC.f_91074_ != null) {
            if (KeyBindsScreen.m_96638_()) {
                if (isPurchased && mayPlayerUpgrade && isConnectedSkillPurchased && SkillsUtils.getSkillById((Player)this.MC.f_91074_, this.info.getId()).isPresent()) {
                    Networking.sendToServer(new C2SSkillButtonPacket(this.info.getId(), "upgrade", this.info.getReqUpPoints(), this.MC.f_91074_.m_20148_()));
                }
            } else if (canPurchase && !isPurchased && isConnectedSkillPurchased) {
                this.screen.setAnimationId(this.info.getId());
                Networking.sendToServer(new C2SSkillButtonPacket(this.info.getId(), "buy", this.info.getReqPoints(), this.MC.f_91074_.m_20148_()));
            }
        }
    }

    public boolean m_6375_(double p_93641_, double p_93642_, int type) {
        if (type == 1) {
            boolean isPurchased = SkillsUtils.isSkillUnlockd((Player)this.MC.f_91074_, this.info.getId());
            if (this.MC.f_91074_ != null && isPurchased && this.isHover() && SkillsUtils.getSkillById((Player)this.MC.f_91074_, this.info.getId()).isPresent()) {
                Networking.sendToServer(new C2SSkillButtonPacket(this.info.getId(), "active", 0, this.MC.f_91074_.m_20148_()));
            }
        }
        return super.m_6375_(p_93641_, p_93642_, type);
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }

    @Override
    public void hovered(GuiGraphics guiGraphics, int mX, int mY, float partTicks) {
        int color = 14928378;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color));
        String formattedId = this.info.getId().substring(0, 1).toUpperCase() + this.info.getId().substring(1).toLowerCase();
        ArrayList tooltip = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237113_((String)formattedId).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)).m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true)))});
        Optional<SkillData> skillOpt = SkillsUtils.getSkillById((Player)this.MC.f_91074_, this.info.getId());
        SkillData skill = skillOpt.orElse(null);
        boolean skillPurchased = skill != null && skill.isPurchased();
        int skillLvl = skill != null ? skill.getLvl() : 0;
        boolean hasStatOrMod = this.info.getConditions().stream().anyMatch(condition -> condition.getType() == ConditionType.STAT || condition.getType() == ConditionType.MOD);
        boolean hasItemOrBlock = this.info.getConditions().stream().anyMatch(condition -> condition.getType() == ConditionType.ITEM || condition.getType() == ConditionType.BLOCK);
        boolean mayPlayerUpgrade = SkillsUtils.mayPlayerUpgrade((Player)this.MC.f_91074_, this.info.getId());
        if (hasStatOrMod || hasItemOrBlock) {
            tooltip.add(Component.m_237113_((String)"\u00bb\u2505--\u2505-\u2505-\u272f\u25e6\u272f-\u2505-\u2505--\u2505\u00ab").m_130948_(style));
            if (skill != null) {
                localizedKey = "etheria.skill." + skill.getId().replace(":", ".");
                entry = Component.m_237115_((String)localizedKey).getString();
                value = "";
                if (KeyBindsScreen.m_96638_() && mayPlayerUpgrade) {
                    i1 = skillLvl == 0 ? this.info.getInitialValue() : this.info.getInitialValue() * (float)skillLvl;
                    i2 = skillLvl == 0 ? this.info.getInitialValue() : this.info.getInitialValue() * (float)skillLvl;
                    value1 = i1 == (float)((int)i1) ? String.valueOf((int)i1) : String.valueOf(i1);
                    value2 = i2 == (float)((int)i2) ? String.valueOf((int)i2) : String.valueOf(i2);
                    value = "(" + value1 + "->" + value2 + ")";
                } else {
                    float i = skillLvl == 0 ? this.info.getInitialValue() : this.info.getInitialValue() * (float)skillLvl;
                    value = i == (float)((int)i) ? String.valueOf((int)i) : String.valueOf(i);
                }
                entry = ((String)entry).replaceAll("1%s%", (String)value);
                tooltip.add(Component.m_237113_((String)entry).m_130948_(style));
            }
            tooltip.add(Component.m_237113_((String)"\u00bb\u2505--\u2505-\u2505-\u272f\u25e6\u272f-\u2505-\u2505--\u2505\u00ab").m_130948_(style));
        } else {
            tooltip.add(Component.m_237113_((String)"\u00bb\u2505--\u2505-\u2505-\u272f\u25e6\u272f-\u2505-\u2505--\u2505\u00ab").m_130948_(style));
            if (skill != null) {
                localizedKey = "etheria.skill." + skill.getId().replace(":", ".");
                entry = Component.m_237115_((String)localizedKey).getString();
                value = "";
                if (KeyBindsScreen.m_96638_() && mayPlayerUpgrade) {
                    i1 = skillLvl == 0 ? this.info.getInitialValue() : this.info.getInitialValue() * (float)skillLvl;
                    i2 = skillLvl == 0 ? this.info.getInitialValue() : this.info.getInitialValue() * (float)(skillLvl + 1);
                    value1 = i1 == (float)((int)i1) ? String.valueOf((int)i1) : String.valueOf(i1);
                    value2 = i2 == (float)((int)i2) ? String.valueOf((int)i2) : String.valueOf(i2);
                    value = "(" + value1 + " -> " + value2 + ")";
                } else {
                    float init = this.info.getInitialValue();
                    float i = skillLvl == 0 ? this.info.getInitialValue() : this.info.getInitialValue() * (float)skillLvl;
                    value = i == (float)((int)i) ? String.valueOf((int)i) : String.valueOf(i);
                }
                entry = ((String)entry).replaceAll("1%s%", (String)value);
                tooltip.add(Component.m_237113_((String)entry).m_130948_(style));
            }
            tooltip.add(Component.m_237113_((String)"\u00bb\u2505--\u2505-\u2505-\u272f\u25e6\u272f-\u2505-\u2505--\u2505\u00ab").m_130948_(style));
        }
        if (this.info.getMaxLvl() > 0) {
            tooltip.add(Component.m_237113_((String)" ").m_130948_(style));
            tooltip.add(Component.m_237110_((String)"etheria.skill.current_level", (Object[])new Object[]{skillLvl >= this.info.getMaxLvl() ? Component.m_237115_((String)"etheria.skill.max_level") : Component.m_237110_((String)"etheria.skill.level_progress", (Object[])new Object[]{skillLvl, this.info.getMaxLvl()})}).m_130948_(style));
            tooltip.add(Component.m_237113_((String)" ").m_130948_(style));
            tooltip.add(Component.m_237113_((String)"\u00bb\u2505-\u272f\u25e6\u272f-\u2505\u00ab").m_130948_(style));
        }
        if (skill != null) {
            if (!skillPurchased) {
                tooltip.add(Component.m_237115_((String)"etheria.skill.not_learned"));
                tooltip.add(Component.m_237110_((String)"etheria.skill.unlock_cost", (Object[])new Object[]{this.info.getReqPoints()}).m_130948_(style));
            } else {
                tooltip.add(Component.m_237115_((String)"etheria.skill.learned").m_130948_(style));
                if (this.info.getMaxLvl() > 0 && skillLvl < this.info.getMaxLvl()) {
                    tooltip.add(Component.m_237110_((String)"etheria.skill.upgrade_cost", (Object[])new Object[]{this.info.getReqUpPoints()}).m_130948_(style));
                    tooltip.add(Component.m_237115_((String)"etheria.skill.upgrade_hint").m_130948_(style));
                }
                boolean isMod = false;
                for (ConditionInfo cond : this.info.getConditions()) {
                    if (!cond.getType().equals((Object)ConditionType.MOD)) continue;
                    isMod = true;
                    break;
                }
                if (!isMod) {
                    tooltip.add(Component.m_237110_((String)"etheria.skill.status", (Object[])new Object[]{Component.m_237115_((String)(skill.isActive() ? "etheria.skill.active" : "etheria.skill.inactive"))}).m_130948_(style));
                }
            }
        }
        tooltip.add(Component.m_237113_((String)"\u00bb\u2505-\u272f\u25e6\u272f-\u2505\u00ab").m_130948_(style));
        ArrayList result = new ArrayList();
        for (MutableComponent entry : tooltip) {
            result.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, 270));
        }
        int tooltipWidth = 270;
        int n = result.size();
        Objects.requireNonNull(this.MC.f_91062_);
        int tooltipHeight = n * (9 + 2);
        int tooltipX = mX - tooltipWidth / 2;
        int tooltipY = mY;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        int scaledX = tooltipX * 2;
        int scaledY = tooltipY * 2;
        int scaledWidth = tooltipWidth * 2;
        int scaledHeight = tooltipHeight * 2;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(scaledX + 135), (int)scaledY, (int)(scaledWidth / 2), (int)(scaledHeight / 2), (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 3500.0f);
        for (FormattedCharSequence entry : result) {
            int textWidth = this.MC.f_91062_.m_92724_(entry);
            guiGraphics.m_280648_(this.MC.f_91062_, entry, scaledX + (270 - textWidth / 2), scaledY, color);
            Objects.requireNonNull(this.MC.f_91062_);
            scaledY += 9 + 2;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    protected void m_168797_(@NotNull NarrationElementOutput p_259858_) {
    }

    private void drawItem(PoseStack matrix, ItemStack stack, int x, int y) {
        boolean useItemLight;
        Minecraft mc = Minecraft.m_91087_();
        int color = Integer.parseInt("d9ace5", 16) | 0xFF000000;
        BakedModel model = mc.m_91291_().m_174264_(stack, null, null, 0);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.m_252880_((float)x, (float)y, 0.0f);
        matrix.m_85841_(1.0f, -1.0f, 2.0f);
        matrix.m_85841_(12.0f, 12.0f, 12.0f);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = useItemLight = !model.m_7547_();
        if (useItemLight) {
            Lighting.m_84930_();
        }
        mc.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrix, (MultiBufferSource)renderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, model);
        renderTypeBuffer.m_109911_();
        matrix.m_85841_(1.0f, 1.0f, 1.0f);
        RenderSystem.enableDepthTest();
        if (useItemLight) {
            Lighting.m_84931_();
        }
    }

    public Minecraft getMC() {
        return this.MC;
    }

    public SkillInfo getInfo() {
        return this.info;
    }

    public MiconScreen getScreen() {
        return this.screen;
    }

    public boolean m_274382_() {
        return this.hovered;
    }

    public float getSize() {
        return this.size;
    }

    public float getSizeOff() {
        return this.sizeOff;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isWasPurchased() {
        return this.wasPurchased;
    }
}

