/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.gui.EtherSettingScreen;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.handlers.ClientTickHandler;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EtherSettingWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private Minecraft MC = Minecraft.m_91087_();
    private final EtherSettingScreen screen;
    private boolean hovered = false;
    private boolean isBase = false;
    public float size = 1.5f;
    private float sizeOff = 1.0f;
    private int index;
    private int id;
    public boolean isFixed;
    public boolean dragging = false;
    public int dragOffsetX;
    public int dragOffsetY;

    public EtherSettingWidget(int p_93365_, int p_93366_, int p_93367_, int p_93368_, EtherSettingScreen screen, int id, int index, boolean isBase) {
        super(p_93365_, p_93366_, p_93367_, p_93368_);
        this.screen = screen;
        this.index = index;
        this.isBase = isBase;
        this.id = id;
    }

    @Override
    public void m_5691_() {
        super.m_5691_();
        if (!this.isBase && !this.isFixed) {
            this.dragging = true;
        }
    }

    public void m_7691_(double p_93669_, double p_93670_) {
        super.m_7691_(p_93669_, p_93670_);
        this.dragging = false;
    }

    public boolean onDrag(double mouseX, double mouseY) {
        if (this.dragging && !this.isBase && !this.isFixed) {
            this.m_252865_((int)mouseX - this.dragOffsetX - 11);
            this.m_253211_((int)mouseY - this.dragOffsetY - 11);
            return true;
        }
        return false;
    }

    public void m_88315_(GuiGraphics p_282421_, int p_93658_, int p_93659_, float p_93660_) {
    }

    @Override
    public void tick() {
        float maxScale = 1.4f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.sizeOff < maxScale) {
                this.sizeOff = Math.min(maxScale, this.sizeOff + (maxScale - this.sizeOff) * 0.25f);
            }
        } else if (this.sizeOff != minScale) {
            this.sizeOff = Math.max(minScale, this.sizeOff - 0.05f);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float ticks, int mX, int mY) {
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), mX, mY);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        PoseStack poseStack = guiGraphics.m_280168_();
        int[] numbers = new int[]{1, 2, 3, 4};
        int cyclicIndex = (this.index - 1) % numbers.length;
        int color = 14456567;
        ResourceLocation skill_template = new ResourceLocation("etheria", "textures/gui/widget/star" + numbers[cyclicIndex] + ".png");
        if (this.isBase && this.screen.isOnEther(this, 4.0f)) {
            skill_template = new ResourceLocation("etheria", "textures/gui/widget/active_star" + (this.index % 2 == 0 ? "" : "2") + ".png");
            color = 15516037;
        } else if (this.isBase) {
            skill_template = new ResourceLocation("etheria", "textures/gui/widget/star_gray.png");
            color = 0xB7B7B7;
        }
        if (ClientTickHandler.clientTickCount % 6 == 0) {
            this.screen.getParticleContainer().addParticle(new ScreenGlowingParticle((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - 9.0f - (float)this.screen.getOffX() + (float)(new Random().nextInt(6) - new Random().nextInt(6)) * this.size, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 11.0f - (float)this.screen.getOffY(), 0.0f, -0.15f, 0.2f * this.size, 10 + new Random().nextInt(60), 3.0f, new Color(color)));
        }
        poseStack.m_85836_();
        poseStack.m_85841_(this.size, this.size, 1.0f);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.size, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.size, 0.0f);
        long currentTimeMillis = System.currentTimeMillis();
        long period = 10000L;
        float rotation = (float)(Math.sin(Math.PI * 2 * (double)currentTimeMillis * ((double)this.index * 0.1) / (double)period) * 30.0);
        if (this.index % 2 == 0) {
            rotation -= 45.0f;
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
        guiGraphics.m_280163_(skill_template, -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    public boolean m_6375_(double p_93641_, double p_93642_, int type) {
        return super.m_6375_(p_93641_, p_93642_, type);
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }

    @Override
    public void hovered(GuiGraphics guiGraphics, int mX, int mY, float partTicks) {
    }

    @Override
    protected void m_168797_(@NotNull NarrationElementOutput p_259858_) {
    }

    private void drawItem(PoseStack matrix, ItemStack stack, int x, int y) {
        boolean useItemLight;
        Minecraft mc = Minecraft.m_91087_();
        int color = Integer.parseInt("d9ace5", 16) | 0xFF000000;
        BakedModel model = mc.m_91291_().m_174264_(stack, null, null, 0);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.m_252880_((float)x, (float)y, 0.0f);
        matrix.m_85841_(1.0f, -1.0f, 2.0f);
        matrix.m_85841_(12.0f, 12.0f, 12.0f);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = useItemLight = !model.m_7547_();
        if (useItemLight) {
            Lighting.m_84930_();
        }
        mc.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrix, (MultiBufferSource)renderTypeBuffer, 0xF000F0, OverlayTexture.f_118083_, model);
        renderTypeBuffer.m_109911_();
        matrix.m_85841_(1.0f, 1.0f, 1.0f);
        RenderSystem.enableDepthTest();
        if (useItemLight) {
            Lighting.m_84931_();
        }
    }

    public Minecraft getMC() {
        return this.MC;
    }

    public EtherSettingScreen getScreen() {
        return this.screen;
    }

    public boolean m_274382_() {
        return this.hovered;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public float getSize() {
        return this.size;
    }

    public float getSizeOff() {
        return this.sizeOff;
    }

    public int getIndex() {
        return this.index;
    }

    public int getId() {
        return this.id;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public int getDragOffsetX() {
        return this.dragOffsetX;
    }

    public int getDragOffsetY() {
        return this.dragOffsetY;
    }
}

