/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.capability.EtheriaCapability;
import it.mralxart.etheria.client.gui.MiconScreen;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.handlers.ClientTickHandler;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.enigma.EnigmaUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.C2SPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.utils.RandomUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementSlotWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private final MiconScreen micon;
    private float scale = 1.5f;
    private float sizeOff = 1.0f;
    public boolean hovered = false;
    @Nullable
    public Element element;
    public int index;

    public ElementSlotWidget(int x, int y, MiconScreen micon, @Nullable Element element, int index) {
        super(x, y, 18, 18);
        this.micon = micon;
        this.element = element;
        this.index = index;
    }

    @Override
    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.3f));
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    @Override
    public void m_5691_() {
        CompoundTag tag;
        if (CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_).getElements().isEmpty() && this.element != null) {
            tag = new CompoundTag();
            tag.m_128359_("element", this.element.name().toLowerCase());
            Networking.sendToServer(new C2SPacket(tag, 806));
            this.createParticleBurst();
        }
        if (this.element != null && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElements().contains((Object)this.element) && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement() != this.element && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement2() != this.element) {
            tag = new CompoundTag();
            tag.m_128359_("element", this.element.name().toLowerCase());
            Networking.sendToServer(new C2SPacket(tag, 1));
        } else if (this.element != null && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElements().contains((Object)this.element) && (CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement() != this.element || CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement2() != this.element)) {
            tag = new CompoundTag();
            tag.m_128359_("element", this.element.name().toLowerCase());
            Networking.sendToServer(new C2SPacket(tag, 847));
        }
    }

    public void createParticleBurst() {
        float centerX = (float)this.m_252754_() + (float)this.f_93618_ / 2.0f - (float)this.micon.getOffX();
        float centerY = (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - (float)this.micon.getOffY();
        Color particleColor = new Color(15516037);
        for (int i = 0; i < 40; ++i) {
            float angle = RandomUtils.random().nextFloat() * 2.0f * (float)Math.PI;
            float speed = 1.5f + RandomUtils.random().nextFloat() * 2.5f;
            float velX = (float)Math.cos(angle) * speed;
            float velY = (float)Math.sin(angle) * speed;
            this.micon.getParticleContainer().addParticle(new ScreenGlowingParticle(centerX - 9.0f, centerY - 11.0f, velX, velY, 0.3f + RandomUtils.random().nextFloat() * 0.4f, 20 + RandomUtils.random().nextInt(30), -0.1f, particleColor));
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        float colorr;
        PoseStack poseStack = guiGraphics.m_280168_();
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        float offSize = 1.0f;
        if (this.micon.widgetSize.containsKey("" + this.index) && this.micon.widgetSize.get("" + this.index).floatValue() != 1.0f) {
            offSize = this.micon.widgetSize.get("" + this.index).floatValue();
        }
        this.scale = this.micon.zoom * 1.5f + offSize - 1.0f;
        EtheriaCapability cap = CapabilityRegistry.getCap((Player)Minecraft.m_91087_().f_91074_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 0.0f);
        long currentTimeMillis = System.currentTimeMillis();
        long period = 10000L;
        float rotation = (float)(Math.sin(Math.PI * 2 * (double)currentTimeMillis * ((double)this.index * 0.1) / (double)period) * 30.0);
        if (this.index % 2 == 0) {
            rotation -= 45.0f;
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
        int color = 14456567;
        if (this.element != null && cap.getElement().equals((Object)this.element) || cap.getElement2().equals((Object)this.element)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/active_star.png"), -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
            color = 15516037;
        } else if (this.element != null && cap.getElements().contains((Object)this.element)) {
            int[] numbers = new int[]{1, 2, 3, 4};
            int cyclicIndex = (this.index - 1) % numbers.length;
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/star" + numbers[cyclicIndex] + ".png"), -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
        } else if (this.element != null && !cap.getElements().contains((Object)this.element)) {
            if (CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElements().isEmpty() && this.element != null) {
                long time = System.currentTimeMillis() / 50L;
                colorr = (float)((double)0.85f + Math.sin((double)time * Math.ceil(2.0) * (double)0.075f) * (double)0.3f);
                RenderSystem.setShaderColor((float)colorr, (float)colorr, (float)colorr, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            }
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/star_gray.png"), -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
            color = 0xB7B7B7;
        } else if (this.element == null) {
            RenderSystem.setShaderColor((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/star_gray.png"), -11, -11, 0.0f, 0.0f, 22, 22, 22, 22);
            color = 0xB7B7B7;
        }
        poseStack.m_85849_();
        if (CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElements().isEmpty() && this.element != null) {
            long time = System.currentTimeMillis() / 50L;
            colorr = (float)((double)0.85f + Math.sin((double)time * Math.ceil(2.0) * (double)0.075f) * (double)0.3f);
            RenderSystem.setShaderColor((float)colorr, (float)colorr, (float)colorr, (float)1.0f);
        }
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale / 2.0f, this.scale / 2.0f, this.scale / 2.0f);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / (this.scale / 2.0f), ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / (this.scale / 2.0f), 200.0f);
        if (this.element != null && cap.getElements().contains((Object)this.element)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/scroll_" + this.element.name().toLowerCase() + ".png"), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            if (ClientTickHandler.clientTickCount % 2 == 0) {
                this.micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - 9.0f - (float)this.micon.getOffX() + (new Random().nextFloat() - new Random().nextFloat()) * 7.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 11.0f - (float)this.micon.getOffY(), 0.0f, -0.3f, 0.3f, (int)(20.0f + new Random().nextFloat() * 32.0f), 3.0f, new Color(color)));
            }
        } else if (this.element != null && !cap.getElements().contains((Object)this.element)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/scroll_" + this.element.name().toLowerCase() + ".png"), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            if (ClientTickHandler.clientTickCount % 2 == 0) {
                this.micon.getParticleContainer().addParticle(new ScreenGlowingParticle((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - 9.0f - (float)this.micon.getOffX() + (float)(new Random().nextInt(6) - new Random().nextInt(6)) * this.scale, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 11.0f - (float)this.micon.getOffY(), 0.0f, -0.15f, 0.2f * this.scale, 10 + new Random().nextInt(60), 3.0f, new Color(color)));
            }
        } else if (this.element == null) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/lock.png"), -5, -5, 0.0f, 0.0f, 10, 10, 10, 10);
        }
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void hovered(GuiGraphics guiGraphics, int mX, int mY, float partTicks) {
        int color = 14928378;
        boolean isEnigma = false;
        if (this.element == null) {
            isEnigma = true;
            color = EnigmaUtils.getEnigmaStartColor(ClientTickHandler.clientTickCount).getRGB();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)).m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true));
        MutableComponent titleComponent = this.element != null ? Component.m_237115_((String)("etheria.element." + this.element.name().toLowerCase())) : Component.m_237113_((String)"Soon");
        tooltip.add(titleComponent.m_130948_(style));
        style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color));
        if (CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElements().isEmpty() && this.element != null) {
            tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.ready_to_unlock").m_130948_(style));
            tooltip.add(Component.m_237113_((String)" "));
        } else if (this.element != null && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElements().contains((Object)this.element) && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement() != this.element && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement2() != this.element) {
            tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130940_(ChatFormatting.DARK_GRAY));
            lmbKey = Component.m_237115_((String)"mage_micon.key.lmb").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
            tooltip.add(Component.m_237110_((String)"mage_micon.tooltip.hint.activate", (Object[])new Object[]{lmbKey}).m_130940_(ChatFormatting.DARK_GRAY));
        } else if (this.element != null && CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElements().contains((Object)this.element) && (CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement() == this.element || CapabilityRegistry.getCap((Player)this.MC.f_91074_).getElement2() == this.element)) {
            tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130940_(ChatFormatting.DARK_GRAY));
            lmbKey = Component.m_237115_((String)"mage_micon.key.lmb").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
            tooltip.add(Component.m_237110_((String)"mage_micon.tooltip.hint.deactivate", (Object[])new Object[]{lmbKey}).m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            tooltip.add(Component.m_237115_((String)"mage_micon.tooltip.separator").m_130948_(style));
        }
        ArrayList result = new ArrayList();
        for (MutableComponent entry : tooltip) {
            result.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, 270));
        }
        int tooltipWidth = 270;
        int n = result.size();
        Objects.requireNonNull(this.MC.f_91062_);
        int tooltipHeight = n * (9 + 2);
        int tooltipX = mX - tooltipWidth / 2;
        int tooltipY = mY;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        int scaledX = tooltipX * 2;
        int scaledY = tooltipY * 2;
        int scaledWidth = tooltipWidth * 2;
        int scaledHeight = tooltipHeight * 2;
        if (!isEnigma) {
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(scaledX + 135), (int)scaledY, (int)(scaledWidth / 2), (int)(scaledHeight / 2), (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
        } else {
            int startColor = EnigmaUtils.getEnigmaStartColor(ClientTickHandler.clientTickCount).getRGB();
            int endColor = EnigmaUtils.getEnigmaEndColor(ClientTickHandler.clientTickCount).getRGB();
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(scaledX + 135), (int)scaledY, (int)(scaledWidth / 2), (int)(scaledHeight / 2), (int)1300, (int)-267386864, (int)-267386864, (int)startColor, (int)endColor);
        }
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 3500.0f);
        for (FormattedCharSequence entry : result) {
            int textWidth = this.MC.f_91062_.m_92724_(entry);
            guiGraphics.m_280648_(this.MC.f_91062_, entry, scaledX + (270 - textWidth / 2), scaledY, color);
            Objects.requireNonNull(this.MC.f_91062_);
            scaledY += 9 + 2;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public void tick() {
        float maxScale = 1.4f;
        float minScale = 1.0f;
        if (this.micon.widgetSize.containsKey("" + this.index) && this.micon.widgetSize.get("" + this.index).floatValue() != 1.0f) {
            this.sizeOff = this.micon.widgetSize.get("" + this.index).floatValue();
        }
        if (this.hovered) {
            if (this.sizeOff < maxScale) {
                this.sizeOff = Math.min(maxScale, this.sizeOff + (maxScale - this.sizeOff) * 0.25f);
            }
        } else if (this.sizeOff != minScale) {
            this.sizeOff = Math.max(minScale, this.sizeOff - 0.05f);
        }
        this.micon.widgetSize.put("" + this.index, Float.valueOf(this.sizeOff));
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }
}

