/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.widgets;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.gui.MiconScreen;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.particles.ScreenSmokeParticle;
import it.mralxart.etheria.client.particles.data.AbstractParticle;
import it.mralxart.etheria.leveling.data.ImageType;
import it.mralxart.etheria.magemicon.data.ConstellationInfo;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ConstellationSelectWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private boolean hovered = false;
    private float scale = 1.0f;
    private float xOff = 1.0f;
    private MiconScreen screen;
    private ConstellationInfo info;
    private int i = 0;

    public ConstellationSelectWidget(int x, int y, MiconScreen screen, ConstellationInfo info, int i) {
        super(x, y, 19, 19);
        this.screen = screen;
        this.info = info;
        this.i = i;
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }

    public void m_88315_(GuiGraphics p_282421_, int p_93658_, int p_93659_, float p_93660_) {
    }

    @Override
    public void m_5691_() {
        super.m_5691_();
        this.screen.constellation = this.info.getId();
        this.screen.m_232761_();
        this.screen.m_232761_();
        for (AbstractParticle particle : new ArrayList<AbstractParticle>(this.screen.getParticleContainer().getParticles())) {
            if (particle instanceof ScreenSmokeParticle) continue;
            particle.setRemoved(true);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float ticks, int pMouseX, int pMouseY) {
        ItemStack stack;
        PoseStack poseStack = guiGraphics.m_280168_();
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float offset = (float)this.i * (float)Math.PI / 2.0f;
        float tick = (float)Blaze3D.m_83640_();
        float offX = (float)(Math.sin(tick + offset) * 3.0 * Math.sin((double)(tick + offset) * 0.3));
        float offY = (float)(Math.cos(tick + offset) * 3.0 * Math.sin((double)(tick + offset) * 0.3));
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale + offX, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale + offY, 0.0f);
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/border_wood.png"), -9, -9, 0.0f, 0.0f, 19, 19, 19, 19);
        if (this.screen.constellation.equals(this.info.getId())) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/item_widget_hover.png"), -9, -9, 0.0f, 0.0f, 19, 19, 19, 19);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale / 2.0f, this.scale / 2.0f, 1.0f);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / (this.scale / 2.0f) + offX * 2.0f, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / (this.scale / 2.0f) + offY * 2.0f, 0.0f);
        poseStack.m_85837_(-7.5, -7.5, 150.0);
        if (this.info.getImage().getType().equals((Object)ImageType.ITEM)) {
            stack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.info.getImage().getId()))));
            RenderSystem.setShaderColor((float)227.0f, (float)201.0f, (float)250.0f, (float)1.0f);
            guiGraphics.m_280480_(stack, 1, 0);
            guiGraphics.m_280480_(stack, -1, 0);
            guiGraphics.m_280480_(stack, 0, 1);
            guiGraphics.m_280480_(stack, 0, -1);
        }
        poseStack.m_252880_(8.0f, 8.0f, 150.0f);
        if (this.info.getImage().getType().equals((Object)ImageType.TEXTURE)) {
            guiGraphics.m_280163_(new ResourceLocation(this.info.getImage().getId()), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(this.scale / 2.0f, this.scale / 2.0f, 1.0f);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / (this.scale / 2.0f) + offX * 2.0f, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / (this.scale / 2.0f) + offY * 2.0f, 0.0f);
        poseStack.m_85837_(-7.5, -7.5, 181.0);
        if (this.info.getImage().getType().equals((Object)ImageType.ITEM)) {
            stack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.info.getImage().getId()))));
            RenderSystem.setShaderColor((float)1.5f, (float)1.5f, (float)1.5f, (float)1.0f);
            guiGraphics.m_280480_(stack, 0, 0);
        }
        poseStack.m_85849_();
    }

    @Override
    public void tick() {
        float maxScale = 1.03f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.xOff < maxScale) {
                this.xOff = Math.min(maxScale, this.xOff + (maxScale - this.xOff) * 0.25f);
            }
        } else if (this.xOff > minScale) {
            this.xOff = Math.max(minScale, this.xOff + (minScale - this.xOff) * 0.25f);
        }
        this.scale = this.xOff;
    }

    @Override
    public void hovered(GuiGraphics guiGraphics, int mX, int mY, float pPartialTick) {
        int color = 14928378;
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        MutableComponent titleComponent = Component.m_237115_((String)("mage_micon.constellation." + this.info.getId()));
        Style style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)).m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true));
        tooltip.add(titleComponent.m_130948_(style));
        style = Style.f_131099_.m_131148_(TextColor.m_131266_((int)color));
        int tooltipWidth = 135;
        MutableComponent component = Component.m_237115_((String)("mage_micon.constellation." + this.info.getId() + ".description"));
        if (!component.getString().isEmpty()) {
            tooltip.add(component.m_130948_(style));
        }
        ArrayList result = new ArrayList();
        for (MutableComponent entry : tooltip) {
            result.addAll(this.MC.f_91062_.m_92923_((FormattedText)entry, 265));
        }
        int n = result.size();
        Objects.requireNonNull(this.MC.f_91062_);
        int tooltipHeight = n * (9 + 2) / 2 + 6;
        int tooltipX = this.m_252754_() + 23;
        int tooltipY = this.m_252907_() + 1;
        float offset = (float)this.i * (float)Math.PI / 2.0f;
        float tick = (float)Blaze3D.m_83640_();
        float offX = (float)(Math.sin(tick + offset) * 3.0 * Math.sin((double)(tick + offset) * 0.3));
        float offY = (float)(Math.cos(tick + offset) * 3.0 * Math.sin((double)(tick + offset) * 0.3));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(offX, offY, 0.0f);
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)tooltipX, (int)tooltipY, (int)tooltipWidth, (int)tooltipHeight, (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
        guiGraphics.m_280168_().m_252880_((float)(tooltipX + 3), (float)(tooltipY + 4), 3500.0f);
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        int currentY = 0;
        for (FormattedCharSequence entry : result) {
            guiGraphics.m_280648_(this.MC.f_91062_, entry, 0, currentY, color);
            Objects.requireNonNull(this.MC.f_91062_);
            currentY += 9 + 2;
        }
        guiGraphics.m_280168_().m_85849_();
    }
}

