/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.magemicon.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.blocks.EtherAltar;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.handlers.TranslationHandler;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.magic.magemicon.Page;
import it.mralxart.etheria.magic.magemicon.data.ChapterData;
import it.mralxart.etheria.magic.magemicon.data.IconData;
import it.mralxart.etheria.magic.magemicon.data.ItemsData;
import it.mralxart.etheria.magic.magemicon.data.RecipeData;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class ChapterWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private final MageMicon micon;
    private Chapter chapter;
    private float scale = 1.0f;
    private float xOff = 1.0f;
    private boolean hovered = false;
    private boolean first = true;
    @Nullable
    private ItemStack stack = null;
    private String category = "";

    public ChapterWidget(int x, int y, MageMicon micon, boolean first) {
        super(x + 10, y, 126, 18);
        this.micon = micon;
        this.first = first;
    }

    public ChapterWidget(int x, int y, MageMicon micon, boolean first, String category) {
        super(x + 10, y, 126, 18);
        this.micon = micon;
        this.category = category;
        this.first = first;
    }

    public ChapterWidget(int x, int y, MageMicon micon, String chapter, boolean first) {
        super(x + 10, y, 126, 18);
        this.micon = micon;
        this.chapter = MageMiconUtils.getChapter(micon.category.index, chapter);
        this.first = first;
        if (!this.chapter.text.isEmpty()) {
            this.chapter.setPages(ChapterWidget.constructPages(this.micon, this.chapter));
        }
    }

    public ChapterWidget(int x, int y, MageMicon micon, String category, String spell, boolean first) {
        super(x + 10, y, 126, 18);
        this.micon = micon;
        this.category = category;
        this.chapter = new Chapter(spell, new ArrayList<Page>(), "");
        this.first = first;
    }

    public ChapterWidget(int x, int y, MageMicon micon, @Nullable ItemStack itemStack, boolean first) {
        super(x + 10, y, 126, 18);
        this.micon = micon;
        this.stack = itemStack;
        this.first = first;
    }

    public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    @Override
    public void m_5691_() {
        if (this.chapter != null && MageMiconUtils.isChapterLocked((Player)Minecraft.m_91087_().f_91074_, this.chapter.index)) {
            return;
        }
        if (this.micon.category.index.equals("spells")) {
            this.micon.page1 = new Page(this.chapter.index, Page.Type.SPELL);
            this.micon.page2 = new Page(this.chapter.index, Page.Type.TEXT, "mage_micon.spell." + this.chapter.index + ".description");
            this.micon.beforeCategory = this.micon.category.index;
            this.micon.category.index = "";
        }
        if (this.micon.category.index.equals("rituals")) {
            this.micon.beforeCategory = this.micon.category.index;
            this.micon.category.index = "";
            this.micon.id = this.category;
            this.micon.resetScreen();
            String string = this.category;
            if (this.stack != null) {
                string = this.stack.m_41778_();
            }
            this.micon.chapter = MageMiconUtils.getEmptyChapter(string);
            this.micon.page1 = new Page(string, Page.Type.RITUAL);
            this.micon.page2 = new Page(string, Page.Type.RITUAL);
            if (this.stack == null) {
                this.stack = ((EtherAltar)BlockRegistry.ETHER_ALTAR.get()).m_5456_().m_7968_();
            }
            this.micon.item = this.stack;
            return;
        }
        if (this.chapter != null && !this.chapter.text.isEmpty()) {
            this.chapter.setPages(ChapterWidget.constructPages(this.micon, this.chapter));
        }
        this.micon.chapter = this.chapter;
        this.micon.pagesIndex = 0;
        this.micon.indexPage1 = 0;
        this.micon.indexPage2 = 1;
        this.micon.resetScreen();
    }

    public static List<Page> constructPages(MageMicon micon, Chapter chapter) {
        String title = chapter.index;
        String text = chapter.text;
        text = Component.m_264568_((String)text, (String)text).getString();
        ArrayList<Page> pages = new ArrayList<Page>();
        int maxLinesPerPage = 14;
        List lines = TranslationHandler.build().contains(text) ? Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)TranslationHandler.translate(text)), 136, Style.f_131099_) : Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)Component.m_237113_((String)text), 136, Style.f_131099_);
        Map<Object, Object> recipes = new HashMap();
        if (MageMiconUtils.getChapterData(micon.category.index, chapter.index) != null) {
            recipes = MageMiconUtils.getChapterData(micon.category.index, chapter.index).getRecipes();
        }
        Map<Object, Object> items = new HashMap();
        if (MageMiconUtils.getChapterData(micon.category.index, chapter.index) != null) {
            items = MageMiconUtils.getChapterData(micon.category.index, chapter.index).getItems();
        }
        Map<Object, Object> rituals = new HashMap();
        if (MageMiconUtils.getChapterData(micon.category.index, chapter.index) != null) {
            rituals = MageMiconUtils.getChapterData(micon.category.index, chapter.index).getRituals();
        }
        int lineIndex = 0;
        int currentLineCount = 0;
        while (lineIndex < lines.size()) {
            StringBuilder pageText = new StringBuilder();
            while (lineIndex < lines.size()) {
                Page craftPage;
                String afterMarker;
                Page textPage;
                String beforeMarker;
                String craftMarker;
                String line = ((FormattedText)lines.get(lineIndex)).getString();
                boolean markerFound = false;
                for (Map.Entry<Object, Object> entry : rituals.entrySet()) {
                    craftMarker = "{" + (String)entry.getKey() + "}";
                    if (!line.contains(craftMarker)) continue;
                    markerFound = true;
                    beforeMarker = line.substring(0, line.indexOf(craftMarker));
                    if (!beforeMarker.isBlank()) {
                        pageText.append(beforeMarker).append("\n");
                        ++currentLineCount;
                    }
                    if (!pageText.isEmpty()) {
                        textPage = new Page();
                        textPage.setIndex("mage_micon.chapter." + title);
                        textPage.setText(pageText.toString().trim());
                        textPage.setType(Page.Type.TEXT);
                        pages.add(textPage);
                        pageText = new StringBuilder();
                        currentLineCount = 0;
                    }
                    Page ritualPage = new Page();
                    ritualPage.setIndex((String)entry.getValue());
                    ritualPage.setType(Page.Type.RITUAL);
                    micon.item = ItemStack.f_41583_;
                    ritualPage.pageOffSet = 1;
                    pages.add(ritualPage);
                    afterMarker = line.substring(line.indexOf(craftMarker) + craftMarker.length());
                    if (!afterMarker.isBlank()) {
                        lines.set(lineIndex, FormattedText.m_130775_((String)afterMarker));
                        break;
                    }
                    ++lineIndex;
                    break;
                }
                for (Map.Entry<Object, Object> entry : items.entrySet()) {
                    String afterMarker2;
                    craftMarker = "{" + (String)entry.getKey() + "}";
                    if (!line.contains(craftMarker)) continue;
                    markerFound = true;
                    beforeMarker = line.substring(0, line.indexOf(craftMarker));
                    if (!beforeMarker.isBlank()) {
                        pageText.append(beforeMarker).append("\n");
                        ++currentLineCount;
                    }
                    if (!pageText.isEmpty()) {
                        craftPage = new Page();
                        craftPage.setIndex("mage_micon.chapter." + title);
                        craftPage.setText(pageText.toString().trim());
                        craftPage.setType(Page.Type.ITEMS);
                        craftPage.setUpItem(((ItemsData)entry.getValue()).getUpItem());
                        craftPage.setItems(((ItemsData)entry.getValue()).getItems().stream().map(ItemStack::new).collect(Collectors.toList()));
                        pages.add(craftPage);
                        pageText = new StringBuilder();
                        currentLineCount = 0;
                    }
                    if (!(afterMarker2 = line.substring(line.indexOf(craftMarker) + craftMarker.length())).isBlank()) {
                        lines.set(lineIndex, FormattedText.m_130775_((String)afterMarker2));
                        break;
                    }
                    ++lineIndex;
                    break;
                }
                for (Map.Entry<Object, Object> entry : recipes.entrySet()) {
                    craftMarker = "{" + (String)entry.getKey() + "}";
                    if (!line.contains(craftMarker)) continue;
                    markerFound = true;
                    beforeMarker = line.substring(0, line.indexOf(craftMarker));
                    if (!beforeMarker.isBlank()) {
                        pageText.append(beforeMarker).append("\n");
                        ++currentLineCount;
                    }
                    if (!pageText.isEmpty()) {
                        textPage = new Page();
                        textPage.setIndex("mage_micon.chapter." + title);
                        textPage.setText(pageText.toString().trim());
                        textPage.setType(Page.Type.TEXT);
                        pages.add(textPage);
                        pageText = new StringBuilder();
                        currentLineCount = 0;
                    }
                    craftPage = new Page();
                    craftPage.setIndex("mage_micon.chapter." + title);
                    craftPage.setType(Page.Type.CRAFTING);
                    craftPage.setItem(((RecipeData)entry.getValue()).getItem());
                    craftPage.setUpItem(((RecipeData)entry.getValue()).getUpItem());
                    craftPage.setTag(((RecipeData)entry.getValue()).getTag());
                    craftPage.setItems(((RecipeData)entry.getValue()).getItems().stream().map(ItemStack::new).collect(Collectors.toList()));
                    pages.add(craftPage);
                    afterMarker = line.substring(line.indexOf(craftMarker) + craftMarker.length());
                    if (!afterMarker.isBlank()) {
                        lines.set(lineIndex, FormattedText.m_130775_((String)afterMarker));
                        break;
                    }
                    ++lineIndex;
                    break;
                }
                if (!markerFound) {
                    pageText.append(line).append("\n");
                    ++currentLineCount;
                    ++lineIndex;
                }
                if (currentLineCount < maxLinesPerPage || pageText.isEmpty()) continue;
                Page textPage2 = new Page();
                textPage2.setIndex("mage_micon.chapter." + title);
                textPage2.setText(pageText.toString().trim());
                textPage2.setType(Page.Type.TEXT);
                pages.add(textPage2);
                pageText = new StringBuilder();
                currentLineCount = 0;
            }
            if (pageText.isEmpty()) continue;
            Page textPage = new Page();
            textPage.setIndex("mage_micon.chapter." + title);
            textPage.setText(pageText.toString().trim());
            textPage.setType(Page.Type.TEXT);
            if (textPage.getText().isEmpty()) continue;
            pages.add(textPage);
        }
        return pages;
    }

    public static boolean hasCraftingRecipe(ItemStack itemStack, ClientLevel level) {
        RecipeManager recipeManager = level.m_7465_();
        return recipeManager.m_44013_(RecipeType.f_44107_).stream().anyMatch(recipe -> recipe.m_8043_(level.m_9598_()).m_41720_() == itemStack.m_41720_());
    }

    @Override
    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.3f));
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        poseStack.m_85836_();
        poseStack.m_252880_(-48.0f, 0.0f, 0.0f);
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / this.scale, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / this.scale, 0.0f);
        if (this.chapter != null && MageMiconUtils.isChapterLocked((Player)Minecraft.m_91087_().f_91074_, this.chapter.index)) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/locked_chapter_widget.png"), -19, -9, 0.0f, 0.0f, 126, 18, 126, 18);
            MutableComponent text = Component.m_237113_((String)"???");
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 1, -2, 14003075, false);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 0, -3, 9858892, false);
            poseStack.m_85849_();
            if (GuiUtils.isHovered(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, pMouseX, pMouseY) && !this.micon.category.index.isEmpty()) {
                Style baseStyle = Style.f_131099_.m_178520_(ElementsUtils.getColorByElement(Element.ETHER).getRGB());
                Style endStyle = Style.f_131099_.m_178520_(ElementsUtils.getEndColorByElement(Element.ETHER).getRGB()).m_131155_(Boolean.valueOf(true));
                String help = "";
                ChapterData data = MageMiconUtils.getChapterData(this.micon.category.index, this.chapter.getIndex());
                if (data != null) {
                    if (data.getHintItem() != ItemStack.f_41583_.m_41720_()) {
                        help = data.getHintItem().m_7968_().m_41611_().getString().replace("[", "").replace("]", "");
                    } else if (!data.getHintString().isEmpty()) {
                        help = Component.m_237115_((String)data.getHintString()).getString();
                    }
                }
                List<MutableComponent> tooltipText = List.of(Component.m_237113_((String)("\u00bb " + Component.m_237115_((String)"mage_micon.chapter_unlock").getString() + " \u00ab")).m_130948_(baseStyle), Component.m_237113_((String)(Component.m_237115_((String)"mage_micon.maybe_helpful").getString() + ": ")).m_130948_(endStyle).m_7220_((Component)Component.m_237113_((String)help).m_130948_(endStyle)));
                GuiUtils.renderCustomTooltip(guiGraphics, Minecraft.m_91087_().f_91062_, tooltipText, pMouseX, pMouseY + 9, ElementsUtils.getColorByElement(Element.ETHER).getRGB(), ElementsUtils.getEndColorByElement(Element.ETHER).getRGB());
            }
            return;
        }
        if (this.micon.category.index.equals("spells") || this.category.equals("spells")) {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/item/spells/" + this.chapter.index + ".png"), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/chapter_widget.png"), -9, -9, 0.0f, 0.0f, 126, 18, 126, 18);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!SpellsUtils.isUnlock((Player)this.MC.f_91074_, this.chapter.index)) {
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/lock.png"), -10, -10, 0.0f, 0.0f, 20, 20, 20, 20);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Component text = GuiUtils.translate("mage_micon.spell." + this.chapter.index);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, text, 14, -2, 14003075, false);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, text, 13, -3, 9858892, false);
        } else if (this.micon.category.index.equals("rituals")) {
            MutableComponent text;
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/chapter_widget.png"), -19, -9, 0.0f, 0.0f, 126, 18, 126, 18);
            boolean isCustomName = new ResourceLocation(this.category).m_135827_().equals("etheria");
            if (this.stack == null) {
                guiGraphics.m_280480_(((EtherAltar)BlockRegistry.ETHER_ALTAR.get()).m_5456_().m_7968_(), -18, -8);
                text = Component.m_237115_((String)("mage_micon.rituals." + this.category));
            } else if (!isCustomName) {
                guiGraphics.m_280480_(this.stack, -18, -8);
                text = Component.m_237115_((String)("mage_micon.rituals." + this.category));
            } else {
                guiGraphics.m_280480_(this.stack, -18, -8);
                text = Component.m_237113_((String)this.stack.m_41611_().getString().replace("[", "").replace("]", ""));
            }
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 1, -2, 14003075, false);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 0, -3, 9858892, false);
        } else {
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/chapter_widget.png"), -19, -9, 0.0f, 0.0f, 126, 18, 126, 18);
            if (this.chapter != null) {
                ItemStack itemStack;
                Object object;
                IconData iconData = MageMiconUtils.getChapterData(this.micon.category.index, this.chapter.index).getIconData();
                if (iconData.getType().equals((Object)IconData.Type.ITEM) && (object = iconData.getIcon()) instanceof ItemStack && !(itemStack = (ItemStack)object).m_41619_()) {
                    guiGraphics.m_280480_(itemStack, -18, -8);
                } else if (iconData.getType().equals((Object)IconData.Type.TEXTURE) && (object = iconData.getIcon()) instanceof String) {
                    String s = (String)object;
                    guiGraphics.m_280163_(new ResourceLocation("etheria", s), -18, -8, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            }
            MutableComponent text = Component.m_237113_((String)"");
            if (this.chapter != null) {
                text = Component.m_237115_((String)("mage_micon.chapter." + this.chapter.index));
            }
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 1, -2, 14003075, false);
            guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 0, -3, 9858892, false);
        }
        poseStack.m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }

    @Override
    public void tick() {
        float maxScale = 1.05f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.xOff < maxScale) {
                this.xOff = Math.min(maxScale, this.xOff + (maxScale - this.xOff) * 0.25f);
            }
        } else if (this.xOff != minScale) {
            this.xOff = Math.max(minScale, this.xOff - 0.05f);
        }
        this.scale = this.xOff;
    }

    public ChapterWidget setStack(ItemStack itemStack) {
        this.stack = itemStack;
        return this;
    }

    public ChapterWidget setCategory(String string) {
        this.category = string;
        return this;
    }
}

