/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui.magemicon.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.base.WidgetBase;
import it.mralxart.etheria.client.utils.GuiUtils;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.elements.ElementsUtils;
import it.mralxart.etheria.magic.magemicon.Category;
import it.mralxart.etheria.magic.magemicon.MageMicon;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class CategoryWidget
extends WidgetBase
implements ICustomRenderWidget,
ITickWidget {
    private final MageMicon micon;
    private final Category category;
    private float xOff = 1.0f;
    private boolean hovered = false;
    private float xOffset = 0.0f;

    public CategoryWidget(int x, int y, MageMicon micon, String category) {
        super(x, y, 24, 18);
        this.micon = micon;
        this.category = MageMiconUtils.getCategory(category);
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
    }

    @Override
    public void m_5691_() {
        this.micon.category = this.category;
        this.micon.chapter = null;
        this.micon.indexPage1 = 0;
        this.micon.indexPage2 = 1;
        this.micon.pagesIndex = 0;
        this.micon.updatePages();
        this.micon.resetScreen();
        this.micon.getParticleContainer().clear();
    }

    @Override
    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11714_, (float)5.0f));
    }

    @Override
    public void render(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        float scale = 1.1f;
        this.hovered = this.isHovered(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), pMouseX, pMouseY);
        this.xOffset = this.micon.category.index.equals(this.category.index) ? 2.0f : -2.0f;
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252880_(((float)this.m_252754_() + (float)this.f_93618_ / 2.0f) / scale - this.xOff - this.xOffset, ((float)this.m_252907_() + (float)this.f_93619_ / 2.0f) / scale, 0.0f);
        guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/category.png"), -12, -9, 0.0f, 0.0f, 32, 18, 32, 18);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(-this.xOff - this.xOffset, 0.0f, 0.0f);
        guiGraphics.m_280480_(this.category.item, this.m_252754_() + 1, this.m_252907_() + 1);
        guiGraphics.m_280302_(Minecraft.m_91087_().f_91062_, this.category.item, this.m_252754_() + 1, this.m_252907_() + 1, null);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(-this.xOff - this.xOffset, 0.0f, 950.0f);
        if (this.hovered) {
            MutableComponent categoryComponent = Component.m_237113_((String)("\u00bb " + GuiUtils.translate("mage_micon.category." + this.category.index).getString() + " \u00ab")).m_130948_(Style.f_131099_.m_178520_(ElementsUtils.getColorByElement(Element.ETHER).getRGB()));
            GuiUtils.renderCustomTooltip(guiGraphics, Minecraft.m_91087_().f_91062_, categoryComponent.m_240407_(), pMouseX + 3, pMouseY + 9, ElementsUtils.getColorByElement(Element.ETHER).getRGB(), ElementsUtils.getEndColorByElement(Element.ETHER).getRGB());
        }
        poseStack.m_85849_();
    }

    @Override
    public void tick() {
        float maxScale = 8.0f;
        float minScale = 1.0f;
        if (this.hovered) {
            if (this.xOff < maxScale) {
                this.xOff = Math.min(maxScale, this.xOff + (maxScale - this.xOff) * 0.35f);
            }
        } else if (this.xOff != minScale) {
            this.xOff = Math.max(minScale, this.xOff - 0.75f);
        }
    }

    @Override
    public boolean isHover() {
        return this.hovered;
    }
}

