/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.mralxart.etheria.client.gui.base.ICustomRenderWidget;
import it.mralxart.etheria.client.gui.base.ICustomScaledGui;
import it.mralxart.etheria.client.gui.base.ITickWidget;
import it.mralxart.etheria.client.gui.magemicon.widgets.CometWidget;
import it.mralxart.etheria.client.gui.widgets.SkillConnection;
import it.mralxart.etheria.client.gui.widgets.SkillWidget;
import it.mralxart.etheria.client.particles.ScreenGlowingParticle;
import it.mralxart.etheria.client.particles.data.AbstractParticle;
import it.mralxart.etheria.client.particles.utils.ParticleContainer;
import it.mralxart.etheria.leveling.data.Branches;
import it.mralxart.etheria.leveling.data.CategoryInfo;
import it.mralxart.etheria.leveling.data.SkillInfo;
import it.mralxart.etheria.leveling.utils.SkillsUtils;
import it.mralxart.etheria.registry.CapabilityRegistry;
import it.mralxart.etheria.registry.SoundsRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkillScreen
extends Screen
implements ICustomScaledGui {
    public List<SkillConnection> connections = new ArrayList<SkillConnection>();
    public float animationProgress = -1.0f;
    public String animationId = "";
    private Map<String, SkillWidget> skillWidgets = new HashMap<String, SkillWidget>();
    public Map<String, CategoryInfo> lvlInfos = new HashMap<String, CategoryInfo>();
    public float animation;
    private int offX = 0;
    private int offY = 0;
    public float zoom = 1.0f;
    public final int BACKGROUND_SIZE = 1024;
    protected int maxScrollX;
    protected int maxScrollY;
    public int starsAmount = 0;
    public Map<String, Float> widgetSize = new HashMap<String, Float>();
    private ParticleContainer particleContainer = new ParticleContainer();
    private ParticleContainer screenParticleContainer = new ParticleContainer();
    private SoundInstance instance;
    private int lastOffX = 0;
    private int lastOffY = 0;
    private final List<CometWidget> comets = new ArrayList<CometWidget>();
    private float targetOffX = 0.0f;
    private float targetOffY = 0.0f;

    public SkillScreen(Map<String, CategoryInfo> map, int modifier) {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            Minecraft.m_91087_().m_91152_(null);
        }
        this.lvlInfos = new HashMap<String, CategoryInfo>(map);
    }

    public SkillScreen(Map<String, CategoryInfo> lvlInfos) {
        super((Component)Component.m_237119_());
        if (this.f_96541_ == null) {
            Minecraft.m_91087_().m_91152_(null);
        }
        this.lvlInfos = new HashMap<String, CategoryInfo>(lvlInfos);
        Minecraft.m_91087_().m_91106_().m_120391_();
        this.instance = SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundsRegistry.PYRO_1.get()), (float)0.6f);
        Random random = new Random();
        for (int i = 0; i < 5; ++i) {
            this.comets.add(new CometWidget(random.nextFloat() * (float)this.f_96543_ - (float)random.nextInt(400), random.nextFloat() * (float)this.f_96544_ - (float)random.nextInt(400), 1.6f + random.nextFloat() * 0.8f, random.nextInt(300) + random.nextInt(300)));
        }
        this.targetOffX = -19.0f;
        this.targetOffY = 89.0f;
        this.zoom = 0.625f;
    }

    public void m_7379_() {
        super.m_7379_();
        Minecraft.m_91087_().m_91106_().m_120399_(this.instance);
        Minecraft.m_91087_().m_91106_().m_120407_();
    }

    public void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.connections.clear();
        this.starsAmount = 1;
        for (CategoryInfo info : this.lvlInfos.values()) {
            this.starsAmount += info.getSkills().values().size();
        }
        int index = 1;
        for (CategoryInfo info : this.lvlInfos.values()) {
            for (SkillInfo skillInfo : info.getSkills().values()) {
                if (skillInfo.getBlocked().booleanValue()) continue;
                int widgetX = (int)((float)(skillInfo.getX() - centerX) * this.zoom + (float)centerX + (float)this.offX);
                int widgetY = (int)((float)(skillInfo.getY() - centerY) * this.zoom + (float)centerY + (float)this.offY);
                if (!this.widgetSize.containsKey(skillInfo.getId())) {
                    this.widgetSize.put(skillInfo.getId(), Float.valueOf(1.0f));
                }
                this.addGatewayConnections(skillInfo);
                ++index;
            }
        }
        this.maxScrollX -= this.f_96543_ / 2 - 80;
        this.maxScrollY -= this.f_96544_ / 2 - 80;
        if (this.maxScrollX < 0) {
            this.maxScrollX = 0;
        }
        if (this.maxScrollY < 0) {
            this.maxScrollY = 0;
        }
    }

    private void addGatewayConnections(SkillInfo skill) {
        skill.getParents().forEach(connectedSkillId -> this.connectSkills(this.connections, skill.getId(), (String)connectedSkillId));
    }

    protected void connectSkills(List<SkillConnection> connections, String skillId1, String skillId2) {
        SkillWidget button1 = this.skillWidgets.get(skillId1);
        SkillWidget button2 = this.skillWidgets.get(skillId2);
        if (button1 != null && button2 != null) {
            connections.add(new SkillConnection(button2, button1));
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mX, int mY, float ticks) {
        ICustomRenderWidget widget;
        AbstractButton button;
        if (this.f_96541_ == null) {
            return;
        }
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int barY = this.f_96544_ - centerY / 4 - 10;
        PoseStack poseStack = guiGraphics.m_280168_();
        this.animation += ticks;
        this.m_280273_(guiGraphics);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.m_85836_();
        this.connections.forEach(connection -> this.renderConnection(guiGraphics, (SkillConnection)connection));
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget)) continue;
            widget = (ICustomRenderWidget)button;
            widget.render(guiGraphics, ticks, mX, mY);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (GuiEventListener listener : this.m_6702_()) {
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ICustomRenderWidget) || !(widget = (ICustomRenderWidget)button).isHover()) continue;
            widget.hovered(guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.offX, (float)this.offY, 0.0f);
        for (AbstractParticle particle : this.particleContainer.getParticles()) {
            particle.render(this, guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        for (AbstractParticle particle : this.screenParticleContainer.getParticles()) {
            particle.render(this, guiGraphics, mX, mY, ticks);
        }
        poseStack.m_85849_();
        int step = -162;
        int branchcount = 0;
        for (Branches branch : Branches.values()) {
            if (branch.equals((Object)Branches.NONE)) continue;
            if (branchcount == 4) {
                step = -162;
                barY += 18;
            }
            if (branch.equals((Object)Branches.EXPLORATION) && !ModList.get().isLoaded("etheria_addition")) {
                step += 110;
                ++branchcount;
                continue;
            }
            float percentage = 0.0f;
            int skillXp = SkillsUtils.getXp((Player)this.f_96541_.f_91074_, branch);
            int lvl = SkillsUtils.getLvl((Player)this.f_96541_.f_91074_, branch);
            int requiredXpForNextLevel = lvl * 100 + 150;
            if (skillXp != 0) {
                percentage = (float)skillXp / (float)requiredXpForNextLevel * 100.0f;
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 350.0f);
            RenderSystem.setShaderColor((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/small_xp_background.png"), centerX - 45 + step, barY, 0.0f, 0.0f, 91, 6, 91, 6);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/small_xp_line.png"), centerX - 44 - 1 + step, barY + 1, 0.0f, 0.0f, (int)Math.ceil(percentage / 100.0f * 89.0f), 4, 89, 4);
            boolean xpHovered = SkillScreen.isHovered(centerX - 44 + step, barY, 89, 4, mX, mY);
            this.getScreenParticleContainer().addParticle(new ScreenGlowingParticle(centerX - 6 + step + (new Random().nextInt(44) - new Random().nextInt(44)), barY - 4, 0.0f, -0.2f, 0.25f, 5 + new Random().nextInt(60), 3.0f, new Color(0xB7B7B7)));
            float color = (float)((double)0.85f + Math.sin((double)System.currentTimeMillis() / 100.0 * Math.ceil(2.0) * (double)0.075f) * (double)0.3f);
            if (xpHovered) {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)1);
                RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
                guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/widget/small_xp_highlight.png"), centerX - 45 + step, barY - 1, 0.0f, 0.0f, 91, 8, 91, 8);
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ArrayList description = Lists.newArrayList();
                ArrayList tooltip = Lists.newArrayList();
                int maxWidth = 180;
                int renderWidth = 0;
                int yOff = 0;
                description = Lists.newArrayList((Object[])new MutableComponent[]{Component.m_237115_((String)"etheria.skillbar.title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131162_(Boolean.valueOf(true)))});
                description.add(Component.m_237115_((String)"etheria.skillbar.description"));
                description.add(Component.m_237110_((String)"etheria.skillbar.points", (Object[])new Object[]{CapabilityRegistry.getCap((Player)this.f_96541_.f_91074_).getSkillPoints()}));
                for (MutableComponent entry : description) {
                    int entryWidth = this.f_96541_.f_91062_.m_92852_((FormattedText)entry) / 2;
                    if (entryWidth > renderWidth) {
                        renderWidth = Math.min(entryWidth, maxWidth);
                    }
                    tooltip.addAll(this.f_96541_.f_91062_.m_92923_((FormattedText)entry, maxWidth * 2));
                }
                int heightTip = Math.round((float)tooltip.size() * 4.5f);
                poseStack.m_85836_();
                TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)(mX - renderWidth / 2), (int)(mY - heightTip - 3), (int)renderWidth, (int)heightTip, (int)1300, (int)-267386864, (int)-267386864, (int)-395521, (int)-2320649);
                poseStack.m_85849_();
                poseStack.m_85836_();
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                poseStack.m_252880_((float)(mX * 2), (float)(mY - heightTip - 3) * 2.0f, 3500.0f);
                for (FormattedCharSequence entry : tooltip) {
                    guiGraphics.m_280649_(this.f_96541_.f_91062_, entry, -(this.f_96541_.f_91062_.m_92724_(entry) / 2), yOff * 2, 14928378, false);
                    yOff += 5;
                }
                poseStack.m_85849_();
            }
            guiGraphics.m_280163_(new ResourceLocation("etheria", "textures/gui/skill_point.png"), centerX - 22 + 16 + step, barY - 6, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.enableBlend();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.setShaderColor((float)227.0f, (float)201.0f, (float)250.0f, (float)1.0f);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2 + 1, (barY - 6 + 4) * 2);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2 - 1, (barY - 6 + 4) * 2);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2, (barY - 6 + 4) * 2 + 1);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2, (barY - 6 + 4) * 2 - 1);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280480_(Branches.getItem(branch), (centerX - 22 + 20 + step) * 2, (barY - 6 + 4) * 2);
            poseStack.m_85849_();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            if (xpHovered) {
                RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
            }
            guiGraphics.m_280056_(this.f_96541_.f_91062_, "" + SkillsUtils.getLvl((Player)this.f_96541_.f_91074_, branch), centerX - 45 - 2 + step, barY - 1, new Color(12683758).getRGB(), true);
            guiGraphics.m_280056_(this.f_96541_.f_91062_, "" + (SkillsUtils.getLvl((Player)this.f_96541_.f_91074_, branch) + 1), centerX + 45 - 2 + step, barY - 1, new Color(12683758).getRGB(), true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            step += 110;
            ++branchcount;
        }
        super.m_88315_(guiGraphics, mX, mY, ticks);
    }

    public static void renderTooltipBorder(GuiGraphics guiGraphics, ResourceLocation texture, int width, int height, int x, int y) {
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        manager.m_174784_(texture);
        int texSize = 19;
        int cornerSize = 9;
        guiGraphics.m_280411_(texture, x, y, cornerSize, cornerSize, 0.0f, 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize, y, width, cornerSize, (float)cornerSize, 0.0f, 1, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize + width, y, cornerSize, cornerSize, (float)(cornerSize + 1), 0.0f, cornerSize, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x, y + cornerSize, cornerSize, height, 0.0f, (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.m_280411_(texture, x + width + cornerSize, y + cornerSize, cornerSize, height, (float)(cornerSize + 1), (float)cornerSize, cornerSize, 1, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize, y + cornerSize, width, height, (float)(cornerSize + 1), (float)(cornerSize + 1), 1, 1, texSize, texSize);
        guiGraphics.m_280411_(texture, x, y + height + cornerSize, cornerSize, cornerSize, 0.0f, (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize, y + height + cornerSize, width, cornerSize, (float)cornerSize, (float)(cornerSize + 1), 1, cornerSize, texSize, texSize);
        guiGraphics.m_280411_(texture, x + cornerSize + width, y + cornerSize + height, cornerSize, cornerSize, (float)(cornerSize + 1), (float)(cornerSize + 1), cornerSize, cornerSize, texSize, texSize);
    }

    private void renderConnection(GuiGraphics guiGraphics, SkillConnection connection) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        double connectionX = (float)connection.getWidget1().m_252754_() + (float)connection.getWidget1().m_5711_() / 2.0f;
        double connectionY = (float)connection.getWidget1().m_252907_() + (float)connection.getWidget1().m_93694_() / 2.0f;
        float rotation = SkillScreen.getAngleBetweenButtons(connection.getWidget1(), connection.getWidget2());
        poseStack.m_85837_(connectionX + 1.0, connectionY + 1.0, 0.0);
        poseStack.m_252781_(Axis.f_252403_.m_252961_(rotation));
        poseStack.m_85841_(this.zoom, this.zoom, 1.0f);
        int length = (int)(SkillScreen.getDistanceBetweenButtons(connection.getWidget1(), connection.getWidget2()) / this.zoom);
        boolean highlighted = SkillsUtils.isSkillUnlockd((Player)Minecraft.m_91087_().f_91074_, connection.getWidget1().info.getId());
        guiGraphics.m_280411_(new ResourceLocation("etheria", "textures/gui/widget/conection_line.png"), 0, -3, length, 6, -this.animation, highlighted ? 0.0f : 6.0f, length, 6, 30, 12);
        guiGraphics.m_280168_().m_85849_();
    }

    public static float getAngleBetweenButtons(SkillWidget widget1, SkillWidget widget2) {
        float x1 = (float)widget1.m_252754_() + (float)widget1.m_5711_() / 2.0f;
        float y1 = (float)widget1.m_252907_() + (float)widget1.m_93694_() / 2.0f;
        float x2 = (float)widget2.m_252754_() + (float)widget2.m_5711_() / 2.0f;
        float y2 = (float)widget2.m_252907_() + (float)widget2.m_93694_() / 2.0f;
        return (float)Mth.m_14136_((double)(y2 - y1), (double)(x2 - x1));
    }

    public static float getDistanceBetweenButtons(SkillWidget widget1, SkillWidget widget2) {
        float x1 = (float)widget1.m_252754_() + (float)widget1.m_5711_() / 2.0f;
        float y1 = (float)widget1.m_252907_() + (float)widget1.m_93694_() / 2.0f;
        float x2 = (float)widget2.m_252754_() + (float)widget2.m_5711_() / 2.0f;
        float y2 = (float)widget2.m_252907_() + (float)widget2.m_93694_() / 2.0f;
        return Mth.m_14116_((float)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.targetOffX += (float)pDragX;
        this.targetOffY += (float)pDragY;
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        float newZoom = (float)((double)this.zoom + amount * 0.05);
        this.zoom = newZoom = Math.min(Math.max(newZoom, 0.625f), 2.0f);
        this.getParticleContainer().clear();
        this.m_232761_();
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_86600_() {
        super.m_86600_();
        this.getParticleContainer().tickParticles(this);
        this.getScreenParticleContainer().tickParticles(this);
        if (this.animationProgress >= 0.0f) {
            this.animationProgress += 0.04f;
            if (this.animationProgress > 1.0f) {
                this.animationProgress = -1.0f;
            }
        }
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !((button = (AbstractButton)listener) instanceof ITickWidget)) continue;
            ITickWidget widget = (ITickWidget)button;
            widget.tick();
        }
        float smoothFactor = 0.2f;
        this.offX += (int)((this.targetOffX - (float)this.offX) * smoothFactor);
        this.offY += (int)((this.targetOffY - (float)this.offY) * smoothFactor);
        float result = 0.0f;
        if ((double)this.zoom > 0.625) {
            result = this.zoom * 1.4f * 60.0f;
        }
        if ((double)this.zoom > 0.674 && (double)this.zoom < 0.676) {
            result -= 60.0f;
        }
        int maxOffX = (int)(512.0 - (double)this.f_96543_ / 2.0 / (double)this.zoom + (double)result);
        int maxOffY = (int)(512.0 - (double)this.f_96544_ / 2.0 / (double)this.zoom);
        this.offX = Math.max(-maxOffX, Math.min(this.offX, maxOffX));
        this.offY = Math.max(-maxOffY, Math.min(this.offY, maxOffY));
        this.m_232761_();
        Minecraft.m_91087_().m_91106_().m_120389_(false);
        if (!Minecraft.m_91087_().m_91106_().m_120403_(this.instance)) {
            int i = new Random().nextInt(1, 3);
            int ii = new Random().nextInt(1, 2);
            float randomPitch = switch (ii) {
                case 1 -> 0.9f;
                case 2 -> 1.1f;
                default -> 1.0f;
            };
            switch (i) {
                case 1: {
                    this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_1.get()), (float)randomPitch, (float)0.5f);
                    break;
                }
                case 2: {
                    this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_2.get()), (float)randomPitch, (float)0.5f);
                    break;
                }
                case 3: {
                    this.instance = SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsRegistry.MAGE_MICON_3.get()), (float)randomPitch, (float)0.5f);
                }
            }
            Minecraft.m_91087_().m_91106_().m_120367_(this.instance);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        ResourceLocation texture = new ResourceLocation("etheria", "textures/gui/background.png");
        int size = 1024;
        poseStack.m_85836_();
        poseStack.m_85841_(this.zoom, this.zoom, 1.0f);
        poseStack.m_252880_((float)this.f_96543_ / 2.0f / this.zoom, (float)this.f_96544_ / 2.0f / this.zoom, 0.0f);
        guiGraphics.m_280398_(texture, -(size / 2) + this.offX / 2, -(size / 2) + this.offY / 2, 0, (float)size, (float)size, size, size, size, size);
        poseStack.m_85849_();
        for (CometWidget comet : this.comets) {
            comet.update();
            poseStack.m_85836_();
            poseStack.m_252880_(comet.x, comet.y, 0.0f);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            guiGraphics.m_280398_(new ResourceLocation("etheria", "textures/gui/comet.png"), (int)(-19.0f + comet.offX + (float)this.offX), (int)(-20.0f + comet.offY + (float)this.offY), 0, 38.0f, 40.0f, 38, 40, 38, 40);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    public static boolean isHovered(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    @Override
    public int getScale() {
        return 0;
    }

    public List<SkillConnection> getConnections() {
        return this.connections;
    }

    public float getAnimationProgress() {
        return this.animationProgress;
    }

    public String getAnimationId() {
        return this.animationId;
    }

    public Map<String, SkillWidget> getSkillWidgets() {
        return this.skillWidgets;
    }

    public Map<String, CategoryInfo> getLvlInfos() {
        return this.lvlInfos;
    }

    public float getAnimation() {
        return this.animation;
    }

    public int getOffX() {
        return this.offX;
    }

    public int getOffY() {
        return this.offY;
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getBACKGROUND_SIZE() {
        return this.BACKGROUND_SIZE;
    }

    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    public int getStarsAmount() {
        return this.starsAmount;
    }

    public Map<String, Float> getWidgetSize() {
        return this.widgetSize;
    }

    public ParticleContainer getParticleContainer() {
        return this.particleContainer;
    }

    public ParticleContainer getScreenParticleContainer() {
        return this.screenParticleContainer;
    }

    public SoundInstance getInstance() {
        return this.instance;
    }

    public int getLastOffX() {
        return this.lastOffX;
    }

    public int getLastOffY() {
        return this.lastOffY;
    }

    public List<CometWidget> getComets() {
        return this.comets;
    }

    public float getTargetOffX() {
        return this.targetOffX;
    }

    public float getTargetOffY() {
        return this.targetOffY;
    }

    public void setConnections(List<SkillConnection> connections) {
        this.connections = connections;
    }

    public void setAnimationProgress(float animationProgress) {
        this.animationProgress = animationProgress;
    }

    public void setAnimationId(String animationId) {
        this.animationId = animationId;
    }

    public void setSkillWidgets(Map<String, SkillWidget> skillWidgets) {
        this.skillWidgets = skillWidgets;
    }

    public void setLvlInfos(Map<String, CategoryInfo> lvlInfos) {
        this.lvlInfos = lvlInfos;
    }

    public void setAnimation(float animation) {
        this.animation = animation;
    }

    public void setOffX(int offX) {
        this.offX = offX;
    }

    public void setOffY(int offY) {
        this.offY = offY;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setMaxScrollX(int maxScrollX) {
        this.maxScrollX = maxScrollX;
    }

    public void setMaxScrollY(int maxScrollY) {
        this.maxScrollY = maxScrollY;
    }

    public void setStarsAmount(int starsAmount) {
        this.starsAmount = starsAmount;
    }

    public void setWidgetSize(Map<String, Float> widgetSize) {
        this.widgetSize = widgetSize;
    }

    public void setParticleContainer(ParticleContainer particleContainer) {
        this.particleContainer = particleContainer;
    }

    public void setScreenParticleContainer(ParticleContainer screenParticleContainer) {
        this.screenParticleContainer = screenParticleContainer;
    }

    public void setInstance(SoundInstance instance) {
        this.instance = instance;
    }

    public void setLastOffX(int lastOffX) {
        this.lastOffX = lastOffX;
    }

    public void setLastOffY(int lastOffY) {
        this.lastOffY = lastOffY;
    }

    public void setTargetOffX(float targetOffX) {
        this.targetOffX = targetOffX;
    }

    public void setTargetOffY(float targetOffY) {
        this.targetOffY = targetOffY;
    }
}

