/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.capability;

import it.mralxart.etheria.handlers.ConfigCommandHandler;
import it.mralxart.etheria.leveling.SkillsHandler;
import it.mralxart.etheria.magemicon.utils.StarUtils;
import it.mralxart.etheria.magic.spells.Spell;
import it.mralxart.etheria.magic.spells.utils.SpellsUtils;
import it.mralxart.etheria.network.Networking;
import it.mralxart.etheria.network.packets.SyncCapabilityPacket;
import it.mralxart.etheria.network.packets.SyncEntityCapabilityPacket;
import it.mralxart.etheria.registry.CapabilityRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class SyncCapabilityManager {
    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SyncCapabilityManager.sync(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SyncCapabilityManager.sync(event.getEntity());
        if (!SpellsUtils.getSpell(event.getEntity(), "icy_spear").isUnlock()) {
            SpellsUtils.getSpell(event.getEntity(), "icy_spear").setUnlock(true);
            SpellsUtils.getSpell(event.getEntity(), "fireball").setUnlock(true);
        }
        if (CapabilityRegistry.getCap(event.getEntity()).getActiveSpells().isEmpty()) {
            CapabilityRegistry.getCap(event.getEntity()).getActiveSpells().put("icy_spear", 1);
            CapabilityRegistry.getCap(event.getEntity()).getActiveSpells().put("fireball", 2);
        }
        for (Spell spell : CapabilityRegistry.getCap(event.getEntity()).getSpells().values()) {
            if (spell == null || !spell.isUnlock()) continue;
            StarUtils.unlockStarById(event.getEntity(), spell.getId(), true);
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ConfigCommandHandler.handeSyncAllConfigs(serverPlayer);
        }
        SyncCapabilityManager.sync(event.getEntity());
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        SyncCapabilityManager.sync(event.getEntity());
    }

    public static boolean sync(Player player) {
        if (player.m_20193_().m_5776_()) {
            return false;
        }
        SkillsHandler.removeAttribute((LivingEntity)player, "etheria_movement_speed_combat", Attributes.f_22279_, AttributeModifier.Operation.ADDITION);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!SpellsUtils.getUnlockedSpells(player).contains(SpellsUtils.getSpell(player, "icy_spear"))) {
                SpellsUtils.getSpell((Player)serverPlayer, "icy_spear").setUnlock(true);
                SpellsUtils.getSpell((Player)serverPlayer, "fireball").setUnlock(true);
            }
            Networking.sendToClient(serverPlayer, new SyncCapabilityPacket(CapabilityRegistry.getCap(player).serializeNBT()));
            return true;
        }
        return false;
    }

    public static void syncEntity(LivingEntity entity, CompoundTag data) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Networking.sendToClient(player, new SyncEntityCapabilityPacket(data, entity.m_19879_()));
        } else if (!entity.m_9236_().f_46443_) {
            Networking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncEntityCapabilityPacket(data, entity.m_19879_()));
        }
    }

    @Deprecated
    public static boolean syncSides(Player player) {
        return SyncCapabilityManager.sync(player);
    }
}

