/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.blocks;

import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.magic.trial.TrialState;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.TrialTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TrialBlock
extends BaseEntityBlock
implements IMageMiconEntryItem {
    public static final EnumProperty<TrialState> TRIAL_SPAWNER_STATE = EnumProperty.m_61587_((String)"trial_spawner_state", TrialState.class);

    public TrialBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60953_(s -> 4).m_60978_(1200.0f).m_60918_(SoundType.f_56730_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TRIAL_SPAWNER_STATE, (Comparable)((Object)TrialState.INACTIVE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TRIAL_SPAWNER_STATE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)TileRegistry.TRIAL.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TileRegistry.TRIAL.get() == type ? TrialTile::tick : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TrialTile) {
            TrialTile tile = (TrialTile)blockEntity;
            tile.setDirection(this.getNextDirection(tile.getDirection()));
            Item item = heldItem.m_41720_();
            if (item instanceof SpawnEggItem) {
                SpawnEggItem item2 = (SpawnEggItem)item;
                ((TrialTile)blockEntity).setEntityType(item2.m_43228_(null));
                heldItem.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private Direction getNextDirection(Direction current) {
        return switch (current) {
            case Direction.NORTH -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.NORTH;
            default -> Direction.NORTH;
        };
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("ether_constructs", "trials");
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialState var2);

        public TrialState getState();

        public void markUpdated();
    }
}

