/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.blocks;

import it.mralxart.etheria.blocks.base.DropWithNbtBlock;
import it.mralxart.etheria.blocks.base.IEnigmaBlock;
import it.mralxart.etheria.items.base.IArtefactItem;
import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IEtherPedestal;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.registry.TileRegistry;
import it.mralxart.etheria.tiles.EtherPrismTile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EtherPrism
extends DropWithNbtBlock
implements EntityBlock,
IEtherPedestal,
IElementItem,
IEnigmaBlock,
IMageMiconEntryItem {
    public EtherPrism() {
        super(BlockBehaviour.Properties.m_284310_().m_60953_(s -> 0).m_60999_().m_60978_(3.0f).m_60918_(SoundType.f_56742_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENIGMA, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENIGMA});
    }

    @Override
    public Element getElement() {
        return Element.ETHER;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EtherPrismTile(pos, state);
    }

    public void m_6810_(BlockState state, @NotNull Level world, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        Object object;
        if (!state.m_60713_(newState.m_60734_()) && (object = world.m_7702_(pos)) instanceof EtherPrismTile) {
            EtherPrismTile tile = (EtherPrismTile)object;
            for (ItemStack stack : tile.getItemStacks()) {
                if (stack == null || stack.m_41619_()) continue;
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
            }
            tile.setItemStacks(new ArrayList<ItemStack>());
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_ && level.m_7702_(pos) != null && !player.m_7500_()) {
            ItemStack drop = new ItemStack((ItemLike)this);
            CompoundTag tag = level.m_7702_(pos).m_187482_();
            tag.m_128473_("itemStacks");
            drop.m_41784_().m_128365_("BlockEntityTag", (Tag)tag);
            EtherPrism.m_49840_((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof EtherPrismTile)) {
            return InteractionResult.FAIL;
        }
        EtherPrismTile tile = (EtherPrismTile)blockEntity;
        ItemStack handStack = player.m_21205_();
        BlockState oldState = level.m_8055_(pos);
        List<ItemStack> itemStacks = tile.getItemStacks();
        if (player.m_6144_() && !itemStacks.isEmpty()) {
            ItemStack removedStack = itemStacks.remove(itemStacks.size() - 1);
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), removedStack));
        } else if (!handStack.m_41619_() && handStack.m_41720_() instanceof IArtefactItem && itemStacks.size() < (tile.isEnigma() ? 8 : 4)) {
            itemStacks.add(handStack.m_41620_(1));
        }
        tile.m_6596_();
        level.m_7260_(pos, oldState, level.m_8055_(pos), 3);
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (TileRegistry.ETHER_PRISM.get() == type) {
            return EtherPrismTile::tick;
        }
        return null;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("ether_constructs", "ritual_constructs");
    }
}

