/*
 * Decompiled with CFR 0.152.
 */
package it.mralxart.etheria.blocks;

import it.mralxart.etheria.items.base.IElementItem;
import it.mralxart.etheria.items.base.IEtherEntryItem;
import it.mralxart.etheria.items.base.IMageMiconEntryItem;
import it.mralxart.etheria.magic.elements.Element;
import it.mralxart.etheria.magic.magemicon.Chapter;
import it.mralxart.etheria.magic.magemicon.MageMiconUtils;
import it.mralxart.etheria.tiles.EtherDistributorTile;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EtherDistributor
extends Block
implements EntityBlock,
IElementItem,
IMageMiconEntryItem {
    public EtherDistributor() {
        super(BlockBehaviour.Properties.m_284310_().m_60953_(s -> 0).m_60999_().m_60978_(3.0f).m_60918_(SoundType.f_56730_).m_60955_());
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        return List.of(new ItemStack((ItemLike)this));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, @NotNull BlockState state) {
        return new EtherDistributorTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_60508_) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof EtherDistributorTile)) {
            return InteractionResult.FAIL;
        }
        EtherDistributorTile tile = (EtherDistributorTile)blockEntity;
        ItemStack handStack = player.m_21205_();
        ItemStack tileStack = tile.getItemStack();
        BlockState oldState = level.m_8055_(pos);
        if (tileStack.m_41619_() && handStack.m_41720_() instanceof IEtherEntryItem) {
            tile.setItemStack(handStack.m_41620_(1));
        } else if (player.m_6144_()) {
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), tileStack));
            tile.setItemStack(ItemStack.f_41583_);
        }
        tile.m_6596_();
        level.m_7260_(pos, oldState, level.m_8055_(pos), 3);
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        EtherDistributorTile tile;
        ItemStack stack;
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = worldIn.m_7702_(pos)) instanceof EtherDistributorTile && (stack = (tile = (EtherDistributorTile)blockEntity).getItemStack()) != null && !stack.m_41619_()) {
            worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), Block.m_49796_((double)4.5, (double)3.0, (double)4.5, (double)11.5, (double)5.0, (double)11.5), Block.m_49796_((double)5.5, (double)5.0, (double)5.5, (double)10.5, (double)11.0, (double)10.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof EtherDistributorTile) {
                EtherDistributorTile tile = (EtherDistributorTile)t;
                tile.tick(level, blockPos, blockState);
            }
        };
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public Element getElement() {
        return Element.ETHER;
    }

    @Override
    public Chapter getChapter() {
        return MageMiconUtils.getChapter("ether_constructs", "ritual_constructs");
    }
}

